/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.ISpanModel;
import com.sec.osdm.pages.utils.table.ITableModel;
import com.sec.osdm.pages.utils.table.SpanInfo;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class RowHeaderTableModel
implements TableModel,
ISpanModel {
    protected ITableModel m_parentModel = null;
    protected EventListenerList listenerList = new EventListenerList();

    public RowHeaderTableModel(ITableModel parentModel) {
        this.m_parentModel = parentModel;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.m_parentModel.getRowHdrColCount();
    }

    @Override
    public int getRowCount() {
        return this.m_parentModel.getRowHdrRowCount();
    }

    @Override
    public String getColumnName(int col) {
        if (this.m_parentModel.getCornerCount() == 1) {
            return "Dummy" + String.valueOf(col);
        }
        return this.m_parentModel.getCornerName(col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.m_parentModel.getRowHdrName(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
    }

    @Override
    public void addTableModelListener(TableModelListener l2) {
        this.listenerList.add(TableModelListener.class, l2);
    }

    @Override
    public void removeTableModelListener(TableModelListener l2) {
        this.listenerList.remove(TableModelListener.class, l2);
    }

    public void fireTableChanged(TableModelEvent e2) {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == TableModelListener.class) {
                ((TableModelListener)listeners[i2 + 1]).tableChanged(e2);
            }
            i2 -= 2;
        }
    }

    @Override
    public SpanInfo getSpanInfo() {
        return this.m_parentModel.getRowHeaderSpanInfo();
    }

    @Override
    public void setSpanInfo(SpanInfo info) {
    }
}

