/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.io.AppINIFile;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class P201FCustomerData
extends AppPage {
    private final String SECTION_NAME = "customer_data";
    private AppFTPClient m_ftp = new AppFTPClient();
    private String m_filePath = String.valueOf(AppProperty.m_runDirectory) + "SiteInfo.tbl";
    private AppINIFile m_iniFile = null;
    private Hashtable m_fileData = new Hashtable();
    private Map m_secData = null;
    private String[] m_itemList = new String[]{"address", "street", "city", "state", "zip", "tel_no", "fax_no", "number", "extension_number", "mailbox_number", "emergency", "dial", "sys_admin", "app_admin", "sub_admin"};

    public P201FCustomerData(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        this.m_pageInfo.setUpMsgType((byte)-56);
        this.m_ftp.connect("admin", "samsung");
        this.m_ftp.getFile("/os7100/vm/dta/SiteInfo.tbl", this.m_filePath);
        this.m_ftp.disConnect();
        this.m_iniFile = new AppINIFile(this.m_filePath);
        this.createComponents();
        this.createTable();
    }

    public void createComponents() {
        this.m_corner = new String[][]{{AppLang.getText("Item")}, {""}};
        this.m_colTitle = new String[][]{{AppLang.getText("Value")}};
        this.m_rowTitle = new String[this.m_itemList.length][2];
        int i2 = 0;
        while (i2 < this.m_rowTitle.length) {
            this.m_rowTitle[i2][0] = "";
            this.m_rowTitle[i2][1] = "";
            ++i2;
        }
        this.m_rowTitle[0][0] = "Customer Site Information";
        this.m_rowTitle[0][1] = "Address";
        this.m_rowTitle[1][1] = "Street";
        this.m_rowTitle[2][1] = "City";
        this.m_rowTitle[3][1] = "State";
        this.m_rowTitle[4][1] = "Zip Code";
        this.m_rowTitle[5][1] = "Tel Number";
        this.m_rowTitle[6][1] = "FAX Number";
        this.m_rowTitle[7][0] = "System Administrator";
        this.m_rowTitle[7][1] = "Number";
        this.m_rowTitle[8][1] = "Extension Number";
        this.m_rowTitle[9][1] = "City";
        this.m_rowTitle[10][1] = "Emergency";
        this.m_rowTitle[11][0] = "Modem Remote Access";
        this.m_rowTitle[11][1] = "Dial Number";
        this.m_rowTitle[12][0] = "Keyboard Access Passwords";
        this.m_rowTitle[12][1] = "System Administrator";
        this.m_rowTitle[13][1] = "Application Administrator";
        this.m_rowTitle[14][1] = "Subscriber Administrator";
        this.setComponents();
    }

    private void setComponents() {
        ArrayList<String> recvData = null;
        this.m_fileData = this.m_iniFile.getAllData();
        if (this.m_fileData != null) {
            for (String key : this.m_fileData.keySet()) {
                this.m_secData = (Map)this.m_fileData.get(key);
                recvData = new ArrayList();
                if (key.equals("customer_data")) {
                    int i2 = 0;
                    while (i2 < this.m_itemList.length) {
                        recvData.add(i2, String.valueOf(this.m_itemList[i2]) + "=" + (String)this.m_secData.get(this.m_itemList[i2]));
                        ++i2;
                    }
                } else {
                    for (String key1 : this.m_secData.keySet()) {
                        recvData.add(String.valueOf(key1) + "=" + (String)this.m_secData.get(key1));
                    }
                }
                this.m_fileData.put(key, recvData);
            }
        }
        if ((recvData = (ArrayList<String>)this.m_fileData.get("customer_data")) == null) {
            recvData = new ArrayList<String>();
            int i3 = 0;
            while (i3 < this.m_itemList.length) {
                recvData.add(i3, String.valueOf(this.m_itemList[i3]) + "= ");
                ++i3;
            }
            this.m_fileData.put("customer_data", recvData);
        }
        this.m_components.clear();
        int idx = 0;
        this.m_compText = new AppTextBox(0, 37);
        this.setData(recvData, idx);
        this.m_compText = new AppTextBox(0, 21);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 12);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 12);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 37);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 37);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 37);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
        this.m_compText = new AppTextBox(0, 22);
        this.setData(recvData, ++idx);
    }

    private void setData(ArrayList recvData, int idx) {
        String[] strData = ((String)recvData.get(idx)).split("=");
        if (strData.length >= 2) {
            this.m_compText.setText(strData[1].trim());
        }
        this.m_components.add(idx, this.m_compText);
    }

    @Override
    public void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return (AppTextBox)P201FCustomerData.this.m_components.get(row);
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                ArrayList recvData = (ArrayList)P201FCustomerData.this.m_fileData.get("customer_data");
                String[] strData = ((String)recvData.get(row)).split("=");
                String preValue = "";
                if (strData.length >= 2) {
                    preValue = strData[1].trim();
                }
                String curValue = String.valueOf(P201FCustomerData.this.m_itemList[row]) + "=" + ((AppTextBox)aValue).getText().trim();
                recvData.set(row, curValue);
                P201FCustomerData.this.m_fileData.put("customer_data", recvData);
                if (!P201FCustomerData.this.m_bIsChanged && !preValue.equals(curValue)) {
                    P201FCustomerData.this.m_bIsChanged = true;
                }
            }
        };
        this.m_model.setRowWidth(new int[]{180, 200});
        this.m_model.setColWidth(new int[]{350});
        this.m_table = new AppTable(this.m_model);
        this.setPrintableComponent(this.m_table);
        this.refreshTable();
        this.m_contentPane.add((Component)this.m_table, "Center");
    }

    private void refreshTable() {
        this.m_model.setColHeaderColSpan(0, 0, 2);
        this.m_model.setRowHeaderRowSpan(0, 0, 7);
        this.m_model.setRowHeaderRowSpan(7, 0, 4);
        this.m_model.setRowHeaderRowSpan(12, 0, 3);
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Save")) {
            this.m_iniFile.saveFile(this.m_fileData);
            this.m_ftp.connect("admin", "samsung");
            this.m_ftp.putFile(this.m_filePath, "/os7100/vm/dta/SiteInfo.tbl");
            this.m_ftp.disConnect();
            ArrayList<String> saveData = new ArrayList<String>();
            saveData.add(0, "1");
            saveData.add(1, "/os7100/vm/dta/SiteInfo.tbl");
            this.m_recvData.clear();
            this.m_recvData.add(0, saveData);
        }
        this.actionPageToolButton(command);
    }

    @Override
    public void createPage() {
    }
}

