/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa.openblock;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.openblock.AppBlockListDetailDlg;
import com.sec.osdm.pages.vmaa.openblock.P1001AnnouncementBlock;
import com.sec.osdm.pages.vmaa.openblock.P1004AudioTextLibBlock;
import com.sec.osdm.pages.vmaa.openblock.P1007ByeBlock;
import com.sec.osdm.pages.vmaa.openblock.P1009DialBlock;
import com.sec.osdm.pages.vmaa.openblock.P100DDirectoryBlock;
import com.sec.osdm.pages.vmaa.openblock.P1010DocumentLibrarianBlock;
import com.sec.osdm.pages.vmaa.openblock.P1015EClassBlock;
import com.sec.osdm.pages.vmaa.openblock.P101AExtensionBlock;
import com.sec.osdm.pages.vmaa.openblock.P1021FaxBlock;
import com.sec.osdm.pages.vmaa.openblock.P1024ListBlock;
import com.sec.osdm.pages.vmaa.openblock.P1028MailboxBlock;
import com.sec.osdm.pages.vmaa.openblock.P102EMClassBlock;
import com.sec.osdm.pages.vmaa.openblock.P1032MenuBlock;
import com.sec.osdm.pages.vmaa.openblock.P1035ModeBlock;
import com.sec.osdm.pages.vmaa.openblock.P1038NetworkBlock;
import com.sec.osdm.pages.vmaa.openblock.P103DPortBlock;
import com.sec.osdm.pages.vmaa.openblock.P103FQueryBlock;
import com.sec.osdm.pages.vmaa.openblock.P1043SpeakBlock;
import com.sec.osdm.pages.vmaa.openblock.P1046StationBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AppReferenceDlg
extends JDialog
implements ActionListener {
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private String[][] m_RowNames = null;
    private String[][] m_ColNames = new String[][]{{"Block", "Label Name", "Group"}};
    private JButton m_btnClose = new JButton(AppLang.getText("Close"));
    private AppTextBox[] m_txtBlock = null;
    private AppTextBox[] m_txtLabelName = null;
    private AppTextBox[] m_txtGroup = null;
    private AppReferenceDlg m_thisObj = null;
    private String m_msgId = "";
    private String m_serial = "";
    private String[] m_arrSerial = null;
    private RefDialogTableListener m_tableListener = new RefDialogTableListener();
    private JPanel m_pnTable = new JPanel(new BorderLayout());
    private AppRequestInfo m_reqData = null;
    private byte[] m_ReqSerial = new byte[4];
    private AppBlockListDetailDlg m_objBlock = null;

    public AppReferenceDlg(String msgId, String serial, JDialog dialog) {
        super(dialog, AppLang.getText("Find Block"), true);
        AppGlobal.g_dialogList.add(this);
        this.setIconImage(AppImages.Img_Logo);
        this.m_msgId = msgId;
        this.m_thisObj = this;
        this.m_serial = serial.trim();
        this.setInit();
        this.requestData();
        this.createComponent();
        this.createTable();
        JPanel btnPan = new JPanel(new FlowLayout());
        btnPan.add(this.m_btnClose);
        this.setMouseListener();
        this.add((Component)this.m_pnTable, "Center");
        this.add((Component)btnPan, "South");
        this.setVisible(true);
    }

    private void setInit() {
        this.m_reqData = new AppRequestInfo(this.m_msgId, -38, -1);
        this.m_ReqSerial = new byte[4];
        AppFunctions.int2byte(this.m_ReqSerial, 0, Integer.parseInt(this.m_serial));
        this.m_reqData.setReqData(this.m_ReqSerial);
        this.setSize(460, 350);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.m_btnClose.addActionListener(this);
        this.m_btnClose.setActionCommand("close");
        AppGlobal.fixSize(this.m_btnClose, new Dimension(100, 22));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppReferenceDlg.this.m_thisObj.dispose();
                if (AppGlobal.g_dialogList.size() > 0) {
                    AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                }
            }
        });
    }

    public boolean requestData() {
        this.m_reqData.setResult(AppComm.getInstance().requestDownload(this.m_reqData.getPageInfo()));
        return this.m_reqData.getResult();
    }

    private void createComponent() {
        this.m_RowNames = new String[this.m_reqData.getRecvData().size()][1];
        this.m_arrSerial = new String[this.m_reqData.getRecvData().size()];
        this.m_txtBlock = new AppTextBox[this.m_reqData.getRecvData().size()];
        this.m_txtLabelName = new AppTextBox[this.m_reqData.getRecvData().size()];
        this.m_txtGroup = new AppTextBox[this.m_reqData.getRecvData().size()];
        int i2 = 0;
        while (i2 < this.m_reqData.getRecvData().size()) {
            this.m_RowNames[i2][0] = "" + (i2 + 1);
            this.m_txtBlock[i2] = new AppTextBox(0, 20);
            this.m_txtLabelName[i2] = new AppTextBox(0, 20);
            this.m_txtGroup[i2] = new AppTextBox(0, 20);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_reqData.getRecvData().size()) {
            ArrayList al_data = (ArrayList)this.m_reqData.getRecvData().get(i2);
            int j2 = 0;
            while (j2 < al_data.size()) {
                String tmpData = (String)al_data.get(j2);
                this.setText(i2, j2, tmpData);
                ++j2;
            }
            ++i2;
        }
    }

    private void setText(int pos, int index, String data) {
        if (index == 0) {
            this.m_arrSerial[pos] = data;
        }
        if (index == 1) {
            this.m_txtBlock[pos].setText(data);
        }
        if (index == 2) {
            if (!data.equals("0")) {
                this.m_txtGroup[pos].setText(data);
            } else {
                this.m_txtGroup[pos].setText("");
            }
        }
        if (index == 3) {
            this.m_txtLabelName[pos].setText(data);
        }
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_RowNames, this.m_ColNames, "#"){

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return AppReferenceDlg.this.m_txtBlock[row];
                }
                if (col == 1) {
                    return AppReferenceDlg.this.m_txtLabelName[row];
                }
                return AppReferenceDlg.this.m_txtGroup[row];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{50});
        this.m_model.setColWidth(new int[]{100, 200, 80});
        this.m_table = new AppTable(this.m_model);
        this.m_pnTable.add((Component)this.m_table, "Center");
    }

    public void setMouseListener() {
        this.m_table.getTable().removeMouseListener(this.m_tableListener);
        this.m_table.getTable().addMouseListener(this.m_tableListener);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.m_thisObj.dispose();
        if (AppGlobal.g_dialogList.size() > 0) {
            AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
        }
    }

    private void createBlockPage(String blockName) {
        if (blockName.equals("ANN")) {
            this.m_objBlock = new P1001AnnouncementBlock();
        } else if (blockName.equals("ATL")) {
            this.m_objBlock = new P1004AudioTextLibBlock();
        } else if (blockName.equals("BYE")) {
            this.m_objBlock = new P1007ByeBlock();
        } else if (blockName.equals("DAL")) {
            this.m_objBlock = new P1009DialBlock();
        } else if (blockName.equals("DIR")) {
            this.m_objBlock = new P100DDirectoryBlock();
        } else if (blockName.equals("DTL")) {
            this.m_objBlock = new P1010DocumentLibrarianBlock();
        } else if (blockName.equals("ECL")) {
            this.m_objBlock = new P1015EClassBlock();
        } else if (blockName.equals("EXT")) {
            this.m_objBlock = new P101AExtensionBlock();
        } else if (blockName.equals("FAX")) {
            this.m_objBlock = new P1021FaxBlock();
        } else if (blockName.equals("LST")) {
            this.m_objBlock = new P1024ListBlock();
        } else if (blockName.equals("MBX")) {
            this.m_objBlock = new P1028MailboxBlock();
        } else if (blockName.equals("MCL")) {
            this.m_objBlock = new P102EMClassBlock();
        } else if (blockName.equals("MNU")) {
            this.m_objBlock = new P1032MenuBlock();
        } else if (blockName.equals("MOD")) {
            this.m_objBlock = new P1035ModeBlock();
        } else if (blockName.equals("NMX")) {
            this.m_objBlock = new P1038NetworkBlock();
        } else if (blockName.equals("POT")) {
            this.m_objBlock = new P103DPortBlock();
        } else if (blockName.equals("QRY")) {
            this.m_objBlock = new P103FQueryBlock();
        } else if (blockName.equals("SPK")) {
            this.m_objBlock = new P1043SpeakBlock();
        } else if (blockName.equals("STA")) {
            this.m_objBlock = new P1046StationBlock();
        }
    }

    private class RefDialogTableListener
    extends MouseAdapter {
        private RefDialogTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() >= 2 && AppReferenceDlg.this.m_table.getTable().getSelectedColumn() == 1 && AppReferenceDlg.this.m_reqData.getRecvData() != null) {
                int rowIdx = AppReferenceDlg.this.m_table.getTable().getSelectedRow();
                String BlockName = ((AppTextBox)AppReferenceDlg.this.m_model.getValueAt(rowIdx, 0)).getText().trim();
                AppReferenceDlg.this.createBlockPage(BlockName);
                AppReferenceDlg.this.m_objBlock.createPage(AppReferenceDlg.this.m_arrSerial[rowIdx], new ArrayList());
                AppReferenceDlg.this.requestData();
                AppReferenceDlg.this.createComponent();
                AppReferenceDlg.this.m_model.setRowHeaderNames(AppReferenceDlg.this.m_RowNames);
                AppReferenceDlg.this.m_table.tableChanged(null);
                AppReferenceDlg.this.setMouseListener();
            }
        }
    }
}

