/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.event.EventListenerList;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;

public abstract class SearchQuery {
    protected EventListenerList listenerList = new EventListenerList();
    protected SearchEngine hs;
    protected String searchparams;
    protected Locale l;
    private static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$search$SearchListener;

    public SearchQuery(SearchEngine searchEngine) {
        this.hs = searchEngine;
    }

    public void addSearchListener(SearchListener searchListener) {
        this.listenerList.add(class$javax$help$search$SearchListener == null ? (class$javax$help$search$SearchListener = SearchQuery.class$("javax.help.search.SearchListener")) : class$javax$help$search$SearchListener, searchListener);
    }

    public void removeSearchListener(SearchListener searchListener) {
        this.listenerList.remove(class$javax$help$search$SearchListener == null ? (class$javax$help$search$SearchListener = SearchQuery.class$("javax.help.search.SearchListener")) : class$javax$help$search$SearchListener, searchListener);
    }

    public void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
        this.searchparams = string;
        this.l = locale;
        this.fireSearchStarted();
    }

    public void stop() throws IllegalStateException {
        this.fireSearchFinished();
    }

    public SearchEngine getSearchEngine() {
        return this.hs;
    }

    public abstract boolean isActive();

    public void itemsFound(boolean bl2, Vector vector) {
        this.fireItemsFound(bl2, vector);
    }

    protected void fireItemsFound(boolean bl2, Vector vector) {
        SearchQuery.debug("fireItemsFound");
        SearchQuery.debug("  params: " + this.searchparams);
        SearchQuery.debug("  insearch: " + bl2);
        SearchQuery.debug("  docs: " + vector);
        Object[] objectArray = this.listenerList.getListenerList();
        SearchEvent searchEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) {
                if (searchEvent == null) {
                    searchEvent = new SearchEvent(this, this.searchparams, bl2, vector);
                }
                ((SearchListener)objectArray[n2 + 1]).itemsFound(searchEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireItemsFound(SearchEvent searchEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        Vector<SearchItem> vector = new Vector<SearchItem>();
        Enumeration enumeration = searchEvent.getSearchItems();
        while (enumeration.hasMoreElements()) {
            vector.addElement((SearchItem)enumeration.nextElement());
        }
        SearchEvent searchEvent2 = new SearchEvent(this, searchEvent.getParams(), searchEvent.isSearchCompleted(), vector);
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) {
                ((SearchListener)objectArray[n2 + 1]).itemsFound(searchEvent2);
            }
            n2 -= 2;
        }
    }

    protected void fireSearchStarted() {
        SearchQuery.debug("fireSearchStarted");
        Object[] objectArray = this.listenerList.getListenerList();
        SearchEvent searchEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) {
                if (searchEvent == null) {
                    searchEvent = new SearchEvent(this, this.searchparams, true);
                }
                ((SearchListener)objectArray[n2 + 1]).searchStarted(searchEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireSearchFinished() {
        SearchQuery.debug("fireSearchFinished");
        Object[] objectArray = this.listenerList.getListenerList();
        SearchEvent searchEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) {
                if (searchEvent == null) {
                    searchEvent = new SearchEvent(this, this.searchparams, false);
                }
                ((SearchListener)objectArray[n2 + 1]).searchFinished(searchEvent);
            }
            n2 -= 2;
        }
    }

    private static void debug(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

