/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.tftp;

import com.oroinc.net.tftp.TFTPPacket;
import com.oroinc.net.tftp.TFTPPacketException;
import java.net.DatagramPacket;
import java.net.InetAddress;

public abstract class TFTPRequestPacket
extends TFTPPacket {
    static final String[] _modeStrings = new String[]{"netascii", "octet"};
    static final byte[][] _modeBytes = new byte[][]{{110, 101, 116, 97, 115, 99, 105, 105, 0}, {111, 99, 116, 101, 116, 0}};
    int _mode;
    String _filename;

    TFTPRequestPacket(InetAddress inetAddress, int n2, int n3, String string, int n4) {
        super(n3, inetAddress, n2);
        this._filename = string;
        this._mode = n4;
    }

    TFTPRequestPacket(int n2, DatagramPacket datagramPacket) throws TFTPPacketException {
        super(n2, datagramPacket.getAddress(), datagramPacket.getPort());
        byte[] byArray = datagramPacket.getData();
        if (this.getType() != byArray[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 2;
        int n4 = datagramPacket.getLength();
        while (n3 < n4 && byArray[n3] != 0) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        this._filename = stringBuffer.toString();
        if (n3 >= n4) {
            throw new TFTPPacketException("Bad filename and mode format.");
        }
        stringBuffer.setLength(0);
        ++n3;
        while (n3 < n4 && byArray[n3] != 0) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        String string = stringBuffer.toString().toLowerCase();
        n4 = _modeStrings.length;
        n3 = 0;
        while (n3 < n4) {
            if (string.equals(_modeStrings[n3])) {
                this._mode = n3;
                break;
            }
            ++n3;
        }
        if (n3 >= n4) {
            throw new TFTPPacketException("Unrecognized TFTP transfer mode: " + string);
        }
    }

    final DatagramPacket _newDatagram(DatagramPacket datagramPacket, byte[] byArray) {
        int n2 = this._filename.length();
        int n3 = _modeBytes[this._mode].length;
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        System.arraycopy(this._filename.getBytes(), 0, byArray, 2, n2);
        byArray[n2 + 2] = 0;
        System.arraycopy(_modeBytes[this._mode], 0, byArray, n2 + 3, n3);
        datagramPacket.setAddress(this._address);
        datagramPacket.setPort(this._port);
        datagramPacket.setData(byArray);
        datagramPacket.setLength(n2 + n3 + 4);
        return datagramPacket;
    }

    public final DatagramPacket newDatagram() {
        int n2 = this._filename.length();
        int n3 = _modeBytes[this._mode].length;
        byte[] byArray = new byte[n2 + n3 + 4];
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        System.arraycopy(this._filename.getBytes(), 0, byArray, 2, n2);
        byArray[n2 + 2] = 0;
        System.arraycopy(_modeBytes[this._mode], 0, byArray, n2 + 3, n3);
        return new DatagramPacket(byArray, byArray.length, this._address, this._port);
    }

    public final int getMode() {
        return this._mode;
    }

    public final String getFilename() {
        return this._filename;
    }
}

