/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppNewCombo;
import com.sec.osdm.pages.utils.components.AppNewText;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class AppSetup
extends JDialog
implements ActionListener,
KeyListener,
ItemListener {
    private JTabbedPane m_tabPane = new JTabbedPane();
    private JPanel m_panMain = new JPanel();
    private JPanel m_panModem = new JPanel();
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private AppTable m_importTable = null;
    private AppTableModel m_importModel = null;
    private ArrayList m_component = new ArrayList();
    private AppTextBox m_compText = null;
    private JRadioButton m_compRadio = null;
    private String[][] m_corner = new String[][]{{""}};
    private String[][] m_colTitle = new String[][]{{"Select", "Site Name", "Link Type", "Destination/Tel Number", "Data/COM", "File/Baudrate", "FTP Port", "VM Port"}};
    private String[][] m_rowTitle = null;
    private Hashtable m_linkInfo = new Hashtable();
    private Hashtable m_modemInfo = new Hashtable();
    private String[] m_arrPort = new String[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM10"};
    private String[] m_arrRate = new String[]{"9600", "19200", "38400", "115200"};
    private JTextField m_dataPort = new JTextField("5090");
    private JTextField m_filePort = new JTextField("5003");
    private JTextField m_ftpPort = new JTextField("21");
    private JTextField m_vmPort = new JTextField("6001");
    private JTextField m_siteName = new JTextField();
    private JTextField m_siteInfo = new JTextField();
    private JComboBox m_cbPort = new JComboBox<String>(this.m_arrPort);
    private JComboBox m_cbRate = new JComboBox<String>(this.m_arrRate);
    private JRadioButton[] m_jbLink = new JRadioButton[2];
    private JCheckBox m_default = new JCheckBox(AppLang.getText("Default Port"), true);
    private JTextField m_dialRetry = new JTextField("1");
    private JTextField m_duration = new JTextField("90");
    private boolean m_bLanMode = true;
    private AppLayout m_layout = new AppLayout(this.m_panMain, 760, 760);
    private String m_exportFile = null;
    private String m_importFile = null;
    private String m_importITFile = null;
    private Workbook m_workBook = null;

    public AppSetup() {
        super(AppGlobal.g_frmMain, AppLang.getText("Setup"), true);
        this.m_linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        this.m_modemInfo = (Hashtable)AppProperty.m_properties.get("MODEM_INFO");
        this.m_bLanMode = ((String)this.m_linkInfo.get("LINK_KIND")).equals("LAN");
        this.createComponents();
        this.createModemOption();
        this.setComponent();
        this.setIconImage(AppImages.Img_Logo);
        this.getContentPane().add(this.m_tabPane);
        this.setSize(890, 600);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
        this.setVisible(true);
    }

    private void createComponents() {
        this.m_layout.addComponent(this.createLinkType(), 5, 5, 870, 60);
        this.m_layout.addComponent(this.createSiteInfo(), 5, 70, 870, 60);
        this.m_tabPane.add(AppLang.getText("Site List"), this.m_panMain);
        this.m_tabPane.add(AppLang.getText("MODEM Options"), this.m_panModem);
    }

    private JPanel createLinkType() {
        JPanel panLink = new JPanel();
        AppLayout layout = new AppLayout(panLink, 870, 60);
        ButtonGroup bgLink = new ButtonGroup();
        JLabel[] lbTitle = new JLabel[7];
        String[] strLink = new String[]{"LAN", "MODEM"};
        String[] strTitle = new String[]{"Data Port", "File Port", "COM Port", "Baudrate", "FTP Port", "VM Port"};
        panLink.setBorder(new LineBorder(Color.darkGray));
        int i2 = 0;
        while (i2 < strLink.length) {
            this.m_jbLink[i2] = new JRadioButton(AppLang.getText(strLink[i2]));
            this.m_jbLink[i2].setActionCommand(strLink[i2]);
            this.m_jbLink[i2].addActionListener(this);
            bgLink.add(this.m_jbLink[i2]);
            ++i2;
        }
        if (this.m_bLanMode) {
            this.m_jbLink[0].setSelected(true);
        } else {
            this.m_jbLink[1].setSelected(true);
        }
        i2 = 0;
        while (i2 < strTitle.length) {
            lbTitle[i2] = new JLabel(AppLang.getText(strTitle[i2]), 4);
            ++i2;
        }
        this.m_dataPort.addKeyListener(this);
        this.m_filePort.addKeyListener(this);
        this.m_ftpPort.addKeyListener(this);
        this.m_vmPort.addKeyListener(this);
        this.m_dataPort.setEnabled(false);
        this.m_filePort.setEnabled(false);
        this.m_ftpPort.setEnabled(false);
        this.m_vmPort.setEnabled(false);
        this.m_default.addItemListener(this);
        this.m_cbPort.setSelectedIndex(0);
        this.m_cbRate.setSelectedItem("38400");
        if (this.m_bLanMode) {
            this.m_dataPort.setText((String)this.m_linkInfo.get("DATA_PORT"));
            this.m_filePort.setText((String)this.m_linkInfo.get("FILE_PORT"));
            if (this.m_linkInfo.get("FTP_PORT") != null) {
                this.m_ftpPort.setText((String)this.m_linkInfo.get("FTP_PORT"));
            } else {
                this.m_ftpPort.setText("21");
            }
            if (this.m_linkInfo.get("VM_PORT") != null) {
                this.m_vmPort.setText((String)this.m_linkInfo.get("VM_PORT"));
            } else {
                this.m_vmPort.setText("6001");
            }
            if (!(this.m_dataPort.getText().trim().equals("5090") && this.m_filePort.getText().trim().equals("5003") && this.m_ftpPort.getText().trim().equals("21") && this.m_vmPort.getText().trim().equals("6001"))) {
                this.m_default.setSelected(false);
                this.m_dataPort.setEnabled(true);
                this.m_filePort.setEnabled(true);
                this.m_ftpPort.setEnabled(true);
                this.m_vmPort.setEnabled(true);
            }
        } else {
            if ((String)this.m_linkInfo.get("COM_PORT") != null && !((String)this.m_linkInfo.get("COM_PORT")).equals("")) {
                this.m_cbPort.setSelectedItem("COM" + (String)this.m_linkInfo.get("COM_PORT"));
            }
            if ((String)this.m_linkInfo.get("BAUD_RATE") != null && !((String)this.m_linkInfo.get("BAUD_RATE")).equals("")) {
                this.m_cbRate.setSelectedItem((String)this.m_linkInfo.get("BAUD_RATE"));
            }
        }
        layout.addComponent(this.m_jbLink[0], 5, 5, 80, 23);
        layout.addComponent(lbTitle[0], 90, 5, 80, 23);
        layout.addComponent(this.m_dataPort, 175, 5, 50, 23);
        layout.addComponent(lbTitle[1], 230, 5, 80, 23);
        layout.addComponent(this.m_filePort, 315, 5, 50, 23);
        layout.addComponent(lbTitle[4], 370, 5, 80, 23);
        layout.addComponent(this.m_ftpPort, 455, 5, 50, 23);
        layout.addComponent(lbTitle[5], 510, 5, 80, 23);
        layout.addComponent(this.m_vmPort, 595, 5, 50, 23);
        layout.addComponent(this.m_default, 715, 5, 150, 23);
        layout.addComponent(this.m_jbLink[1], 5, 32, 80, 23);
        layout.addComponent(lbTitle[2], 90, 32, 80, 23);
        layout.addComponent(this.m_cbPort, 175, 32, 80, 23);
        layout.addComponent(lbTitle[3], 260, 32, 80, 23);
        layout.addComponent(this.m_cbRate, 345, 32, 80, 23);
        return panLink;
    }

    private JPanel createSiteInfo() {
        JPanel panSite = new JPanel();
        JLabel lbSite = new JLabel(AppLang.getText("Site Name"), 4);
        JButton[] btButton = new JButton[6];
        JButton[] btExec = new JButton[3];
        String[] strButton = new String[]{"Apply", "Delete", "Close", "Import(xls)", "Export(xls)", "Import(IT)"};
        String[] strExec = new String[]{"Search", "Connect", "File"};
        JLabel lbInfo = new JLabel(AppLang.getText("Destination"), 4);
        AppLayout layout = new AppLayout(panSite, 870, 60);
        this.m_siteName.addKeyListener(this);
        int i2 = 0;
        while (i2 < strButton.length) {
            btButton[i2] = new JButton(AppLang.getText(strButton[i2]));
            btButton[i2].setActionCommand(strButton[i2]);
            btButton[i2].addActionListener(this);
            ++i2;
        }
        layout.addComponent(btButton[0], 640, 5, 105, 16);
        layout.addComponent(btButton[1], 640, 41, 105, 16);
        layout.addComponent(btButton[2], 750, 41, 115, 16);
        layout.addComponent(btButton[3], 640, 23, 105, 16);
        layout.addComponent(btButton[4], 750, 23, 115, 16);
        layout.addComponent(btButton[5], 750, 5, 115, 16);
        i2 = 0;
        while (i2 < strExec.length) {
            btExec[i2] = new JButton();
            btExec[i2].setToolTipText(strExec[i2]);
            btExec[i2].setActionCommand(strExec[i2]);
            btExec[i2].addActionListener(this);
            layout.addComponent(btExec[i2], i2 * 34 + 536, 5, 30, 24);
            ++i2;
        }
        btExec[0].setIcon(AppImages.Img_Find);
        btExec[1].setIcon(AppImages.Img_Connect);
        btExec[2].setIcon(AppImages.Img_FileControl);
        layout.addComponent(lbSite, 5, 5, 110, 25);
        layout.addComponent(this.m_siteName, 117, 5, 415, 25);
        layout.addComponent(lbInfo, 5, 32, 110, 25);
        layout.addComponent(this.m_siteInfo, 117, 32, 520, 25);
        panSite.setBorder(new LineBorder(Color.darkGray));
        return panSite;
    }

    private void createModemOption() {
        JLabel[] lbTitle = new JLabel[5];
        String[] strTitle = new String[]{"Dial Retry", "Dial Duration", "sec", "Dial Type", "Init. Command"};
        final JTextField initCommand = new JTextField("AT&F");
        final JRadioButton rbType = new JRadioButton("DTMF", true);
        JRadioButton rbType1 = new JRadioButton("PULSE", false);
        ButtonGroup bgType = new ButtonGroup();
        JButton btnApply = new JButton(AppLang.getText("Apply"));
        AppLayout layout = new AppLayout(this.m_panModem, 750, 600);
        int i2 = 0;
        while (i2 < lbTitle.length) {
            lbTitle[i2] = new JLabel(AppLang.getText(strTitle[i2]), 4);
            ++i2;
        }
        lbTitle[2].setHorizontalAlignment(2);
        bgType.add(rbType);
        bgType.add(rbType1);
        this.m_dialRetry.addKeyListener(this);
        this.m_duration.addKeyListener(this);
        this.m_dialRetry.setText((String)this.m_modemInfo.get("DIAL_RETRY"));
        this.m_duration.setText((String)this.m_modemInfo.get("DIAL_DURATION"));
        if (((String)this.m_modemInfo.get("DIAL_TYPE")).equals("1")) {
            rbType1.setSelected(true);
        } else {
            rbType.setSelected(true);
        }
        initCommand.setText((String)this.m_modemInfo.get("INIT_COMMAND"));
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AppSetup.this.m_modemInfo.put("DIAL_RETRY", AppSetup.this.m_dialRetry.getText().trim());
                AppSetup.this.m_modemInfo.put("DIAL_DURATION", AppSetup.this.m_duration.getText().trim());
                AppSetup.this.m_modemInfo.put("DIAL_TYPE", "1");
                if (rbType.isSelected()) {
                    AppSetup.this.m_modemInfo.put("DIAL_TYPE", "0");
                }
                AppSetup.this.m_modemInfo.put("INIT_COMMAND", initCommand.getText().trim());
                AppProperty.m_properties.put("MODEM_INFO", AppSetup.this.m_modemInfo);
                AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            }
        });
        layout.addComponent(lbTitle[0], 20, 10, 125, 23);
        layout.addComponent(this.m_dialRetry, 155, 10, 100, 23);
        layout.addComponent(lbTitle[1], 310, 10, 140, 23);
        layout.addComponent(this.m_duration, 470, 10, 100, 23);
        layout.addComponent(lbTitle[2], 575, 10, 50, 23);
        layout.addComponent(lbTitle[3], 20, 40, 125, 23);
        layout.addComponent(rbType, 155, 40, 100, 23);
        layout.addComponent(rbType1, 270, 40, 100, 23);
        layout.addComponent(lbTitle[4], 10, 70, 140, 23);
        layout.addComponent(initCommand, 155, 70, 300, 23);
        layout.addComponent(btnApply, 470, 70, 105, 23);
    }

    private void setComponent() {
        ArrayList<Object> compData = null;
        Hashtable siteList = new Hashtable();
        ArrayList siteInfo = new ArrayList();
        Vector vtTemp = null;
        String siteName2 = "";
        int cnt = 0;
        this.m_component.clear();
        int i2 = 0;
        while (i2 < AppProperty.m_sitelist.size()) {
            siteList = (Hashtable)AppProperty.m_sitelist.get(i2);
            vtTemp = new Vector(siteList.keySet());
            Collections.sort(vtTemp);
            for (String siteName2 : vtTemp) {
                siteInfo = (ArrayList)siteList.get(siteName2);
                compData = new ArrayList<Object>();
                this.m_compRadio = new JRadioButton("", false);
                this.m_compRadio.setHorizontalAlignment(0);
                if (siteName2.equals((String)this.m_linkInfo.get("SITE_NAME")) && (i2 == 0 && ((String)this.m_linkInfo.get("LINK_KIND")).equals("LAN") || i2 == 1 && ((String)this.m_linkInfo.get("LINK_KIND")).equals("MODEM"))) {
                    this.m_compRadio.setSelected(true);
                    this.m_siteName.setText((String)this.m_linkInfo.get("SITE_NAME"));
                    this.m_siteInfo.setText((String)siteInfo.get(0));
                }
                this.m_compRadio.setActionCommand("" + cnt);
                this.m_compRadio.addActionListener(new SelectListener());
                compData.add(0, this.m_compRadio);
                this.m_compText = new AppTextBox();
                this.m_compText.setText(siteName2);
                compData.add(1, this.m_compText);
                this.m_compText = new AppTextBox();
                this.m_compText.setText(i2 == 0 ? "LAN" : "MODEM");
                compData.add(2, this.m_compText);
                this.m_compText = new AppTextBox();
                this.m_compText.setText((String)siteInfo.get(0));
                compData.add(3, this.m_compText);
                this.m_compText = new AppTextBox();
                this.m_compText.setText(i2 == 0 ? (String)siteInfo.get(1) : "COM" + (String)siteInfo.get(1));
                compData.add(4, this.m_compText);
                this.m_compText = new AppTextBox();
                this.m_compText.setText(i2 == 0 ? (String)siteInfo.get(2) : String.valueOf((String)siteInfo.get(2)) + "bps");
                compData.add(5, this.m_compText);
                this.m_compText = new AppTextBox();
                if (i2 == 0) {
                    if (siteInfo.size() <= 3) {
                        this.m_compText.setText("21");
                    } else {
                        this.m_compText.setText((String)siteInfo.get(3));
                    }
                } else {
                    this.m_compText.setText("");
                }
                compData.add(6, this.m_compText);
                this.m_compText = new AppTextBox();
                if (i2 == 0) {
                    if (siteInfo.size() <= 4) {
                        this.m_compText.setText("6001");
                    } else {
                        this.m_compText.setText((String)siteInfo.get(4));
                    }
                } else {
                    this.m_compText.setText("");
                }
                compData.add(7, this.m_compText);
                this.m_component.add(cnt, compData);
                ++cnt;
            }
            ++i2;
        }
        this.m_rowTitle = new String[this.m_component.size()][1];
        this.createTable();
    }

    private void createTable() {
        if (this.m_table != null) {
            this.m_panMain.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppSetup.this.m_component.get(row);
                if (col == 0) {
                    return (JRadioButton)compData.get(col);
                }
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.m_model.setRowWidth(new int[1]);
        this.m_model.setColWidth(new int[]{70, 152, 110, 160, 90, 110, 80, 80});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model, 2);
        this.m_layout.addComponent(this.m_table, 5, 135, 870, 400);
    }

    private void getTableFilter() {
        String siteName = this.m_siteName.getText().trim();
        if (siteName.equals("")) {
            int i2 = 0;
            while (i2 < this.m_model.getRowHdrRowCount()) {
                this.m_table.setRowHeight(i2, 22);
                ++i2;
            }
        } else {
            String site = "";
            int i3 = 0;
            while (i3 < this.m_model.getRowHdrRowCount()) {
                site = ((AppTextBox)this.m_model.getValueAt(i3, 1)).getText().trim();
                this.m_table.setRowHidden(i3);
                if (site.startsWith(siteName)) {
                    this.m_table.setRowHeight(i3, 22);
                }
                ++i3;
            }
        }
    }

    private void addTableData() {
        String siteName = this.m_siteName.getText().trim();
        String siteInfo = this.m_siteInfo.getText().trim();
        Hashtable siteList = null;
        String sValue = "";
        if (!siteName.equals("") && !siteInfo.equals("") && this.m_bLanMode) {
            if (!AppFunctions.checkIPAddress(null, siteInfo)) {
                this.m_siteInfo.setText("");
                return;
            }
            if (this.m_dataPort.getText().trim().equals("") || this.m_filePort.getText().trim().equals("") || this.m_ftpPort.getText().trim().equals("") || this.m_vmPort.getText().trim().equals("")) {
                return;
            }
            int dataPort = Integer.parseInt(this.m_dataPort.getText().trim());
            int filePort = Integer.parseInt(this.m_filePort.getText().trim());
            int ftpPort = Integer.parseInt(this.m_ftpPort.getText().trim());
            int vmPort = Integer.parseInt(this.m_vmPort.getText().trim());
            if (dataPort < 1 || dataPort > 65535 || filePort < 1 || filePort > 65535 || ftpPort < 1 || ftpPort > 65535 || vmPort < 1 || vmPort > 65535) {
                AppGlobal.showWarnMessage("", "You must input port number between 1 and 65535.");
                if (dataPort < 1 || dataPort > 65535) {
                    this.m_dataPort.setText("");
                }
                if (filePort < 1 || filePort > 65535) {
                    this.m_filePort.setText("");
                }
                if (ftpPort < 1 || ftpPort > 65535) {
                    this.m_ftpPort.setText("");
                }
                if (vmPort < 1 || vmPort > 65535) {
                    this.m_vmPort.setText("");
                }
                return;
            }
        }
        if ((siteList = this.m_bLanMode ? (Hashtable)AppProperty.m_sitelist.get(0) : (Hashtable)AppProperty.m_sitelist.get(1)).containsKey(siteName) && AppGlobal.showConfirmMessage("Change", "There is a same site. Do you want to change?") == 1) {
            return;
        }
        ArrayList<String> siteData = new ArrayList<String>();
        if (this.m_bLanMode) {
            siteData.add(0, siteInfo);
            siteData.add(1, this.m_dataPort.getText().trim());
            siteData.add(2, this.m_filePort.getText().trim());
            siteData.add(3, this.m_ftpPort.getText().trim());
            siteData.add(4, this.m_vmPort.getText().trim());
        } else {
            siteData.add(0, siteInfo);
            siteData.add(1, "" + (this.m_cbPort.getSelectedIndex() + 1));
            siteData.add(2, (String)this.m_cbRate.getSelectedItem());
        }
        siteList.put(siteName, siteData);
        if (this.m_bLanMode) {
            AppProperty.m_sitelist.set(0, siteList);
        } else {
            AppProperty.m_sitelist.set(1, siteList);
        }
        AppProperty.saveDataToFile(AppProperty.m_fileSiteList, AppProperty.m_sitelist);
        this.setLinkInfo();
        this.setComponent();
        sValue = String.valueOf((String)siteData.get(0)) + ";" + (String)siteData.get(1) + ";" + (String)siteData.get(2);
        if (this.m_bLanMode) {
            sValue = String.valueOf(sValue) + ";" + (String)siteData.get(3);
        }
        AppGlobal.g_frmMain.m_toolBar.addLinkPopupItem(siteName, sValue, this.m_bLanMode);
    }

    private void removeTableData() {
        String siteName = "";
        int i2 = 0;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            if (((JRadioButton)this.m_model.getValueAt(i2, 0)).isSelected()) {
                siteName = ((AppTextBox)this.m_model.getValueAt(i2, 1)).getText().trim();
                break;
            }
            ++i2;
        }
        if (!siteName.equals("")) {
            Hashtable siteList = new Hashtable();
            if (this.m_bLanMode) {
                siteList = (Hashtable)AppProperty.m_sitelist.get(0);
                siteList.remove(siteName);
                AppProperty.m_sitelist.set(0, siteList);
            } else {
                siteList = (Hashtable)AppProperty.m_sitelist.get(1);
                siteList.remove(siteName);
                AppProperty.m_sitelist.set(1, siteList);
            }
            AppProperty.saveDataToFile(AppProperty.m_fileSiteList, AppProperty.m_sitelist);
            if (siteName.equals((String)this.m_linkInfo.get("SITE_NAME"))) {
                this.m_linkInfo.put("SITE_NAME", "");
                AppProperty.m_properties.put("LINK_INFO", this.m_linkInfo);
                AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            }
            this.m_siteName.setText("");
            this.m_siteInfo.setText("");
            AppGlobal.g_frmMain.m_toolBar.removeLinkPopupItem(siteName);
            this.setComponent();
        }
    }

    private void setLinkInfo() {
        this.m_linkInfo.put("LINK_KIND", "LAN");
        if (!this.m_bLanMode) {
            this.m_linkInfo.put("LINK_KIND", "MODEM");
        }
        this.m_linkInfo.put("SITE_NAME", this.m_siteName.getText().trim());
        this.m_linkInfo.put("IP_ADDRESS", this.m_siteInfo.getText().trim());
        this.m_linkInfo.put("DATA_PORT", this.m_dataPort.getText().trim());
        this.m_linkInfo.put("FILE_PORT", this.m_filePort.getText().trim());
        this.m_linkInfo.put("FTP_PORT", this.m_ftpPort.getText().trim());
        this.m_linkInfo.put("VM_PORT", this.m_vmPort.getText().trim());
        this.m_linkInfo.put("TEL_NUMBER", this.m_siteInfo.getText().trim());
        this.m_linkInfo.put("COM_PORT", "" + (this.m_cbPort.getSelectedIndex() + 1));
        this.m_linkInfo.put("BAUD_RATE", (String)this.m_cbRate.getSelectedItem());
        AppProperty.m_properties.put("LINK_INFO", this.m_linkInfo);
        AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
    }

    private void importIT() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("IT Site List File")) + "(*.isd)", "isd");
        if (browser.openBrowser()) {
            this.m_importITFile = browser.getFilePath();
            if (!browser.getFileName().equals("Link.isd")) {
                AppGlobal.showErrorMessage("Error", "This file is not a Site List file. [Link.isd] \ndefault folder = C:\\Program Files\\Samsung Electronics\\Installation_Tool\\DB");
                return;
            }
            if (!this.m_importITFile.trim().equals("")) {
                ExecuteITImport m_importIT = new ExecuteITImport();
                m_importIT.start();
            }
        }
    }

    private void importSiteList() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("Excel File")) + "(*.xls)", "xls");
        if (browser.openBrowser()) {
            this.m_importFile = browser.getFilePath();
            if (!this.m_importFile.trim().equals("")) {
                ExecuteImport m_import = new ExecuteImport();
                m_import.start();
            }
        }
    }

    private void exportSiteList() {
        JFileChooser jfc = new JFileChooser((String)AppProperty.m_properties.get("USER_DIR"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(AppLang.getText("Excel File")) + "(*.xls)", "xls");
        jfc.setFileFilter(filter);
        jfc.setDialogType(1);
        int yn = jfc.showOpenDialog(null);
        if (yn == 0) {
            File fd;
            AppProperty.m_properties.put("USER_DIR", jfc.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            this.m_exportFile = jfc.getSelectedFile().getAbsolutePath();
            if (!this.m_exportFile.endsWith(".xls")) {
                this.m_exportFile = String.valueOf(this.m_exportFile) + ".xls";
            }
            if ((fd = new File(this.m_exportFile)).exists()) {
                try {
                    Workbook workbook = Workbook.getWorkbook(fd);
                    String[] items = workbook.getSheetNames();
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, e2.getMessage());
                }
            }
            if (!this.m_exportFile.trim().equals("")) {
                AppGlobal.showProgress("Export data to excel file...", "Site List..");
                ExecuteExport export = new ExecuteExport();
                export.start();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("LAN") || command.equals("MODEM")) {
            this.m_bLanMode = command.equals("LAN");
        } else if (command.equals("Search")) {
            this.getTableFilter();
        } else if (command.equals("Connect") || command.equals("File")) {
            if (!this.m_siteName.getText().trim().equals("") && !this.m_siteInfo.getText().trim().equals("")) {
                if (this.m_bLanMode && (this.m_dataPort.getText().trim().equals("") || this.m_filePort.getText().trim().equals(""))) {
                    return;
                }
                this.setLinkInfo();
                this.dispose();
                if (command.equals("Connect")) {
                    AppMenuActions.s_actConnect.actionPerformed(null);
                } else {
                    AppMenuActions.s_actFileControl.actionPerformed(null);
                }
            }
        } else if (command.equals("Apply")) {
            this.addTableData();
        } else if (command.equals("Delete")) {
            this.removeTableData();
        } else if (command.equals("Close")) {
            this.dispose();
        } else if (command.equals("Import(xls)")) {
            this.importSiteList();
        } else if (command.equals("Export(xls)")) {
            this.exportSiteList();
        } else if (command.equals("Import(IT)")) {
            this.importIT();
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (e2.getSource() == this.m_dataPort || e2.getSource() == this.m_filePort || e2.getSource() == this.m_ftpPort || e2.getSource() == this.m_vmPort || e2.getSource() == this.m_dialRetry || e2.getSource() == this.m_duration) {
            String port = ((JTextField)e2.getSource()).getText().trim();
            if (port != null && !port.equals("") && !Character.isDigit(port.charAt(port.length() - 1))) {
                AppGlobal.showWarnMessage("", "You must input only number.");
                ((JTextField)e2.getSource()).setText(port.substring(0, port.length() - 1));
                return;
            }
        } else if (e2.getSource() == this.m_siteName) {
            if (e2.getKeyCode() == 10) {
                this.getTableFilter();
            }
        } else if (e2.getSource() == this.m_siteInfo && e2.getKeyCode() == 10) {
            this.addTableData();
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        JCheckBox port = (JCheckBox)e2.getSource();
        this.m_dataPort.setEnabled(true);
        this.m_filePort.setEnabled(true);
        this.m_ftpPort.setEnabled(true);
        this.m_vmPort.setEnabled(true);
        if (port.isSelected()) {
            this.m_dataPort.setText("5090");
            this.m_filePort.setText("5003");
            this.m_ftpPort.setText("21");
            this.m_vmPort.setText("6001");
            this.m_dataPort.setEnabled(false);
            this.m_filePort.setEnabled(false);
            this.m_ftpPort.setEnabled(false);
            this.m_vmPort.setEnabled(false);
        }
    }

    class ExecuteExport
    extends Thread {
        ExecuteExport() {
        }

        @Override
        public void run() {
            File file = new File(AppSetup.this.m_exportFile.trim());
            WritableWorkbook m_workBook = null;
            try {
                int j2;
                if (file.exists()) {
                    Workbook workbook = Workbook.getWorkbook(file);
                    m_workBook = Workbook.createWorkbook(file, workbook);
                } else {
                    m_workBook = Workbook.createWorkbook(file);
                }
                String[] sheetNames = m_workBook.getSheetNames();
                int i2 = 0;
                while (i2 < sheetNames.length) {
                    if (sheetNames[i2].equals("Site List")) {
                        m_workBook.removeSheet(i2);
                        break;
                    }
                    ++i2;
                }
                WritableSheet sheet = m_workBook.createSheet("Site List", 0);
                WritableCellFormat fColumns = new WritableCellFormat();
                WritableCellFormat fData = new WritableCellFormat();
                fColumns.setBackground(Colour.GRAY_25);
                fColumns.setBorder(Border.ALL, BorderLineStyle.THIN);
                Label label = null;
                String data = "";
                int row = 1;
                int col = 1;
                int i3 = 0;
                while (i3 < AppSetup.this.m_model.getCornerHdrColCount()) {
                    j2 = 0;
                    while (j2 < AppSetup.this.m_model.getCornerHdrRowCount()) {
                        data = (String)AppSetup.this.m_model.getCornerHdrNames(j2, i3);
                        label = new Label(col + i3, row + j2, data, (CellFormat)fColumns);
                        sheet.addCell(label);
                        ++j2;
                    }
                    ++i3;
                }
                col += AppSetup.this.m_model.getCornerHdrColCount();
                i3 = 1;
                while (i3 < AppSetup.this.m_model.getColHdrColCount()) {
                    if (!AppSetup.this.m_model.isColHidden(i3)) {
                        j2 = 0;
                        while (j2 < AppSetup.this.m_model.getColHdrRowCount()) {
                            data = (String)AppSetup.this.m_model.getColHdrName(j2, i3);
                            label = new Label(col, row + j2, data, (CellFormat)fColumns);
                            sheet.addCell(label);
                            ++j2;
                        }
                        ++col;
                    }
                    ++i3;
                }
                col = 1;
                row += AppSetup.this.m_model.getCornerHdrRowCount();
                i3 = 0;
                while (i3 < AppSetup.this.m_model.getRowHdrColCount()) {
                    j2 = 0;
                    while (j2 < AppSetup.this.m_model.getRowHdrRowCount()) {
                        data = (String)AppSetup.this.m_model.getRowHdrName(j2, i3);
                        label = new Label(col + i3, row + j2, data, (CellFormat)fColumns);
                        sheet.addCell(label);
                        ++j2;
                    }
                    ++i3;
                }
                row = AppSetup.this.m_model.getCornerHdrRowCount() + 1;
                col = AppSetup.this.m_model.getCornerHdrColCount() + 1;
                fData.setBorder(Border.ALL, BorderLineStyle.THIN);
                i3 = 1;
                while (i3 < AppSetup.this.m_model.getColHdrColCount()) {
                    if (!AppSetup.this.m_model.isColHidden(i3)) {
                        j2 = 0;
                        while (j2 < AppSetup.this.m_model.getRowHdrRowCount()) {
                            Object obj = AppSetup.this.m_model.getValueAt(j2, i3);
                            label = obj instanceof AppComboBox ? new Label(col, row + j2, ((AppComboBox)obj).getSelectedItem(), (CellFormat)fData) : (obj instanceof AppTextBox ? new Label(col, row + j2, ((AppTextBox)obj).getText().trim(), (CellFormat)fData) : (obj instanceof AppNewCombo ? new Label(col, row + j2, (String)((AppNewCombo)obj).getSelectedItem(), (CellFormat)fData) : new Label(col, row + j2, ((AppNewText)obj).getText().trim(), (CellFormat)fData)));
                            sheet.addCell(label);
                            ++j2;
                        }
                        ++col;
                    }
                    ++i3;
                }
                m_workBook.write();
                m_workBook.close();
            }
            catch (Exception e1) {
                AppGlobal.hideProgress();
                JOptionPane.showMessageDialog(null, e1.getMessage());
            }
            AppGlobal.hideProgress();
        }
    }

    class ExecuteITImport
    extends Thread {
        ExecuteITImport() {
        }

        @Override
        public void run() {
            String m_baudrate = "";
            String m_filePort = "5003";
            String m_ftpPort = "21";
            String m_vmPort = "6001";
            String sValue = "";
            Hashtable siteList = null;
            AppGlobal.showProgress(AppLang.getText("Import data from IT Site Lists..."), "Site List..");
            Table table = null;
            try {
                table = Database.open(new File(AppSetup.this.m_importITFile.trim())).getTable("SystemList");
                for (Map<String, Object> row : table) {
                    String m_name = row.get("Name").toString();
                    String m_kind = row.get("Kind").toString();
                    String m_dest = row.get("Destination").toString();
                    String m_opt1 = row.get("Option1").toString();
                    String m_opt2 = row.get("Option2").toString();
                    boolean m_lanMode = m_kind.equals("0");
                    if (!m_lanMode) {
                        switch (Integer.parseInt(m_opt2)) {
                            case 0: {
                                m_baudrate = "1200";
                                break;
                            }
                            case 1: {
                                m_baudrate = "2400";
                                break;
                            }
                            case 2: {
                                m_baudrate = "4800";
                                break;
                            }
                            case 3: {
                                m_baudrate = "9600";
                                break;
                            }
                            case 4: {
                                m_baudrate = "19200";
                                break;
                            }
                            case 5: {
                                m_baudrate = "38400";
                                break;
                            }
                            case 6: {
                                m_baudrate = "57600";
                                break;
                            }
                            case 7: {
                                m_baudrate = "115200";
                                break;
                            }
                        }
                    }
                    if (m_lanMode && !AppFunctions.checkIPAddress(null, m_dest) || m_name.equals("") || m_kind.equals("") || (siteList = m_lanMode ? (Hashtable)AppProperty.m_sitelist.get(0) : (Hashtable)AppProperty.m_sitelist.get(1)).containsKey(m_name) && AppGlobal.showConfirmMessage("Change", "[" + m_name + "]" + " There is a same site. Do you want to change?") == 1) continue;
                    ArrayList<String> siteData = new ArrayList<String>();
                    if (m_lanMode) {
                        siteData.add(0, m_dest);
                        siteData.add(1, m_opt1.trim());
                        siteData.add(2, m_opt2.trim());
                        siteData.add(3, "21".trim());
                        siteData.add(4, "6001".trim());
                    } else {
                        siteData.add(0, m_name);
                        siteData.add(1, String.valueOf(Integer.parseInt(m_opt1) + 1));
                        siteData.add(2, m_baudrate);
                    }
                    siteList.put(m_name, siteData);
                    if (m_lanMode) {
                        AppProperty.m_sitelist.set(0, siteList);
                    } else {
                        AppProperty.m_sitelist.set(1, siteList);
                    }
                    AppProperty.saveDataToFile(AppProperty.m_fileSiteList, AppProperty.m_sitelist);
                    AppSetup.this.m_linkInfo.put("LINK_KIND", "LAN");
                    if (!m_lanMode) {
                        AppSetup.this.m_linkInfo.put("LINK_KIND", "MODEM");
                    }
                    AppSetup.this.m_linkInfo.put("SITE_NAME", m_name);
                    AppSetup.this.m_linkInfo.put("IP_ADDRESS", m_dest);
                    AppSetup.this.m_linkInfo.put("DATA_PORT", m_opt1);
                    AppSetup.this.m_linkInfo.put("FILE_PORT", m_opt2);
                    AppSetup.this.m_linkInfo.put("FTP_PORT", "21");
                    AppSetup.this.m_linkInfo.put("VM_PORT", "6001");
                    AppSetup.this.m_linkInfo.put("TEL_NUMBER", m_name);
                    AppSetup.this.m_linkInfo.put("COM_PORT", String.valueOf(Integer.parseInt(m_opt1) + 1));
                    AppSetup.this.m_linkInfo.put("BAUD_RATE", m_baudrate);
                    AppProperty.m_properties.put("LINK_INFO", AppSetup.this.m_linkInfo);
                    AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
                    sValue = String.valueOf((String)siteData.get(0)) + ";" + (String)siteData.get(1) + ";" + (String)siteData.get(2);
                    if (m_lanMode) {
                        sValue = String.valueOf(sValue) + ";" + (String)siteData.get(3);
                    }
                    AppGlobal.g_frmMain.m_toolBar.addLinkPopupItem(m_name, sValue, m_lanMode);
                }
                AppSetup.this.setComponent();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            AppGlobal.hideProgress();
        }
    }

    class ExecuteImport
    extends Thread {
        ExecuteImport() {
        }

        @Override
        public void run() {
            String sValue = "";
            Hashtable siteList = null;
            try {
                AppGlobal.showProgress(AppLang.getText("Import data from excel file..."), "Site List..");
                File file = new File(AppSetup.this.m_importFile.trim());
                if (file.exists()) {
                    Workbook workbook = Workbook.getWorkbook(file);
                    Sheet sheet = workbook.getSheet(0);
                    int col = sheet.getColumns();
                    int row = sheet.getRows();
                    int i2 = 2;
                    while (i2 < row) {
                        boolean m_bLanMode;
                        String m_vmPort;
                        String m_ftpPort;
                        String m_filePort;
                        String m_dataPort;
                        int k2 = 2;
                        Cell cell = sheet.getCell(k2++, i2);
                        String m_siteName = cell.getContents();
                        cell = sheet.getCell(k2++, i2);
                        String m_lanMode = cell.getContents().trim();
                        cell = sheet.getCell(k2++, i2);
                        String m_siteInfo = cell.getContents().trim();
                        if ((m_dataPort = (cell = sheet.getCell(k2++, i2)).getContents().trim()).equals("")) {
                            m_dataPort = "5090";
                        }
                        if ((m_filePort = (cell = sheet.getCell(k2++, i2)).getContents().trim()).equals("")) {
                            m_filePort = "5003";
                        }
                        if ((m_ftpPort = (cell = sheet.getCell(k2++, i2)).getContents().trim()).equals("")) {
                            m_ftpPort = "21";
                        }
                        if ((m_vmPort = (cell = sheet.getCell(k2++, i2)).getContents().trim()).equals("")) {
                            m_vmPort = "6001";
                        }
                        if (!((m_bLanMode = m_lanMode.equals("LAN")) && !AppFunctions.checkIPAddress(null, m_siteInfo) || m_siteName.equals("") || m_lanMode.equals("") || (siteList = m_bLanMode ? (Hashtable)AppProperty.m_sitelist.get(0) : (Hashtable)AppProperty.m_sitelist.get(1)).containsKey(m_siteName) && AppGlobal.showConfirmMessage("Change", "[" + m_siteName + "]" + " There is a same site. Do you want to change?") == 1)) {
                            ArrayList<String> siteData = new ArrayList<String>();
                            if (m_bLanMode) {
                                siteData.add(0, m_siteInfo);
                                siteData.add(1, m_dataPort.trim());
                                siteData.add(2, m_filePort.trim());
                                siteData.add(3, m_ftpPort.trim());
                                siteData.add(4, m_vmPort.trim());
                            } else {
                                siteData.add(0, m_siteInfo);
                                siteData.add(1, m_dataPort.substring(3));
                                siteData.add(2, m_filePort.split("b")[0]);
                            }
                            siteList.put(m_siteName, siteData);
                            if (m_bLanMode) {
                                AppProperty.m_sitelist.set(0, siteList);
                            } else {
                                AppProperty.m_sitelist.set(1, siteList);
                            }
                            AppProperty.saveDataToFile(AppProperty.m_fileSiteList, AppProperty.m_sitelist);
                            AppSetup.this.m_linkInfo.put("LINK_KIND", "LAN");
                            if (!m_bLanMode) {
                                AppSetup.this.m_linkInfo.put("LINK_KIND", "MODEM");
                            }
                            AppSetup.this.m_linkInfo.put("SITE_NAME", m_siteName);
                            AppSetup.this.m_linkInfo.put("IP_ADDRESS", m_siteInfo);
                            AppSetup.this.m_linkInfo.put("DATA_PORT", m_dataPort);
                            AppSetup.this.m_linkInfo.put("FILE_PORT", m_filePort);
                            AppSetup.this.m_linkInfo.put("FTP_PORT", m_ftpPort);
                            AppSetup.this.m_linkInfo.put("VM_PORT", m_vmPort);
                            AppSetup.this.m_linkInfo.put("TEL_NUMBER", m_siteInfo);
                            AppSetup.this.m_linkInfo.put("COM_PORT", m_dataPort.substring(3));
                            AppSetup.this.m_linkInfo.put("BAUD_RATE", m_filePort.split("b")[0]);
                            AppProperty.m_properties.put("LINK_INFO", AppSetup.this.m_linkInfo);
                            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
                            sValue = String.valueOf((String)siteData.get(0)) + ";" + (String)siteData.get(1) + ";" + (String)siteData.get(2);
                            if (m_bLanMode) {
                                sValue = String.valueOf(sValue) + ";" + (String)siteData.get(3);
                            }
                            AppGlobal.g_frmMain.m_toolBar.addLinkPopupItem(m_siteName, sValue, m_bLanMode);
                        }
                        ++i2;
                    }
                    AppSetup.this.setComponent();
                }
            }
            catch (Exception e1) {
                AppGlobal.hideProgress();
                JOptionPane.showMessageDialog(null, e1.getMessage());
            }
            AppGlobal.hideProgress();
        }
    }

    class SelectListener
    implements ActionListener {
        SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int row = Integer.parseInt(e2.getActionCommand());
            int i2 = 0;
            while (i2 < AppSetup.this.m_model.getRowHdrRowCount()) {
                ((JRadioButton)AppSetup.this.m_model.getValueAt(i2, 0)).setSelected(false);
                if (i2 == row) {
                    ((JRadioButton)AppSetup.this.m_model.getValueAt(i2, 0)).setSelected(true);
                    String mode = ((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 2)).getText().trim();
                    AppSetup.this.m_siteName.setText(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 1)).getText().trim());
                    AppSetup.this.m_siteInfo.setText(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 3)).getText().trim());
                    AppSetup.this.m_default.setSelected(true);
                    AppSetup.this.m_dataPort.setEnabled(false);
                    AppSetup.this.m_filePort.setEnabled(false);
                    AppSetup.this.m_ftpPort.setEnabled(false);
                    AppSetup.this.m_vmPort.setEnabled(false);
                    if (mode.equals("LAN")) {
                        AppSetup.this.m_dataPort.setText(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 4)).getText().trim());
                        AppSetup.this.m_filePort.setText(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 5)).getText().trim());
                        AppSetup.this.m_ftpPort.setText(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 6)).getText().trim());
                        AppSetup.this.m_vmPort.setText(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 7)).getText().trim());
                        AppSetup.this.m_bLanMode = true;
                        AppSetup.this.m_jbLink[0].setSelected(true);
                        if (!(AppSetup.this.m_dataPort.getText().trim().equals("5090") && AppSetup.this.m_filePort.getText().trim().equals("5003") && AppSetup.this.m_ftpPort.getText().trim().equals("21") && AppSetup.this.m_vmPort.getText().trim().equals("6001"))) {
                            AppSetup.this.m_default.setSelected(false);
                            AppSetup.this.m_dataPort.setEnabled(true);
                            AppSetup.this.m_filePort.setEnabled(true);
                            AppSetup.this.m_ftpPort.setEnabled(true);
                            AppSetup.this.m_vmPort.setEnabled(true);
                        }
                    } else {
                        String rate = ((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 5)).getText().trim();
                        rate = rate.replace("bps", "");
                        AppSetup.this.m_cbPort.setSelectedItem(((AppTextBox)AppSetup.this.m_model.getValueAt(i2, 4)).getText().trim());
                        AppSetup.this.m_cbRate.setSelectedItem(rate);
                        AppSetup.this.m_bLanMode = false;
                        AppSetup.this.m_jbLink[1].setSelected(true);
                    }
                }
                ++i2;
            }
            AppSetup.this.m_table.repaint();
        }
    }
}

