/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.utils.AppDialog;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class AppEnvironSettings
extends AppDialog {
    private final int SIZE_WIDTH = 380;
    private final int SIZE_HEIGHT = 310;
    private JPanel panMiscellaneous = new JPanel();
    private JCheckBox cbUseToolBar = new JCheckBox(AppLang.getText("Use Tool Bar"), (boolean)((Boolean)AppProperty.m_properties.get("USE_TOOLBAR")));
    private JCheckBox cbOpenPage = new JCheckBox(AppLang.getText("Open Page Circularly in maximum of window"), (boolean)((Boolean)AppProperty.m_properties.get("OPEN_PAGE")));
    private JCheckBox cbDisplayMMC = new JCheckBox(AppLang.getText("Display MMC number in tree menu"), (boolean)((Boolean)AppProperty.m_properties.get("DISPLAY_MMC")));
    private JPanel panSortMethod = new JPanel();
    private JRadioButton rbPort = new JRadioButton(AppLang.getText("By Port"));
    private JRadioButton rbNumber = new JRadioButton(AppLang.getText("By Number"));
    private ButtonGroup bgType = new ButtonGroup();
    private JButton jbApply = new JButton(AppLang.getText("Apply"));
    private JButton jbCancel = new JButton(AppLang.getText("Cancel"));

    public AppEnvironSettings() {
        this.m_layout = new AppLayout(this.m_contentPane, 380, 310);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppEnvironSettings.this.openDialog("Environment Settings", 380, 310);
            }
        });
    }

    private void createComponents() {
        this.panMiscellaneous.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("Miscellaneous") + " "));
        this.panMiscellaneous.setSize(340, 200);
        this.panMiscellaneous.setLocation(20, 20);
        this.panMiscellaneous.setLayout(null);
        this.cbUseToolBar.setSize(300, 20);
        this.cbUseToolBar.setLocation(20, 25);
        this.panMiscellaneous.add(this.cbUseToolBar);
        this.cbOpenPage.setSize(300, 20);
        this.cbOpenPage.setLocation(20, 50);
        this.panMiscellaneous.add(this.cbOpenPage);
        this.cbDisplayMMC.setSize(300, 20);
        this.cbDisplayMMC.setLocation(20, 75);
        this.panMiscellaneous.add(this.cbDisplayMMC);
        this.panSortMethod.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("Sort Method") + " "));
        this.panSortMethod.setSize(300, 60);
        this.panSortMethod.setLocation(20, 110);
        this.panSortMethod.setLayout(null);
        this.bgType.add(this.rbPort);
        this.bgType.add(this.rbNumber);
        this.rbPort.setSize(100, 20);
        this.rbPort.setLocation(20, 25);
        this.panSortMethod.add(this.rbPort);
        this.rbNumber.setSize(100, 20);
        this.rbNumber.setLocation(140, 25);
        this.panSortMethod.add(this.rbNumber);
        if (Boolean.valueOf(AppProperty.m_properties.get("SORT_METHOD").equals("By Number")).booleanValue()) {
            this.rbNumber.setSelected(true);
        } else {
            this.rbPort.setSelected(true);
        }
        this.panMiscellaneous.add(this.panSortMethod);
        this.add(this.panMiscellaneous);
        this.jbApply.setSize(100, 20);
        this.jbApply.setLocation(140, 240);
        this.jbApply.setActionCommand("Apply");
        this.jbApply.addActionListener(this);
        this.add(this.jbApply);
        this.jbCancel.setSize(100, 20);
        this.jbCancel.setLocation(255, 240);
        this.jbCancel.setActionCommand("Cancel");
        this.jbCancel.addActionListener(this);
        this.add(this.jbCancel);
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Apply")) {
            int Reboot = AppGlobal.showConfirmMessage(AppLang.getText("Environment Settings"), AppLang.getText("Do you want to apply a new setting value?"));
            if (Reboot == 0) {
                AppProperty.m_properties.put("USE_TOOLBAR", this.cbUseToolBar.isSelected());
                AppProperty.m_properties.put("OPEN_PAGE", this.cbOpenPage.isSelected());
                AppProperty.m_properties.put("DISPLAY_MMC", this.cbDisplayMMC.isSelected());
                if (this.rbPort.isSelected()) {
                    AppProperty.m_properties.put("SORT_METHOD", "By Port");
                } else {
                    AppProperty.m_properties.put("SORT_METHOD", "By Number");
                }
                AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
                AppGlobal.g_frmMain.m_toolBar.setVisible((Boolean)AppProperty.m_properties.get("USE_TOOLBAR"));
                AppGlobal.g_frmMain.m_treePane.repaintTreePane();
                this.closeDialog();
            }
        } else if (command.equals("Cancel")) {
            this.closeDialog();
        }
    }
}

