/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils.convert;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class AppGetITData {
    private Socket m_sock = null;
    private OutputStream m_os = null;
    private ArrayList m_tableList = new ArrayList();
    private Hashtable m_recvData = null;
    private String m_source = "";

    public AppGetITData(String file) {
        this.m_source = file;
        this.m_recvData = new Hashtable();
        if (AppGlobal.g_accessProcess != null) {
            this.disconnect();
        }
        if (this.connect()) {
            this.getTableList();
            this.getTableData();
            this.disconnect();
        }
    }

    public Hashtable getITData() {
        return this.m_recvData;
    }

    private boolean connect() {
        try {
            File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "AccessDB.exe");
            String path = file.exists() ? String.valueOf(System.getProperty("user.dir")) + File.separator + "AccessDB.exe " + this.m_source : String.valueOf(AppProperty.m_runDirectory) + "AccessDB.exe " + this.m_source;
            AppGlobal.g_accessProcess = Runtime.getRuntime().exec(path);
            this.m_sock = new Socket("127.0.0.1", 9000);
            this.m_os = this.m_sock.getOutputStream();
            return this.checkPassword();
        }
        catch (Exception e2) {
            AppGlobal.hideProgress();
            return false;
        }
    }

    private boolean checkPassword() {
        byte[] reqData = new byte[52];
        byte[] recv = null;
        reqData[0] = -45;
        reqData[1] = 50;
        int m_pwdCnt = 0;
        while (true) {
            if (m_pwdCnt++ > 2) {
                this.disconnect();
                AppGlobal.showErrorMessage(AppLang.getText("Invalid Password"), AppLang.getText("Because the password is wrong 3 times, the program will be shut down..."));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
                return false;
            }
            String m_password = JOptionPane.showInputDialog(AppLang.getText("Input the password of Installation DB."));
            if (m_password == null) break;
            AppFunctions.str2byte(reqData, 2, 50, m_password.trim());
            if (this.sendData(reqData) && (recv = this.recvData()) != null && recv[0] == 1) {
                byte[] password = new byte[50];
                AppFunctions.str2byte(password, 0, 50, m_password.trim());
                this.m_recvData.put("0001", password);
                return true;
            }
            AppGlobal.showErrorMessage("", "Inputted password is wrong. Again input the password.");
        }
        return false;
    }

    private void getTableList() {
        byte[] reqData = new byte[2];
        byte[] temp = null;
        this.m_tableList.clear();
        temp = new byte[]{0, 0};
        this.m_tableList.add(0, temp);
        try {
            byte[] recv;
            reqData[0] = -47;
            reqData[1] = 0;
            if (this.sendData(reqData) && (recv = this.recvData()) != null) {
                int i2 = 0;
                while (i2 < recv.length) {
                    temp = new byte[2];
                    System.arraycopy(recv, i2, temp, 0, 2);
                    this.m_tableList.add(this.m_tableList.size(), temp);
                    i2 += 2;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void getTableData() {
        byte[] reqData = new byte[4];
        byte[] temp = null;
        String msgId = "";
        try {
            int i2 = 0;
            while (i2 < this.m_tableList.size()) {
                byte[] recv;
                temp = (byte[])this.m_tableList.get(i2);
                msgId = AppFunctions.unsignedValue(AppFunctions.byte2short(temp, 0));
                reqData[0] = -46;
                reqData[1] = 2;
                System.arraycopy(temp, 0, reqData, 2, 2);
                if (this.sendData(reqData) && (recv = this.recvData()) != null) {
                    String key = String.format("%04x", Integer.parseInt(msgId)).toUpperCase();
                    this.m_recvData.put(key, recv);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void disconnect() {
        byte[] reqData = new byte[]{-48, 0};
        this.sendData(reqData);
        try {
            Thread.sleep(1000L);
            this.m_os = null;
            this.m_sock = null;
            AppGlobal.g_accessProcess = null;
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    private boolean sendData(byte[] req) {
        if (this.m_os == null) {
            this.connect();
        }
        try {
            this.m_os.write(req);
            this.m_os.flush();
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] recvData() {
        byte[] m_bTemp = new byte[2048000];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int msgLen = -1;
        InputStream is = null;
        try {
            is = this.m_sock.getInputStream();
            do {
                if ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) < 4 || msgLen != -1 || (msgLen = AppFunctions.byte2int(m_bTemp, 0)) != 0) continue;
                return null;
            } while (msgLen < 0 || (nOffset += nRead) < msgLen + 4);
            m_bData = new byte[msgLen];
            System.arraycopy(m_bTemp, 4, m_bData, 0, msgLen);
            return m_bData;
        }
        catch (IOException e2) {
            return null;
        }
    }
}

