/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.conference;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.pages.AppConference;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppPattern;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PA106EmailForm
extends AppConference {
    private final int SIZE_WIDTH = 500;
    private final int SIZE_HEIGHT = 615;
    private JTextField m_txtSubject1 = new JTextField();
    private JTextField m_txtSubject2 = new JTextField();
    private JScrollPane m_txtMailScroll = new JScrollPane();
    private JTextArea m_txtMail = new JTextArea();
    private JCheckBox m_chkEmail = new JCheckBox();
    private Hashtable m_partyInfo = new Hashtable();
    private JTextField m_txtEmailAddr = new JTextField();

    public PA106EmailForm(AppConference parent) {
        this(parent, null, null);
    }

    public PA106EmailForm(AppConference parent, Hashtable partyInfo, JCheckBox chkEmail) {
        this.m_parent = parent;
        this.m_partyInfo = partyInfo;
        this.m_chkEmail = chkEmail;
        this.m_colTitle = new String[][]{{"Name", "Phone", "Email"}};
        this.m_layout = new AppLayout(this.m_panMain, 500, 615);
        this.initParentData();
        this.createComponents();
        this.openDialog("Meet Me Conference Invitation", 500, 615);
    }

    private void createComponents() {
        JButton btnOK = new JButton(AppLang.getText("Send"));
        JButton btnCancel = new JButton(AppLang.getText("Cancel"));
        btnOK.setActionCommand(btnOK.getText());
        btnOK.addActionListener(this);
        btnCancel.setActionCommand(btnCancel.getText());
        btnCancel.addActionListener(this);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Conference Subject")), 10, 10, 120, 23);
        this.m_txtSubject1.setEnabled(false);
        this.m_txtSubject1.setText(this.m_parent.m_cnfTitle);
        this.m_layout.addComponent(this.m_txtSubject1, 130, 10, 360, 23);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Email Subject")), 10, 38, 120, 23);
        this.m_layout.addComponent(this.m_txtSubject2, 130, 38, 360, 23);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Sender Email Address")), 10, 66, 120, 23);
        this.m_txtEmailAddr.setDocument(new AppPattern(40, "^[0-9a-zA-Z@.]*$"));
        this.m_layout.addComponent(this.m_txtEmailAddr, 130, 66, 360, 23);
        this.m_txtMailScroll.getViewport().add(this.m_txtMail);
        this.m_txtMail.setLineWrap(true);
        this.m_txtMail.setBorder(new LineBorder(Color.darkGray));
        this.m_layout.addComponent(this.m_txtMailScroll, 5, 94, 484, 322);
        this.m_layout.addComponent(btnOK, 319, 556, 80, 23);
        this.m_layout.addComponent(btnCancel, 409, 556, 80, 23);
        this.setComponents();
        this.requestMailForm();
    }

    private void setComponents() {
        ArrayList recvData = new ArrayList();
        ArrayList<JLabel> compData = null;
        this.m_components.clear();
        for (String key : this.m_partyInfo.keySet()) {
            recvData = (ArrayList)this.m_partyInfo.get(key);
            compData = new ArrayList<JLabel>();
            int i2 = 0;
            while (i2 < 3) {
                this.m_compLabel = new JLabel((String)recvData.get(i2));
                this.m_compLabel.setFont(new Font("SansSerif", 0, 12));
                compData.add(i2, this.m_compLabel);
                ++i2;
            }
            this.m_components.add(this.m_components.size(), compData);
        }
        this.m_rowTitle = new String[this.m_components.size()][1];
        this.createTable();
    }

    private void createTable() {
        if (this.m_table != null) {
            this.m_panMain.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)PA106EmailForm.this.m_components.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setColWidth(new int[]{100, 150, 210});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model);
        this.m_layout.addComponent(this.m_table, 5, 420, 485, 132);
    }

    private void requestMailForm() {
        ArrayList recvData = new ArrayList();
        ArrayList saveData = (ArrayList)this.m_parent.m_saveData.get(0);
        this.m_reqData = new byte[218];
        int i2 = 0;
        while (i2 < 18) {
            this.m_reqData[i2] = (byte)Integer.parseInt((String)saveData.get(i2));
            ++i2;
        }
        AppFunctions.str2byte(this.m_reqData, 18, 3, (String)saveData.get(19));
        this.m_reqData[21] = (byte)Integer.parseInt((String)saveData.get(20));
        i2 = 21;
        while (i2 < 29) {
            this.m_reqData[i2 + 1] = (byte)Integer.parseInt((String)saveData.get(i2));
            ++i2;
        }
        AppFunctions.str2byte(this.m_reqData, 30, 4, (String)saveData.get(29));
        i2 = 30;
        while (i2 < 36) {
            this.m_reqData[i2 + 4] = (byte)Integer.parseInt((String)saveData.get(i2));
            ++i2;
        }
        AppFunctions.str2byte(this.m_reqData, 40, 128, this.m_txtSubject1.getText().trim());
        i2 = 0;
        while (i2 < 24) {
            short party = (short)Integer.parseInt((String)saveData.get(i2 + 36));
            AppFunctions.short2byte(this.m_reqData, i2 * 2 + 168, party);
            ++i2;
        }
        AppFunctions.tel2byte(this.m_reqData, 216, (String)saveData.get(18));
        this.m_pageInfo = new AppPageInfo("A106");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        this.readDataFromSystem();
        i2 = 0;
        while (i2 < this.m_recvData.size()) {
            recvData = (ArrayList)this.m_recvData.get(i2);
            this.m_txtMail.append((String)recvData.get(0));
            this.m_txtEmailAddr.setText((String)recvData.get(1));
            ++i2;
        }
    }

    private void createNewMail(boolean bSend) {
        ArrayList<String> saveData = new ArrayList<String>();
        this.m_saveData = new ArrayList();
        int i2 = 0;
        while (i2 < 8) {
            saveData.add(i2, AppFunctions.unsignedValue(this.m_parent.m_startTime[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            saveData.add(i2 + 8, AppFunctions.unsignedValue(this.m_parent.m_endTime[i2]));
            ++i2;
        }
        saveData.add(16, AppFunctions.unsignedValue(this.m_parent.m_cardPos[0]));
        saveData.add(17, AppFunctions.unsignedValue(this.m_parent.m_cardPos[1]));
        saveData.add(18, this.m_parent.m_cnfOwner);
        saveData.add(19, this.m_parent.m_cnfId);
        saveData.add(20, bSend ? "0" : "1");
        saveData.add(21, this.m_txtSubject2.getText().trim());
        saveData.add(22, this.m_txtMail.getText().trim());
        saveData.add(23, this.m_txtEmailAddr.getText().trim());
        saveData.add(24, "" + this.m_cnfRepeat);
        saveData.add(25, "");
        i2 = 0;
        while (i2 < 8) {
            saveData.add(i2 + 26, AppFunctions.unsignedValue(this.m_parent.m_endDate[i2]));
            ++i2;
        }
        this.m_saveData.add(0, saveData);
        this.m_pageInfo = new AppPageInfo("A107");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        this.saveDataToSystem();
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Send")) {
            this.createNewMail(true);
            this.closeDialog();
        } else if (command.equals("Cancel")) {
            this.createNewMail(false);
            this.closeDialog();
        }
    }
}

