/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.components;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.utils.table.ICellComponent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AppPasswordTextBox
implements ICellComponent {
    private static final Hashtable<Integer, String> m_htPattern = new Hashtable();
    private static final Hashtable<Integer, String> m_htTooltip;
    private JTable m_owner = null;
    private JPasswordField m_component = null;
    private int m_pattern = 0;
    private int m_minimum = 0;
    private int m_maximum = 0;
    private int m_length = 0;
    private String m_default = "";
    private String m_toolTip = "";

    static {
        m_htPattern.put(9, "^[0-9]*$");
        m_htPattern.put(30, "^[0-9a-zA-Z]*$");
        m_htTooltip = new Hashtable();
        m_htTooltip.put(9, "0 ~ 9");
        m_htTooltip.put(30, "0 ~ 9, a ~ z, A ~ Z");
    }

    public AppPasswordTextBox() {
        this(0, 0, 0, 0, "");
    }

    public AppPasswordTextBox(int pattern, int len) {
        this(pattern, len, 0, 0, "");
    }

    public AppPasswordTextBox(int pattern, int len, int min, int max) {
        this(pattern, len, min, max, "");
    }

    public AppPasswordTextBox(int pattern, int len, int min, int max, int iDefault) {
        this(pattern, len, min, max, "" + iDefault);
    }

    public AppPasswordTextBox(int pattern, int len, int min, int max, String sDefault) {
        this.setPattern(pattern);
        this.setRange(min, max);
        this.setLength(len);
        this.setDefault(sDefault);
        this.m_toolTip = AppLang.getText("Available value");
        this.m_toolTip = this.m_maximum > 0 ? String.valueOf(this.m_toolTip) + ": " + this.m_minimum + " ~ " + this.m_maximum : (this.m_pattern == 0 ? String.valueOf(this.m_toolTip) + ": " + AppLang.getText("All characters") + " - " + AppLang.getText("Max length") + ": " + this.m_length : String.valueOf(this.m_toolTip) + ": " + m_htTooltip.get(this.m_pattern) + " - " + AppLang.getText("Max length") + ": " + this.m_length);
        this.m_component = new JPasswordField();
        this.m_component.setDocument(new TextPattern());
        this.setTooltipText(this.m_toolTip);
    }

    public String getText() {
        return this.m_component.getText().trim();
    }

    public void setText(String strText) {
        this.m_component.setText(strText.trim());
    }

    public void setTooltipText(String strTooltipText) {
        this.m_component.setToolTipText(strTooltipText.trim());
    }

    public void setPattern(int pattern) {
        this.m_pattern = pattern > 37 ? 0 : pattern;
    }

    public void setRange(int min, int max) {
        this.m_minimum = min;
        this.m_maximum = max;
        if (min > max) {
            this.m_minimum = max;
            this.m_maximum = min;
        }
    }

    public void setLength(int len) {
        this.m_length = len;
    }

    public void setDefault(String sDefault) {
        this.m_default = sDefault.trim();
    }

    public void toolTipEvent() {
        this.m_component.dispatchEvent(new KeyEvent(this.m_component, 401, 0L, 2, 112));
    }

    @Override
    public void finishEditing() {
        int value;
        String strData = this.m_component.getText();
        if (strData.equals("")) {
            this.m_component.setText(this.m_default);
        }
        if (!(strData.equals("") || this.m_maximum <= 0 || (value = Integer.parseInt(this.m_component.getText().trim())) >= this.m_minimum && value <= this.m_maximum)) {
            this.m_component.setText(this.m_default);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.m_component;
    }

    @Override
    public JTable getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(JTable table) {
        this.m_owner = table;
    }

    @Override
    public String toString() {
        String tmpstr = "";
        int i2 = 0;
        while (i2 < this.getText().length()) {
            tmpstr = String.valueOf(tmpstr) + "*";
            ++i2;
        }
        return tmpstr;
    }

    private String getDefault() {
        if (this.m_maximum > 0) {
            return "" + this.m_minimum;
        }
        return "";
    }

    @Override
    public void clear() {
        this.m_component.setText(this.getDefault());
    }

    @Override
    public boolean checkValue(String strData) {
        return true;
    }

    @Override
    public void fromString(String strData) {
        this.setText(strData.trim());
    }

    class TextPattern
    extends PlainDocument {
        String m_inText = "";
        int m_inValue = 0;
        boolean m_bResult = true;

        TextPattern() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (AppPasswordTextBox.this.m_pattern != 0 && !Pattern.matches((String)m_htPattern.get(AppPasswordTextBox.this.m_pattern), str)) {
                AppPasswordTextBox.this.toolTipEvent();
                return;
            }
            if (AppPasswordTextBox.this.m_length <= 0) {
                super.insertString(offset, str, attr);
                return;
            }
            if (this.getLength() + str.length() > AppPasswordTextBox.this.m_length) {
                AppPasswordTextBox.this.toolTipEvent();
                return;
            }
            super.insertString(offset, str, attr);
            if (AppPasswordTextBox.this.m_maximum > 0) {
                this.m_bResult = true;
                this.m_inText = AppPasswordTextBox.this.m_component.getText().trim();
                try {
                    this.m_inValue = Integer.parseInt(this.m_inText);
                    if (this.m_inText.length() >= String.format("%d", AppPasswordTextBox.this.m_minimum).length() && this.m_inValue > AppPasswordTextBox.this.m_maximum) {
                        this.m_bResult = false;
                    }
                }
                catch (NumberFormatException ne) {
                    this.m_bResult = false;
                }
                if (!this.m_bResult) {
                    AppPasswordTextBox.this.m_component.setText(AppPasswordTextBox.this.m_default);
                    AppPasswordTextBox.this.toolTipEvent();
                }
            }
        }
    }
}

