/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.pages.utils.table.AppClipboardManager;
import com.sec.osdm.pages.utils.table.AppExcelClipParser;
import com.sec.osdm.pages.utils.table.AppKeyHandler;
import com.sec.osdm.pages.utils.table.ICellComponent;
import javax.swing.JTable;

public class AppHandlerPaste
extends AppKeyHandler {
    public static final String KEY_COMMAND = "Paste";

    public AppHandlerPaste(JTable table) {
        super(table, 86, 2, KEY_COMMAND);
    }

    @Override
    public void bindAction() {
        AppGlobal.g_bIsRepeat = true;
        AppGlobal.g_bIsApplyAll = false;
        AppGlobal.g_applyAllEvent = "";
        int[] arrSelectedRows = this.m_table.getSelectedRows();
        int[] arrSelectedCols = this.m_table.getSelectedColumns();
        if (arrSelectedRows.length == 0 || arrSelectedCols.length == 0) {
            return;
        }
        int nRowCount = 0;
        int nColCount = 0;
        boolean isSigleSelect = false;
        if (arrSelectedRows.length == 1 && arrSelectedCols.length == 1) {
            nRowCount = this.m_table.getRowCount() - arrSelectedRows[0];
            nColCount = this.m_table.getColumnCount() - arrSelectedCols[0];
            isSigleSelect = true;
        } else {
            nRowCount = arrSelectedRows.length;
            nColCount = arrSelectedCols.length;
            isSigleSelect = false;
        }
        try {
            AppExcelClipParser clipParser = new AppExcelClipParser(AppClipboardManager.getInstance().read());
            String strValue = null;
            int nRow = 0;
            int nCol = 0;
            int i2 = 0;
            while (i2 < nRowCount) {
                int nCurRow;
                int n2 = nCurRow = isSigleSelect ? arrSelectedRows[0] + i2 : arrSelectedRows[i2];
                if (!this.isRowHidden(nCurRow)) {
                    int j2 = 0;
                    while (j2 < nColCount) {
                        int nCurCol;
                        int n3 = nCurCol = isSigleSelect ? arrSelectedCols[0] + j2 : arrSelectedCols[j2];
                        if (!this.isColHidden(nCurCol)) {
                            Object aCellComp = this.m_table.getValueAt(nCurRow, nCurCol);
                            boolean fEditable = this.m_table.isCellEditable(nCurRow, nCurCol);
                            if (aCellComp instanceof ICellComponent && fEditable) {
                                strValue = clipParser.getValueAt(nRow % clipParser.getRowCount(), nCol % clipParser.getColumnCount());
                                ICellComponent comp = (ICellComponent)this.m_table.getValueAt(nCurRow, nCurCol);
                                if (comp != null) {
                                    if (comp.checkValue(strValue)) {
                                        comp.fromString(strValue);
                                        this.m_table.setValueAt(comp, nCurRow, nCurCol);
                                    }
                                    if (isSigleSelect && ++nCol > clipParser.getColumnCount() - 1) break;
                                }
                            }
                        }
                        ++j2;
                    }
                    nCol = 0;
                    if (isSigleSelect && ++nRow > clipParser.getRowCount() - 1) break;
                }
                ++i2;
            }
            this.m_table.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AppGlobal.g_bIsRepeat = false;
    }

    @Override
    public String getKeyCommand() {
        return KEY_COMMAND;
    }
}

