/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.biff.XFRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.Pattern;
import jxl.format.VerticalAlignment;
import jxl.write.WriteException;
import jxl.write.biff.JxlWriteException;

public class CellXFRecord
extends XFRecord {
    protected CellXFRecord(FontRecord fnt, DisplayFormat form) {
        super(fnt, form);
        this.setXFDetails(XFRecord.cell, 0);
    }

    CellXFRecord(XFRecord fmt) {
        super(fmt);
        this.setXFDetails(XFRecord.cell, 0);
    }

    protected CellXFRecord(CellFormat format) {
        super(format);
    }

    public void setAlignment(Alignment a2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFAlignment(a2);
    }

    public void setBackground(Colour c2, Pattern p2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFBackground(c2, p2);
        super.setXFCellOptions(16384);
    }

    public void setLocked(boolean l2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFLocked(l2);
        super.setXFCellOptions(32768);
    }

    public void setShrinkToFit(boolean s2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFShrinkToFit(s2);
    }

    public void setVerticalAlignment(VerticalAlignment va) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFVerticalAlignment(va);
    }

    public void setOrientation(Orientation o2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFOrientation(o2);
    }

    public void setWrap(boolean w2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        super.setXFWrap(w2);
    }

    public void setBorder(Border b2, BorderLineStyle ls, Colour c2) throws WriteException {
        if (this.isInitialized()) {
            throw new JxlWriteException(JxlWriteException.formatInitialized);
        }
        if (b2 == Border.ALL) {
            super.setXFBorder(Border.LEFT, ls, c2);
            super.setXFBorder(Border.RIGHT, ls, c2);
            super.setXFBorder(Border.TOP, ls, c2);
            super.setXFBorder(Border.BOTTOM, ls, c2);
            return;
        }
        if (b2 == Border.NONE) {
            super.setXFBorder(Border.LEFT, BorderLineStyle.NONE, Colour.BLACK);
            super.setXFBorder(Border.RIGHT, BorderLineStyle.NONE, Colour.BLACK);
            super.setXFBorder(Border.TOP, BorderLineStyle.NONE, Colour.BLACK);
            super.setXFBorder(Border.BOTTOM, BorderLineStyle.NONE, Colour.BLACK);
            return;
        }
        super.setXFBorder(b2, ls, c2);
    }
}

