/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TempPageHolder;
import com.healthmarketscience.jackcess.scsu.Compress;
import com.healthmarketscience.jackcess.scsu.EndOfInputException;
import com.healthmarketscience.jackcess.scsu.Expand;
import com.healthmarketscience.jackcess.scsu.IllegalInputException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
implements Comparable<Column> {
    private static final Log LOG = LogFactory.getLog(Column.class);
    public static final Object AUTO_NUMBER = "<AUTO_NUMBER>";
    public static final Object KEEP_VALUE = "<KEEP_VALUE>";
    private static final double MILLISECONDS_PER_DAY = 8.64E7;
    private static final long MILLIS_BETWEEN_EPOCH_AND_1900 = 2209161600000L;
    private static final byte LONG_VALUE_TYPE_THIS_PAGE = -128;
    private static final byte LONG_VALUE_TYPE_OTHER_PAGE = 64;
    private static final byte LONG_VALUE_TYPE_OTHER_PAGES = 0;
    private static final int LONG_VALUE_TYPE_MASK = -1073741824;
    public static final byte FIXED_LEN_FLAG_MASK = 1;
    public static final byte AUTO_NUMBER_FLAG_MASK = 4;
    public static final byte AUTO_NUMBER_GUID_FLAG_MASK = 64;
    public static final byte UNKNOWN_FLAG_MASK = 2;
    private static final short GENERAL_SORT_ORDER_VALUE = 1033;
    public static final SortOrder GENERAL_LEGACY_SORT_ORDER = new SortOrder(1033, 0);
    public static final SortOrder GENERAL_SORT_ORDER = new SortOrder(1033, 1);
    private static final Pattern GUID_PATTERN = Pattern.compile("\\s*[{]?([\\p{XDigit}]{8})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{12})[}]?\\s*");
    private static final byte[] TEXT_COMPRESSION_HEADER = new byte[]{-1, -2};
    private final Table _table;
    private boolean _compressedUnicode = false;
    private boolean _variableLength;
    private boolean _autoNumber;
    private byte _precision;
    private byte _scale;
    private DataType _type;
    private short _columnLength;
    private short _columnNumber;
    private int _columnIndex;
    private int _displayIndex;
    private String _name;
    private int _fixedDataOffset;
    private int _varLenTableIndex;
    private SortOrder _textSortOrder;
    private short _textCodePage;
    private AutoNumberGenerator _autoNumberGenerator;
    private PropertyMap _props;

    public Column() {
        this(null);
    }

    public Column(JetFormat format) {
        this._table = null;
    }

    Column(boolean testing, Table table) {
        if (!testing) {
            throw new IllegalArgumentException();
        }
        this._table = table;
    }

    public Column(Table table, ByteBuffer buffer, int offset, int displayIndex) throws IOException {
        this._table = table;
        this._displayIndex = displayIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Column def block:\n" + ByteUtil.toHexString(buffer, offset, 25));
        }
        this.setType(DataType.fromByte(buffer.get(offset + this.getFormat().OFFSET_COLUMN_TYPE)));
        this._columnNumber = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_NUMBER);
        this._columnLength = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_LENGTH);
        if (this._type.getHasScalePrecision()) {
            this._precision = buffer.get(offset + this.getFormat().OFFSET_COLUMN_PRECISION);
            this._scale = buffer.get(offset + this.getFormat().OFFSET_COLUMN_SCALE);
        } else if (this._type.isTextual()) {
            this._textSortOrder = Column.readSortOrder(buffer, offset + this.getFormat().OFFSET_COLUMN_SORT_ORDER, this.getFormat());
            int cpOffset = this.getFormat().OFFSET_COLUMN_CODE_PAGE;
            if (cpOffset >= 0) {
                this._textCodePage = buffer.getShort(offset + cpOffset);
            }
        }
        byte flags = buffer.get(offset + this.getFormat().OFFSET_COLUMN_FLAGS);
        this._variableLength = (flags & 1) == 0;
        this._autoNumber = (flags & 0x44) != 0;
        this.setAutoNumberGenerator();
        boolean bl2 = this._compressedUnicode = (buffer.get(offset + this.getFormat().OFFSET_COLUMN_COMPRESSED_UNICODE) & 1) == 1;
        if (this._variableLength) {
            this._varLenTableIndex = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_VARIABLE_TABLE_INDEX);
        } else {
            this._fixedDataOffset = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_FIXED_DATA_OFFSET);
        }
    }

    public Table getTable() {
        return this._table;
    }

    public Database getDatabase() {
        return this.getTable().getDatabase();
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isVariableLength() {
        return this._variableLength;
    }

    public void setVariableLength(boolean variableLength) {
        this._variableLength = variableLength;
    }

    public boolean isAutoNumber() {
        return this._autoNumber;
    }

    public void setAutoNumber(boolean autoNumber) {
        this._autoNumber = autoNumber;
        this.setAutoNumberGenerator();
    }

    public short getColumnNumber() {
        return this._columnNumber;
    }

    public void setColumnNumber(short newColumnNumber) {
        this._columnNumber = newColumnNumber;
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    public void setColumnIndex(int newColumnIndex) {
        this._columnIndex = newColumnIndex;
    }

    public int getDisplayIndex() {
        return this._displayIndex;
    }

    public void setType(DataType type) {
        this._type = type;
        if (!type.isVariableLength()) {
            this.setLength((short)type.getFixedSize());
        } else if (!type.isLongValue()) {
            this.setLength((short)type.getDefaultSize());
        }
        this.setVariableLength(type.isVariableLength());
        if (type.getHasScalePrecision()) {
            this.setScale((byte)type.getDefaultScale());
            this.setPrecision((byte)type.getDefaultPrecision());
        }
    }

    public DataType getType() {
        return this._type;
    }

    public int getSQLType() throws SQLException {
        return this._type.getSQLType();
    }

    public void setSQLType(int type) throws SQLException {
        this.setSQLType(type, 0);
    }

    public void setSQLType(int type, int lengthInUnits) throws SQLException {
        this.setType(DataType.fromSQLType(type, lengthInUnits));
    }

    public boolean isCompressedUnicode() {
        return this._compressedUnicode;
    }

    public void setCompressedUnicode(boolean newCompessedUnicode) {
        this._compressedUnicode = newCompessedUnicode;
    }

    public byte getPrecision() {
        return this._precision;
    }

    public void setPrecision(byte newPrecision) {
        this._precision = newPrecision;
    }

    public byte getScale() {
        return this._scale;
    }

    public void setScale(byte newScale) {
        this._scale = newScale;
    }

    public SortOrder getTextSortOrder() {
        return this._textSortOrder;
    }

    public void setTextSortOrder(SortOrder newTextSortOrder) {
        this._textSortOrder = newTextSortOrder;
    }

    public short getTextCodePage() {
        return this._textCodePage;
    }

    public void setLength(short length) {
        this._columnLength = length;
    }

    public short getLength() {
        return this._columnLength;
    }

    public void setLengthInUnits(short unitLength) {
        this.setLength((short)this.getType().fromUnitSize(unitLength));
    }

    public short getLengthInUnits() {
        return (short)this.getType().toUnitSize(this.getLength());
    }

    public void setVarLenTableIndex(int idx) {
        this._varLenTableIndex = idx;
    }

    public int getVarLenTableIndex() {
        return this._varLenTableIndex;
    }

    public void setFixedDataOffset(int newOffset) {
        this._fixedDataOffset = newOffset;
    }

    public int getFixedDataOffset() {
        return this._fixedDataOffset;
    }

    protected Charset getCharset() {
        return this.getDatabase().getCharset();
    }

    protected TimeZone getTimeZone() {
        return this.getDatabase().getTimeZone();
    }

    private void setAutoNumberGenerator() {
        if (!this._autoNumber || this._type == null) {
            this._autoNumberGenerator = null;
            return;
        }
        if (this._autoNumberGenerator != null && this._autoNumberGenerator.getType() == this._type) {
            return;
        }
        switch (this._type) {
            case LONG: {
                this._autoNumberGenerator = new LongAutoNumberGenerator();
                break;
            }
            case GUID: {
                this._autoNumberGenerator = new GuidAutoNumberGenerator();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected autoNumber column type " + (Object)((Object)this._type));
            }
        }
    }

    public AutoNumberGenerator getAutoNumberGenerator() {
        return this._autoNumberGenerator;
    }

    public PropertyMap getProperties() throws IOException {
        if (this._props == null) {
            this._props = this.getTable().getPropertyMaps().get(this.getName());
        }
        return this._props;
    }

    public void validate(JetFormat format) {
        if (this.getType() == null) {
            throw new IllegalArgumentException("must have type");
        }
        Database.validateIdentifierName(this.getName(), format.MAX_COLUMN_NAME_LENGTH, "column");
        if (this.isVariableLength() != this.getType().isVariableLength()) {
            throw new IllegalArgumentException("invalid variable length setting");
        }
        if (!this.isVariableLength()) {
            if (this.getLength() != this.getType().getFixedSize()) {
                if (this.getLength() < this.getType().getFixedSize()) {
                    throw new IllegalArgumentException("invalid fixed length size");
                }
                LOG.warn("Column length " + this.getLength() + " longer than expected fixed size " + this.getType().getFixedSize());
            }
        } else if (!this.getType().isLongValue() && !this.getType().isValidSize(this.getLength())) {
            throw new IllegalArgumentException("var length out of range");
        }
        if (this.getType().getHasScalePrecision()) {
            if (!this.getType().isValidScale(this.getScale())) {
                throw new IllegalArgumentException("Scale must be from " + this.getType().getMinScale() + " to " + this.getType().getMaxScale() + " inclusive");
            }
            if (!this.getType().isValidPrecision(this.getPrecision())) {
                throw new IllegalArgumentException("Precision must be from " + this.getType().getMinPrecision() + " to " + this.getType().getMaxPrecision() + " inclusive");
            }
        }
        if (this.isAutoNumber() && this.getType() != DataType.LONG && this.getType() != DataType.GUID) {
            throw new IllegalArgumentException("Auto number column must be long integer or guid");
        }
        if (this.isCompressedUnicode() && !this.getType().isTextual()) {
            throw new IllegalArgumentException("Only textual columns allow unicode compression (text/memo)");
        }
    }

    public Object read(byte[] data) throws IOException {
        return this.read(data, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public Object read(byte[] data, ByteOrder order) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(order);
        if (this._type == DataType.BOOLEAN) {
            throw new IOException("Tried to read a boolean from data instead of null mask.");
        }
        if (this._type == DataType.BYTE) {
            return buffer.get();
        }
        if (this._type == DataType.INT) {
            return buffer.getShort();
        }
        if (this._type == DataType.LONG) {
            return buffer.getInt();
        }
        if (this._type == DataType.DOUBLE) {
            return buffer.getDouble();
        }
        if (this._type == DataType.FLOAT) {
            return Float.valueOf(buffer.getFloat());
        }
        if (this._type == DataType.SHORT_DATE_TIME) {
            return this.readDateValue(buffer);
        }
        if (this._type == DataType.BINARY) {
            return data;
        }
        if (this._type == DataType.TEXT) {
            return this.decodeTextValue(data);
        }
        if (this._type == DataType.MONEY) {
            return this.readCurrencyValue(buffer);
        }
        if (this._type == DataType.OLE) {
            if (data.length > 0) {
                return this.readLongValue(data);
            }
            return null;
        }
        if (this._type == DataType.MEMO) {
            if (data.length > 0) {
                return this.readLongStringValue(data);
            }
            return null;
        }
        if (this._type == DataType.NUMERIC) {
            return this.readNumericValue(buffer);
        }
        if (this._type == DataType.GUID) {
            return this.readGUIDValue(buffer, order);
        }
        if (this._type == DataType.UNKNOWN_0D || this._type == DataType.UNKNOWN_11) {
            return data;
        }
        throw new IOException("Unrecognized data type: " + (Object)((Object)this._type));
    }

    private byte[] readLongValue(byte[] lvalDefinition) throws IOException {
        ByteBuffer def = ByteBuffer.wrap(lvalDefinition).order(PageChannel.DEFAULT_BYTE_ORDER);
        int lengthWithFlags = def.getInt();
        int length = lengthWithFlags & 0x3FFFFFFF;
        byte[] rtn = new byte[length];
        byte type = (byte)((lengthWithFlags & 0xC0000000) >>> 24);
        if (type == -128) {
            def.getInt();
            def.getInt();
            def.get(rtn);
        } else {
            if (lvalDefinition.length != this.getFormat().SIZE_LONG_VALUE_DEF) {
                throw new IOException("Expected " + this.getFormat().SIZE_LONG_VALUE_DEF + " bytes in long value definition, but found " + lvalDefinition.length);
            }
            int rowNum = ByteUtil.getUnsignedByte(def);
            int pageNum = ByteUtil.get3ByteInt(def, def.position());
            ByteBuffer lvalPage = this.getPageChannel().createPageBuffer();
            switch (type) {
                case 64: {
                    this.getPageChannel().readPage(lvalPage, pageNum);
                    short rowStart = Table.findRowStart(lvalPage, rowNum, this.getFormat());
                    short rowEnd = Table.findRowEnd(lvalPage, rowNum, this.getFormat());
                    if (rowEnd - rowStart != length) {
                        throw new IOException("Unexpected lval row length");
                    }
                    lvalPage.position(rowStart);
                    lvalPage.get(rtn);
                    break;
                }
                case 0: {
                    int chunkLength;
                    ByteBuffer rtnBuf = ByteBuffer.wrap(rtn);
                    for (int remainingLen = length; remainingLen > 0; remainingLen -= chunkLength) {
                        lvalPage.clear();
                        this.getPageChannel().readPage(lvalPage, pageNum);
                        short rowStart = Table.findRowStart(lvalPage, rowNum, this.getFormat());
                        short rowEnd = Table.findRowEnd(lvalPage, rowNum, this.getFormat());
                        lvalPage.position(rowStart);
                        rowNum = ByteUtil.getUnsignedByte(lvalPage);
                        pageNum = ByteUtil.get3ByteInt(lvalPage);
                        chunkLength = rowEnd - rowStart - 4;
                        if (chunkLength > remainingLen) {
                            rowEnd = (short)(rowEnd - (chunkLength - remainingLen));
                            chunkLength = remainingLen;
                        }
                        lvalPage.limit(rowEnd);
                        rtnBuf.put(lvalPage);
                    }
                    break;
                }
                default: {
                    throw new IOException("Unrecognized long value type: " + type);
                }
            }
        }
        return rtn;
    }

    private String readLongStringValue(byte[] lvalDefinition) throws IOException {
        byte[] binData = this.readLongValue(lvalDefinition);
        if (binData == null) {
            return null;
        }
        return this.decodeTextValue(binData);
    }

    private BigDecimal readCurrencyValue(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() != 8) {
            throw new IOException("Invalid money value.");
        }
        return new BigDecimal(BigInteger.valueOf(buffer.getLong(0)), 4);
    }

    private void writeCurrencyValue(ByteBuffer buffer, Object value) throws IOException {
        try {
            BigDecimal decVal = Column.toBigDecimal(value);
            decVal = decVal.setScale(4);
            buffer.putLong(decVal.movePointRight(4).longValueExact());
        }
        catch (ArithmeticException e2) {
            throw (IOException)new IOException("Currency value out of range").initCause(e2);
        }
    }

    private BigDecimal readNumericValue(ByteBuffer buffer) {
        boolean negate = buffer.get() != 0;
        byte[] tmpArr = new byte[16];
        buffer.get(tmpArr);
        if (buffer.order() != ByteOrder.BIG_ENDIAN) {
            Column.fixNumericByteOrder(tmpArr);
        }
        BigInteger intVal = new BigInteger(tmpArr);
        if (negate) {
            intVal = intVal.negate();
        }
        return new BigDecimal(intVal, this.getScale());
    }

    private void writeNumericValue(ByteBuffer buffer, Object value) throws IOException {
        try {
            int maxByteLen;
            boolean negative;
            BigDecimal decVal = Column.toBigDecimal(value);
            boolean bl2 = negative = decVal.compareTo(BigDecimal.ZERO) < 0;
            if (negative) {
                decVal = decVal.negate();
            }
            buffer.put(negative ? (byte)-128 : 0);
            decVal = decVal.setScale(this.getScale());
            if (decVal.precision() > this.getPrecision()) {
                throw new IOException("Numeric value is too big for specified precision " + this.getPrecision() + ": " + decVal);
            }
            byte[] intValBytes = decVal.unscaledValue().toByteArray();
            if (intValBytes.length > (maxByteLen = this.getType().getFixedSize() - 1)) {
                throw new IOException("Too many bytes for valid BigInteger?");
            }
            if (intValBytes.length < maxByteLen) {
                byte[] tmpBytes = new byte[maxByteLen];
                System.arraycopy(intValBytes, 0, tmpBytes, maxByteLen - intValBytes.length, intValBytes.length);
                intValBytes = tmpBytes;
            }
            if (buffer.order() != ByteOrder.BIG_ENDIAN) {
                Column.fixNumericByteOrder(intValBytes);
            }
            buffer.put(intValBytes);
        }
        catch (ArithmeticException e2) {
            throw (IOException)new IOException("Numeric value out of range").initCause(e2);
        }
    }

    private Date readDateValue(ByteBuffer buffer) {
        long dateBits = buffer.getLong();
        long time = this.fromDateDouble(Double.longBitsToDouble(dateBits));
        return new DateExt(time, dateBits);
    }

    private long fromDateDouble(double value) {
        long time = Math.round(value * 8.64E7);
        time -= 2209161600000L;
        time -= this.getTimeZoneOffset(time);
        return time;
    }

    private void writeDateValue(ByteBuffer buffer, Object value) {
        if (value == null) {
            buffer.putDouble(0.0);
        } else if (value instanceof DateExt) {
            buffer.putLong(((DateExt)value).getDateBits());
        } else {
            buffer.putDouble(this.toDateDouble(value));
        }
    }

    private double toDateDouble(Object value) {
        long time = value instanceof Date ? ((Date)value).getTime() : (value instanceof Calendar ? ((Calendar)value).getTimeInMillis() : ((Number)value).longValue());
        time += this.getTimeZoneOffset(time);
        return (double)(time += 2209161600000L) / 8.64E7;
    }

    private long getTimeZoneOffset(long time) {
        Calendar c2 = Calendar.getInstance(this.getTimeZone());
        c2.setTimeInMillis(time);
        return (long)c2.get(15) + (long)c2.get(16);
    }

    private String readGUIDValue(ByteBuffer buffer, ByteOrder order) {
        if (order != ByteOrder.BIG_ENDIAN) {
            byte[] tmpArr = new byte[16];
            buffer.get(tmpArr);
            ByteUtil.swap4Bytes(tmpArr, 0);
            ByteUtil.swap2Bytes(tmpArr, 4);
            ByteUtil.swap2Bytes(tmpArr, 6);
            buffer = ByteBuffer.wrap(tmpArr);
        }
        StringBuilder sb = new StringBuilder(22);
        sb.append("{");
        sb.append(ByteUtil.toHexString(buffer, 0, 4, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 4, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 6, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 8, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 10, 6, false));
        sb.append("}");
        return sb.toString();
    }

    private void writeGUIDValue(ByteBuffer buffer, Object value, ByteOrder order) throws IOException {
        Matcher m2 = GUID_PATTERN.matcher(Column.toCharSequence(value));
        if (m2.matches()) {
            ByteBuffer origBuffer = null;
            byte[] tmpBuf = null;
            if (order != ByteOrder.BIG_ENDIAN) {
                origBuffer = buffer;
                tmpBuf = new byte[16];
                buffer = ByteBuffer.wrap(tmpBuf);
            }
            ByteUtil.writeHexString(buffer, m2.group(1));
            ByteUtil.writeHexString(buffer, m2.group(2));
            ByteUtil.writeHexString(buffer, m2.group(3));
            ByteUtil.writeHexString(buffer, m2.group(4));
            ByteUtil.writeHexString(buffer, m2.group(5));
            if (tmpBuf != null) {
                ByteUtil.swap4Bytes(tmpBuf, 0);
                ByteUtil.swap2Bytes(tmpBuf, 4);
                ByteUtil.swap2Bytes(tmpBuf, 6);
                origBuffer.put(tmpBuf);
            }
        } else {
            throw new IOException("Invalid GUID: " + value);
        }
    }

    public ByteBuffer writeLongValue(byte[] value, int remainingRowLength) throws IOException {
        if (value.length > this.getType().getMaxSize()) {
            throw new IOException("value too big for column, max " + this.getType().getMaxSize() + ", got " + value.length);
        }
        int type = 0;
        int lvalDefLen = this.getFormat().SIZE_LONG_VALUE_DEF;
        if (this.getFormat().SIZE_LONG_VALUE_DEF + value.length <= remainingRowLength && value.length <= this.getFormat().MAX_INLINE_LONG_VALUE_SIZE) {
            type = -128;
            lvalDefLen += value.length;
        } else {
            type = value.length <= this.getFormat().MAX_LONG_VALUE_ROW_SIZE ? 64 : 0;
        }
        ByteBuffer def = this.getPageChannel().createBuffer(lvalDefLen);
        int lengthWithFlags = value.length | type << 24;
        def.putInt(lengthWithFlags);
        if (type == -128) {
            def.putInt(0);
            def.putInt(0);
            def.put(value);
        } else {
            TempPageHolder lvalBufferH = this.getTable().getLongValueBuffer();
            ByteBuffer lvalPage = null;
            int firstLvalPageNum = -1;
            byte firstLvalRow = 0;
            switch (type) {
                case 64: {
                    lvalPage = this.getLongValuePage(value.length, lvalBufferH);
                    firstLvalPageNum = lvalBufferH.getPageNumber();
                    firstLvalRow = (byte)Table.addDataPageRow(lvalPage, value.length, this.getFormat(), 0);
                    lvalPage.put(value);
                    this.getPageChannel().writePage(lvalPage, firstLvalPageNum);
                    break;
                }
                case 0: {
                    ByteBuffer buffer = ByteBuffer.wrap(value);
                    int remainingLen = buffer.remaining();
                    buffer.limit(0);
                    lvalPage = this.getLongValuePage(this.getFormat().MAX_LONG_VALUE_ROW_SIZE, lvalBufferH);
                    int lvalPageNum = firstLvalPageNum = lvalBufferH.getPageNumber();
                    ByteBuffer nextLvalPage = null;
                    int nextLvalPageNum = 0;
                    while (remainingLen > 0) {
                        lvalPage.clear();
                        int chunkLength = Math.min(this.getFormat().MAX_LONG_VALUE_ROW_SIZE - 4, remainingLen);
                        if (chunkLength < remainingLen) {
                            lvalBufferH.clear();
                            nextLvalPage = this.getLongValuePage(this.getFormat().MAX_LONG_VALUE_ROW_SIZE, lvalBufferH);
                            nextLvalPageNum = lvalBufferH.getPageNumber();
                        } else {
                            nextLvalPage = null;
                            nextLvalPageNum = 0;
                        }
                        byte lvalRow = (byte)Table.addDataPageRow(lvalPage, chunkLength + 4, this.getFormat(), 0);
                        lvalPage.put((byte)0);
                        ByteUtil.put3ByteInt(lvalPage, nextLvalPageNum);
                        buffer.limit(buffer.limit() + chunkLength);
                        lvalPage.put(buffer);
                        remainingLen -= chunkLength;
                        this.getPageChannel().writePage(lvalPage, lvalPageNum);
                        if (lvalPageNum == firstLvalPageNum) {
                            firstLvalRow = lvalRow;
                        } else if (lvalRow != 0) {
                            throw new IllegalStateException("Expected row 0, but was " + lvalRow);
                        }
                        lvalPage = nextLvalPage;
                        lvalPageNum = nextLvalPageNum;
                    }
                    break;
                }
                default: {
                    throw new IOException("Unrecognized long value type: " + type);
                }
            }
            def.put(firstLvalRow);
            ByteUtil.put3ByteInt(def, firstLvalPageNum);
            def.putInt(0);
        }
        def.flip();
        return def;
    }

    private void writeLongValueHeader(ByteBuffer lvalPage) {
        lvalPage.put((byte)1);
        lvalPage.put((byte)1);
        lvalPage.putShort((short)this.getFormat().DATA_PAGE_INITIAL_FREE_SPACE);
        lvalPage.put((byte)76);
        lvalPage.put((byte)86);
        lvalPage.put((byte)65);
        lvalPage.put((byte)76);
        lvalPage.putInt(0);
        lvalPage.putShort((short)0);
    }

    private ByteBuffer getLongValuePage(int dataLength, TempPageHolder lvalBufferH) throws IOException {
        ByteBuffer lvalPage = null;
        if (lvalBufferH.getPageNumber() != -1 && Table.rowFitsOnDataPage(dataLength, lvalPage = lvalBufferH.getPage(this.getPageChannel()), this.getFormat())) {
            return lvalPage;
        }
        lvalPage = lvalBufferH.setNewPage(this.getPageChannel());
        this.writeLongValueHeader(lvalPage);
        return lvalPage;
    }

    public ByteBuffer write(Object obj, int remainingRowLength) throws IOException {
        return this.write(obj, remainingRowLength, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public ByteBuffer write(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        if (Column.isRawData(obj)) {
            return ByteBuffer.wrap(((RawData)obj).getBytes());
        }
        if (!this.isVariableLength() || !this.getType().isVariableLength()) {
            return this.writeFixedLengthField(obj, order);
        }
        if (!this.getType().isLongValue()) {
            switch (this.getType()) {
                case NUMERIC: {
                    ByteBuffer buffer = this.getPageChannel().createBuffer(this.getType().getFixedSize(), order);
                    this.writeNumericValue(buffer, obj);
                    buffer.flip();
                    return buffer;
                }
                case TEXT: {
                    byte[] encodedData = this.encodeTextValue(obj, 0, this.getLengthInUnits(), false).array();
                    obj = encodedData;
                    break;
                }
                case BINARY: 
                case UNKNOWN_0D: {
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected inline var length type: " + (Object)((Object)this.getType()));
                }
            }
            ByteBuffer buffer = ByteBuffer.wrap(Column.toByteArray(obj));
            buffer.order(order);
            return buffer;
        }
        switch (this.getType()) {
            case OLE: {
                break;
            }
            case MEMO: {
                int maxMemoChars = DataType.MEMO.toUnitSize(DataType.MEMO.getMaxSize());
                obj = this.encodeTextValue(obj, 0, maxMemoChars, false).array();
                break;
            }
            default: {
                throw new RuntimeException("unexpected var length, long value type: " + (Object)((Object)this.getType()));
            }
        }
        return this.writeLongValue(Column.toByteArray(obj), remainingRowLength);
    }

    public ByteBuffer writeFixedLengthField(Object obj, ByteOrder order) throws IOException {
        int size = this.getType().getFixedSize(this._columnLength);
        ByteBuffer buffer = this.getPageChannel().createBuffer(size, order);
        obj = Column.booleanToInteger(obj);
        switch (this.getType()) {
            case BOOLEAN: {
                break;
            }
            case BYTE: {
                buffer.put(Column.toNumber(obj).byteValue());
                break;
            }
            case INT: {
                buffer.putShort(Column.toNumber(obj).shortValue());
                break;
            }
            case LONG: {
                buffer.putInt(Column.toNumber(obj).intValue());
                break;
            }
            case MONEY: {
                this.writeCurrencyValue(buffer, obj);
                break;
            }
            case FLOAT: {
                buffer.putFloat(Column.toNumber(obj).floatValue());
                break;
            }
            case DOUBLE: {
                buffer.putDouble(Column.toNumber(obj).doubleValue());
                break;
            }
            case SHORT_DATE_TIME: {
                this.writeDateValue(buffer, obj);
                break;
            }
            case TEXT: {
                short numChars = this.getLengthInUnits();
                buffer.put(this.encodeTextValue(obj, numChars, numChars, true));
                break;
            }
            case GUID: {
                this.writeGUIDValue(buffer, obj, order);
                break;
            }
            case NUMERIC: {
                this.writeNumericValue(buffer, obj);
                break;
            }
            case BINARY: 
            case UNKNOWN_0D: 
            case UNKNOWN_11: {
                byte[] bytes = Column.toByteArray(obj);
                if (bytes.length != this.getLength()) {
                    throw new IOException("Invalid fixed size binary data, size " + this.getLength() + ", got " + bytes.length);
                }
                buffer.put(bytes);
                break;
            }
            default: {
                throw new IOException("Unsupported data type: " + (Object)((Object)this.getType()));
            }
        }
        buffer.flip();
        return buffer;
    }

    private String decodeTextValue(byte[] data) throws IOException {
        try {
            boolean isCompressed;
            boolean bl2 = isCompressed = data.length > 1 && data[0] == TEXT_COMPRESSION_HEADER[0] && data[1] == TEXT_COMPRESSION_HEADER[1];
            if (isCompressed) {
                int dataStart;
                Expand expander = new Expand();
                StringBuilder textBuf = new StringBuilder(data.length);
                int dataEnd = dataStart = TEXT_COMPRESSION_HEADER.length;
                boolean inCompressedMode = true;
                while (dataEnd < data.length) {
                    if (data[dataEnd] == 0) {
                        this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, expander, textBuf);
                        inCompressedMode = !inCompressedMode;
                        dataStart = ++dataEnd;
                        continue;
                    }
                    ++dataEnd;
                }
                this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, expander, textBuf);
                return textBuf.toString();
            }
            return Column.decodeUncompressedText(data, this.getCharset());
        }
        catch (IllegalInputException e2) {
            throw (IOException)new IOException("Can't expand text column").initCause(e2);
        }
        catch (EndOfInputException e3) {
            throw (IOException)new IOException("Can't expand text column").initCause(e3);
        }
    }

    private void decodeTextSegment(byte[] data, int dataStart, int dataEnd, boolean inCompressedMode, Expand expander, StringBuilder textBuf) throws IllegalInputException, EndOfInputException {
        if (dataEnd <= dataStart) {
            return;
        }
        int dataLength = dataEnd - dataStart;
        if (inCompressedMode) {
            byte[] tmpData = ByteUtil.copyOf(data, dataStart, dataLength);
            expander.reset();
            textBuf.append(expander.expand(tmpData));
        } else {
            textBuf.append(Column.decodeUncompressedText(data, dataStart, dataLength, this.getCharset()));
        }
    }

    private static CharBuffer decodeUncompressedText(byte[] textBytes, int startPos, int length, Charset charset) {
        return charset.decode(ByteBuffer.wrap(textBytes, startPos, length));
    }

    private ByteBuffer encodeTextValue(Object obj, int minChars, int maxChars, boolean forceUncompressed) throws IOException {
        CharSequence text = Column.toCharSequence(obj);
        if (text.length() > maxChars || text.length() < minChars) {
            throw new IOException("Text is wrong length for " + (Object)((Object)this.getType()) + " column, max " + maxChars + ", min " + minChars + ", got " + text.length());
        }
        if (!forceUncompressed && this.isCompressedUnicode() && Column.isAsciiCompressible(text)) {
            byte[] encodedChars = new byte[TEXT_COMPRESSION_HEADER.length + text.length()];
            encodedChars[0] = TEXT_COMPRESSION_HEADER[0];
            encodedChars[1] = TEXT_COMPRESSION_HEADER[1];
            for (int i2 = 0; i2 < text.length(); ++i2) {
                encodedChars[i2 + Column.TEXT_COMPRESSION_HEADER.length] = (byte)text.charAt(i2);
            }
            return ByteBuffer.wrap(encodedChars);
        }
        return Column.encodeUncompressedText(text, this.getCharset());
    }

    private static boolean isAsciiCompressible(CharSequence text) {
        if (text.length() <= TEXT_COMPRESSION_HEADER.length) {
            return false;
        }
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (Compress.isAsciiCrLfOrTab(c2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("\tName: (" + this._table.getName() + ") " + this._name);
        rtn.append("\n\tType: 0x" + Integer.toHexString(this._type.getValue()) + " (" + (Object)((Object)this._type) + ")");
        rtn.append("\n\tNumber: " + this._columnNumber);
        rtn.append("\n\tLength: " + this._columnLength);
        rtn.append("\n\tVariable length: " + this._variableLength);
        if (this._variableLength) {
            rtn.append("\n\tCompressed Unicode: " + this._compressedUnicode);
        }
        if (this._autoNumber) {
            rtn.append("\n\tLast AutoNumber: " + this._autoNumberGenerator.getLast());
        }
        if (this._type.isTextual()) {
            rtn.append("\n\tText Sort order: " + this._textSortOrder);
            if (this._textCodePage > 0) {
                rtn.append("\n\tText Code Page: " + this._textCodePage);
            }
        }
        rtn.append("\n\n");
        return rtn.toString();
    }

    public static String decodeUncompressedText(byte[] textBytes, Charset charset) {
        return Column.decodeUncompressedText(textBytes, 0, textBytes.length, charset).toString();
    }

    public static ByteBuffer encodeUncompressedText(CharSequence text, Charset charset) {
        CharBuffer cb2 = text instanceof CharBuffer ? (CharBuffer)text : CharBuffer.wrap(text);
        return charset.encode(cb2);
    }

    @Override
    public int compareTo(Column other) {
        if (this._columnNumber > other.getColumnNumber()) {
            return 1;
        }
        if (this._columnNumber < other.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public static short countVariableLength(List<Column> columns) {
        short rtn = 0;
        for (Column col : columns) {
            if (!col.isVariableLength()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    public static short countNonLongVariableLength(List<Column> columns) {
        short rtn = 0;
        for (Column col : columns) {
            if (!col.isVariableLength() || col.getType().isLongValue()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    private static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        return new BigDecimal(value.toString());
    }

    private static Number toNumber(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        return Double.valueOf(value.toString());
    }

    public static CharSequence toCharSequence(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        if (value instanceof Clob) {
            try {
                Clob c2 = (Clob)value;
                return c2.getSubString(1L, (int)c2.length());
            }
            catch (SQLException e2) {
                throw (IOException)new IOException(e2.getMessage()).initCause(e2);
            }
        }
        if (value instanceof Reader) {
            char[] buf = new char[8192];
            StringBuilder sout = new StringBuilder();
            Reader in = (Reader)value;
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                sout.append(buf, 0, read);
            }
            return sout;
        }
        return value.toString();
    }

    public static byte[] toByteArray(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Blob) {
            try {
                Blob b2 = (Blob)value;
                return b2.getBytes(1L, (int)b2.length());
            }
            catch (SQLException e2) {
                throw (IOException)new IOException(e2.getMessage()).initCause(e2);
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (value instanceof InputStream) {
            byte[] buf = new byte[8192];
            InputStream in = (InputStream)value;
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                bout.write(buf, 0, read);
            }
        } else {
            ObjectOutputStream oos = new ObjectOutputStream(bout);
            oos.writeObject(value);
            oos.close();
        }
        return bout.toByteArray();
    }

    public static boolean toBooleanValue(Object obj) {
        return obj != null && (Boolean)obj != false;
    }

    private static void fixNumericByteOrder(byte[] bytes) {
        for (int i2 = 0; i2 < 4; ++i2) {
            ByteUtil.swap4Bytes(bytes, i2 * 4);
        }
    }

    protected static Object booleanToInteger(Object obj) {
        if (obj instanceof Boolean) {
            obj = (Boolean)obj != false ? 1 : 0;
        }
        return obj;
    }

    static RawData rawDataWrapper(byte[] bytes) {
        return new RawData(bytes);
    }

    static boolean isRawData(Object value) {
        return value instanceof RawData;
    }

    protected static void writeDefinitions(ByteBuffer buffer, List<Column> columns, JetFormat format, Charset charset) throws IOException {
        short columnNumber = 0;
        short fixedOffset = 0;
        short variableOffset = 0;
        short longVariableOffset = Column.countNonLongVariableLength(columns);
        for (Column col : columns) {
            col.setColumnNumber(columnNumber);
            int position = buffer.position();
            buffer.put(col.getType().getValue());
            buffer.putInt(1625);
            buffer.putShort(columnNumber);
            if (col.isVariableLength()) {
                if (!col.getType().isLongValue()) {
                    short s2 = variableOffset;
                    variableOffset = (short)(variableOffset + 1);
                    buffer.putShort(s2);
                } else {
                    short s3 = longVariableOffset;
                    longVariableOffset = (short)(longVariableOffset + 1);
                    buffer.putShort(s3);
                }
            } else {
                buffer.putShort((short)0);
            }
            buffer.putShort(columnNumber);
            if (col.getType().isTextual()) {
                Column.writeSortOrder(buffer, col._textSortOrder, format);
            } else {
                if (col.getType().getHasScalePrecision()) {
                    buffer.put(col.getPrecision());
                    buffer.put(col.getScale());
                } else {
                    buffer.put((byte)0);
                    buffer.put((byte)0);
                }
                buffer.putShort((short)0);
            }
            buffer.put(Column.getColumnBitFlags(col));
            if (col.isCompressedUnicode()) {
                buffer.put((byte)1);
            } else {
                buffer.put((byte)0);
            }
            buffer.putInt(0);
            if (col.isVariableLength()) {
                buffer.putShort((short)0);
            } else {
                buffer.putShort(fixedOffset);
                fixedOffset = (short)(fixedOffset + col.getType().getFixedSize(col.getLength()));
            }
            if (!col.getType().isLongValue()) {
                buffer.putShort(col.getLength());
            } else {
                buffer.putShort((short)0);
            }
            columnNumber = (short)(columnNumber + 1);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Creating new column def block\n" + ByteUtil.toHexString(buffer, position, format.SIZE_COLUMN_DEF_BLOCK));
        }
        for (Column col : columns) {
            Table.writeName(buffer, col.getName(), charset);
        }
    }

    private static byte getColumnBitFlags(Column col) {
        byte flags = 2;
        if (!col.isVariableLength()) {
            flags = (byte)(flags | 1);
        }
        if (col.isAutoNumber()) {
            flags = (byte)(flags | col.getAutoNumberGenerator().getColumnFlags());
        }
        return flags;
    }

    static SortOrder readSortOrder(ByteBuffer buffer, int position, JetFormat format) {
        short value = buffer.getShort(position);
        byte version = 0;
        if (format.SIZE_SORT_ORDER == 4) {
            version = buffer.get(position + 3);
        }
        if (value == 0) {
            return format.DEFAULT_SORT_ORDER;
        }
        if (value == 1033) {
            if (version == GENERAL_LEGACY_SORT_ORDER.getVersion()) {
                return GENERAL_LEGACY_SORT_ORDER;
            }
            if (version == GENERAL_SORT_ORDER.getVersion()) {
                return GENERAL_SORT_ORDER;
            }
        }
        return new SortOrder(value, version);
    }

    private static void writeSortOrder(ByteBuffer buffer, SortOrder sortOrder, JetFormat format) {
        if (sortOrder == null) {
            sortOrder = format.DEFAULT_SORT_ORDER;
        }
        buffer.putShort(sortOrder.getValue());
        if (format.SIZE_SORT_ORDER == 4) {
            buffer.put((byte)0);
            buffer.put(sortOrder.getVersion());
        }
    }

    public static final class SortOrder {
        private final short _value;
        private final byte _version;

        public SortOrder(short value, byte version) {
            this._value = value;
            this._version = version;
        }

        public short getValue() {
            return this._value;
        }

        public byte getVersion() {
            return this._version;
        }

        public int hashCode() {
            return this._value;
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 != null && this.getClass() == o2.getClass() && this._value == ((SortOrder)o2)._value && this._version == ((SortOrder)o2)._version;
        }

        public String toString() {
            return this._value + "(" + this._version + ")";
        }
    }

    private final class GuidAutoNumberGenerator
    extends AutoNumberGenerator {
        private Object _lastAutoNumber;

        private GuidAutoNumberGenerator() {
        }

        public Object getLast() {
            return this._lastAutoNumber;
        }

        public Object getNext() {
            this._lastAutoNumber = "{" + UUID.randomUUID() + "}";
            return this._lastAutoNumber;
        }

        public int getColumnFlags() {
            return 64;
        }

        public DataType getType() {
            return DataType.GUID;
        }
    }

    private final class LongAutoNumberGenerator
    extends AutoNumberGenerator {
        private LongAutoNumberGenerator() {
        }

        public Object getLast() {
            return Column.this.getTable().getLastLongAutoNumber();
        }

        public Object getNext() {
            return Column.this.getTable().getNextLongAutoNumber();
        }

        public int getColumnFlags() {
            return 4;
        }

        public DataType getType() {
            return DataType.LONG;
        }
    }

    public abstract class AutoNumberGenerator {
        protected AutoNumberGenerator() {
        }

        public abstract Object getLast();

        public abstract Object getNext();

        public abstract int getColumnFlags();

        public abstract DataType getType();
    }

    private static class RawData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] _bytes;

        private RawData(byte[] bytes) {
            this._bytes = bytes;
        }

        private byte[] getBytes() {
            return this._bytes;
        }

        public String toString() {
            return "RawData: " + ByteUtil.toHexString(this.getBytes());
        }

        private Object writeReplace() throws ObjectStreamException {
            return this.getBytes();
        }
    }

    private static final class DateExt
    extends Date {
        private static final long serialVersionUID = 0L;
        private final transient long _dateBits;

        private DateExt(long time, long dateBits) {
            super(time);
            this._dateBits = dateBits;
        }

        public long getDateBits() {
            return this._dateBits;
        }

        private Object writeReplace() throws ObjectStreamException {
            return new Date(super.getTime());
        }
    }
}

