/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.scsu;

import com.healthmarketscience.jackcess.scsu.Debug;
import com.healthmarketscience.jackcess.scsu.EndOfInputException;
import com.healthmarketscience.jackcess.scsu.EndOfOutputException;
import com.healthmarketscience.jackcess.scsu.IllegalInputException;
import com.healthmarketscience.jackcess.scsu.SCSU;

public class Compress
extends SCSU {
    private int iIn;
    private int iOut;
    private int iSCU = -1;
    private boolean fUnicodeMode = false;
    static int iNextWindow = 3;

    private boolean locateWindow(int ch2, int[] offsetTable) {
        int iWin = this.getCurrentWindow();
        if (iWin != -1 && ch2 >= offsetTable[iWin] && ch2 < offsetTable[iWin] + 128) {
            return true;
        }
        for (iWin = 0; iWin < offsetTable.length; ++iWin) {
            if (ch2 < offsetTable[iWin] || ch2 >= offsetTable[iWin] + 128) continue;
            this.selectWindow(iWin);
            return true;
        }
        return false;
    }

    public static boolean isAsciiCrLfOrTab(int ch2) {
        return ch2 >= 32 && ch2 <= 127 || ch2 == 9 || ch2 == 10 || ch2 == 13;
    }

    public int outputSingleByteRun(char[] in, byte[] out) throws EndOfOutputException, EndOfInputException, IllegalInputException {
        int iWin = this.getCurrentWindow();
        while (this.iIn < in.length) {
            int outlen = 0;
            byte byte1 = 0;
            byte byte2 = 0;
            int ch2 = in[this.iIn];
            int inlen = 1;
            if ((ch2 & 0xF800) == 55296) {
                if ((ch2 & 0xFC00) == 56320) {
                    throw new IllegalInputException("Unpaired low surrogate: " + this.iIn);
                }
                if (this.iIn >= in.length - 1) {
                    throw new EndOfInputException();
                }
                char ch22 = in[this.iIn + 1];
                if ((ch22 & 0xFC00) != 56320) {
                    throw new IllegalInputException("Unpaired high surrogate: " + (this.iIn + 1));
                }
                ch2 = (ch2 - 55296 << 10 | ch22 - 56320) + 65536;
                inlen = 2;
            }
            if (Compress.isAsciiCrLfOrTab(ch2) || ch2 == 0) {
                byte2 = (byte)(ch2 & 0x7F);
                outlen = 1;
            } else if (ch2 < 32) {
                byte1 = 1;
                byte2 = (byte)ch2;
                outlen = 2;
            } else if (ch2 >= this.dynamicOffset[iWin] && ch2 < this.dynamicOffset[iWin] + 128) {
                byte2 = (byte)((ch2 -= this.dynamicOffset[iWin]) | 0x80);
                outlen = 1;
            }
            if (this.iOut + outlen >= out.length) {
                throw new EndOfOutputException();
            }
            switch (outlen) {
                default: {
                    return ch2;
                }
                case 2: {
                    out[this.iOut++] = byte1;
                }
                case 1: 
            }
            out[this.iOut++] = byte2;
            this.iIn += inlen;
        }
        return 0;
    }

    private void quoteSingleByte(int ch2, byte[] out) throws EndOfOutputException {
        Debug.out("Quoting SingleByte ", ch2);
        int iWin = this.getCurrentWindow();
        if (this.iOut >= out.length - 2) {
            throw new EndOfOutputException();
        }
        out[this.iOut++] = (byte)(1 + iWin);
        if (ch2 >= this.dynamicOffset[iWin] && ch2 < this.dynamicOffset[iWin] + 128) {
            out[this.iOut++] = (byte)((ch2 -= this.dynamicOffset[iWin]) | 0x80);
        } else if (ch2 >= staticOffset[iWin] && ch2 < staticOffset[iWin] + 128) {
            out[this.iOut++] = (byte)(ch2 -= staticOffset[iWin]);
        } else {
            throw new IllegalStateException("ch = " + ch2 + " not valid in quoteSingleByte. Internal Compressor Error");
        }
        ++this.iIn;
        Debug.out("New input: ", this.iIn);
    }

    public char outputUnicodeRun(char[] in, byte[] out) throws EndOfOutputException {
        char ch2 = '\u0000';
        while (this.iIn < in.length) {
            ch2 = in[this.iIn];
            int outlen = 2;
            if (Compress.isCompressible(ch2)) {
                if (this.iIn < in.length - 1) {
                    Debug.out("is-comp: ", ch2);
                    char ch22 = in[this.iIn + 1];
                    if (Compress.isCompressible(ch22)) break;
                    Debug.out("no-comp: ", ch22);
                }
                if (ch2 >= '\ue000' && ch2 <= '\uf2ff') {
                    outlen = 3;
                }
            }
            if (this.iOut >= out.length - outlen) {
                Debug.out("End of Output @", this.iOut);
                throw new EndOfOutputException();
            }
            if (outlen == 3) {
                out[this.iOut++] = -16;
            }
            out[this.iOut++] = (byte)(ch2 >>> 8);
            out[this.iOut++] = (byte)(ch2 & 0xFF);
            ++this.iIn;
        }
        return ch2;
    }

    private boolean positionWindow(int ch2, byte[] out, boolean fCurUnicodeMode) throws IllegalInputException, EndOfOutputException {
        int iWin = iNextWindow % 8;
        int iPosition = 0;
        if (ch2 < 128) {
            throw new IllegalStateException("ch < 0x80");
        }
        for (int i2 = 0; i2 < fixedOffset.length; ++i2) {
            if (ch2 < fixedOffset[i2] || ch2 >= fixedOffset[i2] + 128) continue;
            iPosition = i2;
            break;
        }
        if (iPosition != 0) {
            Debug.out("FIXED position is ", iPosition + 249);
            this.dynamicOffset[iWin] = fixedOffset[iPosition];
            iPosition += 249;
        } else if (ch2 < 13312) {
            iPosition = ch2 >>> 7;
            this.dynamicOffset[iWin] = ch2 & 0xFF80;
            Debug.out("Offset=" + this.dynamicOffset[iWin] + ", iPosition=" + iPosition + " for char", ch2);
        } else {
            if (ch2 < 57344) {
                return false;
            }
            if (ch2 <= 65535) {
                iPosition = ch2 - 44032 >>> 7;
                this.dynamicOffset[iWin] = ch2 & 0xFF80;
                Debug.out("Offset=" + this.dynamicOffset[iWin] + ", iPosition=" + iPosition + " for char", ch2);
            } else {
                iPosition = ch2 - 65536 >>> 7;
                Debug.out("Try position Window at ", iPosition);
                iPosition |= iWin << 13;
                this.dynamicOffset[iWin] = ch2 & 0x1FFF80;
            }
        }
        if (iPosition < 256 && this.iOut < out.length - 1) {
            out[this.iOut++] = (byte)((fCurUnicodeMode ? -24 : 24) + iWin);
            out[this.iOut++] = (byte)(iPosition & 0xFF);
        } else if (iPosition >= 256 && this.iOut < out.length - 2) {
            Debug.out("Setting extended window at ", iPosition);
            out[this.iOut++] = fCurUnicodeMode ? -15 : 11;
            out[this.iOut++] = (byte)(iPosition >>> 8 & 0xFF);
            out[this.iOut++] = (byte)(iPosition & 0xFF);
        } else {
            throw new EndOfOutputException();
        }
        this.selectWindow(iWin);
        ++iNextWindow;
        return true;
    }

    public int simpleCompress(char[] in, int iStartIn, byte[] out, int iStartOut) throws IllegalInputException, EndOfInputException, EndOfOutputException {
        this.iIn = iStartIn;
        this.iOut = iStartOut;
        while (this.iIn < in.length) {
            int ch2;
            if (this.iSCU != -1) {
                Debug.out("Remaining", in, this.iIn);
                Debug.out("Output until [" + this.iOut + "]: ", out);
                ch2 = this.outputUnicodeRun(in, out);
                if (this.iOut - this.iSCU == 3) {
                    out[this.iSCU] = 14;
                    this.iSCU = -1;
                    continue;
                }
                this.iSCU = -1;
                this.fUnicodeMode = true;
            } else {
                ch2 = this.outputSingleByteRun(in, out);
            }
            if (this.iIn == in.length) break;
            Debug.out("Output so far: ", out);
            Debug.out("Routing ch=" + ch2 + " for Input", in, this.iIn);
            if (this.iOut >= out.length - 1) {
                throw new EndOfOutputException();
            }
            int ich = this.iIn;
            while (ch2 < 128) {
                if (ich == in.length || !Compress.isCompressible(in[ich])) {
                    ch2 = in[this.iIn];
                    break;
                }
                ch2 = in[ich];
                ++ich;
            }
            int iprevWindow = this.getCurrentWindow();
            if (ch2 < 128 || this.locateWindow(ch2, this.dynamicOffset)) {
                char ch22;
                Debug.out("located dynamic window " + this.getCurrentWindow() + " at ", this.iOut + 1);
                if (!this.fUnicodeMode && this.iIn < in.length - 1 && (ch22 = in[this.iIn + 1]) >= this.dynamicOffset[iprevWindow] && ch22 < this.dynamicOffset[iprevWindow] + 128) {
                    this.quoteSingleByte(ch2, out);
                    this.selectWindow(iprevWindow);
                    continue;
                }
                out[this.iOut++] = (byte)((this.fUnicodeMode ? -32 : 16) + this.getCurrentWindow());
                this.fUnicodeMode = false;
                continue;
            }
            if (!this.fUnicodeMode && this.locateWindow(ch2, staticOffset)) {
                Debug.out("located a static window", this.getCurrentWindow());
                this.quoteSingleByte(ch2, out);
                this.selectWindow(iprevWindow);
                continue;
            }
            if (this.positionWindow(ch2, out, this.fUnicodeMode)) {
                this.fUnicodeMode = false;
                continue;
            }
            this.iSCU = this.iOut;
            out[this.iOut++] = 15;
        }
        return this.iOut - iStartOut;
    }

    public byte[] compress(String inStr) throws IllegalInputException, EndOfInputException {
        byte[] out = new byte[inStr.length() * 2];
        char[] in = inStr.toCharArray();
        Debug.out("compress input: ", in);
        this.reset();
        while (true) {
            try {
                this.simpleCompress(in, this.charsRead(), out, this.bytesWritten());
            }
            catch (EndOfOutputException e2) {
                byte[] largerOut = new byte[out.length * 2];
                System.arraycopy(out, 0, largerOut, 0, out.length);
                out = largerOut;
                continue;
            }
            break;
        }
        byte[] trimmedOut = new byte[this.bytesWritten()];
        System.arraycopy(out, 0, trimmedOut, 0, trimmedOut.length);
        out = trimmedOut;
        Debug.out("compress output: ", out);
        return out;
    }

    public void reset() {
        super.reset();
        this.fUnicodeMode = false;
        this.iSCU = -1;
    }

    public int bytesWritten() {
        return this.iOut;
    }

    public int charsRead() {
        return this.iIn;
    }
}

