/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.scsu;

import com.healthmarketscience.jackcess.scsu.Debug;
import com.healthmarketscience.jackcess.scsu.EndOfInputException;
import com.healthmarketscience.jackcess.scsu.IllegalInputException;
import com.healthmarketscience.jackcess.scsu.SCSU;

public class Expand
extends SCSU {
    protected int iOut = 0;
    protected int iIn = 0;

    protected void defineWindow(int iWindow, byte bOffset) throws IllegalInputException {
        int iOffset;
        int n2 = iOffset = bOffset < 0 ? bOffset + 256 : bOffset;
        if (iOffset == 0) {
            throw new IllegalInputException();
        }
        if (iOffset < 104) {
            this.dynamicOffset[iWindow] = iOffset << 7;
        } else if (iOffset < 168) {
            this.dynamicOffset[iWindow] = (iOffset << 7) + 44032;
        } else {
            if (iOffset < 249) {
                throw new IllegalInputException("iOffset == " + iOffset);
            }
            this.dynamicOffset[iWindow] = fixedOffset[iOffset - 249];
        }
        this.selectWindow(iWindow);
    }

    protected void defineExtendedWindow(char chOffset) {
        int iWindow = chOffset >>> 13;
        this.dynamicOffset[iWindow] = ((chOffset & 0x1FFF) << 7) + 65536;
        this.selectWindow(iWindow);
    }

    protected int expandUnicode(byte[] in, int iCur, StringBuilder sb) throws IllegalInputException, EndOfInputException {
        while (iCur < in.length - 1) {
            byte b2 = in[iCur];
            if (b2 >= -32 && b2 <= -25) {
                Debug.out("SelectWindow: ", b2);
                this.selectWindow(b2 - -32);
                return iCur;
            }
            if (b2 >= -24 && b2 <= -17) {
                this.defineWindow(b2 - -24, in[iCur + 1]);
                return iCur + 1;
            }
            if (b2 == -15) {
                if (iCur >= in.length - 2) break;
                this.defineExtendedWindow(Expand.charFromTwoBytes(in[iCur + 1], in[iCur + 2]));
                return iCur + 2;
            }
            if (b2 == -16) {
                if (iCur >= in.length - 2) break;
                ++iCur;
            }
            char ch2 = Expand.charFromTwoBytes(in[iCur], in[iCur + 1]);
            sb.append(ch2);
            ++this.iOut;
            iCur += 2;
        }
        if (iCur == in.length) {
            return iCur;
        }
        throw new EndOfInputException();
    }

    public static char charFromTwoBytes(byte hi, byte lo) {
        char ch2 = (char)(lo >= 0 ? lo : 256 + lo);
        return (char)(ch2 + (char)((hi >= 0 ? hi : 256 + hi) << 8));
    }

    protected String expandSingleByte(byte[] in) throws IllegalInputException, EndOfInputException {
        int iCur;
        StringBuilder sb = new StringBuilder(in.length);
        this.iOut = 0;
        block9: for (iCur = 0; iCur < in.length; ++iCur) {
            int iStaticWindow = 0;
            int iDynamicWindow = this.getCurrentWindow();
            switch (in[iCur]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    Debug.out("SQn:", iStaticWindow);
                    if (iCur >= in.length - 1) {
                        Debug.out("SQn missing argument: ", in, iCur);
                        break block9;
                    }
                    iDynamicWindow = iStaticWindow = in[iCur] - 1;
                    ++iCur;
                }
                default: {
                    int ch2;
                    if (in[iCur] >= 0) {
                        ch2 = in[iCur] + staticOffset[iStaticWindow];
                        sb.append((char)ch2);
                        ++this.iOut;
                        continue block9;
                    }
                    ch2 = in[iCur] + 256;
                    ch2 -= 128;
                    Debug.out("Dynamic: ", (char)(ch2 += this.dynamicOffset[iDynamicWindow]));
                    if (ch2 < 65536) {
                        sb.append((char)ch2);
                        ++this.iOut;
                        continue block9;
                    }
                    Debug.out("Extension character: ", ch2);
                    sb.append((char)(55296 + ((ch2 -= 65536) >> 10)));
                    ++this.iOut;
                    sb.append((char)(56320 + (ch2 & 0xFFFF03FF)));
                    ++this.iOut;
                    continue block9;
                }
                case 11: {
                    if ((iCur += 2) >= in.length) {
                        Debug.out("SDn missing argument: ", in, iCur - 1);
                        break block9;
                    }
                    this.defineExtendedWindow(Expand.charFromTwoBytes(in[iCur - 1], in[iCur]));
                    continue block9;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    if (++iCur >= in.length) {
                        Debug.out("SDn missing argument: ", in, iCur - 1);
                        break block9;
                    }
                    this.defineWindow(in[iCur - 1] - 24, in[iCur]);
                    continue block9;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.selectWindow(in[iCur] - 16);
                    continue block9;
                }
                case 15: {
                    iCur = this.expandUnicode(in, iCur + 1, sb);
                    continue block9;
                }
                case 14: {
                    if ((iCur += 2) >= in.length) {
                        Debug.out("SQU missing argument: ", in, iCur - 2);
                        break block9;
                    }
                    int ch2 = Expand.charFromTwoBytes(in[iCur - 1], in[iCur]);
                    Debug.out("Quoted: ", (char)ch2);
                    sb.append((char)ch2);
                    ++this.iOut;
                    continue block9;
                }
                case 12: {
                    throw new IllegalInputException();
                }
            }
        }
        if (iCur >= in.length) {
            sb.setLength(this.iOut);
            this.iIn = iCur;
            return sb.toString();
        }
        Debug.out("Length ==" + in.length + " iCur =", iCur);
        throw new EndOfInputException();
    }

    public String expand(byte[] in) throws IllegalInputException, EndOfInputException {
        String str = this.expandSingleByte(in);
        Debug.out("expand output: ", str.toCharArray());
        return str;
    }

    public void reset() {
        this.iOut = 0;
        this.iIn = 0;
        super.reset();
    }

    public int charsWritten() {
        return this.iOut;
    }

    public int bytesRead() {
        return this.iIn;
    }
}

