/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDebug;
import com.sec.osdm.io.AppDllLoader;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.comm.CommDriver;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public class AppModem
extends AppComm {
    private final int MSG_TASK = 114;
    private final int MSG_ENQ = 5;
    private final int MSG_ACK = 6;
    private final int MSG_NAK = 21;
    private final int MSG_FAIL = 0;
    private final int MSG_CONT = 0;
    private final int MSG_END = 255;
    private final int MSG_STX = 2;
    private final int MSG_ETX = 3;
    private final int MODEM_SIZE = 5;
    private final int MAX_SIZE = 256;
    private static AppModem m_oThis = null;
    private static Hashtable m_linkInfo = new Hashtable();
    private SerialPort m_sp = null;
    private InputStream m_is = null;
    private OutputStream m_os = null;

    private AppModem() {
        AppDllLoader.loadLibrary();
    }

    public static AppModem getInstance() {
        if (m_oThis == null) {
            m_oThis = new AppModem();
        }
        m_linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        return m_oThis;
    }

    private boolean createSerialPort() {
        block4: {
            String driverName = "com.sun.comm.Win32Driver";
            System.setSecurityManager(null);
            CommDriver commDriver = (CommDriver)Class.forName(driverName).newInstance();
            commDriver.initialize();
            Enumeration findingPort = CommPortIdentifier.getPortIdentifiers();
            while (findingPort.hasMoreElements()) {
                CommPortIdentifier pid = (CommPortIdentifier)findingPort.nextElement();
                if (!pid.getName().equals("COM" + (String)m_linkInfo.get("COM_PORT"))) continue;
                this.m_sp = (SerialPort)pid.open("Modem", 1000);
                break;
            }
            if (this.m_sp == null) break block4;
            this.m_sp.setSerialPortParams(Integer.parseInt((String)m_linkInfo.get("BAUD_RATE")), 8, 1, 0);
            this.m_is = this.m_sp.getInputStream();
            this.m_os = this.m_sp.getOutputStream();
            return true;
        }
        try {
            AppGlobal.showErrorMessage("", AppLang.getText("Selected COM port is not found."));
        }
        catch (Exception e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to create serial port."));
        }
        return false;
    }

    private boolean isConnected() {
        return this.m_sp != null && !((String)m_linkInfo.get("TEL_NUMBER")).trim().equals("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connect() {
        if (!this.createSerialPort()) {
            return false;
        }
        int cnt = 0;
        try {
            while (true) {
                this.send("AT&F");
                if (this.recv("OK", 2)) {
                    this.send("ATDT" + ((String)m_linkInfo.get("TEL_NUMBER")).trim());
                    if (this.recv("OK", 2)) {
                        return false;
                    }
                    break;
                }
                if (cnt > 2) {
                    this.disconnect();
                    return false;
                }
                ++cnt;
            }
            if (this.recv("CONNECT", 60)) return true;
            this.disconnect();
            return false;
        }
        catch (Exception e2) {
            if (this.m_sp != null) {
                this.disconnect();
            }
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to connect via Modem."));
            return false;
        }
    }

    @Override
    public void disconnect() {
        try {
            if (this.m_sp != null) {
                this.m_sp.close();
                this.m_sp = null;
                this.m_is.close();
                this.m_is = null;
                this.m_os.close();
                this.m_os = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (AppGlobal.g_lockOut != null) {
            AppGlobal.g_lockOut = null;
        }
    }

    private void setLocked() {
        if (AppGlobal.g_lockOut != null) {
            AppGlobal.g_lockOut.begin();
        }
    }

    private void resetLocked() {
        if (AppGlobal.g_lockOut != null) {
            AppGlobal.g_lockOut.end();
        }
    }

    private void send(String s2) throws Exception {
        s2 = String.valueOf(s2) + "\r\n";
        this.m_os.write(s2.getBytes());
    }

    private boolean recv(String exp, int nLimit) throws Exception {
        int reTryCnt = 0;
        int cnt = 0;
        String strTemp = "";
        while (true) {
            Thread.sleep(100L);
            Thread.yield();
            strTemp = "";
            cnt = this.m_is.available();
            int i2 = 0;
            while (i2 < cnt) {
                strTemp = String.valueOf(strTemp) + (char)this.m_is.read();
                ++i2;
            }
            if (strTemp.contains(exp)) {
                return true;
            }
            if (reTryCnt > nLimit * 10) {
                return false;
            }
            ++reTryCnt;
        }
    }

    @Override
    public boolean sendData(byte[] data) {
        if (!this.isConnected()) {
            return false;
        }
        ArrayList<byte[]> sendPacket = new ArrayList<byte[]>();
        byte[] send = null;
        int size = 0;
        boolean bRet = false;
        int i2 = 0;
        while (i2 < data.length) {
            size = data.length < i2 + 256 ? data.length - i2 : 256;
            send = new byte[size];
            System.arraycopy(data, i2, send, 0, size);
            sendPacket.add(sendPacket.size(), send);
            i2 += 256;
        }
        this.resetLocked();
        bRet = this.sendPacket(sendPacket);
        this.setLocked();
        return bRet;
    }

    private boolean sendPacket(ArrayList send) {
        byte[] header = new byte[4];
        byte[] data = null;
        byte[] packet = null;
        header[0] = 114;
        header[1] = 0;
        int i2 = 0;
        while (i2 < send.size()) {
            if (i2 == send.size() - 1) {
                header[1] = -1;
            }
            AppFunctions.short2byte(header, 2, (short)i2);
            data = (byte[])send.get(i2);
            packet = new byte[header.length + data.length + 5];
            packet[0] = 2;
            AppFunctions.short2byte(packet, 1, (short)(header.length + data.length));
            System.arraycopy(header, 0, packet, 3, header.length);
            System.arraycopy(data, 0, packet, 3 + header.length, data.length);
            this.setCheckSum(packet);
            packet[packet.length - 1] = 3;
            this.sendAnswer(5);
            if (this.waitAnswer() != 6) {
                return false;
            }
            try {
                this.m_os.write(packet);
                this.m_os.flush();
            }
            catch (Exception e2) {
                return false;
            }
            if (this.waitAnswer() != 6) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public byte[] recvData() {
        ArrayList packet = new ArrayList();
        byte[] m_bData = null;
        byte[] m_bTemp = null;
        int msgLen = 0;
        int offset = 0;
        this.resetLocked();
        try {
            packet = this.recvPacket();
            if (packet.size() > 0) {
                int i2 = 0;
                while (i2 < packet.size()) {
                    msgLen += ((byte[])packet.get(i2)).length;
                    ++i2;
                }
                if (msgLen > 0) {
                    m_bData = new byte[msgLen];
                    offset = 0;
                    i2 = 0;
                    while (i2 < packet.size()) {
                        m_bTemp = (byte[])packet.get(i2);
                        System.arraycopy(m_bTemp, 0, m_bData, offset, m_bTemp.length);
                        offset += m_bTemp.length;
                        ++i2;
                    }
                    AppDebug.sendDebugMsg("Receive Data", m_bData);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLocked();
        return m_bData;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList recvPacket() throws Exception {
        recvData = new ArrayList<byte[]>();
        bbRecv = null;
        bTemp = null;
        bData = null;
        data = null;
        nAvailable = 0;
        msgLen = 0;
        recvData.clear();
        do {
            if (this.waitAnswer() != 5) {
                return null;
            }
            this.sendAnswer(6);
            if (this.waiting()) ** GOTO lbl31
            return null;
lbl-1000:
            // 1 sources

            {
                bTemp = new byte[nAvailable];
                bbRcvTemp = null;
                if (bbRecv != null) {
                    bbRcvTemp = bbRecv.duplicate();
                    bbRcvTemp.rewind();
                } else {
                    bbRcvTemp = ByteBuffer.allocate(0);
                }
                bbRecv = ByteBuffer.allocate(bbRcvTemp.capacity() + nAvailable);
                bbRecv.put(bbRcvTemp);
                this.m_is.read(bTemp);
                bbRecv.put(bTemp);
                Thread.sleep(100L);
lbl31:
                // 2 sources

                ** while ((nAvailable = this.m_is.available()) > 0)
            }
lbl32:
            // 1 sources

            bbRecv.rewind();
            bData = bbRecv.array();
            bbRecv = null;
            if (this.getCheckSum(bData)) {
                this.sendAnswer(6);
                msgLen = AppFunctions.byte2short(bData, 1);
                data = new byte[msgLen - 4];
                System.arraycopy(bData, 7, data, 0, data.length);
                recvData.add(recvData.size(), data);
                continue;
            }
            this.sendAnswer(21);
        } while (bData[4] != -1);
        return recvData;
    }

    private void sendAnswer(int type) {
        try {
            switch (type) {
                case 5: {
                    this.m_os.write(5);
                    break;
                }
                case 6: {
                    this.m_os.write(6);
                    break;
                }
                case 21: {
                    this.m_os.write(21);
                }
            }
            this.m_os.flush();
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int waitAnswer() {
        int cnt = 0;
        try {
            while (true) {
                int nAnswer = 0;
                if (this.m_is.available() > 0) {
                    nAnswer = this.m_is.read();
                }
                switch (nAnswer) {
                    case 5: {
                        return 5;
                    }
                    case 6: {
                        return 6;
                    }
                    case 21: {
                        return 21;
                    }
                }
                if (cnt > 90) {
                    return 0;
                }
                Thread.sleep(100L);
                ++cnt;
            }
        }
        catch (Exception e2) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waiting() {
        int nRetry = 0;
        try {
            while (true) {
                int nRead;
                if ((nRead = this.m_is.available()) > 0) {
                    return true;
                }
                if (++nRetry > 300) {
                    return false;
                }
                Thread.sleep(100L);
                Thread.yield();
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    private void setCheckSum(byte[] packet) {
        byte result = 0;
        int i2 = 1;
        while (i2 < packet.length - 2) {
            result = (byte)(result ^ packet[i2]);
            ++i2;
        }
        packet[packet.length - 2] = result;
    }

    private boolean getCheckSum(byte[] packet) {
        byte result = 0;
        int i2 = 1;
        while (i2 < packet.length - 2) {
            result = (byte)(result ^ packet[i2]);
            ++i2;
        }
        return packet[packet.length - 2] == result;
    }

    public void cancelJob() {
        if (m_oThis != null) {
            this.disconnect();
        }
    }

    public static /* bridge */ /* synthetic */ AppComm getInstance() {
        return AppModem.getInstance();
    }
}

