/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main;

import com.sec.osdm.common.AppDateTimer;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.common.SecurityUtil;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDownRequest;
import com.sec.osdm.io.AppIOConst;
import com.sec.osdm.io.AppLockOut;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.components.AppSelect;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AppLogIn
extends AppDialog
implements KeyListener {
    private final int SIZE_WIDTH = 285;
    private final int SIZE_HEIGHT = 200;
    private DoLogin m_login = null;
    private JTextField m_txtUser = new JTextField();
    private JPasswordField m_txtPass = new JPasswordField();
    private JComboBox m_cbTenant = new JComboBox();
    private JButton m_btnOK = new JButton(AppLang.getText("OK"));
    private JButton m_btnCancel = new JButton(AppLang.getText("Cancel"));
    private String m_userId = "";
    private int m_runMode;
    private JLabel lbUser = new JLabel(AppLang.getText("ID"), 4);
    private JLabel lbPass = new JLabel(AppLang.getText("Password"), 4);
    private int m_pwdCnt = 0;
    private JCheckBox cbUseToolBar = new JCheckBox(AppLang.getText("Encryption"), false);

    public AppLogIn(int mode) {
        AppGlobal.hideProgress();
        this.m_runMode = mode;
        this.m_userId = (String)AppProperty.m_properties.get("USER_ID");
        if (this.m_userId == null) {
            this.m_userId = "";
        }
        try {
            this.cbUseToolBar.setSelected((Boolean)AppProperty.m_properties.get("LOGIN_ENCRYPT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        AppGlobal.g_bIsLoginReq = false;
        this.m_layout = new AppLayout(this.m_contentPane, 285, 200);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppLogIn.this.openDialog("Login", 285, 200);
            }
        });
    }

    private void createComponents() {
        JLabel lbTenant = new JLabel(AppLang.getText("Tenant No"), 4);
        this.m_cbTenant.addItem(String.valueOf(AppLang.getText("Tenant")) + " 1");
        this.m_cbTenant.addItem(String.valueOf(AppLang.getText("Tenant")) + " 2");
        this.m_cbTenant.setSelectedIndex(0);
        this.m_txtUser.setText(this.m_userId);
        this.m_txtUser.addKeyListener(this);
        this.m_txtUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e2) {
                AppLogIn.this.m_txtUser.setFocusable(true);
            }
        });
        this.m_txtPass.addKeyListener(this);
        this.lbUser.addKeyListener(this);
        this.lbPass.addKeyListener(this);
        this.lbPass.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (AppLogIn.this.m_runMode == 1) {
                    if (e2.getClickCount() >= 5) {
                        AppLogIn.this.lbPass.setForeground(Color.red);
                    } else {
                        AppLogIn.this.lbPass.setForeground(AppLogIn.this.lbUser.getForeground());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }
        });
        if (this.m_runMode == 2 && !this.m_userId.trim().equals("")) {
            this.m_txtUser.setFocusable(false);
        }
        this.m_btnOK.setActionCommand("OK");
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel.setActionCommand("Cancel");
        this.m_btnCancel.addActionListener(this);
        if (this.m_runMode == 1) {
            this.m_layout.addComponent(this.lbPass, 10, 10, 100, 25);
            this.m_layout.addComponent(this.m_txtPass, 113, 10, 150, 25);
            this.m_layout.addComponent(lbTenant, 10, 45, 100, 25);
            this.m_layout.addComponent(this.m_cbTenant, 113, 45, 150, 25);
            this.m_layout.addComponent(this.m_btnOK, 30, 110, 100, 25);
            this.m_layout.addComponent(this.m_btnCancel, 150, 110, 100, 25);
        } else {
            this.m_layout.addComponent(this.lbUser, 10, 10, 100, 25);
            this.m_layout.addComponent(this.m_txtUser, 113, 10, 150, 25);
            this.m_layout.addComponent(this.lbPass, 10, 45, 100, 25);
            this.m_layout.addComponent(this.m_txtPass, 113, 45, 150, 25);
            this.m_layout.addComponent(lbTenant, 10, 80, 100, 25);
            this.m_layout.addComponent(this.m_cbTenant, 113, 80, 150, 25);
            this.m_layout.addComponent(this.m_btnOK, 30, 130, 100, 25);
            this.m_layout.addComponent(this.m_btnCancel, 150, 130, 100, 25);
            this.m_layout.addComponent(this.cbUseToolBar, 110, 105, 100, 25);
        }
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("OK")) {
            if (this.m_runMode != 1) {
                if (this.m_txtUser.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(this, AppLang.getText("You must input the [ID]."));
                    this.lbUser.requestFocus();
                    return;
                }
                if (String.valueOf(this.m_txtPass.getPassword()).trim().equals("")) {
                    JOptionPane.showMessageDialog(this, AppLang.getText("You must input the [Password]."), AppLang.getText("Login Error"), 1);
                    this.m_txtUser.setFocusable(true);
                    this.m_txtUser.requestFocus();
                    return;
                }
            }
            if (this.CheckPWD()) {
                this.setVisible(false);
                if (this.m_runMode == 2 && this.m_txtUser.getText().trim().equals("admin") && (String.valueOf(this.m_txtPass.getPassword()).trim().equals("samsung") || String.valueOf(this.m_txtPass.getPassword()).trim().equals("#PBX1357sec.com"))) {
                    JOptionPane.showMessageDialog(null, String.valueOf(AppLang.getText("Without changing the default password is being used.")) + "\n" + AppLang.getText("Password changes are recommended."), AppLang.getText("Login"), 1);
                    ChangePassword m_change = new ChangePassword();
                    if (m_change.getIsChanged()) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Password is changed successfully"), AppLang.getText("Login"), 1);
                        m_change.closeDialog();
                    } else {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Password is not changed"), AppLang.getText("Login"), 0);
                        m_change.closeDialog();
                        return;
                    }
                }
                this.m_login = new DoLogin();
                this.m_login.start();
            } else {
                this.lbPass.requestFocus();
            }
        } else {
            this.disConnectAndDispose();
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (e2.getSource() == this.lbUser && e2.getKeyCode() == 10) {
            this.m_txtUser.requestFocus();
        } else if (e2.getSource() == this.m_txtUser && e2.getKeyCode() == 10) {
            this.m_txtPass.requestFocus();
        } else if (e2.getSource() == this.m_txtPass && e2.getKeyCode() == 10) {
            this.m_btnOK.doClick();
        } else if (e2.getSource() == this.lbPass && e2.getKeyCode() == 10) {
            this.m_txtPass.requestFocus();
        }
        this.m_txtUser.setFocusable(true);
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        if (e2.getSource() == this.m_txtUser && this.m_txtUser.getText().length() >= 16 || e2.getSource() == this.m_txtPass && String.valueOf(this.m_txtPass.getPassword()).trim().length() >= 16) {
            e2.consume();
        }
    }

    public void disConnectAndDispose() {
        AppComm.getInstance().disconnect();
        this.m_login = null;
        this.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CheckPWD() {
        AppPageInfo m_pageInfo = null;
        byte[] m_recvData = null;
        byte[] m_reqData = new byte[34];
        String m_msgId = "FFFF";
        boolean m_result = false;
        int m_msgLen = 0;
        AppGlobal.g_bIsWithoutPWD = false;
        if (this.m_runMode == 1 && this.lbPass.getForeground().equals(Color.red) && this.CheckWithoutPWD()) {
            AppGlobal.g_bIsWithoutPWD = true;
        }
        AppGlobal.g_bIsCancel = false;
        m_pageInfo = new AppPageInfo(m_msgId);
        m_reqData[0] = (byte)this.m_cbTenant.getSelectedIndex();
        m_reqData[1] = 1;
        if (this.m_runMode == 1) {
            AppFunctions.str2byte(m_reqData, 2, 16, String.valueOf(this.m_txtPass.getPassword()).trim());
        } else if (this.cbUseToolBar.isSelected()) {
            try {
                byte[] encrypted = SecurityUtil.getCryptoAESByte(String.valueOf(this.m_txtPass.getPassword()).trim());
                System.arraycopy(encrypted, 0, m_reqData, 2, encrypted.length);
            }
            catch (Exception encrypted) {}
        } else {
            AppFunctions.str2byte(m_reqData, 2, 16, String.valueOf(this.m_txtPass.getPassword()).trim());
        }
        AppFunctions.str2byte(m_reqData, 18, 16, this.m_txtUser.getText().trim());
        m_pageInfo.setDownMsgType((byte)1);
        m_pageInfo.setRecordSize(m_reqData.length);
        m_pageInfo.setReqData(m_reqData);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException encrypted) {
            // empty catch block
        }
        if (AppGlobal.g_bIsCancel) {
            AppGlobal.hideProgress();
            this.disConnectAndDispose();
            return false;
        }
        m_result = AppComm.getInstance().requestDownload(m_pageInfo);
        if (m_result && m_pageInfo.getRespData() != null && m_pageInfo.getRespData().length >= 18) {
            m_recvData = m_pageInfo.getRespData();
            if (m_recvData[14] == 0) {
                m_msgLen = AppFunctions.byte2int(m_recvData, 8);
                byte[] recvData = new byte[m_msgLen];
                System.arraycopy(m_recvData, 18, recvData, 0, m_msgLen);
                AppRunInfo.setLinkData(recvData);
                if ((AppRunInfo.getCountry() == 255 || AppRunInfo.getCountry() == 2) && AppGlobal.showConfirmMessage(AppLang.getText("Continue"), String.valueOf(AppLang.getText("Country is not set.")) + "\r\n" + AppLang.getText("Do you want to continue?")) == 1) {
                    this.disConnectAndDispose();
                    return false;
                }
                if (357 >= AppRunInfo.getRunVersion() || AppGlobal.showConfirmMessage(AppLang.getText("Continue"), String.valueOf(AppLang.getText("The version of [Manager] is lower than [System].")) + "\r\n" + AppLang.getText("Do you want to continue?")) != 1) return true;
                this.disConnectAndDispose();
                return false;
            }
            String errMsg = (String)AppIOConst.m_htError.get(m_recvData[14]);
            if (m_recvData[14] == 3) {
                String address = "[IP] " + AppFunctions.byte2ipV6(m_recvData, 18);
                String[] addr = address.split(":");
                String v4Addr = "";
                if (addr.length > 2) {
                    String addresses = String.valueOf(addr[addr.length - 2]) + addr[addr.length - 1];
                    v4Addr = Integer.parseInt(addresses.substring(0, 2), 16) + ".";
                    v4Addr = String.valueOf(v4Addr) + Integer.parseInt(addresses.substring(2, 4), 16) + ".";
                    v4Addr = String.valueOf(v4Addr) + Integer.parseInt(addresses.substring(4, 6), 16) + ".";
                    v4Addr = String.valueOf(v4Addr) + Integer.parseInt(addresses.substring(6, 8), 16);
                }
                if (AppGlobal.showConfirmMessage("", errMsg = String.valueOf(errMsg) + "\n" + address + "[ " + v4Addr + " ]\n" + AppLang.getText("Do you want to continue?")) == 0) {
                    AppNetwork.getInstance().disconnect();
                    if (!this.CheckPWD()) return false;
                    this.setVisible(false);
                    this.m_login = new DoLogin();
                    this.m_login.start();
                    return false;
                } else {
                    this.disConnectAndDispose();
                }
                return false;
            } else if (m_recvData[14] == 6) {
                String telNo = AppFunctions.byte2tel(m_recvData[18], m_recvData[19]);
                AppGlobal.showInfoMessage("", "Using KMMC by " + telNo);
                this.disConnectAndDispose();
                return false;
            } else if (m_recvData[14] == 8) {
                JOptionPane.showMessageDialog(this, AppLang.getText("Invalid Password"), AppLang.getText("Login Error"), 0);
                this.m_txtUser.requestFocus();
                return false;
            } else {
                AppComm.getInstance().dispErrorMessage(m_recvData[14]);
                this.disConnectAndDispose();
            }
            return false;
        }
        AppGlobal.hideProgress();
        this.disConnectAndDispose();
        return false;
    }

    public boolean CheckWithoutPWD() {
        Calendar now = AppDateTimer.getCurrentPCTime();
        return this.m_txtPass.getText().length() == 4 && this.m_txtPass.getText().substring(0, 2).equals(String.format("%02d", now.get(5))) && this.m_txtPass.getText().substring(2, 4).equalsIgnoreCase(String.format("%02d", now.get(12)));
    }

    public class ChangePassword
    extends JDialog {
        private JLabel m_lChangePass;
        private JLabel m_lConfirmPass;
        private JPasswordField m_txtChangePass;
        private JPasswordField m_txtConfirmPass;
        private JButton m_button_ok;
        private JButton m_button_cancel;
        private ChangePassword m_this;
        private boolean m_isChanged;

        public ChangePassword() {
            super(AppGlobal.g_frmMain, AppLang.getText("Change Password"), true);
            this.m_lChangePass = new JLabel(AppLang.getText("New Password"));
            this.m_lConfirmPass = new JLabel(AppLang.getText("Confirm Password"));
            this.m_txtChangePass = new JPasswordField();
            this.m_txtConfirmPass = new JPasswordField();
            this.m_button_ok = new JButton(AppLang.getText("OK"));
            this.m_button_cancel = new JButton(AppLang.getText("Cancel"));
            this.m_this = null;
            this.m_isChanged = false;
            this.m_this = this;
            this.setDialog();
            this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
            this.setVisible(true);
        }

        private void setDialog() {
            this.m_button_ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    String m_ChangePass = String.valueOf(ChangePassword.this.m_txtChangePass.getPassword()).trim();
                    String m_ConfirmPass = String.valueOf(ChangePassword.this.m_txtConfirmPass.getPassword()).trim();
                    if (m_ChangePass.equals("")) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("You must input the [New Password]."), AppLang.getText("Login"), 1);
                        ChangePassword.this.m_txtChangePass.setFocusable(true);
                        ChangePassword.this.m_txtChangePass.requestFocus();
                        return;
                    }
                    if (m_ChangePass.length() < 6) {
                        JOptionPane.showMessageDialog(null, "[" + AppLang.getText("Min Length") + "] " + "6");
                        ChangePassword.this.m_txtChangePass.setText("");
                        ChangePassword.this.m_txtConfirmPass.setText("");
                        return;
                    }
                    if (!ChangePassword.this.isValidPassword(m_ChangePass)) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Password must be mixed with numeric, alphabet, special characters."));
                        ChangePassword.this.m_txtChangePass.setText("");
                        ChangePassword.this.m_txtConfirmPass.setText("");
                        return;
                    }
                    if (m_ChangePass.trim().equals("samsung") || m_ChangePass.trim().equals("#PBX1357sec.com")) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Default password cannot be saved."));
                        ChangePassword.this.m_txtChangePass.setText("");
                        ChangePassword.this.m_txtConfirmPass.setText("");
                        return;
                    }
                    if (m_ConfirmPass.equals("")) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("You must input the [Confirm Password]."), AppLang.getText("Login"), 1);
                        ChangePassword.this.m_txtConfirmPass.setFocusable(true);
                        ChangePassword.this.m_txtConfirmPass.requestFocus();
                        return;
                    }
                    if (!m_ChangePass.equals(m_ConfirmPass)) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Password is not same."), AppLang.getText("Login"), 0);
                        ChangePassword.this.m_txtChangePass.setFocusable(true);
                        ChangePassword.this.m_txtChangePass.requestFocus();
                        return;
                    }
                    boolean ret = false;
                    AppRequestInfo reqUserInfo = new AppRequestInfo("2107", -48, -16);
                    ret = AppComm.getInstance().requestDownload(reqUserInfo.getPageInfo());
                    ChangePassword.this.m_isChanged = false;
                    if (ret) {
                        ArrayList recvData = new ArrayList();
                        recvData = reqUserInfo.getPageInfo().getRecvData();
                        ArrayList userInfoData = (ArrayList)recvData.get(0);
                        if (AppLogIn.this.cbUseToolBar.isSelected()) {
                            try {
                                userInfoData.set(42, SecurityUtil.getCryptoAESString(m_ChangePass));
                                userInfoData.set(43, SecurityUtil.getCryptoAESString(m_ChangePass));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            userInfoData.set(1, m_ChangePass);
                            userInfoData.set(2, m_ChangePass);
                        }
                        recvData.set(0, userInfoData);
                        reqUserInfo.getPageInfo().setSaveData(recvData);
                        ret = AppComm.getInstance().requestUpload(reqUserInfo.getPageInfo());
                        if (ret) {
                            ChangePassword.this.m_isChanged = true;
                        }
                    }
                    ChangePassword.this.m_this.setVisible(false);
                }
            });
            this.m_button_cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    ChangePassword.this.m_isChanged = false;
                    ChangePassword.this.m_this.setVisible(false);
                }
            });
            this.m_txtChangePass = new JPasswordField(16);
            this.m_txtConfirmPass = new JPasswordField(16);
            AppLayout m_layout = new AppLayout(this, 330, 200);
            m_layout.addComponent(this.m_lChangePass, 20, 30, 150, 20);
            m_layout.addComponent(this.m_lConfirmPass, 20, 60, 150, 20);
            m_layout.addComponent(this.m_txtChangePass, 150, 30, 150, 20);
            m_layout.addComponent(this.m_txtConfirmPass, 150, 60, 150, 20);
            m_layout.addComponent(this.m_button_ok, 50, 110, 100, 25);
            m_layout.addComponent(this.m_button_cancel, 160, 110, 100, 25);
        }

        public boolean getIsChanged() {
            return this.m_isChanged;
        }

        public void closeDialog() {
            this.dispose();
        }

        public boolean isValidPassword(String password) {
            int numeric = 0;
            int alphabet = 0;
            int etc = 0;
            int i2 = 0;
            while (i2 < password.length()) {
                if (password.charAt(i2) >= '0' && password.charAt(i2) <= ':') {
                    ++numeric;
                } else if (password.charAt(i2) >= 'a' && password.charAt(i2) < '{') {
                    ++alphabet;
                } else if (password.charAt(i2) >= 'A' && password.charAt(i2) < '[') {
                    ++alphabet;
                } else {
                    ++etc;
                }
                ++i2;
            }
            if (numeric == 0 && etc == 0) {
                return false;
            }
            if (alphabet == 0 && etc == 0) {
                return false;
            }
            return numeric != 0 || alphabet != 0;
        }
    }

    class DoLogin
    extends Thread {
        AppPageInfo m_pageInfo = null;
        byte[] m_recvData = null;
        byte[] m_reqData = new byte[34];
        String[] m_msgId = new String[]{"2800", "3302", "5D06", "2103", "9101", "2217"};
        byte[] m_msgType = new byte[]{-38, -38, -48, -38, -38, -38};
        boolean m_result = false;
        int m_msgLen = 0;

        DoLogin() {
        }

        @Override
        public void run() {
            AppGlobal.g_bIsCancel = false;
            AppGlobal.g_bIsLoginReq = true;
            AppNetwork.m_address_SVMi20i = "";
            AppNetwork.m_ftp_port_SVMi20i = 0;
            int i2 = 0;
            while (i2 < this.m_msgId.length) {
                Object obj2;
                if (!this.m_msgId[i2].equals("9101") && !this.m_msgId[i2].equals("2217") || (obj2 = AppGlobal.g_useMenu.get(this.m_msgId[i2])) != null) {
                    this.m_pageInfo = new AppPageInfo(this.m_msgId[i2]);
                    this.m_pageInfo.setDownMsgType(this.m_msgType[i2]);
                    AppGlobal.showProgress(((AppTreeNode)AppProperty.m_allMmcList.get(this.m_msgId[i2])).getTabTitle(), String.valueOf(AppLang.getText("Downloading initial data")) + "...");
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException obj2) {
                        // empty catch block
                    }
                    if (AppGlobal.g_bIsCancel) {
                        AppGlobal.hideProgress();
                        AppLogIn.this.disConnectAndDispose();
                        return;
                    }
                    AppComm comm2 = AppComm.getInstance();
                    this.m_result = AppDownRequest.requestDownloadByPageInfo(comm2, this.m_pageInfo);
                    if (this.m_result || !this.m_msgId[i2].equals("2217") && !this.m_msgId[i2].equals("9101")) {
                        if (this.m_result && this.m_pageInfo.getRespData() != null && this.m_pageInfo.getRespData().length >= 18) {
                            this.m_recvData = this.m_pageInfo.getRespData();
                        } else {
                            AppGlobal.hideProgress();
                            AppLogIn.this.disConnectAndDispose();
                            return;
                        }
                    }
                }
                ++i2;
            }
            AppGlobal.hideProgress();
            AppGlobal.g_bIsLoginReq = false;
            AppRunInfo.setTenantNo(AppLogIn.this.m_cbTenant.getSelectedIndex());
            if (AppLogIn.this.m_runMode == 1) {
                AppGlobal.g_frmMain.setAppRunMode(1);
            } else {
                AppProperty.m_properties.put("USER_ID", AppLogIn.this.m_txtUser.getText().trim());
                AppProperty.m_properties.put("LOGIN_ENCRYPT", AppLogIn.this.cbUseToolBar.isSelected());
                AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
                AppGlobal.g_frmMain.setAppRunMode(2);
                AppGlobal.g_lockOut = new AppLockOut();
                AppGlobal.g_lockOut.start();
                AppGlobal.g_bIsLockOut = false;
            }
            AppLogIn.this.m_login = null;
            AppSelect.setInitializeList();
            AppLogIn.this.closeDialog();
        }
    }
}

