/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppControl;
import com.sec.osdm.main.utils.AppFileRequest;
import com.sec.osdm.main.utils.AppFileUpload;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AppFileControl
extends JDialog
implements ActionListener {
    public JTabbedPane m_tabMain = new JTabbedPane();
    private JPanel m_panStorage = new JPanel();
    private JPanel m_panProgram = new JPanel();
    public AppControl m_comm = new AppControl();
    public AppTable m_table1 = null;
    public AppTable m_table2 = null;
    public AppTableModel m_model1 = null;
    public AppTableModel m_model2 = null;
    private ArrayList m_component1 = new ArrayList();
    private ArrayList m_component2 = new ArrayList();
    private AppTextBox m_compText = null;
    private JRadioButton m_compRadio = null;
    private JCheckBox m_compCheck = null;
    private String[][] m_corner1 = new String[][]{{"No", "Type"}};
    private String[][] m_colTitle1 = new String[][]{{"File Name", "Size", "Date", "Boot", "Select"}};
    private String[][] m_rowTitle1 = new String[][]{new String[0]};
    private String[][] m_corner2 = new String[][]{{""}};
    private String[][] m_colTitle2 = new String[][]{{"File Name", "Size(byte(s))", "Modified Date", "Name", "Version", "Date", "Result"}};
    private String[][] m_rowTitle2 = new String[][]{new String[0]};
    private JButton[] m_buttons = new JButton[6];
    private JLabel m_lbSystem = new JLabel("", 0);
    private JProgressBar m_used = new JProgressBar(0, 100);
    public byte[] m_recvData = null;
    public Hashtable m_fileList = new Hashtable();
    public ArrayList m_upList = new ArrayList();
    private AppLayout m_lmStorage = new AppLayout(this.m_panStorage, 685, 470);
    private AppLayout m_lmProgram = new AppLayout(this.m_panProgram, 685, 470);
    public boolean m_useSlave = false;
    public boolean m_oldVersion = false;
    public boolean m_iniChange = false;
    private String m_ftpPath = "";
    private String m_ftpID = "";
    private String m_ftpPassword = "";
    private String m_systemName = "";

    public AppFileControl() {
        this.m_comm.setSystemName("");
        new AppFileRequest("Request", this).start();
    }

    public String getSystemName() {
        return this.m_systemName;
    }

    public void setSystemName(String systemName) {
        this.m_systemName = systemName;
        this.m_comm.setSystemName(systemName);
    }

    public String getFtpPath() {
        this.m_ftpPath = this.getSystemName().equals("OS7200") || this.getSystemName().equals("OS7400") ? "/card/dm/" : "/mnt/mmc/dm/";
        return this.m_ftpPath;
    }

    public String getFtpID() {
        this.m_ftpID = this.getSystemName().equals("OS7200") || this.getSystemName().equals("OS7400") ? "kpsw" : (this.getSystemName().equals("OS7200S") ? "admin" : "admin");
        return this.m_ftpID;
    }

    public String getFtpPassword() {
        this.m_ftpPassword = this.getSystemName().equals("OS7200") || this.getSystemName().equals("OS7400") ? "kpsw4321" : (this.getSystemName().equals("OS7200S") ? "samsung" : "samsung");
        return this.m_ftpPassword;
    }

    public void createComponents() {
        this.createStorageComponents();
        this.createProgramComponents();
        this.m_tabMain.add(AppLang.getText("Storage"), this.m_panStorage);
        this.m_tabMain.add(AppLang.getText("Program"), this.m_panProgram);
        this.setWindow();
    }

    private void createStorageComponents() {
        String[] btTitle = new String[]{"Restart", "Cancel", "Delete", "Change INI", "Refresh", "Update(Slave)"};
        String[] btCommand = new String[]{"Restart", "Cancel", "Delete", "Change", "Refresh", "Update"};
        JLabel lbSystem = new JLabel(AppLang.getText("System"), 4);
        JLabel lbUsed = new JLabel(AppLang.getText("Used"), 4);
        int i2 = 0;
        while (i2 < this.m_buttons.length) {
            this.m_buttons[i2] = new JButton(AppLang.getText(btTitle[i2]));
            this.m_buttons[i2].setActionCommand(btCommand[i2]);
            this.m_buttons[i2].addActionListener(this);
            ++i2;
        }
        if (!this.m_useSlave) {
            this.m_buttons[5].setEnabled(false);
        }
        this.m_lbSystem.setBorder(new LineBorder(Color.darkGray));
        this.m_used.setBorder(new LineBorder(Color.darkGray));
        this.m_used.setStringPainted(true);
        this.m_lmStorage.addComponent(lbSystem, 15, 15, 60, 20);
        this.m_lmStorage.addComponent(this.m_lbSystem, 80, 15, 140, 20);
        this.m_lmStorage.addComponent(lbUsed, 220, 15, 90, 20);
        this.m_lmStorage.addComponent(this.m_used, 315, 15, 220, 20);
        this.m_lmStorage.addComponent(this.m_buttons[0], 540, 15, 105, 20);
        this.m_lmStorage.addComponent(this.m_buttons[1], 650, 15, 80, 20);
        this.m_lmStorage.addComponent(this.m_buttons[2], 125, 442, 100, 20);
        this.m_lmStorage.addComponent(this.m_buttons[3], 245, 442, 120, 20);
        this.m_lmStorage.addComponent(this.m_buttons[4], 385, 442, 100, 20);
        this.m_lmStorage.addComponent(this.m_buttons[5], 505, 442, 200, 20);
        this.setStorageComponents();
    }

    private void createProgramComponents() {
        JButton btnFile = new JButton(AppLang.getText("File"));
        JButton btnUpload = new JButton(AppLang.getText("Upload"));
        btnFile.setActionCommand("File");
        btnFile.addActionListener(this);
        btnUpload.setActionCommand("Upload");
        btnUpload.addActionListener(this);
        this.m_lmProgram.addComponent(btnFile, 10, 15, 90, 20);
        this.m_lmProgram.addComponent(btnUpload, 621, 15, 100, 20);
        this.setProgramComponents();
    }

    public void setStorageComponents() {
        ArrayList recvData = new ArrayList();
        ArrayList fileData = new ArrayList();
        ArrayList compData = null;
        int cnt = 0;
        this.m_component1.clear();
        Vector vtTemp = new Vector(this.m_fileList.keySet());
        Collections.sort(vtTemp);
        for (String key : vtTemp) {
            recvData = (ArrayList)this.m_fileList.get(key);
            int i2 = 0;
            while (i2 < recvData.size()) {
                fileData = (ArrayList)recvData.get(i2);
                compData = new ArrayList();
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText(key);
                compData.add(0, this.m_compText);
                int j2 = 0;
                while (j2 < 3) {
                    this.m_compText = new AppTextBox(0, 0);
                    this.m_compText.setText((String)fileData.get(j2));
                    compData.add(j2 + 1, this.m_compText);
                    ++j2;
                }
                this.m_compRadio = ((String)fileData.get(3)).equals("1") ? new JRadioButton("", true) : new JRadioButton("");
                this.m_compRadio.setActionCommand("" + cnt);
                this.m_compRadio.addActionListener(new BootListener());
                this.m_compRadio.setHorizontalAlignment(0);
                compData.add(4, this.m_compRadio);
                this.m_compCheck = new JCheckBox();
                this.m_compCheck.setHorizontalAlignment(0);
                compData.add(5, this.m_compCheck);
                this.m_component1.add(cnt, compData);
                ++cnt;
                ++i2;
            }
        }
        this.m_rowTitle1 = new String[this.m_component1.size()][2];
        int i3 = 0;
        while (i3 < this.m_rowTitle1.length) {
            this.m_rowTitle1[i3][0] = "" + (i3 + 1);
            compData = (ArrayList)this.m_component1.get(i3);
            this.m_rowTitle1[i3][1] = ((AppTextBox)compData.get(0)).getText().trim();
            ++i3;
        }
        this.setStorageInfo();
        this.createStorageTable();
    }

    private void setStorageInfo() {
        if (this.m_recvData != null && this.m_recvData.length >= 28) {
            String memory = "";
            this.m_lbSystem.setText(AppFunctions.byte2str(this.m_recvData, 16, 11));
            float total = (float)AppFunctions.byte2int(this.m_recvData, 8) / 1048576.0f;
            float used = (float)AppFunctions.byte2int(this.m_recvData, 12) / 1048576.0f;
            memory = String.valueOf(String.format("%.2f", Float.valueOf(used))) + "MB / " + String.format("%.2f", Float.valueOf(total)) + "MB (";
            memory = String.valueOf(memory) + String.format("%.2f", Float.valueOf(used / total * 100.0f)) + "%)";
            this.m_used.setValue((int)(used / total * 100.0f));
            this.m_used.setString(memory);
            if (this.m_recvData[27] == 0) {
                this.m_buttons[0].setEnabled(false);
            }
        }
    }

    private void setProgramComponents() {
        ArrayList recvData = new ArrayList();
        ArrayList<AppTextBox> compData = null;
        DecimalFormat df2 = new DecimalFormat("#,###");
        this.m_component2.clear();
        int i2 = 0;
        while (i2 < this.m_upList.size()) {
            recvData = (ArrayList)this.m_upList.get(i2);
            compData = new ArrayList<AppTextBox>();
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)recvData.get(0));
            compData.add(0, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText(df2.format((Integer)recvData.get(7)));
            compData.add(1, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)recvData.get(2));
            compData.add(2, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)recvData.get(4));
            compData.add(3, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)recvData.get(5));
            compData.add(4, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)recvData.get(6));
            compData.add(5, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            compData.add(6, this.m_compText);
            this.m_component2.add(i2, compData);
            ++i2;
        }
        this.m_rowTitle2 = new String[this.m_component2.size()][1];
        this.createProgramTable();
    }

    private void createStorageTable() {
        if (this.m_table1 != null) {
            this.m_panStorage.remove(this.m_table1);
            this.m_model1 = null;
            this.m_table1 = null;
        }
        this.m_model1 = new AppTableModel(this.m_rowTitle1, this.m_colTitle1, this.m_corner1){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppFileControl.this.m_component1.get(row);
                if (col == 3) {
                    String fileName = ((AppTextBox)this.getValueAt(row, 0)).getText().toUpperCase();
                    if (!fileName.endsWith(".PKG") && !fileName.endsWith(".PGM")) {
                        return null;
                    }
                    return (JRadioButton)compData.get(col + 1);
                }
                if (col == 4) {
                    return (JCheckBox)compData.get(col + 1);
                }
                return (AppTextBox)compData.get(col + 1);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3 || col == 4;
            }
        };
        this.m_model1.setRowWidth(new int[]{50, 60});
        this.m_model1.setColWidth(new int[]{140, 120, 150, 60, 60});
        int cnt = 1;
        int i2 = 1;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            if (((String)this.m_model1.getRowHdrName(i2 - 1, 1)).equals((String)this.m_model1.getRowHdrName(i2, 1))) {
                ++cnt;
            } else {
                this.m_model1.setRowHeaderRowSpan(i2 - cnt, 1, cnt);
                cnt = 1;
            }
            ++i2;
        }
        if (cnt > 1) {
            this.m_model1.setRowHeaderRowSpan(this.m_model1.getRowHdrRowCount() - cnt, 1, cnt);
        }
        this.m_table1 = new AppTable(this.m_model1, 2);
        this.m_lmStorage.addComponent(this.m_table1, 10, 40, 722, 400);
    }

    private void createProgramTable() {
        if (this.m_table2 != null) {
            this.m_panProgram.remove(this.m_table2);
            this.m_model2 = null;
            this.m_table2 = null;
        }
        this.m_model2 = new AppTableModel(this.m_rowTitle2, this.m_colTitle2, this.m_corner2){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppFileControl.this.m_component2.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model2.setRowWidth(new int[1]);
        this.m_model2.setColWidth(new int[]{110, 80, 130, 130, 60, 60, 90});
        this.m_model2.setRowHeaderHidden();
        this.m_table2 = new AppTable(this.m_model2, 2);
        this.m_lmProgram.addComponent(this.m_table2, 2, 40, 722, 425);
    }

    private void setWindow() {
        AppGlobal.g_dialogList.add(AppGlobal.g_dialogList.size(), this);
        this.setTitle(AppLang.getText("File Control"));
        this.setModal(true);
        this.setIconImage(AppImages.Img_Logo);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppFileControl.this.closeDialog();
            }
        });
        this.add(this.m_tabMain);
        this.setSize(755, 530);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
        this.setVisible(true);
    }

    public void closeDialog() {
        this.m_comm.disconnect();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Restart")) {
            if (AppGlobal.showConfirmMessage(AppLang.getText("Restart"), AppLang.getText("Do you want to restart system?")) == 0) {
                this.requestSystemRestart();
            }
        } else if (command.equals("Cancel")) {
            this.closeDialog();
        } else if (command.equals("File")) {
            this.openUploadFile();
        } else if (command.equals("Upload")) {
            new AppFileUpload(this).start();
        } else {
            this.requestFileControl(command);
        }
    }

    public void requestSystemRestart() {
        byte[] reqData = null;
        reqData = this.m_comm.makeMsgHeader((byte)39, (byte)-1, (byte)-1, (short)0, (byte)-1, (byte)-17);
        this.m_comm.requestFileControl(reqData, 0);
        this.closeDialog();
        if (AppRunInfo.getRunMode() == 2) {
            AppMenuActions.s_actDisconnect.actionPerformed(null);
        }
    }

    public void requestFileControl(String mode) {
        new AppFileRequest(mode, this).start();
    }

    private void openUploadFile() {
        JFileChooser jfc = new JFileChooser((String)AppProperty.m_properties.get("USER_DIR"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(AppLang.getText("Program Files")) + "(*.pgm;*.zpg;*.pkg;*.pre;*.inf;*.tar;*.tgz;*.jar;*.html;*.jpg;*.jnlp;*.exe;*.pem)", "pgm", "zpg", "pkg", "pre", "inf", "tar", "tgz", "jar", "html", "jpg", "jnlp", "exe", "pem");
        jfc.setFileFilter(filter);
        jfc.setMultiSelectionEnabled(true);
        this.m_upList.clear();
        int yn = jfc.showOpenDialog(null);
        if (yn == 0) {
            AppProperty.m_properties.put("USER_DIR", jfc.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            ArrayList<Object> upList = null;
            byte[] fileData = null;
            SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            File[] files = jfc.getSelectedFiles();
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].exists()) {
                    String file = files[i2].getAbsolutePath().toLowerCase();
                    if (this.checkFileUsed(files[i2].getName())) {
                        upList = new ArrayList<Object>();
                        upList.add(0, files[i2].getName());
                        upList.add(1, files[i2].getAbsolutePath());
                        Date today = new Date(files[i2].lastModified());
                        upList.add(2, simpleDate.format(today));
                        fileData = new byte[(int)files[i2].length()];
                        byte[] readData = new byte[1024];
                        int nOffset = 0;
                        try {
                            int len;
                            DataInputStream in = new DataInputStream(new FileInputStream(files[i2].getAbsolutePath()));
                            while ((len = in.read(readData)) > 0) {
                                System.arraycopy(readData, 0, fileData, nOffset, len);
                                nOffset += len;
                            }
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        upList.add(3, fileData);
                        if (file.endsWith(".pgm") || file.endsWith(".zpg") || file.endsWith(".pkg") || file.endsWith(".pre") || file.endsWith(".inf") || file.endsWith(".tar")) {
                            upList.add(4, AppFunctions.byte2str(fileData, 0, 16));
                            upList.add(5, AppFunctions.byte2str(fileData, 16, 16));
                            upList.add(6, AppFunctions.byte2str(fileData, 32, 16));
                            upList.add(7, (int)files[i2].length());
                            upList.add(8, fileData[64]);
                            upList.add(9, fileData[65]);
                        } else {
                            upList.add(4, "");
                            upList.add(5, "");
                            upList.add(6, "");
                            upList.add(7, (int)files[i2].length());
                            upList.add(8, "");
                            upList.add(9, "");
                        }
                        this.m_upList.add(this.m_upList.size(), upList);
                    }
                }
                ++i2;
            }
            this.setProgramComponents();
        }
    }

    private boolean checkFileUsed(String file) {
        String fileName = "";
        int i2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            fileName = ((AppTextBox)this.m_model1.getValueAt(i2, 0)).getText().trim();
            if (file.toUpperCase().equals(fileName.toUpperCase())) {
                if (file.toUpperCase().contains(".JNLP")) {
                    AppGlobal.showInfoMessage("", "[" + file + "] " + AppLang.getText("file cannot upload, because it is duplicated."));
                    return false;
                }
                if (AppGlobal.showConfirmMessage(AppLang.getText("Overwrite"), "[" + file + "] " + AppLang.getText("file is duplicated.") + "\n" + AppLang.getText("Do you want to overwrite?")) == 1) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public byte getSubId(String name) {
        if ((name = name.toUpperCase()).startsWith("MCP") || name.startsWith("OS1") || name.startsWith("MPP") || name.startsWith("MPE") || name.startsWith("MP") || name.startsWith("STA")) {
            return 0;
        }
        if (name.startsWith("LAN")) {
            return 1;
        }
        if (name.startsWith("SCP") || name.startsWith("SP1") || name.startsWith("SPP") || name.startsWith("LPP") || name.startsWith("LP4") || name.startsWith("SP")) {
            return 2;
        }
        if (name.startsWith("PRI") || name.startsWith("PR2")) {
            return 3;
        }
        if (name.startsWith("DAT")) {
            return 17;
        }
        if (name.startsWith("CS")) {
            return 33;
        }
        if (name.startsWith("MS")) {
            return 34;
        }
        if (name.startsWith("RD")) {
            return 35;
        }
        if (name.startsWith("AP")) {
            return 36;
        }
        if (name.startsWith("DR")) {
            return 37;
        }
        if (name.startsWith("WS")) {
            return 38;
        }
        if (name.startsWith("RT")) {
            return 39;
        }
        if (name.startsWith("WL")) {
            return 40;
        }
        if (name.startsWith("VM")) {
            return 41;
        }
        if (name.startsWith("SY")) {
            return 42;
        }
        return 0;
    }

    public String getSubName(byte id) {
        switch (id) {
            case 0: {
                return "MCP";
            }
            case 1: {
                return "LAN";
            }
            case 2: {
                return "SCP";
            }
            case 3: {
                return "PRI";
            }
            case 17: {
                return "MCDB";
            }
            case 18: {
                return "SRAM";
            }
            case 33: {
                return "CS";
            }
            case 34: {
                return "MS";
            }
            case 35: {
                return "RD";
            }
            case 36: {
                return "AP";
            }
            case 37: {
                return "DR";
            }
            case 38: {
                return "WS";
            }
            case 39: {
                return "RT";
            }
            case 40: {
                return "WL";
            }
            case 41: {
                return "VM";
            }
            case 42: {
                return "SY";
            }
        }
        return "";
    }

    class BootListener
    implements ActionListener {
        BootListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int row = Integer.parseInt(e2.getActionCommand());
            String type = (String)AppFileControl.this.m_model1.getRowHdrName(row, 1);
            int i2 = 0;
            while (i2 < AppFileControl.this.m_model1.getRowHdrRowCount()) {
                if (type.equals((String)AppFileControl.this.m_model1.getRowHdrName(i2, 1)) && AppFileControl.this.m_model1.getValueAt(i2, 3) != null) {
                    ((JRadioButton)AppFileControl.this.m_model1.getValueAt(i2, 3)).setSelected(false);
                }
                ++i2;
            }
            ((JRadioButton)AppFileControl.this.m_model1.getValueAt(row, 3)).setSelected(true);
            AppFileControl.this.m_table1.repaint();
        }
    }
}

