/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.common.SecurityUtil;
import com.sec.osdm.main.utils.AppAllUpConfig;
import com.sec.osdm.main.utils.AppAllUpLoad;
import com.sec.osdm.main.utils.AppDialog;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class AppPassword
extends AppDialog
implements KeyListener {
    private final int SIZE_WIDTH = 192;
    private final int SIZE_HEIGHT = 135;
    public static final int MODE_DOWNLOAD = 0;
    public static final int MODE_UPLOAD = 1;
    private String m_password = "";
    private int m_mode = 0;
    private boolean m_result = false;
    private Hashtable m_readData = null;
    private JPasswordField m_txtPwd = new JPasswordField();
    private JPasswordField m_txtConfm = new JPasswordField();
    private JButton m_btOK = new JButton(AppLang.getText("OK"));
    private JButton m_btCancel = new JButton(AppLang.getText("Cancel"));

    public AppPassword(Hashtable readData) {
        this.m_layout = new AppLayout(this.m_contentPane, 192, 135);
        this.m_mode = 0;
        if (readData != null) {
            this.m_mode = 1;
            this.m_readData = readData;
        }
        this.createComponents();
        this.openDialog("Input Password", 192, 135);
        if (this.m_mode != 1) {
            this.setVisible(false);
        }
    }

    private void createComponents() {
        JLabel lbTitle = new JLabel(AppLang.getText("Password"), 4);
        JLabel lbTitle1 = new JLabel(AppLang.getText("Confirm"), 4);
        this.m_btOK.setActionCommand("OK");
        this.m_btCancel.setActionCommand("Cancel");
        this.m_btOK.addActionListener(this);
        this.m_btCancel.addActionListener(this);
        this.m_txtPwd.addKeyListener(this);
        this.m_txtConfm.addKeyListener(this);
        if (this.m_mode == 0) {
            this.m_layout.addComponent(lbTitle, 5, 5, 70, 25);
            this.m_layout.addComponent(this.m_txtPwd, 80, 5, 100, 25);
            this.m_layout.addComponent(lbTitle1, 5, 35, 70, 25);
            this.m_layout.addComponent(this.m_txtConfm, 80, 35, 100, 25);
        } else {
            this.m_layout.addComponent(lbTitle, 5, 25, 70, 25);
            this.m_layout.addComponent(this.m_txtPwd, 80, 25, 100, 25);
        }
        this.m_layout.addComponent(this.m_btOK, 7, 75, 80, 20);
        this.m_layout.addComponent(this.m_btCancel, 98, 75, 80, 20);
    }

    public boolean getResult() {
        return this.m_result;
    }

    public byte[] getPassword() {
        byte[] password = new byte[50];
        try {
            password = SecurityUtil.getCryptoAESByte(this.m_password);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return password;
    }

    public Hashtable getReadData() {
        return this.m_readData;
    }

    public void showDialog() {
        this.setVisible(true);
    }

    @Override
    public void runActionEvent(String command) {
        this.m_result = false;
        if (command.equals("OK")) {
            if (this.m_mode == 0) {
                if (String.valueOf(this.m_txtPwd.getPassword()).trim().equals(String.valueOf(this.m_txtConfm.getPassword()).trim())) {
                    this.m_password = String.valueOf(this.m_txtPwd.getPassword()).trim();
                    this.m_result = true;
                } else {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Confirm password is different."));
                    this.m_txtConfm.setText("");
                    this.m_txtConfm.requestFocus();
                }
            } else {
                String password;
                byte[] pass = (byte[])this.m_readData.get("0001");
                try {
                    password = SecurityUtil.getAESDecodedByte(pass);
                }
                catch (Exception e2) {
                    password = AppFunctions.byte2str(pass, 0, 50);
                }
                if (String.valueOf(this.m_txtPwd.getPassword()).trim().equals(password)) {
                    this.closeDialog();
                    byte[] fileData = (byte[])this.m_readData.get("0000");
                    byte[] sysData = AppRunInfo.getLinkData();
                    if (fileData[0] != sysData[0]) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Different system type between system and file."));
                    } else if (fileData[1] != sysData[1]) {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Different country between system and file."));
                    } else {
                        int i2 = 0;
                        while (i2 < sysData.length) {
                            if (i2 != 20 && i2 != 21 && sysData[i2] != fileData[i2]) {
                                new AppAllUpConfig(this.m_readData);
                                return;
                            }
                            ++i2;
                        }
                        new AppAllUpLoad(this.m_readData);
                    }
                    return;
                }
                JOptionPane.showMessageDialog(null, AppLang.getText("Inputted password is wrong."));
                this.m_txtPwd.setText("");
                this.m_txtPwd.requestFocus();
            }
            if (this.m_result) {
                this.setVisible(false);
            }
        } else if (command.equals("Cancel")) {
            this.setVisible(false);
        } else {
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (e2.getSource() == this.m_txtPwd && e2.getKeyCode() == 10) {
            if (this.m_mode == 0) {
                this.m_txtConfm.requestFocus();
            } else {
                this.m_btOK.doClick();
            }
        } else if (e2.getSource() == this.m_txtConfm && e2.getKeyCode() == 10) {
            this.m_btOK.doClick();
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }
}

