/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.conference;

import com.sec.osdm.common.AppDateTimer;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppRunConference;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppConference;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppPopupMenu;
import com.sec.osdm.pages.conference.PA108CreateConference;
import com.sec.osdm.pages.conference.PA201ViewConferenceHistory;
import com.sec.osdm.pages.conference.PA201ViewConferenceInProgress;
import com.sec.osdm.pages.conference.PA201ViewConferenceList;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class PA101ConferenceSchedule
extends AppPage
implements MouseMotionListener,
ItemListener,
MouseListener {
    private JLabel m_lbWeekly = new JLabel("", 0);
    private JButton[] m_button = new JButton[7];
    private JRadioButton m_rbWork = new JRadioButton(AppLang.getText("Work Day"), true);
    private JRadioButton m_rbAll = new JRadioButton(AppLang.getText("All Day"));
    private JScrollPane m_topPane = new JScrollPane();
    private ArrayList m_cardInfo = new ArrayList();
    private ArrayList m_weekInfo = new ArrayList();
    private ArrayList m_confData = new ArrayList();
    private boolean m_bIsWork = true;
    private int[][] m_chCount = new int[7][96];
    public int m_curWeek = 0;
    public int m_prevCard = 0;
    private int m_prevRow;
    private int m_prevCol;
    private int m_pressCol;
    private int m_pressRow;
    private AppConference m_parent = new AppConference();
    private clearSelectionListener m_listener = new clearSelectionListener();

    public PA101ConferenceSchedule(AppPageInfo pageInfo) {
        AppComm.getInstance().requestDownload(new AppPageInfo("9102"));
        this.setPageInfo(pageInfo);
        this.m_parent.m_pageInfo = pageInfo;
        this.m_parent.m_pageInfo.setDownMsgType((byte)-39);
        this.m_parent.m_pageInfo.setUpMsgType((byte)-11);
        this.m_cardInfo = AppRunConference.getCardInfo();
        this.setComponents();
    }

    public void setComponents() {
        JPanel topPane = new JPanel(new GridLayout(2, 1));
        String[] title = new String[]{"<", "This Week", ">", "Create", "Detail", "History", "In Progress"};
        ButtonGroup bgDay = new ButtonGroup();
        String[] items = new String[this.m_cardInfo.size()];
        int i2 = 0;
        while (i2 < this.m_cardInfo.size()) {
            Hashtable cardInfo = (Hashtable)this.m_cardInfo.get(i2);
            this.m_parent.m_cardPos[0] = (Byte)cardInfo.get("CABINET");
            this.m_parent.m_cardPos[1] = (Byte)cardInfo.get("SLOT");
            items[i2] = String.valueOf(this.m_parent.m_cardPos[0] * 256 + this.m_parent.m_cardPos[1]) + ":" + "C" + (this.m_parent.m_cardPos[0] + 1) + "-S" + (this.m_parent.m_cardPos[1] + 1);
            ++i2;
        }
        this.m_parent.m_compCombo = new AppComboBox(items);
        this.m_parent.m_compCombo.addListener(this);
        i2 = 0;
        while (i2 < this.m_button.length) {
            this.m_button[i2] = new JButton(AppLang.getText(title[i2]));
            this.m_button[i2].setMargin(new Insets(0, 0, 0, 0));
            this.m_button[i2].setActionCommand(title[i2]);
            this.m_button[i2].addActionListener(this);
            ++i2;
        }
        this.m_rbWork.setActionCommand("Work");
        this.m_rbWork.addActionListener(this);
        this.m_rbAll.setActionCommand("All");
        this.m_rbAll.addActionListener(this);
        bgDay.add(this.m_rbWork);
        bgDay.add(this.m_rbAll);
        AppGlobal.fixSize(this.m_parent.m_compCombo.getComponent(), new Dimension(80, 23));
        AppGlobal.fixSize(this.m_button[3], new Dimension(90, 23));
        AppGlobal.fixSize(this.m_button[4], new Dimension(60, 23));
        AppGlobal.fixSize(this.m_button[5], new Dimension(60, 23));
        AppGlobal.fixSize(this.m_button[6], new Dimension(90, 23));
        AppGlobal.fixSize(this.m_button[0], new Dimension(40, 23));
        AppGlobal.fixSize(this.m_button[1], new Dimension(130, 23));
        AppGlobal.fixSize(this.m_button[2], new Dimension(40, 23));
        FlowLayout flowLayout = new FlowLayout();
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel panel1_1 = new JPanel(flowLayout);
        JPanel panel1_2 = new JPanel(flowLayout);
        panel1_1.add(new JLabel("Card "));
        panel1_1.add(this.m_parent.m_compCombo.getComponent());
        panel1_2.add(this.m_button[3]);
        panel1_2.add(this.m_button[4]);
        panel1_2.add(this.m_button[5]);
        panel1_2.add(this.m_button[6]);
        panel1.add((Component)panel1_1, "Before");
        panel1.add((Component)panel1_2, "After");
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel panel2_1 = new JPanel(flowLayout);
        JPanel panel2_2 = new JPanel(flowLayout);
        JPanel panel2_3 = new JPanel(flowLayout);
        panel2_1.add(this.m_button[0]);
        panel2_1.add(this.m_button[1]);
        panel2_1.add(this.m_button[2]);
        panel2_2.add(this.m_lbWeekly);
        panel2_3.add(this.m_rbWork);
        panel2_3.add(this.m_rbAll);
        panel2.add((Component)panel2_1, "Before");
        panel2.add((Component)panel2_2, "Center");
        panel2.add((Component)panel2_3, "After");
        topPane.add(panel1);
        topPane.add(panel2);
        this.m_button[3].setEnabled(false);
        this.m_topPane.getViewport().setView(topPane);
        this.m_topPane.setPreferredSize(new Dimension(800, 75));
        this.m_contentPane.add((Component)this.m_topPane, "North");
        if (this.requestData()) {
            this.m_parent.m_table.getVerticalScrollBar().setMaximum(2000);
            this.m_parent.m_table.getVerticalScrollBar().setValue(615);
        }
    }

    public boolean requestData() {
        byte[] date = null;
        this.m_parent.m_reqList = new ArrayList();
        this.m_parent.m_cardPos[0] = (byte)(this.m_parent.m_compCombo.getSelectedIndex() / 256);
        this.m_parent.m_cardPos[1] = (byte)(this.m_parent.m_compCombo.getSelectedIndex() % 256);
        this.m_confData.clear();
        this.m_weekInfo = AppRunConference.getCurrentWeek(this.m_curWeek);
        int i2 = 0;
        while (i2 < this.m_weekInfo.size()) {
            this.m_parent.m_reqData = new byte[10];
            date = (byte[])this.m_weekInfo.get(i2);
            System.arraycopy(date, 0, this.m_parent.m_reqData, 0, 8);
            System.arraycopy(this.m_parent.m_cardPos, 0, this.m_parent.m_reqData, 8, 2);
            this.m_parent.m_reqList.add(i2, this.m_parent.m_reqData);
            this.m_parent.m_pageInfo.setReqData(this.m_parent.m_reqData);
            if (this.m_parent.readDataFromSystem()) {
                this.m_parent.m_recvData = this.m_parent.m_pageInfo.getRecvData();
                if (this.m_parent.m_recvData != null && this.m_parent.m_recvData.size() > 0) {
                    ArrayList recvData = (ArrayList)this.m_parent.m_recvData.get(0);
                    this.m_confData.add(this.m_confData.size(), recvData);
                }
            } else {
                return false;
            }
            ++i2;
        }
        this.createComponents();
        return true;
    }

    public void createComponents() {
        ArrayList recvData = new ArrayList();
        ArrayList<AppTextBox> compData = null;
        long curTime = AppRunConference.getCurrentTime(this.m_curWeek);
        Date startDay = new Date();
        Date endDay = new Date();
        SimpleDateFormat format = new SimpleDateFormat("");
        if (this.m_bIsWork) {
            startDay.setTime(curTime + 86400000L);
            endDay.setTime(curTime + 432000000L);
        } else {
            startDay.setTime(curTime);
            endDay.setTime(curTime + 518400000L);
        }
        this.m_lbWeekly.setText(String.valueOf(AppRunConference.szDate2LangLocale(startDay, 1)) + " ~ " + AppRunConference.szDate2LangLocale(endDay, 1));
        this.m_lbWeekly.setFont(new Font("SansSerif", 1, 18));
        this.m_parent.m_corner = new String[][]{{AppRunConference.szDate2LangLocale(startDay, 9)}};
        this.m_parent.m_colTitle = new String[1][7];
        int i2 = 0;
        while (i2 < this.m_parent.m_colTitle[0].length) {
            endDay.setTime(curTime + 86400000L * (long)i2);
            this.m_parent.m_colTitle[0][i2] = AppRunConference.szDate2LangLocale(endDay, 10);
            ++i2;
        }
        this.m_parent.m_rowTitle = new String[96][1];
        String[] hour = new String[]{"12", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11"};
        int i3 = 0;
        int k2 = 0;
        int j2 = 48;
        while (i3 < hour.length) {
            this.m_parent.m_rowTitle[k2][0] = "AM" + hour[i3];
            this.m_parent.m_rowTitle[j2][0] = "PM" + hour[i3];
            ++i3;
            k2 += 4;
            j2 += 4;
        }
        i3 = 0;
        while (i3 < this.m_confData.size()) {
            recvData = (ArrayList)this.m_confData.get(i3);
            compData = new ArrayList<AppTextBox>();
            int j3 = 0;
            while (j3 < 96) {
                String sValue = (String)recvData.get(j3);
                sValue = sValue.equals("") ? "0" : sValue;
                this.m_chCount[i3][j3] = AppFunctions.signedValue(Integer.parseInt(sValue));
                this.m_parent.m_compText = new AppTextBox();
                this.m_parent.m_compText.setBackground(this.getCellCorlor(this.m_chCount[i3][j3]));
                this.m_parent.m_compText.setHorizontalAlignment(0);
                this.m_parent.m_compText.getComponent().setEnabled(false);
                compData.add(j3, this.m_parent.m_compText);
                ++j3;
            }
            this.m_parent.m_components.add(i3, compData);
            ++i3;
        }
        this.createTable();
    }

    @Override
    public void createTable() {
        if (this.m_parent.m_table != null) {
            this.m_contentPane.remove(this.m_parent.m_table);
            this.m_parent.m_model = null;
            this.m_parent.m_table = null;
        }
        this.m_parent.m_model = new AppTableModel(this.m_parent.m_rowTitle, this.m_parent.m_colTitle, this.m_parent.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)((PA101ConferenceSchedule)PA101ConferenceSchedule.this).m_parent.m_components.get(col)).get(row);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        this.m_parent.m_model.setRowWidth(new int[]{88});
        int[] colWidth = new int[this.m_parent.m_colTitle[0].length];
        int i2 = 0;
        while (i2 < colWidth.length) {
            colWidth[i2] = 140;
            ++i2;
        }
        this.m_parent.m_model.setColWidth(colWidth);
        i2 = 0;
        while (i2 < this.m_parent.m_model.getRowHdrRowCount()) {
            if (i2 % 4 == 0) {
                this.m_parent.m_model.setRowHeaderRowSpan(i2, 0, 4);
            }
            ++i2;
        }
        this.m_parent.m_table = new AppTable(this.m_parent.m_model, 0);
        this.m_parent.m_popup = new AppPopupMenu();
        this.m_parent.m_popup.addPopupItem(AppLang.getText("Create"), "Create", this);
        this.m_parent.m_popup.addPopupItem(AppLang.getText("Detail"), "Detail", this);
        this.m_parent.m_popup.addPopupItem(AppLang.getText("History"), "History", this);
        this.m_parent.m_popup.addPopupItem(AppLang.getText("In Progress"), "In Progress", this);
        this.m_parent.m_popup.addSeparator();
        this.m_parent.m_popup.addPopupItem(AppLang.getText("Previous"), "<", this);
        this.m_parent.m_popup.addPopupItem(AppLang.getText("Next"), ">", this);
        this.m_parent.m_popup.addPopupItem(AppLang.getText("This Week"), "This Week", this);
        this.m_parent.m_popup.addSeparator();
        this.m_parent.m_popup.addPopupItem(AppLang.getText("Workday"), "Work", this);
        this.m_parent.m_popup.addPopupItem(AppLang.getText("All Day"), "All", this);
        this.m_parent.m_table.getTable().setComponentPopupMenu(this.m_parent.m_popup);
        this.m_parent.m_table.getTable().addMouseListener(this);
        this.m_parent.m_table.getTable().addMouseMotionListener(this);
        if (this.m_bIsWork) {
            Calendar now = Calendar.getInstance();
            this.m_parent.m_table.setColHidden((8 - now.getFirstDayOfWeek()) % 7);
            this.m_parent.m_table.setColHidden((7 - now.getFirstDayOfWeek()) % 7);
        }
        this.m_parent.m_table.addMouseListener(this.m_listener);
        this.m_contentPane.add((Component)this.m_parent.m_table, "Center");
        this.m_table = new AppTable(this.m_parent.m_model);
        this.setPrintableComponent(this.m_table);
    }

    private boolean checkStartTime() {
        long curTime;
        long startTime = AppRunConference.getCurrentTime(this.m_parent.m_startTime);
        return startTime >= (curTime = AppDateTimer.getTimeInMillis());
    }

    private Color getCellCorlor(int chCount) {
        Color col = null;
        switch (chCount) {
            case 0: {
                col = new Color(255, 200, 200);
                break;
            }
            case 1: {
                col = new Color(15, 135, 15);
                break;
            }
            case 2: {
                col = new Color(15, 145, 15);
                break;
            }
            case 3: {
                col = new Color(15, 155, 15);
                break;
            }
            case 4: {
                col = new Color(15, 165, 15);
                break;
            }
            case 5: {
                col = new Color(15, 175, 15);
                break;
            }
            case 6: {
                col = new Color(15, 185, 15);
                break;
            }
            case 7: {
                col = new Color(15, 195, 15);
                break;
            }
            case 8: {
                col = new Color(15, 205, 15);
                break;
            }
            case 9: {
                col = new Color(15, 215, 15);
                break;
            }
            case 10: {
                col = new Color(15, 225, 15);
                break;
            }
            case 11: {
                col = new Color(15, 235, 15);
                break;
            }
            case 12: {
                col = new Color(15, 245, 15);
                break;
            }
            case 13: {
                col = new Color(15, 255, 15);
                break;
            }
            case 14: {
                col = new Color(35, 255, 35);
                break;
            }
            case 15: {
                col = new Color(55, 255, 55);
                break;
            }
            case 16: {
                col = new Color(75, 255, 75);
                break;
            }
            case 17: {
                col = new Color(95, 255, 95);
                break;
            }
            case 18: {
                col = new Color(115, 255, 115);
                break;
            }
            case 19: {
                col = new Color(135, 255, 135);
                break;
            }
            case 20: {
                col = new Color(155, 255, 155);
                break;
            }
            case 21: {
                col = new Color(175, 255, 175);
                break;
            }
            case 22: {
                col = new Color(195, 255, 195);
                break;
            }
            case 23: {
                col = new Color(215, 255, 215);
                break;
            }
            case 24: {
                col = new Color(235, 255, 235);
                break;
            }
            default: {
                col = chCount < 0 ? new Color(255, 55, 55) : new Color(255, 255, 255);
            }
        }
        return col;
    }

    @Override
    public void actionToolButton(String command) {
        if (!command.equals("Reservation")) {
            this.m_button[3].setEnabled(false);
        }
        if (command.equals("Create")) {
            new PA108CreateConference(this.m_parent);
            if (this.requestData()) {
                this.m_button[3].setEnabled(false);
                this.m_parent.m_table.getVerticalScrollBar().setMaximum(2400);
                this.m_parent.m_table.getVerticalScrollBar().setValue(615);
            }
        } else if (command.equals("Detail")) {
            new PA201ViewConferenceList(this.m_parent, this.m_curWeek);
        } else if (command.equals("History")) {
            new PA201ViewConferenceHistory(this.m_parent, this.m_curWeek);
        } else if (command.equals("In Progress")) {
            new PA201ViewConferenceInProgress(this.m_parent, this.m_curWeek);
        } else {
            if (command.equals("<")) {
                --this.m_curWeek;
                if (this.requestData()) {
                    this.m_parent.m_table.getVerticalScrollBar().setMaximum(2000);
                    this.m_parent.m_table.getVerticalScrollBar().setValue(615);
                    if (!this.m_button[2].isEnabled()) {
                        this.m_button[2].setEnabled(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, AppLang.getText("No Data exists for Previous Week."));
                    ++this.m_curWeek;
                    this.m_button[0].setEnabled(false);
                }
                return;
            }
            if (command.equals(">")) {
                ++this.m_curWeek;
                if (this.requestData()) {
                    this.m_parent.m_table.getVerticalScrollBar().setMaximum(2000);
                    this.m_parent.m_table.getVerticalScrollBar().setValue(615);
                    if (!this.m_button[0].isEnabled()) {
                        this.m_button[0].setEnabled(true);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, AppLang.getText("No Data exists for Next Week."));
                    --this.m_curWeek;
                    this.m_button[2].setEnabled(false);
                }
                return;
            }
            if (command.equals("This Week")) {
                this.m_curWeek = 0;
                this.m_button[0].setEnabled(true);
                this.m_button[2].setEnabled(true);
            } else if (command.equals("Work")) {
                if (this.m_bIsWork) {
                    return;
                }
                this.m_bIsWork = true;
            } else if (command.equals("All")) {
                if (!this.m_bIsWork) {
                    return;
                }
                this.m_bIsWork = false;
            }
            if (!command.equals("Close") && !command.equals("Reload")) {
                if (this.requestData()) {
                    this.m_parent.m_table.getVerticalScrollBar().setMaximum(2400);
                    this.m_parent.m_table.getVerticalScrollBar().setValue(615);
                }
            } else if (command.equals("Close") || command.equals("Reload")) {
                this.m_parent.m_table.removeMouseListener(this.m_listener);
            }
        }
        this.actionPageToolButton(command);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            if (!this.requestData()) {
                JOptionPane.showMessageDialog(null, AppLang.getText("No Data exists for This Card."));
                this.m_parent.m_compCombo.setSelectedIndex(this.m_prevCard);
                this.m_parent.m_cardPos[0] = (byte)(this.m_parent.m_compCombo.getSelectedIndex() / 256);
                this.m_parent.m_cardPos[1] = (byte)(this.m_parent.m_compCombo.getSelectedIndex() % 256);
            } else {
                this.m_parent.m_table.getVerticalScrollBar().setMaximum(2400);
                this.m_parent.m_table.getVerticalScrollBar().setValue(700);
                this.m_prevCard = this.m_parent.m_compCombo.getSelectedIndex();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        int i2 = 0;
        while (i2 < this.m_button.length) {
            this.m_parent.m_popup.setPopupMenuEnable(null, this.m_button[i2]);
            ++i2;
        }
        Point p2 = e2.getPoint();
        int row = this.m_parent.m_table.getTable().rowAtPoint(p2);
        int col = this.m_parent.m_table.getTable().columnAtPoint(p2);
        if (this.m_prevRow != row || this.m_prevCol != col) {
            ArrayList compData = (ArrayList)this.m_parent.m_components.get(this.m_prevCol);
            AppTextBox component = (AppTextBox)compData.get(this.m_prevRow);
            component.setText("");
            compData.set(this.m_prevRow, component);
            this.m_parent.m_components.set(this.m_prevCol, compData);
            compData = (ArrayList)this.m_parent.m_components.get(col);
            component = (AppTextBox)compData.get(row);
            component.setText("" + this.m_chCount[col][row]);
            compData.set(row, component);
            this.m_parent.m_components.set(col, compData);
            this.m_parent.m_table.repaint();
            this.m_prevRow = row;
            this.m_prevCol = col;
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int i2 = 0;
        while (i2 < this.m_button.length) {
            this.m_parent.m_popup.setPopupMenuEnable(null, this.m_button[i2]);
            ++i2;
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
        ArrayList compData = (ArrayList)this.m_parent.m_components.get(this.m_prevCol);
        AppTextBox component = (AppTextBox)compData.get(this.m_prevRow);
        component.setText("");
        compData.set(this.m_prevRow, component);
        this.m_parent.m_components.set(this.m_prevCol, compData);
        this.m_parent.m_table.repaint();
        this.m_prevRow = 0;
        this.m_prevCol = 0;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.m_pressCol = this.m_parent.m_table.getTable().columnAtPoint(me.getPoint());
        this.m_pressRow = this.m_parent.m_table.getTable().rowAtPoint(me.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int col = this.m_parent.m_table.getTable().columnAtPoint(me.getPoint());
        int row = this.m_parent.m_table.getTable().rowAtPoint(me.getPoint());
        if (this.m_pressCol != col) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Reservation Time has to be on the Day."));
            this.m_button[3].setEnabled(false);
            return;
        }
        this.m_parent.m_startTime = (byte[])this.m_weekInfo.get(col);
        this.m_parent.m_startTime[0] = 0;
        if (this.m_pressRow <= row) {
            this.m_parent.m_startTime[1] = (byte)(this.m_pressRow % 4 * 15);
            this.m_parent.m_startTime[2] = (byte)(this.m_pressRow / 4);
        } else {
            this.m_parent.m_startTime[1] = (byte)(row % 4 * 15);
            this.m_parent.m_startTime[2] = (byte)(row / 4);
        }
        this.m_button[3].setEnabled(this.checkStartTime());
    }

    class clearSelectionListener
    extends MouseAdapter {
        clearSelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (((PA101ConferenceSchedule)PA101ConferenceSchedule.this).m_parent.m_table != null) {
                ((PA101ConferenceSchedule)PA101ConferenceSchedule.this).m_parent.m_table.editingStopped(null);
                ((PA101ConferenceSchedule)PA101ConferenceSchedule.this).m_parent.m_table.getTable().clearSelection();
                ((PA101ConferenceSchedule)PA101ConferenceSchedule.this).m_parent.m_table.getTable().setFocusable(false);
                PA101ConferenceSchedule.this.m_button[3].setEnabled(false);
                ((PA101ConferenceSchedule)PA101ConferenceSchedule.this).m_parent.m_table.repaint();
            }
        }
    }
}

