/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import java.awt.Dimension;

public class SpanInfo {
    public static final int INDEX_ROW = 0;
    public static final int INDEX_COLUMN = 1;
    private int m_nRowSize;
    private int m_nColumnSize;
    private int[][][] m_arrSpan;

    public SpanInfo(int nRowSize, int nColumnSize) {
        this.m_nRowSize = nRowSize;
        this.m_nColumnSize = nColumnSize;
        this.initArrSpan();
    }

    public void initArrSpan() {
        this.m_arrSpan = new int[this.m_nRowSize][this.m_nColumnSize][2];
        int i2 = 0;
        while (i2 < this.m_nRowSize) {
            int j2 = 0;
            while (j2 < this.m_nColumnSize) {
                this.m_arrSpan[i2][j2][0] = 1;
                this.m_arrSpan[i2][j2][1] = 1;
                ++j2;
            }
            ++i2;
        }
    }

    public int[] getSpan(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            int[] ret_code = new int[]{1, 1};
            return ret_code;
        }
        return this.m_arrSpan[row][column];
    }

    public void setSpan(int[] span, int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return;
        }
        this.m_arrSpan[row][column] = span;
    }

    public void combine(int[] rows, int[] columns) {
        if (this.isOutOfBounds(rows, columns)) {
            return;
        }
        int rowSpan = rows.length;
        int columnSpan = columns.length;
        int startRow = rows[0];
        int startColumn = columns[0];
        int i2 = 0;
        while (i2 < rowSpan) {
            int j2 = 0;
            while (j2 < columnSpan) {
                if (this.m_arrSpan[startRow + i2][startColumn + j2][1] != 1 || this.m_arrSpan[startRow + i2][startColumn + j2][0] != 1) {
                    return;
                }
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        int ii = 0;
        while (i2 < rowSpan) {
            int j3 = 0;
            int jj = 0;
            while (j3 < columnSpan) {
                this.m_arrSpan[startRow + i2][startColumn + j3][1] = jj--;
                this.m_arrSpan[startRow + i2][startColumn + j3][0] = ii;
                ++j3;
            }
            ++i2;
            --ii;
        }
        this.m_arrSpan[startRow][startColumn][1] = columnSpan;
        this.m_arrSpan[startRow][startColumn][0] = rowSpan;
    }

    public boolean isVisible(int row, int column) {
        if (this.isOutOfBounds(row, column)) {
            return false;
        }
        return this.m_arrSpan[row][column][1] >= 1 && this.m_arrSpan[row][column][0] >= 1;
    }

    public void setColSpan(int row, int col, int spanNum) {
        int[] arrCol = new int[spanNum];
        int i2 = 0;
        while (i2 < spanNum) {
            arrCol[i2] = col + i2;
            ++i2;
        }
        this.combine(new int[]{row}, arrCol);
    }

    public void setRowSpan(int row, int col, int spanNum) {
        int[] arrRow = new int[spanNum];
        int i2 = 0;
        while (i2 < spanNum) {
            arrRow[i2] = row + i2;
            ++i2;
        }
        this.combine(arrRow, new int[]{col});
    }

    public void insertRow(int row) {
        int[][][] oldSpan = this.m_arrSpan;
        int numRows = oldSpan.length;
        int numColumns = oldSpan[0].length;
        this.m_arrSpan = new int[numRows + 1][numColumns][2];
        if (row > 0) {
            System.arraycopy(oldSpan, 0, this.m_arrSpan, 0, row - 1);
        }
        System.arraycopy(oldSpan, 0, this.m_arrSpan, row, numRows - row);
        int i2 = 0;
        while (i2 < numColumns) {
            this.m_arrSpan[row][i2][1] = 1;
            this.m_arrSpan[row][i2][0] = 1;
            ++i2;
        }
    }

    public Dimension getSize() {
        return new Dimension(this.m_nRowSize, this.m_nColumnSize);
    }

    private boolean isOutOfBounds(int row, int column) {
        return row < 0 || this.m_nRowSize <= row || column < 0 || this.m_nColumnSize <= column;
    }

    private boolean isOutOfBounds(int[] rows, int[] columns) {
        int i2 = 0;
        while (i2 < rows.length) {
            if (rows[i2] < 0 || this.m_nRowSize <= rows[i2]) {
                return true;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < columns.length) {
            if (columns[i2] < 0 || this.m_nColumnSize <= columns[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

