/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppPageMessage;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.AppDeleteDlg;
import com.sec.osdm.pages.vmaa.P2000ScheduleTableDetailDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class P2000ScheduleTable
extends AppPage {
    private String[][] m_rowName = null;
    private String[][] m_colName = null;
    private JCheckBox[] m_chkDel = null;
    private JLabel[] m_tfNo = null;
    private AppTextBox[] m_tfModName = null;
    private AppTextBox[] m_tfPort = null;
    private AppTextBox[] m_tfDayWeek = null;
    private AppTextBox[] m_tfStart = null;
    private String m_refMsgId = "1034";
    private AppRequestInfo[] m_reqInfo = new AppRequestInfo[2];
    private JPanel m_topPan = new JPanel(new BorderLayout());
    private TableListener m_tableListener = new TableListener();
    public static HashMap<String, String> m_mode1 = new HashMap();
    public static HashMap<String, String> m_mode2 = new HashMap();
    public static HashMap<String, String> m_day_week = new HashMap();

    public P2000ScheduleTable(AppPageInfo pageInfo) {
        m_day_week.put("1", "SUN");
        m_day_week.put("2", "MON");
        m_day_week.put("3", "TUE");
        m_day_week.put("4", "WED");
        m_day_week.put("5", "THU");
        m_day_week.put("6", "FRI");
        m_day_week.put("7", "SAT");
        this.setPageInfo(pageInfo);
        this.setInit();
        this.requestData();
        this.createTable();
    }

    private void setInit() {
        JButton m_btnAdd = new JButton(AppLang.getText("Add"));
        JButton m_btnDelete = new JButton(AppLang.getText("Delete"));
        m_btnAdd.addActionListener(this);
        m_btnDelete.addActionListener(this);
        m_btnAdd.setActionCommand("Add");
        m_btnDelete.setActionCommand("Delete");
        AppGlobal.fixSize(m_btnAdd, new Dimension(100, 20));
        AppGlobal.fixSize(m_btnDelete, new Dimension(100, 20));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(m_btnAdd);
        buttonPanel.add(m_btnDelete);
        this.m_topPan.add((Component)buttonPanel, "After");
        this.m_jspTop.getViewport().setView(this.m_topPan);
    }

    public void createComponents() {
        this.m_colName = new String[][]{{"Delete", "No.", "Mode Name", "Ports", "Date/Weekday", "Start"}};
        this.m_rowName = new String[this.m_recvData.size()][1];
        int i2 = 0;
        while (i2 < this.m_rowName.length) {
            this.m_rowName[i2][0] = "";
            ++i2;
        }
        this.m_chkDel = new JCheckBox[this.m_recvData.size()];
        this.m_tfNo = new JLabel[this.m_recvData.size()];
        this.m_tfModName = new AppTextBox[this.m_recvData.size()];
        this.m_tfPort = new AppTextBox[this.m_recvData.size()];
        this.m_tfDayWeek = new AppTextBox[this.m_recvData.size()];
        this.m_tfStart = new AppTextBox[this.m_recvData.size()];
        i2 = 0;
        while (i2 < this.m_recvData.size()) {
            this.m_chkDel[i2] = new JCheckBox();
            this.m_tfNo[i2] = new JLabel("" + (i2 + 1));
            this.m_tfModName[i2] = new AppTextBox();
            this.m_tfPort[i2] = new AppTextBox();
            this.m_tfDayWeek[i2] = new AppTextBox();
            this.m_tfStart[i2] = new AppTextBox();
            this.m_chkDel[i2].setHorizontalAlignment(0);
            this.m_tfNo[i2].setHorizontalAlignment(0);
            ArrayList alData = (ArrayList)this.m_recvData.get(i2);
            this.m_tfModName[i2].setText(m_mode2.get((String)alData.get(0)));
            if (alData.get(1).equals("0") && alData.get(2).equals("0")) {
                this.m_tfPort[i2].setText("ALL");
            } else {
                this.m_tfPort[i2].setText(alData.get(1) + "-" + alData.get(2));
            }
            if (alData.get(3).equals("0") && alData.get(4).equals("0")) {
                this.m_tfDayWeek[i2].setText(String.valueOf(m_day_week.get(alData.get(5))) + "-" + m_day_week.get(alData.get(6)));
            } else {
                String tmpstr = String.format("%02d - %02d", Integer.parseInt((String)alData.get(3)), Integer.parseInt((String)alData.get(4)));
                this.m_tfDayWeek[i2].setText(tmpstr);
            }
            this.m_tfStart[i2].setText(String.valueOf(String.format("%02d", Integer.parseInt((String)alData.get(7)))) + " : " + String.format("%02d", Integer.parseInt((String)alData.get(8))));
            ++i2;
        }
    }

    @Override
    public void createTable() {
        this.m_model = new AppTableModel(this.m_rowName, this.m_colName, ""){

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return P2000ScheduleTable.this.m_chkDel[row];
                    }
                    case 1: {
                        return P2000ScheduleTable.this.m_tfNo[row];
                    }
                    case 2: {
                        return P2000ScheduleTable.this.m_tfModName[row];
                    }
                    case 3: {
                        return P2000ScheduleTable.this.m_tfPort[row];
                    }
                    case 4: {
                        return P2000ScheduleTable.this.m_tfDayWeek[row];
                    }
                    case 5: {
                        return P2000ScheduleTable.this.m_tfStart[row];
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.m_model.setRowHeaderHidden();
        this.m_model.setColWidth(new int[]{80, 50, 120, 80, 150, 100, 80});
        this.m_table = new AppTable(this.m_model);
        this.setPrintableComponent(this.m_table);
        this.m_table.getTable().addMouseListener(this.m_tableListener);
        this.m_jspTop.setVisible(true);
        this.m_contentPane.add((Component)this.m_table, "Center");
    }

    private void requestData() {
        try {
            this.m_reqInfo[0] = new AppRequestInfo(this.m_refMsgId);
            this.m_reqInfo[0].setDownMsgType((byte)-48);
            this.m_reqInfo[0].setReqData(new byte[1]);
            this.m_reqInfo[0].setResult(AppComm.getInstance().requestDownload(this.m_reqInfo[0].getPageInfo()));
            this.m_reqInfo[1] = new AppRequestInfo(this.m_tnInfo.getMsgId());
            this.m_reqInfo[1].setDownMsgType((byte)-48);
            this.m_reqInfo[1].setReqData(new byte[1]);
            this.m_reqInfo[1].setResult(AppComm.getInstance().requestDownload(this.m_reqInfo[1].getPageInfo()));
            this.m_recvData = this.m_reqInfo[1].getRecvData();
            m_mode1.clear();
            m_mode2.clear();
            int i2 = 0;
            while (i2 < this.m_reqInfo[0].getRecvData().size()) {
                ArrayList al_data = (ArrayList)this.m_reqInfo[0].getRecvData().get(i2);
                m_mode1.put((String)al_data.get(2), (String)al_data.get(1));
                m_mode2.put((String)al_data.get(1), (String)al_data.get(2));
                ++i2;
            }
            m_mode1.put("SYSTEM_AUTO", "");
            m_mode2.put("", "SYSTEM_AUTO");
            this.createComponents();
            if (this.m_table != null) {
                this.m_model.setRowHeaderNames(this.m_rowName);
                this.m_table.tableChanged(null);
                this.setMouseListener();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Add")) {
            try {
                int rowCount = this.m_table.getTable().getRowCount();
                new P2000ScheduleTableDetailDlg(this.m_recvData, rowCount + 1, false);
                this.requestData();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (command.equals("Delete")) {
            ArrayList chkTrue = new ArrayList();
            ArrayList chkFalse = new ArrayList();
            int i2 = 0;
            while (i2 < this.m_recvData.size()) {
                Object obj = this.m_model.getValueAt(i2, 0);
                if (obj instanceof JCheckBox && ((JCheckBox)obj).isSelected()) {
                    chkTrue.add(this.m_recvData.get(i2));
                } else {
                    chkFalse.add(this.m_recvData.get(i2));
                }
                ++i2;
            }
            if (chkTrue.size() > 0) {
                try {
                    new AppDeleteDlg(chkTrue, chkFalse);
                    this.requestData();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(null, AppPageMessage.getErrorMsg(6));
            }
        } else {
            this.actionPageToolButton(command);
        }
    }

    public void setMouseListener() {
        this.m_table.getTable().removeMouseListener(this.m_tableListener);
        this.m_table.getTable().addMouseListener(this.m_tableListener);
    }

    @Override
    public void createPage() {
    }

    private class TableListener
    extends MouseAdapter {
        private TableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() >= 2 && P2000ScheduleTable.this.m_table.getTable().getSelectedColumn() == 2 && P2000ScheduleTable.this.m_recvData != null) {
                int rowIdx = P2000ScheduleTable.this.m_table.getTable().getSelectedRow();
                try {
                    new P2000ScheduleTableDetailDlg(P2000ScheduleTable.this.m_recvData, rowIdx + 1, true);
                    P2000ScheduleTable.this.requestData();
                }
                catch (Exception ec2) {
                    ec2.printStackTrace();
                }
            }
        }
    }
}

