/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa.openblock;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.openblock.AppBlockListDetailDlg;
import com.sec.osdm.pages.vmaa.openblock.AppNewBlockDlg;
import com.sec.osdm.pages.vmaa.openblock.P1015EClassBlock;
import com.sec.osdm.pages.vmaa.openblock.P101AExtensionBlock;
import com.sec.osdm.pages.vmaa.openblock.P1021FaxBlock;
import com.sec.osdm.pages.vmaa.openblock.P1024ListBlock;
import com.sec.osdm.pages.vmaa.openblock.P1028MailboxBlock;
import com.sec.osdm.pages.vmaa.openblock.P102EMClassBlock;
import com.sec.osdm.pages.vmaa.openblock.P1038NetworkBlock;
import com.sec.osdm.pages.vmaa.openblock.P1046StationBlock;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppPopUpBlockList
extends JDialog
implements ActionListener {
    private int m_type = 0;
    private byte m_listType = (byte)10;
    private JButton m_btnClose = new JButton(AppLang.getText("Close"));
    private JButton m_btnNew = new JButton(AppLang.getText("New"));
    private JButton m_btnRelod = new JButton(AppLang.getText("Reload"));
    private String m_titleNames = "";
    public AppPopUpBlockList m_thisObject = null;
    private PopupBlockListTableListener m_tableListener = new PopupBlockListTableListener();
    private String[] m_serial = null;
    private JButton[] m_btnEdit = null;
    private AppTextBox[] m_tfLabel = null;
    private JLabel[] m_lbNumber = null;
    private AppTable m_table1 = null;
    private AppTableModel m_model = null;
    private String[][] m_RowNames = null;
    private String[][] m_ColNames = new String[][]{{"No.", "Label Name", "Edit"}};
    private AppTable m_table2 = null;
    private AppTable m_table3 = null;
    private String m_blockSerial = "";
    private String m_blockLabelName = "";
    private ArrayList m_recvData = new ArrayList();
    private String m_MsgId = "";
    private String m_DetailMsgId = "";
    private JTabbedPane m_tabPan = null;
    private JPanel m_pnVMSGroup = new JPanel(new FlowLayout(0));
    private JComboBox m_comboVMSGroup = null;
    private JLabel m_lbVMSGroup = new JLabel(AppLang.getText(" VMS : "));
    private AppBlockListDetailDlg m_blockPage = null;

    public AppPopUpBlockList(JDialog dialog, int type) {
        super((Dialog)dialog, true);
        AppGlobal.g_dialogList.add(this);
        this.setIconImage(AppImages.Img_Logo);
        this.m_type = type;
        this.setType(type);
        this.m_thisObject = this;
        this.setDialog();
        this.m_pnVMSGroup.add(this.m_lbVMSGroup);
        String[] comboData = new String[99];
        int i2 = 0;
        while (i2 < 99) {
            comboData[i2] = String.format("%02d", i2 + 1);
            ++i2;
        }
        this.m_comboVMSGroup = new JComboBox<String>(comboData);
        this.m_pnVMSGroup.add(this.m_comboVMSGroup);
        this.m_comboVMSGroup.setSelectedIndex(0);
        this.m_comboVMSGroup.setActionCommand("vms_change");
        this.m_comboVMSGroup.addActionListener(this);
        this.getInfo();
        this.createComponent();
        this.createTable();
        JPanel btnPan = new JPanel(new FlowLayout());
        btnPan.add(this.m_btnNew);
        btnPan.add(this.m_btnRelod);
        btnPan.add(this.m_btnClose);
        this.setMouseListener();
        if (this.m_type == 1) {
            this.m_tabPan = new JTabbedPane();
            this.m_tabPan.add((Component)this.m_table1, AppLang.getText("Mailbox"));
            this.m_tabPan.add((Component)this.m_table2, AppLang.getText("List"));
            this.m_tabPan.add((Component)this.m_table3, AppLang.getText("Network Mailbox"));
            this.m_tabPan.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    int tabIdx = AppPopUpBlockList.this.m_tabPan.getSelectedIndex();
                    if (tabIdx == 0) {
                        AppPopUpBlockList.this.m_titleNames = AppLang.getText("Mailbox Block");
                        AppPopUpBlockList.this.m_listType = (byte)10;
                        AppPopUpBlockList.this.m_DetailMsgId = "1028";
                        AppPopUpBlockList.this.m_MsgId = "1027";
                    } else if (tabIdx == 1) {
                        AppPopUpBlockList.this.m_titleNames = AppLang.getText("List Block");
                        AppPopUpBlockList.this.m_listType = (byte)9;
                        AppPopUpBlockList.this.m_DetailMsgId = "1024";
                        AppPopUpBlockList.this.m_MsgId = "1023";
                    } else if (tabIdx == 2) {
                        AppPopUpBlockList.this.m_titleNames = AppLang.getText("Network Mailbox Block");
                        AppPopUpBlockList.this.m_listType = (byte)14;
                        AppPopUpBlockList.this.m_DetailMsgId = "1038";
                        AppPopUpBlockList.this.m_MsgId = "1037";
                    }
                    AppPopUpBlockList.this.getInfo();
                    AppPopUpBlockList.this.createComponent();
                    AppPopUpBlockList.this.setTitleNames();
                    AppPopUpBlockList.this.m_model.setRowHeaderNames(AppPopUpBlockList.this.m_RowNames);
                    AppPopUpBlockList.this.m_table1.tableChanged(null);
                    AppPopUpBlockList.this.m_table2.tableChanged(null);
                    AppPopUpBlockList.this.m_table3.tableChanged(null);
                    AppPopUpBlockList.this.setMouseListener();
                }
            });
            this.add((Component)this.m_pnVMSGroup, "North");
            this.add((Component)this.m_tabPan, "Center");
        } else {
            if (this.m_type != 3) {
                this.add((Component)this.m_pnVMSGroup, "North");
            }
            this.add((Component)this.m_table1, "Center");
        }
        this.add((Component)btnPan, "South");
        this.setVisible(true);
    }

    private void setType(int type) {
        switch (type) {
            case 1: {
                this.m_listType = (byte)10;
                break;
            }
            case 2: {
                this.m_listType = (byte)6;
                break;
            }
            case 3: {
                this.m_listType = (byte)18;
                break;
            }
            case 4: {
                this.m_listType = (byte)11;
                break;
            }
            case 5: {
                this.m_listType = (byte)7;
                break;
            }
            case 6: {
                this.m_listType = (byte)8;
                break;
            }
            case 7: {
                this.m_listType = 0;
                break;
            }
        }
    }

    private boolean getInfo() {
        byte[] m_reqData = new byte[]{0, 0, 0, 1, this.m_listType, this.m_type != 3 ? (byte)(this.m_comboVMSGroup.getSelectedIndex() + 1) : (byte)0};
        try {
            AppPageInfo reqInfo = new AppPageInfo("1006");
            reqInfo.setMsgId(this.m_MsgId);
            reqInfo.setRecordSize(6);
            reqInfo.setReqData(m_reqData);
            reqInfo.setDownMsgType((byte)-41);
            AppComm.getInstance().requestDownload(reqInfo);
            this.m_recvData = reqInfo.getRecvData();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    private void setDialog() {
        this.setSize(385, 450);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.m_btnClose.addActionListener(this);
        this.m_btnClose.setActionCommand("close");
        this.m_btnNew.addActionListener(this);
        this.m_btnNew.setActionCommand("new");
        this.m_btnRelod.addActionListener(this);
        this.m_btnRelod.setActionCommand("reload");
        AppGlobal.fixSize(this.m_btnClose, new Dimension(115, 22));
        AppGlobal.fixSize(this.m_btnNew, new Dimension(115, 22));
        AppGlobal.fixSize(this.m_btnRelod, new Dimension(115, 22));
        this.m_btnClose.setFont(AppGlobal.g_btnFont);
        this.m_btnNew.setFont(AppGlobal.g_btnFont);
        this.m_btnRelod.setFont(AppGlobal.g_btnFont);
        switch (this.m_type) {
            case 1: {
                this.m_titleNames = AppLang.getText("Mailbox Block");
                this.m_MsgId = "1027";
                this.m_DetailMsgId = "1028";
                break;
            }
            case 2: {
                this.m_titleNames = AppLang.getText("EClass Block");
                this.m_MsgId = "1014";
                this.m_DetailMsgId = "1015";
                break;
            }
            case 3: {
                this.m_titleNames = AppLang.getText("Station Block");
                this.m_MsgId = "1045";
                this.m_DetailMsgId = "1046";
                break;
            }
            case 4: {
                this.m_titleNames = AppLang.getText("MClass Block");
                this.m_MsgId = "102D";
                this.m_DetailMsgId = "102E";
                break;
            }
            case 5: {
                this.m_titleNames = AppLang.getText("Extension Block");
                this.m_MsgId = "1019";
                this.m_DetailMsgId = "101A";
                break;
            }
            case 6: {
                this.m_titleNames = AppLang.getText("Fax Block");
                this.m_MsgId = "1020";
                this.m_DetailMsgId = "1021";
                break;
            }
            case 7: {
                this.m_titleNames = AppLang.getText("Announcement Block");
                this.m_MsgId = "1000";
                this.m_DetailMsgId = "1001";
            }
        }
        this.setTitleNames();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppPopUpBlockList.this.m_blockLabelName = "";
                AppPopUpBlockList.this.m_blockSerial = "";
                AppPopUpBlockList.this.m_thisObject.setVisible(false);
                if (AppGlobal.g_dialogList.size() > 0) {
                    AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                }
            }
        });
    }

    private void createComponent() {
        this.m_serial = new String[this.m_recvData.size()];
        this.m_btnEdit = new JButton[this.m_recvData.size()];
        this.m_tfLabel = new AppTextBox[this.m_recvData.size()];
        this.m_lbNumber = new JLabel[this.m_recvData.size()];
        this.m_RowNames = new String[this.m_recvData.size()][1];
        int i2 = 0;
        while (i2 < this.m_recvData.size()) {
            this.m_btnEdit[i2] = new JButton("Edit");
            this.m_btnEdit[i2].addActionListener(this);
            this.m_btnEdit[i2].setActionCommand("edit" + i2);
            this.m_btnEdit[i2].setFont(AppGlobal.g_btnFont);
            this.m_tfLabel[i2] = new AppTextBox(0, 30);
            this.m_lbNumber[i2] = new JLabel("" + (i2 + 1));
            this.m_lbNumber[i2].setHorizontalAlignment(0);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_recvData.size()) {
            ArrayList al_list = (ArrayList)this.m_recvData.get(i2);
            this.m_tfLabel[i2].setText((String)al_list.get(1));
            this.m_serial[i2] = (String)al_list.get(0);
            ++i2;
        }
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_RowNames, this.m_ColNames, AppLang.getText("No.")){

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return AppPopUpBlockList.this.m_lbNumber[row];
                    }
                    case 1: {
                        return AppPopUpBlockList.this.m_tfLabel[row];
                    }
                    case 2: {
                        return AppPopUpBlockList.this.m_btnEdit[row];
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0 && col != 1;
            }
        };
        this.m_model.setRowHeaderHidden();
        this.m_model.setRowWidth(new int[]{50});
        this.m_model.setColWidth(new int[]{50, 220, 80});
        this.m_table1 = new AppTable(this.m_model);
        if (this.m_type == 1) {
            this.m_table2 = new AppTable(this.m_model);
            this.m_table3 = new AppTable(this.m_model);
        }
    }

    private void setSerialNumber(String serialNum) {
        this.m_blockSerial = serialNum;
    }

    private void setLabelName(String labelName) {
        this.m_blockLabelName = labelName;
    }

    public String getSerialNumber() {
        return this.m_blockSerial.trim();
    }

    public String getLabelName() {
        return this.m_blockLabelName.trim();
    }

    public String getGroupNumber() {
        String groupNum = "" + this.m_comboVMSGroup.getSelectedIndex();
        return groupNum.trim();
    }

    public void setMouseListener() {
        this.m_table1.getTable().removeMouseListener(this.m_tableListener);
        this.m_table1.getTable().addMouseListener(this.m_tableListener);
        if (this.m_type == 1) {
            this.m_table2.getTable().removeMouseListener(this.m_tableListener);
            this.m_table2.getTable().addMouseListener(this.m_tableListener);
            this.m_table3.getTable().removeMouseListener(this.m_tableListener);
            this.m_table3.getTable().addMouseListener(this.m_tableListener);
        }
    }

    private void setTitleNames() {
        this.setTitle(this.m_titleNames);
    }

    private boolean createBlockClass() {
        if (this.m_DetailMsgId.equals("1015")) {
            this.m_blockPage = new P1015EClassBlock();
        } else if (this.m_DetailMsgId.equals("101A")) {
            this.m_blockPage = new P101AExtensionBlock();
        } else if (this.m_DetailMsgId.equals("1024")) {
            this.m_blockPage = new P1024ListBlock();
        } else if (this.m_DetailMsgId.equals("1028")) {
            this.m_blockPage = new P1028MailboxBlock();
        } else if (this.m_DetailMsgId.equals("102E")) {
            this.m_blockPage = new P102EMClassBlock();
        } else if (this.m_DetailMsgId.equals("1038")) {
            this.m_blockPage = new P1038NetworkBlock();
        } else if (this.m_DetailMsgId.equals("1046")) {
            this.m_blockPage = new P1046StationBlock();
        } else if (this.m_DetailMsgId.equals("1021")) {
            this.m_blockPage = new P1021FaxBlock();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("vms_change") || command.equals("reload")) {
            this.getInfo();
            this.createComponent();
            this.m_model.setRowHeaderNames(this.m_RowNames);
            this.m_table1.tableChanged(null);
            if (this.m_type == 1) {
                this.m_table2.tableChanged(null);
                this.m_table3.tableChanged(null);
            }
            this.setMouseListener();
        } else if (command.equals("close")) {
            this.m_blockLabelName = "";
            this.m_blockSerial = "";
            this.m_thisObject.setVisible(false);
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        } else if (command.equals("new")) {
            new AppNewBlockDlg(this.m_DetailMsgId, new ArrayList());
            this.getInfo();
            this.createComponent();
            this.m_model.setRowHeaderNames(this.m_RowNames);
            this.m_table1.tableChanged(null);
            if (this.m_type == 1) {
                this.m_table2.tableChanged(null);
                this.m_table3.tableChanged(null);
            }
            this.setMouseListener();
        } else if (command.indexOf("edit") > -1) {
            int i2 = 0;
            while (i2 < this.m_btnEdit.length) {
                if (command.equals("edit" + i2)) {
                    try {
                        if (!this.createBlockClass()) break;
                        this.m_blockPage.createPage(this.m_serial[i2], new ArrayList());
                        this.m_btnRelod.doClick();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                ++i2;
            }
        }
    }

    private class PopupBlockListTableListener
    extends MouseAdapter {
        private PopupBlockListTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (AppPopUpBlockList.this.m_type == 1) {
                if (e2.getClickCount() >= 2 && (AppPopUpBlockList.this.m_table1.getTable().getSelectedColumn() == 1 || AppPopUpBlockList.this.m_table2.getTable().getSelectedColumn() == 1 || AppPopUpBlockList.this.m_table3.getTable().getSelectedColumn() == 1) && AppPopUpBlockList.this.m_recvData != null) {
                    int rowIndex = AppPopUpBlockList.this.m_tabPan.getSelectedIndex() == 0 ? AppPopUpBlockList.this.m_table1.getTable().getSelectedRow() : (AppPopUpBlockList.this.m_tabPan.getSelectedIndex() == 1 ? AppPopUpBlockList.this.m_table2.getTable().getSelectedRow() : AppPopUpBlockList.this.m_table3.getTable().getSelectedRow());
                    try {
                        AppPopUpBlockList.this.setLabelName(AppPopUpBlockList.this.m_tfLabel[rowIndex].getText());
                        AppPopUpBlockList.this.setSerialNumber(AppPopUpBlockList.this.m_serial[rowIndex]);
                        AppPopUpBlockList.this.m_thisObject.setVisible(false);
                        if (AppGlobal.g_dialogList.size() > 0) {
                            AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                        }
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
            } else if (e2.getClickCount() >= 2 && AppPopUpBlockList.this.m_table1.getTable().getSelectedColumn() == 1 && AppPopUpBlockList.this.m_recvData != null) {
                try {
                    int rowIndex = AppPopUpBlockList.this.m_table1.getTable().getSelectedRow();
                    AppPopUpBlockList.this.setLabelName(AppPopUpBlockList.this.m_tfLabel[rowIndex].getText());
                    AppPopUpBlockList.this.setSerialNumber(AppPopUpBlockList.this.m_serial[rowIndex]);
                    AppPopUpBlockList.this.m_thisObject.setVisible(false);
                    if (AppGlobal.g_dialogList.size() > 0) {
                        AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
    }
}

