/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;

class PropertySetsReader {
    private BufferedWriter writer;
    private CompoundFile compoundFile;

    public PropertySetsReader(File file, OutputStream os) throws IOException, BiffException {
        int bytesRead;
        this.writer = new BufferedWriter(new OutputStreamWriter(os));
        FileInputStream fis = new FileInputStream(file);
        int initialFileSize = 0x100000;
        int arrayGrowSize = 0x100000;
        byte[] d2 = new byte[initialFileSize];
        int pos = bytesRead = fis.read(d2);
        while (bytesRead != -1) {
            if (pos >= d2.length) {
                byte[] newArray = new byte[d2.length + arrayGrowSize];
                System.arraycopy(d2, 0, newArray, 0, d2.length);
                d2 = newArray;
            }
            bytesRead = fis.read(d2, pos, d2.length - pos);
            pos += bytesRead;
        }
        bytesRead = pos + 1;
        this.compoundFile = new CompoundFile(d2, new WorkbookSettings());
        fis.close();
        this.displaySets();
    }

    void displaySets() throws IOException {
        String[] sets = this.compoundFile.getPropertySetNames();
        for (int i2 = 0; i2 < sets.length; ++i2) {
            this.writer.write(sets[i2]);
            this.writer.newLine();
        }
        this.writer.flush();
        this.writer.close();
    }
}

