/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.BooleanCell;
import jxl.CellType;
import jxl.biff.Type;
import jxl.format.CellFormat;
import jxl.write.biff.CellValue;

public abstract class BooleanRecord
extends CellValue {
    private boolean value;

    protected BooleanRecord(int c2, int r2, boolean val) {
        super(Type.BOOLERR, c2, r2);
        this.value = val;
    }

    protected BooleanRecord(int c2, int r2, boolean val, CellFormat st) {
        super(Type.BOOLERR, c2, r2, st);
        this.value = val;
    }

    protected BooleanRecord(BooleanCell nc) {
        super(Type.BOOLERR, nc);
        this.value = nc.getValue();
    }

    protected BooleanRecord(int c2, int r2, BooleanRecord br2) {
        super(Type.BOOLERR, c2, r2, br2);
        this.value = br2.value;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public CellType getType() {
        return CellType.BOOLEAN;
    }

    protected void setValue(boolean val) {
        this.value = val;
    }

    public byte[] getData() {
        byte[] celldata = super.getData();
        byte[] data = new byte[celldata.length + 2];
        System.arraycopy(celldata, 0, data, 0, celldata.length);
        if (this.value) {
            data[celldata.length] = 1;
        }
        return data;
    }
}

