/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class TelnetAppender
extends AppenderSkeleton {
    private SocketHandler sh;
    private int port = 23;

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            this.sh = new SocketHandler(this.port);
            this.sh.start();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        super.activateOptions();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void close() {
        if (this.sh != null) {
            this.sh.close();
            try {
                this.sh.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void append(LoggingEvent event) {
        String[] s2;
        this.sh.send(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s2 = event.getThrowableStrRep()) != null) {
            int len = s2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                this.sh.send(s2[i2]);
                this.sh.send(Layout.LINE_SEP);
            }
        }
    }

    protected class SocketHandler
    extends Thread {
        private Vector writers = new Vector();
        private Vector connections = new Vector();
        private ServerSocket serverSocket;
        private int MAX_CONNECTIONS = 20;

        public void finalize() {
            this.close();
        }

        public void close() {
            Enumeration e2 = this.connections.elements();
            while (e2.hasMoreElements()) {
                try {
                    ((Socket)e2.nextElement()).close();
                }
                catch (Exception exception) {}
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void send(String message) {
            Enumeration ce2 = this.connections.elements();
            Enumeration e2 = this.writers.elements();
            while (e2.hasMoreElements()) {
                Socket sock = (Socket)ce2.nextElement();
                PrintWriter writer = (PrintWriter)e2.nextElement();
                writer.print(message);
                if (!writer.checkError()) continue;
                this.connections.remove(sock);
                this.writers.remove(writer);
            }
        }

        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket newClient = this.serverSocket.accept();
                    PrintWriter pw = new PrintWriter(newClient.getOutputStream());
                    if (this.connections.size() < this.MAX_CONNECTIONS) {
                        this.connections.addElement(newClient);
                        this.writers.addElement(pw);
                        pw.print("TelnetAppender v1.0 (" + this.connections.size() + " active connections)\r\n\r\n");
                        pw.flush();
                        continue;
                    }
                    pw.print("Too many connections.\r\n");
                    pw.flush();
                    newClient.close();
                }
                catch (Exception e2) {
                    if (this.serverSocket.isClosed()) break;
                    LogLog.error("Encountered error while in SocketHandler loop.", e2);
                    break;
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SocketHandler(int port) throws IOException {
            this.serverSocket = new ServerSocket(port);
            this.setName("TelnetAppender-" + this.getName() + "-" + port);
        }
    }
}

