/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.components;

import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppCellText;
import com.sec.osdm.pages.utils.table.ICellComponent;
import java.awt.Color;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTable;

public class AppNewText
implements ICellComponent,
Serializable {
    private static AppCellText m_component = null;
    private JTable m_owner = null;
    private String m_strData = "";
    private AppPageInfo m_page = null;
    private int m_index = 0;
    private KeyListener m_listener = null;
    private Color m_backColor = Color.WHITE;
    private int m_HorizontalAlignment = 2;

    public AppNewText() {
        this.m_page = null;
    }

    public AppNewText(AppPageInfo page, int index) {
        this.m_page = page;
        this.m_index = index;
    }

    public String getText() {
        return this.m_strData;
    }

    public void setText(String data) {
        this.m_strData = data;
    }

    public void addKeyListener(KeyListener listener) {
        this.m_listener = listener;
    }

    @Override
    public JComponent getComponent() {
        if (m_component == null) {
            m_component = new AppCellText();
        }
        if (this.m_page != null) {
            m_component.setTextInfo(this.m_page, this.m_index);
        }
        m_component.setText(this.m_strData);
        m_component.addKeyListener(this.m_listener);
        return m_component;
    }

    @Override
    public boolean checkValue(String strData) {
        return true;
    }

    @Override
    public void clear() {
        this.fromString("");
    }

    @Override
    public void finishEditing() {
        int maxValue;
        String strData = m_component.getText().trim();
        String strDefault = this.m_page == null ? "" : this.m_page.getFieldDefault(this.m_index);
        int minValue = this.m_page == null ? 0 : this.m_page.getFieldMin(this.m_index);
        int n2 = maxValue = this.m_page == null ? 0 : this.m_page.getFieldMax(this.m_index);
        if (strData.equals("")) {
            m_component.setText(strDefault);
        }
        if (!strData.equals("") && maxValue > 0) {
            try {
                int value = Integer.parseInt(strData);
                if (value < minValue || value > maxValue) {
                    m_component.setText(strDefault);
                }
            }
            catch (NumberFormatException ne) {
                m_component.setText(strDefault);
            }
        }
        this.setText(m_component.getText());
    }

    @Override
    public void fromString(String strData) {
        this.setText(strData);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public JTable getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(JTable table) {
        this.m_owner = table;
    }

    public void setBackground(Color back) {
        this.m_backColor = back;
    }

    public Color getBackground() {
        return this.m_backColor;
    }

    public void setHorizontalAlignment(int alignment) {
        this.m_HorizontalAlignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.m_HorizontalAlignment;
    }
}

