/*
 * Decompiled with CFR 0.152.
 */
package jxl.write;

import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.write.WriteException;
import jxl.write.biff.WritableFontRecord;

public class WritableFont
extends WritableFontRecord {
    public static final FontName ARIAL = new FontName("Arial");
    public static final FontName TIMES = new FontName("Times New Roman");
    public static final FontName COURIER = new FontName("Courier New");
    public static final FontName TAHOMA = new FontName("Tahoma");
    public static final BoldStyle NO_BOLD = new BoldStyle(400);
    public static final BoldStyle BOLD = new BoldStyle(700);
    public static final int DEFAULT_POINT_SIZE = 10;

    public WritableFont(FontName fn) {
        this(fn, 10, NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(Font f2) {
        super(f2);
    }

    public WritableFont(FontName fn, int ps) {
        this(fn, ps, NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fn, int ps, BoldStyle bs2) {
        this(fn, ps, bs2, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fn, int ps, BoldStyle bs2, boolean italic) {
        this(fn, ps, bs2, italic, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fn, int ps, BoldStyle bs2, boolean it, UnderlineStyle us) {
        this(fn, ps, bs2, it, us, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fn, int ps, BoldStyle bs2, boolean it, UnderlineStyle us, Colour c2) {
        this(fn, ps, bs2, it, us, c2, ScriptStyle.NORMAL_SCRIPT);
    }

    public WritableFont(FontName fn, int ps, BoldStyle bs2, boolean it, UnderlineStyle us, Colour c2, ScriptStyle ss) {
        super(fn.name, ps, bs2.value, it, us.getValue(), c2.getValue(), ss.getValue());
    }

    public void setPointSize(int pointSize) throws WriteException {
        super.setPointSize(pointSize);
    }

    public void setBoldStyle(BoldStyle boldStyle) throws WriteException {
        super.setBoldStyle(boldStyle.value);
    }

    public void setItalic(boolean italic) throws WriteException {
        super.setItalic(italic);
    }

    public void setUnderlineStyle(UnderlineStyle us) throws WriteException {
        super.setUnderlineStyle(us.getValue());
    }

    public void setColour(Colour colour) throws WriteException {
        super.setColour(colour.getValue());
    }

    public void setScriptStyle(ScriptStyle scriptStyle) throws WriteException {
        super.setScriptStyle(scriptStyle.getValue());
    }

    public static FontName createFont(String fontName) {
        return new FontName(fontName);
    }

    static class BoldStyle {
        public int value;

        BoldStyle(int val) {
            this.value = val;
        }
    }

    public static class FontName {
        String name;

        FontName(String s2) {
            this.name = s2;
        }
    }
}

