/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.CodecProvider;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class DefaultCodecProvider
implements CodecProvider {
    public static final CodecProvider INSTANCE = new DefaultCodecProvider();
    public static final CodecHandler DUMMY_HANDLER = new DummyHandler();
    public static final CodecHandler UNSUPPORTED_HANDLER = new UnsupportedHandler();

    public CodecHandler createHandler(PageChannel channel, Charset charset) throws IOException {
        JetFormat format = channel.getFormat();
        switch (format.CODEC_TYPE) {
            case NONE: {
                return DUMMY_HANDLER;
            }
            case JET: {
                ByteBuffer bb2 = channel.createPageBuffer();
                channel.readPage(bb2, 0);
                int codecKey = bb2.getInt(format.OFFSET_ENCODING_KEY);
                return codecKey == 0 ? DUMMY_HANDLER : UNSUPPORTED_HANDLER;
            }
            case MSISAM: {
                return UNSUPPORTED_HANDLER;
            }
        }
        throw new RuntimeException("Unknown codec type " + (Object)((Object)format.CODEC_TYPE));
    }

    public static class UnsupportedHandler
    implements CodecHandler {
        public void decodePage(ByteBuffer page, int pageNumber) throws IOException {
            throw new UnsupportedOperationException("Decoding not supported");
        }

        public ByteBuffer encodePage(ByteBuffer page, int pageNumber, int pageOffset) throws IOException {
            throw new UnsupportedOperationException("Encoding not supported");
        }
    }

    public static class DummyHandler
    implements CodecHandler {
        public void decodePage(ByteBuffer page, int pageNumber) throws IOException {
        }

        public ByteBuffer encodePage(ByteBuffer page, int pageNumber, int pageOffset) throws IOException {
            return page;
        }
    }
}

