/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.query;

import com.healthmarketscience.jackcess.query.Query;
import com.healthmarketscience.jackcess.query.QueryFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSelectQuery
extends Query {
    protected BaseSelectQuery(String name, List<Query.Row> rows, int objectId, Query.Type type) {
        super(name, rows, objectId, type);
    }

    protected void toSQLSelectString(StringBuilder builder, boolean useSelectPrefix) {
        List<String> orderings;
        String havingExpr;
        List<String> groupings;
        String whereExpr;
        if (useSelectPrefix) {
            builder.append("SELECT ");
            String selectType = this.getSelectType();
            if (!"".equals(selectType)) {
                builder.append(selectType).append(' ');
            }
        }
        builder.append(this.getSelectColumns());
        this.toSelectInto(builder);
        List<String> fromTables = this.getFromTables();
        if (!fromTables.isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("FROM ").append(fromTables);
            BaseSelectQuery.toRemoteDb(builder, this.getFromRemoteDbPath(), this.getFromRemoteDbType());
        }
        if ((whereExpr = this.getWhereExpression()) != null) {
            builder.append(QueryFormat.NEWLINE).append("WHERE ").append(whereExpr);
        }
        if (!(groupings = this.getGroupings()).isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("GROUP BY ").append(groupings);
        }
        if ((havingExpr = this.getHavingExpression()) != null) {
            builder.append(QueryFormat.NEWLINE).append("HAVING ").append(havingExpr);
        }
        if (!(orderings = this.getOrderings()).isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("ORDER BY ").append(orderings);
        }
    }

    public String getSelectType() {
        if (this.hasFlag(2)) {
            return "DISTINCT";
        }
        if (this.hasFlag(8)) {
            return "DISTINCTROW";
        }
        if (this.hasFlag(16)) {
            StringBuilder builder = new StringBuilder();
            builder.append("TOP ").append(this.getFlagRow().name1);
            if (this.hasFlag(32)) {
                builder.append(" PERCENT");
            }
            return builder.toString();
        }
        return "";
    }

    public List<String> getSelectColumns() {
        List<String> result = new Query.RowFormatter(this.getColumnRows()){

            protected void format(StringBuilder builder, Query.Row row) {
                builder.append(row.expression);
                Query.toAlias(builder, row.name1);
            }
        }.format();
        if (this.hasFlag(1)) {
            result.add("*");
        }
        return result;
    }

    protected void toSelectInto(StringBuilder builder) {
    }

    @Override
    public List<String> getFromTables() {
        return super.getFromTables();
    }

    @Override
    public String getFromRemoteDbPath() {
        return super.getFromRemoteDbPath();
    }

    @Override
    public String getFromRemoteDbType() {
        return super.getFromRemoteDbType();
    }

    @Override
    public String getWhereExpression() {
        return super.getWhereExpression();
    }

    public List<String> getGroupings() {
        return new Query.RowFormatter(this.getGroupByRows()){

            protected void format(StringBuilder builder, Query.Row row) {
                builder.append(row.expression);
            }
        }.format();
    }

    public String getHavingExpression() {
        return this.getHavingRow().expression;
    }

    @Override
    public List<String> getOrderings() {
        return super.getOrderings();
    }
}

