/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class AppLayout
implements ComponentListener {
    public Container m_con;
    private Hashtable m_components;
    private Hashtable m_containers;
    private ComponentListener m_listener;

    public AppLayout(Container c2, int sizeX, int sizeY) {
        this.m_con = c2;
        this.m_components = new Hashtable();
        this.m_containers = new Hashtable();
        this.m_con.setLayout(null);
        this.m_con.addComponentListener(this);
        this.m_con.setSize(sizeX, sizeY);
    }

    public AppLayout(Container c2, int sizeX, int sizeY, ComponentListener listener) {
        this(c2, sizeX, sizeY);
        this.m_listener = listener;
    }

    public void addComponent(Component comp, int x2, int y2, int width, int height) {
        comp.setBounds(x2, y2, width, height);
        this.m_con.add(comp);
    }

    public void addComponentResize(Component comp, int x2, int y2, int widthPer, int heightPer) {
        Dimension d2 = this.m_con.getSize();
        int width = (int)d2.getWidth();
        int height = (int)d2.getHeight();
        int sizeWidth = width * widthPer / 100;
        int sizeHeight = height * heightPer / 100;
        comp.setBounds(x2, y2, sizeWidth, sizeHeight);
        this.m_con.add(comp);
        if (x2 < 1) {
            x2 = 1;
        }
        if (y2 < 1) {
            y2 = 1;
        }
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        int startX = x2 * 100 / width;
        int startY = y2 * 100 / height;
        PointEx p2 = new PointEx(startX, startY, widthPer, heightPer);
        this.m_components.put(comp, p2);
    }

    public void addContainer(Container parent, Container child, int x2, int y2, int widthPer, int heightPer) {
        child.setLayout(null);
        Dimension d2 = this.m_con.getSize();
        int width = (int)d2.getWidth();
        int height = (int)d2.getHeight();
        int sizeWidth = width * widthPer / 100;
        int sizeHeight = height * heightPer / 100;
        child.setBounds(x2, y2, sizeWidth, sizeHeight);
        if (parent == null) {
            this.m_con.add(child);
        } else {
            parent.add(child);
        }
        if (x2 < 1) {
            x2 = 1;
        }
        if (y2 < 1) {
            y2 = 1;
        }
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        int startX = x2 * 100 / width;
        int startY = y2 * 100 / height;
        PointEx p2 = new PointEx(startX, startY, widthPer, heightPer);
        this.m_containers.put(child, p2);
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        Enumeration em = this.m_containers.keys();
        while (em.hasMoreElements()) {
            Container c2 = (Container)em.nextElement();
            PointEx p2 = (PointEx)this.m_containers.get(c2);
            Container parent = c2.getParent();
            Dimension d2 = parent.getSize();
            int width = (int)d2.getWidth();
            int height = (int)d2.getHeight();
            int x2 = p2.x * width / 100;
            int y2 = p2.y * height / 100;
            int sizeX = p2.width * width / 100;
            int sizeY = p2.height * height / 100;
            c2.setLocation(x2, y2);
            c2.setSize(sizeX, sizeY);
        }
        Enumeration enumCom = this.m_components.keys();
        while (enumCom.hasMoreElements()) {
            Component com = (Component)enumCom.nextElement();
            PointEx p3 = (PointEx)this.m_components.get(com);
            Container parent = com.getParent();
            Dimension d3 = parent.getSize();
            int width = (int)d3.getWidth();
            int height = (int)d3.getHeight();
            int x3 = p3.x * width / 100;
            int y3 = p3.y * height / 100;
            int sizeX = p3.width * width / 100;
            int sizeY = p3.height * height / 100;
            com.setLocation(x3, y3);
            com.setSize(sizeX, sizeY);
        }
        this.m_con.validate();
    }

    @Override
    public void componentMoved(ComponentEvent e2) {
        if (this.m_listener != null) {
            this.m_listener.componentMoved(e2);
        }
    }

    @Override
    public void componentShown(ComponentEvent e2) {
        if (this.m_listener != null) {
            this.m_listener.componentShown(e2);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e2) {
        if (this.m_listener != null) {
            this.m_listener.componentHidden(e2);
        }
    }

    class PointEx {
        int x;
        int y;
        int width;
        int height;

        public PointEx(int x2, int y2, int width, int height) {
            this.x = x2;
            this.y = y2;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return new String("x-" + this.x + " y-" + this.y + " width-" + this.width + " height-" + this.height);
        }
    }
}

