/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class AppControl {
    private static int MAX_PACKET_SIZE = 16384;
    private static Socket m_socket = null;
    private static Hashtable m_linkInfo = new Hashtable();
    private String m_systemName = "";

    public AppControl() {
        m_linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
    }

    public String getSystemName() {
        return this.m_systemName;
    }

    public void setSystemName(String systemName) {
        this.m_systemName = systemName;
    }

    private boolean connect() {
        try {
            if (m_socket == null) {
                m_socket = new Socket((String)m_linkInfo.get("IP_ADDRESS"), Integer.parseInt((String)m_linkInfo.get("FILE_PORT")));
            }
            return true;
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public void disconnect() {
        try {
            if (m_socket != null) {
                if (m_socket.isConnected()) {
                    m_socket.close();
                }
                m_socket = null;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public byte[] requestFileControl(byte[] reqData, int pacSize) {
        byte[] recv = null;
        boolean bSendSuccess = false;
        int i2 = 0;
        while (i2 < 3) {
            bSendSuccess = this.sendData(reqData, "");
            if (bSendSuccess && (pacSize <= 0 || (recv = this.recvData(pacSize)) != null)) break;
            try {
                Thread.sleep(500L);
                System.out.println("File Control Retry Count : " + (i2 + 1));
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            ++i2;
        }
        return recv;
    }

    public byte[] requestUpload(byte[] reqData, int pacSize, String fileName) {
        byte[] recv = null;
        int iStart = 0;
        if (this.sendData(reqData, fileName) && pacSize > 0) {
            recv = this.recvUpload(pacSize);
        }
        int i2 = 1;
        while (i2 < recv.length) {
            if (recv[i2] != 20) break;
            iStart += 12;
            i2 += 12;
        }
        byte[] recv_data = new byte[recv.length - iStart];
        System.arraycopy(recv, iStart, recv_data, 0, recv_data.length);
        if (iStart != 0 && recv_data.length == 0 && pacSize > 0) {
            recv_data = this.recvUpload(pacSize);
        }
        return recv_data;
    }

    private boolean sendData(byte[] data, String fileName) {
        byte[] send = null;
        int msgLen = 0;
        long lSend = 0L;
        if (!this.connect()) {
            return false;
        }
        OutputStream os = null;
        try {
            os = m_socket.getOutputStream();
            int i2 = 0;
            while (i2 < data.length) {
                msgLen = MAX_PACKET_SIZE;
                if (i2 + MAX_PACKET_SIZE > data.length) {
                    msgLen = data.length - i2;
                }
                send = new byte[msgLen];
                System.arraycopy(data, i2, send, 0, msgLen);
                os.write(send);
                os.flush();
                if (!fileName.equals("")) {
                    lSend = i2 + msgLen;
                    AppGlobal.showProgress("[" + fileName + "] - " + data.length, String.valueOf(AppLang.getText("Transferring")) + "... (" + lSend + "=" + (int)((float)lSend / (float)data.length * 100.0f) + "%)");
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                i2 += MAX_PACKET_SIZE;
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return false;
        }
        return true;
    }

    public byte[] recvData(int pacSize) {
        byte[] m_bTemp = new byte[4096];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int nDataStart = 0;
        boolean isEnd = false;
        try {
            m_socket.setSoTimeout(10000);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        InputStream is = null;
        try {
            is = m_socket.getInputStream();
            block4: do {
                nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset);
                nOffset += nRead;
                if (pacSize == 172) {
                    nDataStart = 0;
                    while (nDataStart + 8 <= nOffset) {
                        if (m_bTemp[nDataStart + 1] == 37) {
                            nDataStart += 8;
                            continue;
                        }
                        if (m_bTemp[nDataStart + 1] == 20) {
                            nDataStart += 12;
                            continue;
                        }
                        if (m_bTemp[nDataStart + 1] == 38) {
                            nDataStart += 314;
                            continue;
                        }
                        if (m_bTemp[nDataStart + 1] != 18) break;
                        break;
                    }
                }
                if (nOffset - nDataStart < pacSize) continue;
                int i2 = nDataStart + 8;
                while (i2 < m_bTemp.length) {
                    if (m_bTemp[i2 - 1] >= -32 && m_bTemp[i2 - 1] <= -17) {
                        isEnd = true;
                        continue block4;
                    }
                    i2 += pacSize;
                }
            } while (!isEnd);
            m_bData = new byte[nOffset - nDataStart];
            System.arraycopy(m_bTemp, nDataStart, m_bData, 0, nOffset - nDataStart);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        return m_bData;
    }

    public byte[] recvUpload(int pacSize) {
        byte[] m_bTemp = new byte[1024];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        try {
            m_socket.setSoTimeout(10000);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        InputStream is = null;
        try {
            is = m_socket.getInputStream();
            while ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) != -1) {
                if ((nOffset += nRead) >= pacSize) break;
            }
            m_bData = new byte[nOffset];
            System.arraycopy(m_bTemp, 0, m_bData, 0, nOffset);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        return m_bData;
    }

    public byte[] makeMsgHeader(byte msgID, byte subID, byte mode, short seqno, byte len, byte resp) {
        byte[] header = new byte[8];
        header[0] = -6;
        header[1] = msgID;
        header[2] = subID;
        header[3] = mode;
        AppFunctions.short2byte(header, 4, seqno);
        header[6] = len;
        header[7] = resp;
        return header;
    }
}

