/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.utils.AppDialog;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AppOldConvert
extends AppDialog {
    private final int SIZE_WIDTH = 720;
    private final int SIZE_HEIGHT = 130;
    private JLabel m_file1 = new JLabel();
    private JLabel m_file2 = new JLabel();
    private JProgressBar m_progress = new JProgressBar(0, 100);
    private Socket m_sock = null;
    private OutputStream m_os = null;
    private ArrayList m_tableList = new ArrayList();
    private Hashtable m_recvData = new Hashtable();
    private String m_itFile = "";
    private String m_dbFile = "";

    public AppOldConvert() {
        this.m_layout = new AppLayout(this.m_contentPane, 720, 130);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppOldConvert.this.openDialog("DB Conversion", 720, 130);
            }
        });
    }

    private void createComponents() {
        String[] titles = new String[]{"...", "...", AppLang.getText("Start"), AppLang.getText("Close")};
        String[] command = new String[]{"File1", "File2", "Start", "Close"};
        JButton[] buttons = new JButton[4];
        JLabel file1 = new JLabel("Installation DB", 4);
        JLabel file2 = new JLabel("OSDM DB", 4);
        int i2 = 0;
        while (i2 < 4) {
            buttons[i2] = new JButton(titles[i2]);
            buttons[i2].setActionCommand(command[i2]);
            buttons[i2].addActionListener(this);
            ++i2;
        }
        this.m_file1.setBorder(new LineBorder(Color.darkGray));
        this.m_file2.setBorder(new LineBorder(Color.darkGray));
        this.m_progress.setStringPainted(true);
        this.m_progress.setVisible(false);
        this.m_layout.addComponent(file1, 5, 10, 100, 20);
        this.m_layout.addComponent(this.m_file1, 110, 10, 560, 20);
        this.m_layout.addComponent(buttons[0], 675, 10, 30, 20);
        this.m_layout.addComponent(file2, 5, 40, 100, 20);
        this.m_layout.addComponent(this.m_file2, 110, 40, 560, 20);
        this.m_layout.addComponent(buttons[1], 675, 40, 30, 20);
        this.m_layout.addComponent(this.m_progress, 110, 70, 420, 20);
        this.m_layout.addComponent(buttons[2], 555, 70, 70, 20);
        this.m_layout.addComponent(buttons[3], 635, 70, 70, 20);
    }

    private void openAccessDatabase() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("Installation File")) + "(*.IUD)", "IUD");
        if (browser.openBrowser()) {
            this.m_itFile = browser.getFilePath();
            if (AppGlobal.g_accessProcess != null) {
                this.disconnect();
            }
            if (this.connect()) {
                this.m_file1.setText(this.m_itFile);
            }
        }
    }

    private void createDatabase() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("OSDM File")) + "(*.odm)", "odm");
        if (browser.saveBrowserWithExtender("odm")) {
            this.m_dbFile = browser.getFilePath();
            this.m_file2.setText(this.m_dbFile);
        }
    }

    private boolean connect() {
        try {
            File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "AccessDB.exe");
            String path = file.exists() ? String.valueOf(System.getProperty("user.dir")) + File.separator + "AccessDB.exe " + this.m_itFile : String.valueOf(AppProperty.m_runDirectory) + "AccessDB.exe " + this.m_itFile;
            AppGlobal.g_accessProcess = Runtime.getRuntime().exec(path);
            this.m_sock = new Socket("127.0.0.1", 9000);
            this.m_os = this.m_sock.getOutputStream();
            this.m_recvData.clear();
            return this.checkPassword();
        }
        catch (Exception e2) {
            AppGlobal.hideProgress();
            e2.printStackTrace();
            return false;
        }
    }

    private boolean checkPassword() {
        String m_password;
        byte[] reqData = new byte[52];
        byte[] recv = null;
        reqData[0] = -45;
        reqData[1] = 50;
        while ((m_password = JOptionPane.showInputDialog(AppLang.getText("Input the password of Installation DB."))) != null && !m_password.trim().equals("")) {
            AppFunctions.str2byte(reqData, 2, 50, m_password);
            if (this.sendData(reqData) && (recv = this.recvData()) != null && recv[0] == 1) {
                byte[] password = new byte[50];
                AppFunctions.str2byte(password, 0, 50, m_password);
                this.m_recvData.put("0001", password);
                return true;
            }
            AppGlobal.showErrorMessage("", AppLang.getText("Inputted password is wrong. Again input the password."));
        }
        return false;
    }

    private void startConversion() {
        this.getTableList();
        this.getTableData();
        this.disconnect();
        File fd = new File(this.m_dbFile);
        try {
            FileOutputStream m_fos = new FileOutputStream(fd);
            ObjectOutputStream m_oos = new ObjectOutputStream(m_fos);
            m_oos.writeObject(this.m_recvData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.m_dbFile = "";
        this.m_itFile = "";
        this.m_file1.setText("");
        this.m_file2.setText("");
        AppGlobal.showInfoMessage("", "Completed convert database.");
    }

    private void getTableList() {
        byte[] reqData = new byte[2];
        byte[] temp = null;
        this.m_tableList.clear();
        temp = new byte[]{0, 0};
        this.m_tableList.add(0, temp);
        try {
            byte[] recv;
            reqData[0] = -47;
            reqData[1] = 0;
            if (this.sendData(reqData) && (recv = this.recvData()) != null) {
                int i2 = 0;
                while (i2 < recv.length) {
                    temp = new byte[2];
                    System.arraycopy(recv, i2, temp, 0, 2);
                    this.m_tableList.add(this.m_tableList.size(), temp);
                    i2 += 2;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void getTableData() {
        byte[] reqData = new byte[4];
        byte[] temp = null;
        String msgId = "";
        try {
            int i2 = 0;
            while (i2 < this.m_tableList.size()) {
                byte[] recv;
                temp = (byte[])this.m_tableList.get(i2);
                msgId = AppFunctions.unsignedValue(AppFunctions.byte2short(temp, 0));
                reqData[0] = -46;
                reqData[1] = 2;
                System.arraycopy(temp, 0, reqData, 2, 2);
                if (this.sendData(reqData) && (recv = this.recvData()) != null) {
                    String key = String.format("%04x", Integer.parseInt(msgId)).toUpperCase();
                    this.m_recvData.put(key, recv);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void disconnect() {
        byte[] reqData = new byte[]{-48, 0};
        this.sendData(reqData);
        try {
            Thread.sleep(1000L);
            this.m_os = null;
            this.m_sock = null;
            AppGlobal.g_accessProcess = null;
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    private boolean sendData(byte[] req) {
        try {
            this.m_os.write(req);
            this.m_os.flush();
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] recvData() {
        byte[] m_bTemp = new byte[2048000];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int msgLen = -1;
        InputStream is = null;
        try {
            is = this.m_sock.getInputStream();
            do {
                if ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) < 4 || msgLen != -1 || (msgLen = AppFunctions.byte2int(m_bTemp, 0)) != 0) continue;
                return null;
            } while (msgLen < 0 || (nOffset += nRead) < msgLen + 4);
            m_bData = new byte[msgLen];
            System.arraycopy(m_bTemp, 4, m_bData, 0, msgLen);
            return m_bData;
        }
        catch (IOException e2) {
            return null;
        }
    }

    @Override
    public void closeDialog() {
        if (AppGlobal.g_accessProcess != null) {
            this.disconnect();
        }
        this.dispose();
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Start")) {
            if (this.m_file1.getText().trim().equals("") || this.m_file2.getText().trim().equals("")) {
                return;
            }
            this.startConversion();
        } else if (command.equals("File1")) {
            this.m_file1.setText("");
            this.openAccessDatabase();
        } else if (command.equals("File2")) {
            this.m_file2.setText("");
            this.createDatabase();
        } else if (command.equals("Close")) {
            this.closeDialog();
        }
    }
}

