/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppTopPanel;
import com.sec.osdm.pages.utils.AppCards;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class AppCardPane
extends JPanel
implements ActionListener {
    private JTabbedPane m_tabMain = new JTabbedPane();
    private JPanel[] m_panCab = new JPanel[13];
    private JButton[] m_cabinet = new JButton[13];
    private JButton[][] m_card = new JButton[13][12];

    public AppCardPane() {
        this.setLayout(new BorderLayout());
        this.createComponents();
        this.setPhysicalData();
        this.setVirtualData();
    }

    private void createComponents() {
        JPanel panTop = new JPanel(new BorderLayout());
        JPanel panPhysical = new JPanel();
        JPanel panVirtual = new JPanel();
        JScrollPane jspVirtual = new JScrollPane();
        JButton btSystem = new JButton(AppLang.getText("System"));
        AppLayout layPhysical = new AppLayout(panPhysical, this.m_tabMain.getWidth(), this.m_tabMain.getHeight());
        AppLayout layVirtual = new AppLayout(panVirtual, this.m_tabMain.getWidth(), this.m_tabMain.getHeight());
        AppLayout layCabinet = null;
        btSystem.setFont(new Font("SansSerif", 0, 12));
        btSystem.setActionCommand("system");
        btSystem.addActionListener(this);
        panTop.add((Component)btSystem, "Center");
        int i2 = 0;
        while (i2 < this.m_panCab.length) {
            this.m_panCab[i2] = new JPanel();
            this.m_panCab[i2].setBorder(new LineBorder(Color.darkGray));
            this.m_panCab[i2].setVisible(false);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_cabinet.length) {
            this.m_cabinet[i2] = new JButton("");
            this.m_cabinet[i2].setFont(new Font("SansSerif", 0, 12));
            this.m_cabinet[i2].setActionCommand("" + i2);
            this.m_cabinet[i2].addActionListener(this);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_card.length) {
            layCabinet = new AppLayout(this.m_panCab[i2], 270, 122);
            layCabinet.addComponent(this.m_cabinet[i2], 0, 0, 270, 20);
            int j2 = 0;
            while (j2 < this.m_card[i2].length) {
                this.m_card[i2][j2] = new JButton("");
                this.m_card[i2][j2].setPreferredSize(new Dimension(90, 25));
                this.m_card[i2][j2].setFont(new Font("SansSerif", 0, 11));
                this.m_card[i2][j2].setMargin(new Insets(0, 0, 0, 0));
                this.m_card[i2][j2].setActionCommand(String.valueOf(i2) + ":" + j2);
                this.m_card[i2][j2].addActionListener(this);
                this.m_card[i2][j2].setVisible(false);
                layCabinet.addComponent(this.m_card[i2][j2], j2 % 3 * 90, j2 / 3 * 25 + 22, 90, 25);
                ++j2;
            }
            if (i2 < 3) {
                layPhysical.addComponent(this.m_panCab[i2], 10, i2 * 140 + 10, 270, 122);
            } else {
                layVirtual.addComponent(this.m_panCab[i2], 10, (i2 - 3) * 140 + 10, 270, 122);
            }
            layCabinet = null;
            ++i2;
        }
        panVirtual.setPreferredSize(new Dimension(this.m_tabMain.getWidth(), AppRunInfo.getVirtCabinet() * 140));
        jspVirtual.getViewport().add(panVirtual);
        this.m_tabMain.addTab(AppLang.getText("Physical"), panPhysical);
        this.m_tabMain.addTab(AppLang.getText("Virtual"), jspVirtual);
        this.add((Component)panTop, "North");
        this.add((Component)this.m_tabMain, "Center");
    }

    private void setPhysicalData() {
        int cardId = 255;
        int i2 = 0;
        while (i2 < AppRunInfo.getRealCabinet()) {
            int j2;
            if (i2 == 0) {
                j2 = 0;
                while (j2 < AppRunInfo.getRealCabSlot(i2) + 1) {
                    cardId = j2 == 0 ? AppRunInfo.getCurrCard(i2, AppRunInfo.getRealCabSlot(i2)) : AppRunInfo.getCurrCard(i2, j2 - 1);
                    if (cardId != 255) {
                        if (AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 55) {
                            if (j2 != 0) {
                                this.m_card[i2][j2 - 1].setText(AppCards.getCardName(cardId));
                                this.m_card[i2][j2 - 1].setVisible(true);
                            }
                        } else {
                            this.m_card[i2][j2].setText(AppCards.getCardName(cardId));
                            this.m_card[i2][j2].setVisible(true);
                        }
                    }
                    ++j2;
                }
            } else if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                j2 = 0;
                while (j2 < AppRunInfo.getRealCabSlot(i2) + 1) {
                    cardId = j2 == 0 ? AppRunInfo.getCurrCard(i2, AppRunInfo.getRealCabSlot(i2)) : AppRunInfo.getCurrCard(i2, j2 - 1);
                    if (cardId != 255) {
                        this.m_card[i2][j2].setText(AppCards.getCardName(cardId));
                        this.m_card[i2][j2].setVisible(true);
                    }
                    ++j2;
                }
            } else {
                j2 = 0;
                while (j2 < AppRunInfo.getRealCabSlot(i2)) {
                    cardId = AppRunInfo.getCurrCard(i2, j2);
                    if (cardId != 255) {
                        this.m_card[i2][j2].setText(AppCards.getCardName(cardId));
                        this.m_card[i2][j2].setVisible(true);
                    }
                    ++j2;
                }
            }
            this.m_cabinet[i2].setText(String.valueOf(AppLang.getText("Cabinet")) + (i2 + 1));
            this.m_panCab[i2].setVisible(true);
            ++i2;
        }
    }

    private void setVirtualData() {
        int cardId = 255;
        int i2 = 0;
        while (i2 < AppRunInfo.getVirtCabinet()) {
            int idx = i2;
            if (AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 55) {
                ++idx;
            }
            int j2 = 0;
            while (j2 < AppRunInfo.getVirtSlot(idx)) {
                cardId = AppRunInfo.getVirtCard(idx, j2);
                if (cardId != 255) {
                    this.m_card[i2 + 3][j2].setText(AppCards.getCardName(cardId));
                    this.m_card[i2 + 3][j2].setVisible(true);
                }
                ++j2;
            }
            this.m_cabinet[i2 + 3].setText(AppLang.getText("Cabinet" + (AppRunInfo.getRealCabinet() + i2 + 1)));
            this.m_panCab[i2 + 3].setVisible(true);
            ++i2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String[] command = e2.getActionCommand().split(":");
        String[] msgId = null;
        int cabinet = 0;
        int slot = 0;
        if (command[0].equals("system")) {
            msgId = AppCards.getMenuList(300).split(";");
        } else {
            cabinet = Integer.parseInt(command[0]);
            if (command.length > 1) {
                slot = Integer.parseInt(command[1]);
                msgId = cabinet >= 3 ? (AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 55 ? AppCards.getMenuList(AppRunInfo.getVirtCard(cabinet - 2, slot)).split(";") : AppCards.getMenuList(AppRunInfo.getVirtCard(cabinet - 3, slot)).split(";")) : (cabinet == 0 ? (slot == 0 && AppRunInfo.getSystem() != 23 && AppRunInfo.getSystem() != 55 ? AppCards.getMenuList(AppRunInfo.getCurrCard(cabinet, AppRunInfo.getRealCabSlot(0))).split(";") : (AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 55 ? AppCards.getMenuList(AppRunInfo.getCurrCard(cabinet, slot)).split(";") : AppCards.getMenuList(AppRunInfo.getCurrCard(cabinet, slot - 1)).split(";"))) : AppCards.getMenuList(AppRunInfo.getCurrCard(cabinet, slot)).split(";"));
            } else {
                msgId = cabinet >= 3 ? AppCards.getMenuList(302).split(";") : AppCards.getMenuList(301).split(";");
            }
        }
        AppTreeNode tnInfo = null;
        DefaultMutableTreeNode tn = null;
        boolean isFirst = true;
        int i2 = 0;
        while (i2 < msgId.length) {
            if (AppProperty.m_allMmcList.containsKey(msgId[i2])) {
                AppTopPanel top = new AppTopPanel();
                top.createCardPane(msgId);
                tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(msgId[i2]);
                tnInfo.setTopPanel(top);
                if (isFirst) {
                    tn = tnInfo.getTreeNode();
                    isFirst = false;
                }
            }
            ++i2;
        }
        if (!isFirst) {
            AppGlobal.g_frmMain.m_pagePane.openNewPage(tn);
        }
    }
}

