/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.quickport;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppPattern;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class P7202QuickTrunk
extends AppPage
implements KeyListener {
    private final int SIZE_WIDTH = 350;
    private final int SIZE_HEIGHT = 150;
    private AppPageInfo m_trunkInfo = null;
    private ArrayList m_trunkNum = null;
    private AppDialog m_dialog = null;
    private JTextField m_textbox = null;
    private JTextField m_txtTelnum = null;
    private JButton m_btnSech = null;
    private JButton[] m_button = new JButton[2];
    private JLabel m_label = new JLabel(AppLang.getText("Input the tel number"));
    private JLabel m_telLabel = new JLabel(AppLang.getText("Tel Number"));

    public P7202QuickTrunk(AppPageInfo pageInfo) {
        this.m_trunkNum = this.getTrunkAllNum();
        this.setPageInfo(pageInfo);
        this.showDialog();
    }

    private void showDialog() {
        this.m_dialog = new AppDialog();
        AppLayout layout = new AppLayout(this.m_dialog.m_contentPane, 350, 150);
        this.m_button[0] = new JButton(AppLang.getText("OK"));
        this.m_button[1] = new JButton(AppLang.getText("Cancel"));
        this.m_button[0].setFocusable(false);
        this.m_button[1].setFocusable(false);
        this.m_button[0].addActionListener(this);
        this.m_button[1].addActionListener(this);
        this.m_button[0].setActionCommand("Ok");
        this.m_button[1].setActionCommand("Cancel");
        this.m_textbox = new JTextField();
        this.m_textbox.addKeyListener(this);
        this.m_label.addKeyListener(this);
        this.m_textbox.setDocument(new AppPattern(4, "^[0-9]*$"));
        String sValue = "";
        int i2 = 0;
        while (i2 < this.m_trunkNum.size()) {
            sValue = String.valueOf(sValue) + (String)this.m_trunkNum.get(i2);
            if (i2 != this.m_trunkNum.size() - 1) {
                sValue = String.valueOf(sValue) + ", ";
            }
            ++i2;
        }
        this.m_textbox.setToolTipText(sValue);
        layout.addComponent(this.m_label, 5, 5, 150, 22);
        layout.addComponent(this.m_button[0], 260, 5, 80, 22);
        layout.addComponent(this.m_button[1], 260, 32, 80, 22);
        layout.addComponent(this.m_textbox, 5, 85, 335, 22);
        this.m_dialog.openDialog("Partial Request", 350, 150);
    }

    private ArrayList getTrunkAllNum() {
        ArrayList<String> trunkNum = new ArrayList<String>();
        this.m_trunkInfo = new AppPageInfo("7201");
        if (AppComm.getInstance().requestDownload(this.m_trunkInfo)) {
            ArrayList recvData = this.m_trunkInfo.getRecvData();
            int i2 = 0;
            while (i2 < recvData.size()) {
                ArrayList list = (ArrayList)recvData.get(i2);
                trunkNum.add((String)list.get(0));
                ++i2;
            }
        }
        return trunkNum;
    }

    @Override
    public void createPage() {
        if (this.m_recvData != null && this.m_recvData.size() > 0) {
            ArrayList recvData = (ArrayList)this.m_recvData.get(0);
            ArrayList<Object> compData = null;
            String sValue = "";
            this.m_colTitle = new String[1][1];
            this.m_colTitle[0][0] = (String)recvData.get(0);
            compData = new ArrayList<Object>();
            int j2 = 0;
            while (j2 < this.m_rowTitle.length) {
                sValue = (String)recvData.get(this.m_pageInfo.getDataPosition(j2));
                compData.add(j2, this.createComponent(j2, sValue));
                this.m_components.add(j2, compData);
                ++j2;
            }
            JPanel topPan = new JPanel(new BorderLayout());
            JPanel compPan = new JPanel(new FlowLayout(2));
            this.m_btnSech = new JButton("Search");
            this.m_btnSech.addActionListener(this);
            this.m_btnSech.setActionCommand("Search");
            AppGlobal.fixSize(this.m_btnSech, new Dimension(90, 22));
            this.m_txtTelnum = new JTextField(10);
            this.m_txtTelnum.addKeyListener(this);
            this.m_txtTelnum.setDocument(new AppPattern(4, "^[0-9]*$"));
            this.m_telLabel.addKeyListener(this);
            compPan.add(this.m_telLabel);
            compPan.add(this.m_txtTelnum);
            compPan.add(this.m_btnSech);
            topPan.add(compPan);
            this.m_jspTop.setPreferredSize(new Dimension(800, 40));
            this.m_jspTop.setHorizontalScrollBarPolicy(31);
            this.m_jspTop.getViewport().setView(topPan);
            this.m_jspTop.setVisible(true);
            this.createTable();
        }
    }

    @Override
    public void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)P7202QuickTrunk.this.m_components.get(col)).get(row);
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                ArrayList recvData = (ArrayList)P7202QuickTrunk.this.m_recvData.get(0);
                int pos = P7202QuickTrunk.this.m_pageInfo.getDataPosition(row);
                recvData.set(pos, P7202QuickTrunk.this.setComponentValue(row, aValue, (String)recvData.get(pos)));
                P7202QuickTrunk.this.m_recvData.set(0, recvData);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return P7202QuickTrunk.this.getCellEnable(col);
            }
        };
        this.setTableModel();
        this.setTableRowHidden();
    }

    public void checkRequest(String command, JTextField textbox) {
        if (!textbox.getText().trim().equals("")) {
            int inValue = Integer.parseInt(textbox.getText());
            int i2 = 0;
            while (i2 < this.m_trunkNum.size()) {
                int telNum = Integer.parseInt((String)this.m_trunkNum.get(i2));
                if (inValue == telNum) {
                    byte[] data = new byte[2];
                    int port = AppNumPlan.getPortNo(String.valueOf(inValue));
                    AppFunctions.short2byte(data, 0, (short)port);
                    this.m_pageInfo.setReqData(data);
                    this.m_pageInfo.setDownMsgType((byte)-44);
                    this.m_pageInfo.setRecordSize(2);
                    if (command.equals("Ok")) {
                        this.m_dialog.closeDialog();
                    } else {
                        this.m_contentPane.removeAll();
                    }
                    this.requestDownload();
                    return;
                }
                ++i2;
            }
            JOptionPane.showMessageDialog(null, AppLang.getText("Invalid"), AppLang.getText("Data Format Error"), 0);
        }
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Ok")) {
            this.checkRequest(command, this.m_textbox);
        } else if (command.equals("Cancel")) {
            this.m_dialog.closeDialog();
        } else if (command.equals("Search")) {
            this.checkRequest(command, this.m_txtTelnum);
        } else {
            this.actionPageToolButton(command);
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (e2.getSource().equals(this.m_textbox)) {
            if (e2.getKeyCode() == 10) {
                this.m_label.requestFocus();
                this.m_button[0].doClick();
            }
        } else if (e2.getSource().equals(this.m_label)) {
            if (e2.getKeyCode() == 10) {
                this.m_textbox.requestFocus();
            }
        } else if (e2.getSource().equals(this.m_txtTelnum)) {
            if (e2.getKeyCode() == 10) {
                this.m_btnSech.requestFocus();
                this.m_btnSech.doClick();
            }
        } else if (e2.getSource().equals(this.m_telLabel) && e2.getKeyCode() == 10) {
            this.m_btnSech.requestFocus();
        }
    }
}

