/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.systemcontrol;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class P6304MemoryDump
extends AppPage {
    private JButton[] m_btMove = new JButton[3];
    private AppTextBox m_txtAddr = new AppTextBox(2, 8);
    private String[] m_btTitle = new String[]{"Start", "Prev", "Next"};
    private JPanel m_btPanel = new JPanel(new BorderLayout());
    private long m_startAddr = 0L;

    public P6304MemoryDump(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        this.setTableTitle();
        this.createPage();
    }

    @Override
    public void createPage() {
        int i2 = 0;
        while (i2 < this.m_btMove.length) {
            this.m_btMove[i2] = new JButton(this.m_btTitle[i2]);
            this.m_btMove[i2].setActionCommand(this.m_btTitle[i2]);
            this.m_btMove[i2].addActionListener(new MoveButtonListener());
            ++i2;
        }
        JPanel addr = new JPanel(new GridLayout(1, 3));
        addr.add(new JLabel("Address", 4));
        addr.add(this.m_txtAddr.getComponent());
        addr.add(this.m_btMove[0]);
        addr.setPreferredSize(new Dimension(210, 20));
        JPanel button = new JPanel(new GridLayout(1, 2));
        button.add(this.m_btMove[1]);
        button.add(this.m_btMove[2]);
        JPanel jpButton = new JPanel(new BorderLayout());
        jpButton.add((Component)addr, "West");
        jpButton.add((Component)button, "Center");
        jpButton.setPreferredSize(new Dimension(350, 20));
        this.m_btPanel.add((Component)jpButton, "West");
        this.setComponents();
    }

    public void setComponents() {
        if (this.m_recvData == null || this.m_recvData.size() < 1) {
            this.m_rowTitle = new String[0][1];
        } else {
            ArrayList recvData = (ArrayList)this.m_recvData.get(0);
            ArrayList<AppTextBox> compData = null;
            String sValue = "";
            this.m_rowTitle = new String[64][1];
            int i2 = 0;
            while (i2 < this.m_rowTitle.length) {
                this.m_rowTitle[i2][0] = String.format("%08x", this.m_startAddr + (long)(i2 * 16)).toUpperCase();
                sValue = "";
                int j2 = 0;
                while (j2 < 16) {
                    sValue = String.valueOf(sValue) + String.format("%02x", Integer.parseInt((String)recvData.get(i2 * 16 + j2 + 1))).toUpperCase();
                    ++j2;
                }
                compData = new ArrayList<AppTextBox>();
                j2 = 0;
                while (j2 < 4) {
                    this.m_compText = new AppTextBox(2, 8);
                    this.m_compText.setText(sValue.substring(j2 * 8, (j2 + 1) * 8));
                    compData.add(j2, this.m_compText);
                    ++j2;
                }
                this.m_components.add(i2, compData);
                ++i2;
            }
        }
        this.createTable();
    }

    @Override
    public void createTable() {
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)P6304MemoryDump.this.m_components.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{100});
        this.m_model.setColWidth(new int[]{120, 120, 120, 120});
        this.m_model.setColHeaderColSpan(0, 0, 4);
        this.m_table = new AppTable(this.m_model);
        this.setPrintableComponent(this.m_table);
        this.m_contentPane.add((Component)this.m_btPanel, "North");
        this.m_contentPane.add((Component)this.m_table, "Center");
    }

    @Override
    public void actionToolButton(String command) {
        this.actionPageToolButton(command);
    }

    class MoveButtonListener
    implements ActionListener {
        MoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String command = e2.getActionCommand();
            String addr = P6304MemoryDump.this.m_txtAddr.getText().trim();
            long prevAddr = P6304MemoryDump.this.m_startAddr;
            if (addr.equals("")) {
                return;
            }
            byte[] reqData = new byte[1024];
            Arrays.fill(reqData, (byte)0);
            if (command.equals("Start")) {
                P6304MemoryDump.this.m_startAddr = Long.parseLong(addr, 16);
            } else if (command.equals("Prev")) {
                P6304MemoryDump.this.m_startAddr = P6304MemoryDump.this.m_startAddr - 1024L < 0L ? P6304MemoryDump.this.m_startAddr : P6304MemoryDump.this.m_startAddr - 1024L;
            } else if (command.equals("Next")) {
                P6304MemoryDump.this.m_startAddr = P6304MemoryDump.this.m_startAddr + 1024L > 0xFFFFFFFFL ? P6304MemoryDump.this.m_startAddr : P6304MemoryDump.this.m_startAddr + 1024L;
            } else {
                return;
            }
            AppFunctions.int2byte(reqData, 0, (int)P6304MemoryDump.this.m_startAddr);
            P6304MemoryDump.this.m_pageInfo.setRecordSize(reqData.length);
            P6304MemoryDump.this.m_pageInfo.setReqData(reqData);
            if (AppComm.getInstance().requestDownload(P6304MemoryDump.this.m_pageInfo)) {
                P6304MemoryDump.this.m_txtAddr.setText(String.format("%08x", P6304MemoryDump.this.m_startAddr).toUpperCase());
                P6304MemoryDump.this.m_recvData.clear();
                P6304MemoryDump.this.m_recvData = P6304MemoryDump.this.m_pageInfo.getRecvData();
                P6304MemoryDump.this.setComponents();
            } else {
                P6304MemoryDump.this.m_startAddr = prevAddr;
            }
        }
    }
}

