/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.components;

import com.sec.osdm.common.AppLang;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class AppCellCombo
extends JComboBox
implements FocusListener,
KeyListener {
    public AppCellCombo m_this = null;

    public AppCellCombo() {
        this.m_this = this;
        this.prepareShow();
    }

    public AppCellCombo(String[] items) {
        this.setModel(new AppComboModel(items));
        this.prepareShow();
    }

    public AppCellCombo(String[] items, int[] values) {
        this.setModel(new AppComboModel(items, values));
        this.prepareShow();
    }

    public void prepareShow() {
        BasicComboBoxUI ui = new BasicComboBoxUI();
        this.setUI(ui);
        this.setBackground(Color.WHITE);
        this.addKeyListener(this);
    }

    @Override
    public String toString() {
        Object obj = this.getSelectedItem();
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        int nModifiers = e2.getModifiers();
        if (nModifiers == 2 && e2.getKeyCode() == 67) {
            StringSelection str = new StringSelection(this.getSelectedItem().toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(str, str);
            e2.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void processKeyEvent(KeyEvent e2) {
        if (e2.getKeyCode() == 9 || e2.getKeyCode() == 10) {
            this.hidePopup();
        }
        super.processKeyEvent(e2);
    }

    @Override
    public void focusGained(FocusEvent e2) {
    }

    @Override
    public void focusLost(FocusEvent e2) {
    }

    public static class AppComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private String[] m_items = null;
        private int[] m_values = null;
        public int m_selIndex = -1;

        public AppComboModel() {
            this.createSelectItems(null, null);
        }

        public AppComboModel(String[] items) {
            this.createSelectItems(items, null);
        }

        public AppComboModel(String[] items, int[] values) {
            this.createSelectItems(items, values);
        }

        private void createSelectItems(String[] items, int[] values) {
            block6: {
                this.m_items = null;
                this.m_values = null;
                if (items == null) break block6;
                this.m_items = new String[items.length];
                this.m_values = new int[items.length];
                if (values == null) {
                    int i2 = 0;
                    int j2 = 0;
                    while (i2 < items.length) {
                        String[] item = items[i2].split(":");
                        if (item.length > 1) {
                            j2 = Integer.parseInt(item[0]);
                            this.m_items[i2] = AppLang.getText(item[1]);
                        } else {
                            this.m_items[i2] = AppLang.getText(item[0]);
                        }
                        this.m_values[i2] = j2++;
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < items.length) {
                        this.m_items[i3] = AppLang.getText(items[i3]);
                        this.m_values[i3] = i3;
                        ++i3;
                    }
                }
            }
        }

        public int getSelectedValue() {
            try {
                return this.m_values[this.m_selIndex];
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public void setSelectedValue(int value) {
            try {
                int i2 = 0;
                while (i2 < this.m_values.length) {
                    if (value == this.m_values[i2]) {
                        this.m_selIndex = i2;
                        return;
                    }
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_selIndex = 0;
        }

        public String getSelectedItemValue() {
            try {
                return this.m_items[this.m_selIndex];
            }
            catch (Exception exception) {
                return "";
            }
        }

        public void setSelectedItemValue(String item) {
            try {
                int i2 = 0;
                while (i2 < this.m_items.length) {
                    if ((item = AppLang.getText(item)).equals(this.m_items[i2])) {
                        this.m_selIndex = i2;
                        return;
                    }
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_selIndex = 0;
        }

        public int getSelectedIndex() {
            return this.m_selIndex;
        }

        public void setSelectedIndex(int index) {
            this.m_selIndex = index;
        }

        @Override
        public Object getSelectedItem() {
            try {
                return this.m_items[this.m_selIndex];
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void setSelectedItem(Object item) {
            this.m_selIndex = 0;
            try {
                int i2 = 0;
                while (i2 < this.m_items.length) {
                    if ((item = AppLang.getText(item.toString())).equals(this.m_items[i2])) {
                        this.m_selIndex = i2;
                        return;
                    }
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getIndex(String item) {
            try {
                int i2 = 0;
                while (i2 < this.m_items.length) {
                    if ((item = AppLang.getText(item)).equals(this.m_items[i2])) {
                        return i2;
                    }
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            try {
                return this.m_items[index];
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public int getSize() {
            return this.m_items.length;
        }

        public String[] getItems() {
            return this.m_items;
        }

        @Override
        public void removeListDataListener(ListDataListener l2) {
        }

        @Override
        public void addListDataListener(ListDataListener l2) {
        }
    }
}

