/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ConferenceTableLabelRenderer
extends JLabel
implements TableCellRenderer {
    private Color m_bgColor = null;
    private Color m_fgColor = null;
    private Border m_border = null;
    private Font m_font = null;
    private int m_cellAlignment = -1;
    private boolean m_fHeader = false;

    public ConferenceTableLabelRenderer() {
        this.m_fHeader = true;
        this.m_cellAlignment = 0;
    }

    public ConferenceTableLabelRenderer(Color foreColor, Color bgColor, int cellAlignment, Font font, Border border) {
        this.m_fHeader = false;
        this.setRenderer(foreColor, bgColor, cellAlignment, font, border);
    }

    public ConferenceTableLabelRenderer(JTable table, int cellAlignment) {
        this.m_fHeader = true;
        this.setHeaderStyleRenderer(table, cellAlignment);
        this.m_cellAlignment = cellAlignment;
    }

    private void setHeaderStyleRenderer(JTable table, int cellAlignment) {
        this.m_fHeader = true;
        JTableHeader header = table.getTableHeader();
        this.setRenderer(header.getForeground(), header.getBackground(), cellAlignment, header.getFont(), UIManager.getBorder("TableHeader.cellBorder"));
    }

    private void setRenderer(Color foreColor, Color bgColor, int cellAlignment, Font font, Border border) {
        this.setOpaque(true);
        this.m_fgColor = foreColor;
        this.m_bgColor = bgColor;
        this.m_border = border;
        this.m_font = font;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof String) {
            if (Integer.parseInt((String)AppProperty.m_properties.get("USER_LANG")) == 4) {
                this.setIcon(this.getImageIcon_24hours(value));
            } else {
                this.setIcon(this.getImageIcon(value));
            }
        }
        if (this.m_fHeader) {
            if (this.m_cellAlignment != -1) {
                this.setHorizontalAlignment(this.m_cellAlignment);
            }
            this.setFont(table.getTableHeader().getFont());
            super.setForeground(this.m_fgColor != null ? this.m_fgColor : table.getTableHeader().getForeground());
            super.setBackground(this.m_bgColor != null ? this.m_bgColor : table.getTableHeader().getBackground());
        } else {
            Font font = null;
            font = this.m_font != null ? this.m_font : table.getFont();
            this.setFont(font);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.m_fgColor != null ? this.m_fgColor : table.getForeground());
                super.setBackground(this.m_bgColor != null ? this.m_bgColor : table.getBackground());
            }
        }
        if (!this.m_fHeader) {
            Border border = null;
            border = isSelected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : BorderFactory.createEmptyBorder();
            this.setBorder(border);
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        this.setText(value == null ? "" : " " + value.toString());
        return this;
    }

    private ImageIcon getImageIcon(Object value) {
        String path = "/resources/images/page/times/";
        if (value.toString().equals("AM12")) {
            path = String.valueOf(path) + "A12.png";
        } else if (value.toString().equals("AM01")) {
            path = String.valueOf(path) + "A01.png";
        } else if (value.toString().equals("AM02")) {
            path = String.valueOf(path) + "A02.png";
        } else if (value.toString().equals("AM03")) {
            path = String.valueOf(path) + "A03.png";
        } else if (value.toString().equals("AM04")) {
            path = String.valueOf(path) + "A04.png";
        } else if (value.toString().equals("AM05")) {
            path = String.valueOf(path) + "A05.png";
        } else if (value.toString().equals("AM06")) {
            path = String.valueOf(path) + "A06.png";
        } else if (value.toString().equals("AM07")) {
            path = String.valueOf(path) + "A07.png";
        } else if (value.toString().equals("AM08")) {
            path = String.valueOf(path) + "A08.png";
        } else if (value.toString().equals("AM09")) {
            path = String.valueOf(path) + "A09.png";
        } else if (value.toString().equals("AM10")) {
            path = String.valueOf(path) + "A10.png";
        } else if (value.toString().equals("AM11")) {
            path = String.valueOf(path) + "A11.png";
        } else if (value.toString().equals("PM12")) {
            path = String.valueOf(path) + "P12.png";
        } else if (value.toString().equals("PM01")) {
            path = String.valueOf(path) + "P01.png";
        } else if (value.toString().equals("PM02")) {
            path = String.valueOf(path) + "P02.png";
        } else if (value.toString().equals("PM03")) {
            path = String.valueOf(path) + "P03.png";
        } else if (value.toString().equals("PM04")) {
            path = String.valueOf(path) + "P04.png";
        } else if (value.toString().equals("PM05")) {
            path = String.valueOf(path) + "P05.png";
        } else if (value.toString().equals("PM06")) {
            path = String.valueOf(path) + "P06.png";
        } else if (value.toString().equals("PM07")) {
            path = String.valueOf(path) + "P07.png";
        } else if (value.toString().equals("PM08")) {
            path = String.valueOf(path) + "P08.png";
        } else if (value.toString().equals("PM09")) {
            path = String.valueOf(path) + "P09.png";
        } else if (value.toString().equals("PM10")) {
            path = String.valueOf(path) + "P10.png";
        } else if (value.toString().equals("PM11")) {
            path = String.valueOf(path) + "P11.png";
        }
        return new ImageIcon(ConferenceTableLabelRenderer.class.getResource(path));
    }

    private ImageIcon getImageIcon_24hours(Object value) {
        String path = "/resources/images/page/times_24hours/";
        path = String.valueOf(path) + value.toString() + ".png";
        return new ImageIcon(ConferenceTableLabelRenderer.class.getResource(path));
    }
}

