/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class P2025StatusScreen
extends AppPage {
    private AppTable m_table1 = null;
    private AppTableModel m_model1 = null;
    private String[][] m_rowTitle1 = null;
    private String[][] m_colTitle1 = null;
    private String[][] m_corner1 = null;
    private ArrayList m_components1 = new ArrayList();
    private RefreshThread m_refreshThread = null;
    private Socket m_socket = null;
    private byte[] m_header = null;
    private boolean m_bSocConn = false;
    private static final int STATUS_PACKET_SIZE = 3648;
    private static final int STATUS_PACKET_SIZE2 = 3652;
    boolean bIsRun = false;

    public P2025StatusScreen(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        pageInfo.setDownMsgType((byte)-34);
        this.m_bSocConn = this.setSocket();
        this.requestDownload();
    }

    @Override
    public void createPage() {
        this.createComponents();
        this.createTable();
    }

    public void createComponents() {
        this.m_corner = new String[][]{{"Port"}};
        this.m_colTitle = new String[][]{{"Mode", "Active Block", "Status"}};
        this.m_rowTitle = AppRunInfo.getSystem() == 34 ? new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}} : (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50 ? new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"10"}, {"11"}, {"12"}, {"13"}, {"14"}, {"15"}, {"16"}, {"17"}, {"18"}, {"19"}, {"20"}} : new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        this.m_corner1 = new String[][]{{"Reporting"}};
        this.m_colTitle1 = new String[][]{{""}};
        this.m_rowTitle1 = new String[][]{{"Calls To-Date"}, {"Average Calls per Week"}, {"Directory Accesses"}, {"Times All Ports Busy"}, {"Number of Subscribers"}, {"Total Message Count"}, {"Avg Messages/Mailbox"}, {"Disk Space Available (HH:MM)"}};
        this.setComponents();
    }

    private void setComponents() {
        this.resetComponent();
        ArrayList recvData = (ArrayList)this.m_recvData.get(0);
        ArrayList<AppTextBox> compData = null;
        this.m_colTitle1[0][0] = String.valueOf((String)recvData.get(261)) + " ~ " + (String)recvData.get(262) + " " + (String)recvData.get(263);
        int idx = 0;
        idx = AppRunInfo.getSystem() == 34 ? 6 : (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50 ? 20 : 4);
        int i2 = 0;
        while (i2 < idx) {
            compData = new ArrayList<AppTextBox>();
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(i2 + 66));
            compData.add(0, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(i2 + 131));
            compData.add(1, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText(AppLang.getText((String)recvData.get(i2 + 196)));
            compData.add(2, this.m_compText);
            this.m_components.add(i2, compData);
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            this.m_compText = new AppTextBox();
            if (i2 == 5) {
                if (recvData.size() > 272) {
                    this.m_compText.setText((String)recvData.get(272));
                } else {
                    this.m_compText.setText((String)recvData.get(i2 + 264));
                }
            } else if (i2 == 6) {
                int val = Integer.parseInt((String)recvData.get(i2 + 264));
                this.m_compText.setText(String.valueOf(val / 10) + "." + val % 10);
            } else {
                this.m_compText.setText((String)recvData.get(i2 + 264));
            }
            this.m_components1.add(i2, this.m_compText);
            ++i2;
        }
    }

    @Override
    public void createTable() {
        this.m_arrComponent.clear();
        this.createTable1();
        this.createTable2();
        this.m_table.setPreferredSize(new Dimension(600, (this.m_model.getRowHdrRowCount() + 1) * 22));
        AppLayout layout = new AppLayout(this.m_contentPane, this.m_contentPane.getWidth(), this.m_contentPane.getHeight());
        layout.addComponent(this.m_table, 0, 0, 433, 461);
        layout.addComponent(this.m_table1, 438, 0, 433, 461);
        if (this.m_bSocConn && this.m_refreshThread == null) {
            this.m_refreshThread = new RefreshThread();
            this.bIsRun = true;
            this.m_refreshThread.start();
        }
    }

    private void createTable1() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)P2025StatusScreen.this.m_components.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{100});
        this.m_model.setColWidth(new int[]{80, 150, 100});
        this.m_table = new AppTable(this.m_model);
    }

    private void createTable2() {
        this.m_model1 = new AppTableModel(this.m_rowTitle1, this.m_colTitle1, this.m_corner1){

            @Override
            public Object getValueAt(int row, int col) {
                return (AppTextBox)P2025StatusScreen.this.m_components1.get(row);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model1.setRowWidth(new int[]{200});
        this.m_model1.setColWidth(new int[]{230});
        this.m_table1 = new AppTable(this.m_model1);
        this.setPrintableComponent(this.m_table1);
    }

    private void resetComponent() {
        this.m_components.clear();
        this.m_components1.clear();
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
            this.m_contentPane.remove(this.m_table1);
            this.m_model1 = null;
            this.m_table1 = null;
        }
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Close")) {
            this.stopThread();
            this.disConnetSocket();
        }
        this.actionPageToolButton(command);
    }

    private boolean setSocket() {
        try {
            this.m_header = new byte[18];
            this.m_header[0] = 115;
            this.m_header[1] = 113;
            this.m_header[2] = this.m_msgType;
            this.m_header[3] = -1;
            AppFunctions.short2byte(this.m_header, 4, (short)Integer.parseInt(this.m_pageInfo.getMsgId(), 16));
            AppFunctions.short2byte(this.m_header, 6, (short)this.m_pageInfo.getRecordSize());
            AppFunctions.int2byte(this.m_header, 8, this.m_pageInfo.getMsgLength());
            AppFunctions.short2byte(this.m_header, 12, (short)-1);
            this.m_header[14] = this.m_pageInfo.getMsgResponse();
            this.m_header[15] = -1;
            this.m_header[16] = -1;
            this.m_header[17] = -1;
            this.m_socket = new Socket();
            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                this.m_socket.connect(new InetSocketAddress(AppNetwork.m_address_SVMi20i, 6002), 2000);
            } else {
                this.m_socket.connect(new InetSocketAddress(AppNetwork.m_address, 6002), 2000);
            }
            return true;
        }
        catch (UnknownHostException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Server IP address is not exist."));
            return false;
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to create socket."));
            return false;
        }
    }

    private boolean requestSendData(byte msgType) {
        if (this.m_socket != null && this.m_socket.isConnected()) {
            this.m_header[2] = msgType;
            OutputStream os = null;
            try {
                os = this.m_socket.getOutputStream();
                os.write(this.m_header);
                os.flush();
            }
            catch (IOException e2) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean disConnetSocket() {
        if (this.m_socket != null) {
            try {
                this.requestSendData((byte)2);
                this.m_socket.close();
                this.m_socket = null;
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resetPage() {
        InputStream is = null;
        byte[] m_bTemp = new byte[0x200000];
        byte[] m_bTemp2 = new byte[3648];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int msgLen = -1;
        int failCount = 0;
        try {
            is = this.m_socket.getInputStream();
            while ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) != -1) {
                int tempSize = nRead / 3648;
                int addSize = nRead - tempSize * 3648;
                if (nRead > 3648) {
                    System.arraycopy(m_bTemp, tempSize * 3648, m_bTemp2, 0, addSize);
                    System.arraycopy(m_bTemp2, 0, m_bTemp, 0, addSize);
                }
                if ((nRead + nOffset) % 3648 != 0 && nRead != 0 && nRead > 3648) {
                    nOffset = addSize;
                    if (++failCount <= 3) continue;
                    return false;
                }
                if (nRead >= 18 && msgLen == -1 && (msgLen = AppFunctions.byte2int(m_bTemp, 8)) != 3630) {
                    return false;
                }
                if (msgLen < 0 || (nOffset += nRead) < msgLen + 18) continue;
            }
            if (msgLen <= 0) return false;
            m_bData = new byte[msgLen];
            System.arraycopy(m_bTemp, 18, m_bData, 0, msgLen);
            this.m_pageInfo.setRespData(m_bData);
            P2025StatusScreen.makeReceiveData(this.m_pageInfo);
            this.m_recvData = this.m_pageInfo.getRecvData();
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private boolean resetPage2() {
        int msgLen;
        byte[] m_bData;
        byte[] m_bTemp2;
        block10: {
            int packetSize;
            int nRead;
            byte[] m_bTemp;
            block9: {
                InputStream is;
                block8: {
                    is = null;
                    m_bTemp = new byte[0x200000];
                    m_bTemp2 = null;
                    m_bData = null;
                    nRead = 0;
                    msgLen = -1;
                    packetSize = 0;
                    try {
                        is = this.m_socket.getInputStream();
                        if (is.available() != 0) break block8;
                        return true;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return false;
                    }
                }
                nRead = is.read(m_bTemp, 0, m_bTemp.length);
                if (nRead % 3648 == 0) {
                    packetSize = 3648;
                    break block9;
                }
                if (nRead % 3652 == 0) {
                    packetSize = 3652;
                    break block9;
                }
                return false;
            }
            m_bTemp2 = new byte[packetSize];
            System.arraycopy(m_bTemp, nRead - packetSize, m_bTemp2, 0, packetSize);
            msgLen = AppFunctions.byte2int(m_bTemp2, 8);
            if (msgLen == packetSize - 18) break block10;
            return false;
        }
        if (msgLen > 0) {
            m_bData = new byte[msgLen];
            System.arraycopy(m_bTemp2, 18, m_bData, 0, msgLen);
            this.m_pageInfo.setRespData(m_bData);
            P2025StatusScreen.makeReceiveData(this.m_pageInfo);
            this.m_recvData = this.m_pageInfo.getRecvData();
            return true;
        }
        return false;
    }

    public static void makeReceiveData(AppPageInfo pageinfo) {
        ArrayList<String> recvRecord = null;
        ArrayList recvPacket = new ArrayList();
        byte[] recvData = pageinfo.getRespData();
        int[] typeList = pageinfo.getDataType();
        int[] sizeList = pageinfo.getDataSize();
        int recordSize = pageinfo.getRecordSize();
        short sValue = 0;
        int iValue = 0;
        int pos = 0;
        String value = "";
        int i2 = 0;
        while (i2 < recvData.length) {
            pos = i2;
            recvRecord = new ArrayList<String>();
            int j2 = 0;
            while (j2 < pageinfo.getFieldCount()) {
                if (pos >= recvData.length) break;
                switch (typeList[j2]) {
                    case 0: 
                    case 1: 
                    case 13: {
                        value = AppFunctions.unsignedValue(recvData[pos]);
                        if (typeList[j2] != 13 && pageinfo.getFieldType(j2) != 4 && value.equals("255")) {
                            recvRecord.add("");
                            break;
                        }
                        if (typeList[j2] == 1) {
                            recvRecord.add("" + (Integer.parseInt(value) + 1));
                            break;
                        }
                        recvRecord.add(value);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 14: 
                    case 16: {
                        sValue = AppFunctions.byte2short(recvData, pos);
                        value = typeList[j2] != 16 ? AppFunctions.unsignedValue(sValue) : "" + sValue;
                        if (typeList[j2] != 14 && value.equals("65535")) {
                            recvRecord.add("");
                            break;
                        }
                        if (typeList[j2] == 3) {
                            recvRecord.add("" + (Integer.parseInt(value) + 1));
                            break;
                        }
                        recvRecord.add(value);
                        break;
                    }
                    case 4: 
                    case 5: {
                        iValue = AppFunctions.byte2int(recvData, pos);
                        value = AppFunctions.unsignedValue(iValue);
                        if (value.equals("4294967295")) {
                            recvRecord.add("");
                            break;
                        }
                        if (typeList[j2] == 4) {
                            recvRecord.add(value);
                            break;
                        }
                        recvRecord.add("" + (Integer.parseInt(value) + 1));
                        break;
                    }
                    case 6: {
                        recvRecord.add(AppFunctions.byte2ip(recvData, pos, sizeList[j2]));
                        break;
                    }
                    case 7: {
                        recvRecord.add(AppFunctions.byte2str(recvData, pos, sizeList[j2]));
                        break;
                    }
                    case 17: {
                        recvRecord.add(AppFunctions.byte2str(recvData, pos, sizeList[j2], "UTF-8"));
                        break;
                    }
                    case 8: {
                        recvRecord.add(AppFunctions.byte2tel(recvData[pos], recvData[pos + 1]));
                        break;
                    }
                    case 9: {
                        recvRecord.add(AppNumPlan.getTelNumber(Integer.parseInt(AppFunctions.unsignedValue(AppFunctions.byte2short(recvData, pos)))));
                        break;
                    }
                    case 10: {
                        recvRecord.add(AppFunctions.byte2mac(recvData, pos));
                        break;
                    }
                    case 11: {
                        recvRecord.add(AppFunctions.byte2bit(Integer.parseInt(AppFunctions.unsignedValue(recvData[pos])), true));
                        break;
                    }
                    case 12: {
                        recvRecord.add(AppFunctions.byte2bit(Integer.parseInt(AppFunctions.unsignedValue(recvData[pos])), false));
                        break;
                    }
                    case 15: {
                        sValue = AppFunctions.byte2short(recvData, pos);
                        value = AppFunctions.unsignedValue(sValue);
                        int port = Integer.parseInt(value);
                        String tel = AppNumPlan.getTelNumber(port);
                        if (tel.equals("")) {
                            tel = String.format("%04x", port).toUpperCase();
                            tel = tel.replaceAll("A", "*");
                            tel = tel.replaceAll("B", "#");
                            tel = tel.replaceAll("F", "");
                            recvRecord.add(tel);
                            break;
                        }
                        recvRecord.add(tel);
                    }
                }
                pos += sizeList[j2];
                ++j2;
            }
            recvPacket.add(recvRecord);
            i2 += recordSize;
        }
        pageinfo.setRecvData(recvPacket);
    }

    public void stopThread() {
        if (this.m_refreshThread != null) {
            this.bIsRun = false;
            this.m_refreshThread = null;
        }
    }

    class RefreshThread
    extends Thread {
        int m_aliveCount = 0;

        RefreshThread() {
        }

        @Override
        public void run() {
            while (P2025StatusScreen.this.bIsRun) {
                try {
                    RefreshThread.sleep(1000L);
                    if (P2025StatusScreen.this.resetPage2()) {
                        P2025StatusScreen.this.setComponents();
                        P2025StatusScreen.this.createTable();
                        P2025StatusScreen.this.m_table.tableChanged(null);
                        P2025StatusScreen.this.m_table1.tableChanged(null);
                    }
                    ++this.m_aliveCount;
                    if (this.m_aliveCount > 90) {
                        P2025StatusScreen.this.bIsRun = false;
                        JOptionPane.showMessageDialog(null, AppLang.getText("Disconnect Status Screen"), AppLang.getText("Information"), 1);
                        P2025StatusScreen.this.actionToolButton("Close");
                        return;
                    }
                    if (this.m_aliveCount % 30 != 0 || !P2025StatusScreen.this.requestSendData((byte)3)) continue;
                    this.m_aliveCount = 0;
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

