/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net;

import com.sun.net.TelnetProtocolException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TelnetInputStream
extends FilterInputStream {
    boolean stickyCRLF = false;
    boolean seenCR = false;
    public boolean binaryMode = false;

    public TelnetInputStream(InputStream fd, boolean binary) {
        super(fd);
        this.binaryMode = binary;
    }

    public void setStickyCRLF(boolean on) {
        this.stickyCRLF = on;
    }

    @Override
    public int read() throws IOException {
        if (this.binaryMode) {
            return super.read();
        }
        if (this.seenCR) {
            this.seenCR = false;
            return 10;
        }
        int c2 = super.read();
        if (c2 == 13) {
            c2 = super.read();
            switch (c2) {
                default: {
                    throw new TelnetProtocolException("misplaced CR in input");
                }
                case 0: {
                    return 13;
                }
                case 10: 
            }
            if (this.stickyCRLF) {
                this.seenCR = true;
                return 13;
            }
            return 10;
        }
        return c2;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int length) throws IOException {
        if (this.binaryMode) {
            return super.read(bytes, off, length);
        }
        int offStart = off;
        while (--length >= 0) {
            int c2 = this.read();
            if (c2 == -1) break;
            bytes[off++] = (byte)c2;
        }
        return off > offStart ? off - offStart : -1;
    }
}

