/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Pattern;

public class XML {
    private OutputStream out;
    private String encoding;
    private Workbook workbook;

    public XML(Workbook w2, OutputStream out, String enc, boolean f2) throws IOException {
        this.encoding = enc;
        this.workbook = w2;
        this.out = out;
        if (this.encoding == null || !this.encoding.equals("UnicodeBig")) {
            this.encoding = "UTF8";
        }
        if (f2) {
            this.writeFormattedXML();
        } else {
            this.writeXML();
        }
    }

    private void writeXML() throws IOException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(this.out, this.encoding);
            BufferedWriter bw2 = new BufferedWriter(osw);
            bw2.write("<?xml version=\"1.0\" ?>");
            bw2.newLine();
            bw2.write("<!DOCTYPE workbook SYSTEM \"workbook.dtd\">");
            bw2.newLine();
            bw2.newLine();
            bw2.write("<workbook>");
            bw2.newLine();
            for (int sheet = 0; sheet < this.workbook.getNumberOfSheets(); ++sheet) {
                Sheet s2 = this.workbook.getSheet(sheet);
                bw2.write("  <sheet>");
                bw2.newLine();
                bw2.write("    <name><![CDATA[" + s2.getName() + "]]></name>");
                bw2.newLine();
                Cell[] row = null;
                for (int i2 = 0; i2 < s2.getRows(); ++i2) {
                    bw2.write("    <row number=\"" + i2 + "\">");
                    bw2.newLine();
                    row = s2.getRow(i2);
                    for (int j2 = 0; j2 < row.length; ++j2) {
                        if (row[j2].getType() == CellType.EMPTY) continue;
                        bw2.write("      <col number=\"" + j2 + "\">");
                        bw2.write("<![CDATA[" + row[j2].getContents() + "]]>");
                        bw2.write("</col>");
                        bw2.newLine();
                    }
                    bw2.write("    </row>");
                    bw2.newLine();
                }
                bw2.write("  </sheet>");
                bw2.newLine();
            }
            bw2.write("</workbook>");
            bw2.newLine();
            bw2.flush();
            bw2.close();
        }
        catch (UnsupportedEncodingException e2) {
            System.err.println(e2.toString());
        }
    }

    private void writeFormattedXML() throws IOException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(this.out, this.encoding);
            BufferedWriter bw2 = new BufferedWriter(osw);
            bw2.write("<?xml version=\"1.0\" ?>");
            bw2.newLine();
            bw2.write("<!DOCTYPE workbook SYSTEM \"formatworkbook.dtd\">");
            bw2.newLine();
            bw2.newLine();
            bw2.write("<workbook>");
            bw2.newLine();
            for (int sheet = 0; sheet < this.workbook.getNumberOfSheets(); ++sheet) {
                Sheet s2 = this.workbook.getSheet(sheet);
                bw2.write("  <sheet>");
                bw2.newLine();
                bw2.write("    <name><![CDATA[" + s2.getName() + "]]></name>");
                bw2.newLine();
                Cell[] row = null;
                CellFormat format = null;
                Font font = null;
                for (int i2 = 0; i2 < s2.getRows(); ++i2) {
                    bw2.write("    <row number=\"" + i2 + "\">");
                    bw2.newLine();
                    row = s2.getRow(i2);
                    for (int j2 = 0; j2 < row.length; ++j2) {
                        if (row[j2].getType() == CellType.EMPTY && row[j2].getCellFormat() == null) continue;
                        format = row[j2].getCellFormat();
                        bw2.write("      <col number=\"" + j2 + "\">");
                        bw2.newLine();
                        bw2.write("        <data>");
                        bw2.write("<![CDATA[" + row[j2].getContents() + "]]>");
                        bw2.write("</data>");
                        bw2.newLine();
                        if (row[j2].getCellFormat() != null) {
                            bw2.write("        <format wrap=\"" + format.getWrap() + "\"");
                            bw2.newLine();
                            bw2.write("                align=\"" + format.getAlignment().getDescription() + "\"");
                            bw2.newLine();
                            bw2.write("                valign=\"" + format.getVerticalAlignment().getDescription() + "\"");
                            bw2.newLine();
                            bw2.write("                orientation=\"" + format.getOrientation().getDescription() + "\"");
                            bw2.write(">");
                            bw2.newLine();
                            font = format.getFont();
                            bw2.write("          <font name=\"" + font.getName() + "\"");
                            bw2.newLine();
                            bw2.write("                point_size=\"" + font.getPointSize() + "\"");
                            bw2.newLine();
                            bw2.write("                bold_weight=\"" + font.getBoldWeight() + "\"");
                            bw2.newLine();
                            bw2.write("                italic=\"" + font.isItalic() + "\"");
                            bw2.newLine();
                            bw2.write("                underline=\"" + font.getUnderlineStyle().getDescription() + "\"");
                            bw2.newLine();
                            bw2.write("                colour=\"" + font.getColour().getDescription() + "\"");
                            bw2.newLine();
                            bw2.write("                script=\"" + font.getScriptStyle().getDescription() + "\"");
                            bw2.write(" />");
                            bw2.newLine();
                            if (format.getBackgroundColour() != Colour.DEFAULT_BACKGROUND || format.getPattern() != Pattern.NONE) {
                                bw2.write("          <background colour=\"" + format.getBackgroundColour().getDescription() + "\"");
                                bw2.newLine();
                                bw2.write("                      pattern=\"" + format.getPattern().getDescription() + "\"");
                                bw2.write(" />");
                                bw2.newLine();
                            }
                            if (format.getBorder(Border.TOP) != BorderLineStyle.NONE || format.getBorder(Border.BOTTOM) != BorderLineStyle.NONE || format.getBorder(Border.LEFT) != BorderLineStyle.NONE || format.getBorder(Border.RIGHT) != BorderLineStyle.NONE) {
                                bw2.write("          <border top=\"" + format.getBorder(Border.TOP).getDescription() + "\"");
                                bw2.newLine();
                                bw2.write("                  bottom=\"" + format.getBorder(Border.BOTTOM).getDescription() + "\"");
                                bw2.newLine();
                                bw2.write("                  left=\"" + format.getBorder(Border.LEFT).getDescription() + "\"");
                                bw2.newLine();
                                bw2.write("                  right=\"" + format.getBorder(Border.RIGHT).getDescription() + "\"");
                                bw2.write(" />");
                                bw2.newLine();
                            }
                            if (!format.getFormat().getFormatString().equals("")) {
                                bw2.write("          <format_string string=\"");
                                bw2.write(format.getFormat().getFormatString());
                                bw2.write("\" />");
                                bw2.newLine();
                            }
                            bw2.write("        </format>");
                            bw2.newLine();
                        }
                        bw2.write("      </col>");
                        bw2.newLine();
                    }
                    bw2.write("    </row>");
                    bw2.newLine();
                }
                bw2.write("  </sheet>");
                bw2.newLine();
            }
            bw2.write("</workbook>");
            bw2.newLine();
            bw2.flush();
            bw2.close();
        }
        catch (UnsupportedEncodingException e2) {
            System.err.println(e2.toString());
        }
    }
}

