/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppRunInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtil {
    private static final String ALGORITHM_AES = "AES";

    public static byte[] digest(String alg, byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(alg);
        return md.digest(input);
    }

    public static byte[] digest(String alg, byte[] input, byte[] key) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(alg);
        md.update(key);
        return md.digest(input);
    }

    public static String getCryptoAESString(String value) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(AppRunInfo.getEncryptKey().getBytes(), ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(value.getBytes());
        return SecurityUtil.ArrayToHex(encrypted);
    }

    public static byte[] getCryptoAESByte(String value) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(AppRunInfo.getEncryptKey().getBytes(), ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(value.getBytes());
        return encrypted;
    }

    public static byte[] HexToArray(String hex) {
        byte[] strbuf = new byte[hex.length() / 2];
        int i2 = 0;
        while (i2 < strbuf.length) {
            String output = hex.substring(i2 * 2, i2 * 2 + 2);
            int decimal = Integer.parseInt(output, 16);
            strbuf[i2] = (byte)decimal;
            ++i2;
        }
        return strbuf;
    }

    public static String ArrayToHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        int i2 = 0;
        while (i2 < buf.length) {
            if ((buf[i2] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i2] & 0xFF, 16).toUpperCase());
            ++i2;
        }
        return strbuf.toString();
    }

    public static String getAESDecodedString(String encryptedValue) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(AppRunInfo.getEncryptKey().getBytes(), ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
        cipher.init(2, skeySpec);
        byte[] encrypted = SecurityUtil.HexToArray(encryptedValue);
        byte[] decrypted = cipher.doFinal(encrypted);
        String value = new String(decrypted);
        return value;
    }

    public static String getAESDecodedByte(byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(AppRunInfo.getEncryptKey().getBytes(), ALGORITHM_AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        String value = new String(decrypted);
        return value;
    }

    public static void main(String[] args) throws Exception {
    }
}

