/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;

public final class AppINIFile {
    private Ini m_iniFile = new Ini();
    private String m_iniPath = null;
    private Hashtable m_section = new Hashtable();

    public AppINIFile(String file) {
        this.m_iniPath = file;
        try {
            this.m_iniFile.load(new File(this.m_iniPath));
            for (Map.Entry en : this.m_iniFile.entrySet()) {
                this.m_section.put(en.getKey(), this.m_iniFile.get(en.getKey()));
            }
            this.m_iniFile = null;
        }
        catch (InvalidFileFormatException e2) {
            e2.printStackTrace();
            AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid file format."));
        }
        catch (IOException e3) {
            e3.printStackTrace();
            AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("IO Exception."));
        }
    }

    public Hashtable getAllData() {
        return this.m_section;
    }

    public Map getSectionData(String section) {
        return (Map)this.m_section.get(section);
    }

    public String getPropertyData(String section, String property) {
        Map secData = (Map)this.m_section.get(section);
        return (String)secData.get(property);
    }

    public void setSectionData(String section, Map data) {
        if (this.m_section.containsKey(section)) {
            Map secData = (Map)this.m_section.get(section);
            for (String key : data.keySet()) {
                secData.put(key, (String)data.get(key));
            }
        } else {
            this.m_section.put(section, data);
        }
    }

    public void setPropertyData(String section, String key, String data) {
        if (this.m_section.containsKey(section)) {
            Map secData = (Map)this.m_section.get(section);
            secData.put(key, data);
        } else {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put(key, data);
            this.m_section.put(section, ht);
        }
    }

    public void removeSectionData(String section) {
        this.m_section.remove(section);
    }

    public void removePropertyData(String section, String property) {
        Map secData = (Map)this.m_section.get(section);
        secData.remove(property);
    }

    public void saveFile(Hashtable htData) {
        File file = new File(this.m_iniPath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e1) {
            AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("File not found."));
        }
        String szContent = "";
        if (htData == null) {
            Map htContents = null;
            for (String key : this.m_section.keySet()) {
                htContents = (Map)this.m_section.get(key);
                szContent = "[" + key + "]\n";
                try {
                    ((OutputStream)out).write(szContent.getBytes());
                }
                catch (IOException e1) {
                    AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Failed to write data to file."));
                }
                for (String keyProp : htContents.keySet()) {
                    szContent = String.valueOf(keyProp) + " = " + htContents.get(keyProp) + "\n";
                    try {
                        ((OutputStream)out).write(szContent.getBytes());
                    }
                    catch (IOException e1) {
                        AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Failed to write data to file."));
                    }
                }
            }
        } else {
            ArrayList secData = new ArrayList();
            for (String key : htData.keySet()) {
                szContent = "[" + key + "]\n";
                try {
                    ((OutputStream)out).write(szContent.getBytes());
                }
                catch (IOException e1) {
                    AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Failed to write data to file."));
                }
                secData = (ArrayList)htData.get(key);
                int i2 = 0;
                while (i2 < secData.size()) {
                    String data = (String)secData.get(i2);
                    szContent = String.valueOf(data) + "\n";
                    try {
                        ((OutputStream)out).write(szContent.getBytes());
                    }
                    catch (IOException e1) {
                        AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Failed to write data to file."));
                    }
                    ++i2;
                }
            }
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException e1) {
            AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Failed to close file."));
        }
    }
}

