/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.utils.AppAllUpLoad;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.pages.utils.AppCards;
import com.sec.osdm.pages.utils.AppCountry;
import com.sec.osdm.pages.utils.AppSystem;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AppAllUpConfig
extends AppDialog {
    private final int SIZE_WIDTH = 460;
    private final int SIZE_HEIGHT = 600;
    private AppTable m_table1 = null;
    private AppTableModel m_model1 = null;
    private AppTextBox m_compText = null;
    private String[][] m_corner1 = new String[][]{{"Cabinet", "Slot", "Item"}};
    private String[][] m_colTitle1 = new String[][]{{"System DB", "File DB"}};
    private String[][] m_rowTitle1 = new String[][]{new String[0]};
    private ArrayList m_component1 = new ArrayList();
    private Hashtable m_readData = new Hashtable();
    private byte[] m_fileData = null;
    private byte[] m_sysData = null;
    private int m_realCab = 0;
    private int m_virtCab = 0;
    private int[] m_realSlot = null;
    private int[] m_virtSlot = null;

    public AppAllUpConfig(Hashtable readData) {
        this.m_layout = new AppLayout(this.m_contentPane, 460, 600);
        this.m_readData = readData;
        this.m_fileData = (byte[])this.m_readData.get("0000");
        this.m_sysData = AppRunInfo.getLinkData();
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppAllUpConfig.this.openDialog("Configuration", 460, 600);
            }
        });
    }

    private void createComponents() {
        JLabel lbWarn = new JLabel(AppLang.getText("Different below item(s) between system and file."));
        JLabel lbWarn1 = new JLabel(AppLang.getText("If you want to continue, press the [OK] button."));
        JLabel lbWarn2 = new JLabel(AppLang.getText("Else press the [Cancel] button."));
        JPanel jpWarn = new JPanel(new GridLayout(3, 1));
        lbWarn.setFont(new Font("SansSerif", 0, 12));
        lbWarn1.setFont(new Font("SansSerif", 0, 12));
        lbWarn2.setFont(new Font("SansSerif", 0, 12));
        jpWarn.setBorder(new TitledBorder(AppLang.getText("Warning!!")));
        jpWarn.add(lbWarn);
        jpWarn.add(lbWarn1);
        jpWarn.add(lbWarn2);
        this.m_layout.addComponent(jpWarn, 5, 5, 445, 80);
        JButton btOK = new JButton(AppLang.getText("OK"));
        JButton btCancel = new JButton(AppLang.getText("Cancel"));
        btOK.setActionCommand("OK");
        btCancel.setActionCommand("Cancel");
        btOK.addActionListener(this);
        btCancel.addActionListener(this);
        this.m_layout.addComponent(btOK, 260, 543, 80, 20);
        this.m_layout.addComponent(btCancel, 360, 543, 80, 20);
        this.setComponents();
        this.setComponents1();
        this.createTable();
    }

    private void setComponents() {
        ArrayList<AppTextBox> compData = null;
        String[] ipType = new String[]{"IPv4", "IPv6"};
        String[] pcmCode = new String[]{"u-law", "a-law"};
        String[] wbsType = new String[]{"Basic", "Combo", "Dual"};
        String[][] sValue = new String[][]{{AppSystem.getSystemName(this.m_sysData[0]), AppSystem.getSystemName(this.m_fileData[0])}, {AppCountry.getCountryName(this.m_sysData[1]), AppCountry.getCountryName(this.m_fileData[1])}, {AppRunInfo.getSysVersion(), AppFunctions.byte2str(this.m_fileData, 2, 16)}, {"V" + this.m_sysData[18] + "." + String.format("%02x", this.m_sysData[19]), "V" + this.m_fileData[18] + "." + String.format("%02x", this.m_fileData[19])}, {"" + AppRunInfo.getMinSpeed(), "" + AppFunctions.byte2short(this.m_fileData, 22)}, {ipType[this.m_sysData[24]], ipType[this.m_fileData[24]]}, {pcmCode[this.m_sysData[25]], pcmCode[this.m_fileData[25]]}, {wbsType[this.m_sysData[26]], wbsType[this.m_fileData[26]]}};
        this.m_corner = new String[][]{{"Item"}};
        this.m_colTitle = new String[][]{{"System DB", "File DB"}};
        this.m_rowTitle = new String[][]{{"System Type"}, {"Country"}, {"System Version"}, {"TMMC Version"}, {"System Speed Min"}, {"IP Version"}, {"System Coding"}, {"WBS Select"}};
        int i2 = 0;
        while (i2 < this.m_rowTitle.length) {
            compData = new ArrayList<AppTextBox>();
            int j2 = 0;
            while (j2 < 2) {
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText(sValue[i2][j2]);
                compData.add(j2, this.m_compText);
                ++j2;
            }
            this.m_components.add(i2, compData);
            ++i2;
        }
    }

    private void setComponents1() {
        ArrayList<AppTextBox> compData = null;
        int rowCount = 0;
        int rowPos = 0;
        int dataPos = 0;
        String[] swPort = new String[]{"Station Group", "Trunk Group", "Features", "Q-LCR"};
        String[] swItem = new String[]{"Start Port", "Count"};
        this.m_realCab = this.m_sysData[27];
        this.m_virtCab = this.m_sysData[28];
        this.m_realSlot = new int[this.m_realCab];
        this.m_virtSlot = new int[this.m_virtCab];
        int i2 = 0;
        int j2 = 34;
        while (i2 < this.m_realCab) {
            this.m_realSlot[i2] = i2 == 0 ? this.m_sysData[j2] + 1 : this.m_sysData[j2];
            rowCount += this.m_realSlot[i2] * 4;
            ++i2;
            j2 += 220;
        }
        i2 = 0;
        j2 = 692;
        while (i2 < this.m_virtCab) {
            this.m_virtSlot[i2] = this.m_sysData[j2];
            rowCount += this.m_virtSlot[i2];
            ++i2;
            j2 += 38;
        }
        this.m_rowTitle1 = new String[rowCount += 8][3];
        i2 = 0;
        while (i2 < this.m_realCab) {
            dataPos = i2 * 220 + 36;
            j2 = 0;
            int k2 = dataPos;
            while (j2 < this.m_realSlot[i2]) {
                int m2 = 0;
                while (m2 < 4) {
                    this.m_rowTitle1[rowPos][0] = "" + (i2 + 1);
                    this.m_rowTitle1[rowPos][1] = "" + (j2 + 1);
                    this.m_rowTitle1[rowPos][2] = m2 == 0 ? AppLang.getText("Card") : String.valueOf(AppLang.getText("Service")) + m2;
                    compData = new ArrayList();
                    this.m_compText = new AppTextBox(0, 0);
                    if (m2 == 0) {
                        this.m_compText.setText(AppCards.getCardName(Integer.parseInt(AppFunctions.unsignedValue(this.m_sysData[k2 + 1]))));
                    } else {
                        this.m_compText.setText(AppCards.getCardName(Integer.parseInt(AppFunctions.unsignedValue(this.m_sysData[k2 + m2 + 11]))));
                    }
                    compData.add(0, this.m_compText);
                    this.m_compText = new AppTextBox(0, 0);
                    if (m2 == 0) {
                        this.m_compText.setText(AppCards.getCardName(Integer.parseInt(AppFunctions.unsignedValue(this.m_fileData[k2 + 1]))));
                    } else {
                        this.m_compText.setText(AppCards.getCardName(Integer.parseInt(AppFunctions.unsignedValue(this.m_fileData[k2 + m2 + 11]))));
                    }
                    compData.add(1, this.m_compText);
                    this.m_component1.add(rowPos, compData);
                    ++m2;
                    ++rowPos;
                }
                ++j2;
                k2 += 18;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_virtCab) {
            dataPos = i2 * 38 + 694;
            j2 = 0;
            while (j2 < this.m_virtSlot[i2]) {
                this.m_rowTitle1[rowPos][0] = "" + (this.m_realCab + i2 + 1);
                this.m_rowTitle1[rowPos][1] = "" + (j2 + 1);
                this.m_rowTitle1[rowPos][2] = AppLang.getText("Card");
                compData = new ArrayList();
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText(AppCards.getCardName(Integer.parseInt(AppFunctions.unsignedValue(this.m_sysData[dataPos + j2]))));
                compData.add(0, this.m_compText);
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText(AppCards.getCardName(Integer.parseInt(AppFunctions.unsignedValue(this.m_fileData[dataPos + j2]))));
                compData.add(1, this.m_compText);
                this.m_component1.add(rowPos, compData);
                ++j2;
                ++rowPos;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            dataPos = i2 * 4 + 1072;
            j2 = 0;
            while (j2 < 2) {
                if (j2 == 0) {
                    this.m_rowTitle1[rowPos][0] = AppLang.getText(swPort[i2]);
                }
                this.m_rowTitle1[rowPos][1] = "";
                this.m_rowTitle1[rowPos][2] = AppLang.getText(swItem[j2]);
                compData = new ArrayList<AppTextBox>();
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText("" + AppFunctions.byte2short(this.m_sysData, dataPos + j2 * 2));
                compData.add(0, this.m_compText);
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText("" + AppFunctions.byte2short(this.m_fileData, dataPos + j2 * 2));
                compData.add(1, this.m_compText);
                this.m_component1.add(rowPos, compData);
                ++j2;
                ++rowPos;
            }
            ++i2;
        }
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppAllUpConfig.this.m_components.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{185});
        this.m_model.setColWidth(new int[]{120, 120});
        this.m_table = new AppTable(this.m_model, 2);
        this.m_model1 = new AppTableModel(this.m_rowTitle1, this.m_colTitle1, this.m_corner1){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppAllUpConfig.this.m_component1.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model1.setRowWidth(new int[]{55, 50, 80});
        this.m_model1.setColWidth(new int[]{120, 120});
        int rowPos = 0;
        int i2 = 0;
        int k2 = 0;
        while (i2 < this.m_realCab) {
            int j2 = 0;
            while (j2 < this.m_realSlot[i2]) {
                this.m_model1.setRowHeaderRowSpan(rowPos, 1, 4);
                rowPos += 4;
                ++j2;
            }
            this.m_model1.setRowHeaderRowSpan(k2, 0, this.m_realSlot[i2] * 4);
            k2 += this.m_realSlot[i2] * 4;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_virtCab) {
            this.m_model1.setRowHeaderRowSpan(rowPos, 0, this.m_virtSlot[i2]);
            this.m_model1.setRowHeaderRowSpan(rowPos, 2, this.m_virtSlot[i2]);
            rowPos += this.m_virtSlot[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            this.m_model1.setRowHeaderColSpan(rowPos, 0, 2);
            ++i2;
            ++rowPos;
        }
        this.m_table1 = new AppTable(this.m_model1, 2);
        this.m_layout.addComponent(this.m_table, 5, 85, 445, 150);
        this.m_layout.addComponent(this.m_table1, 5, 235, 445, 300);
    }

    @Override
    public void runActionEvent(String command) {
        this.closeDialog();
        if (command.equals("OK")) {
            new AppAllUpLoad(this.m_readData);
        }
    }
}

