/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.main.view.MenuArrowIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

class MenuButton
extends JButton
implements MouseListener {
    private static final Icon m_arrow = new MenuArrowIcon();
    protected JPopupMenu m_pop;
    private String m_command = null;
    private Action actConnect = new AbstractAction(""){
        {
            this.putValue("ShortDescription", AppLang.getText("Connect to OfficeServ equipment"));
            this.putValue("ActionCommandKey", "connect");
            this.putValue("SmallIcon", AppImages.Img_Connect);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            AppGlobal.g_frmMain.m_toolBar.setDisplayLast();
        }
    };
    private Action actBookmark = new AbstractAction(""){
        {
            this.putValue("ShortDescription", AppLang.getText("Bookmark"));
            this.putValue("ActionCommandKey", "bookmark");
            this.putValue("SmallIcon", AppImages.Img_Bookmark);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    private Action actHistory = new AbstractAction(""){
        {
            this.putValue("ShortDescription", AppLang.getText("History"));
            this.putValue("ActionCommandKey", "history");
            this.putValue("SmallIcon", AppImages.Img_History);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    private Action actFileControl = new AbstractAction(""){
        {
            this.putValue("ShortDescription", AppLang.getText("Control files on OfficeServ equipment"));
            this.putValue("ActionCommandKey", "filecontrol");
            this.putValue("SmallIcon", AppImages.Img_FileControl);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppGlobal.g_frmMain.m_toolBar.setDisplayLast();
        }
    };

    public MenuButton(String command, JPopupMenu pop) {
        this.m_command = command;
        if (this.m_command.equals("connect")) {
            this.setAction(this.actConnect);
        } else if (this.m_command.equals("bookmark")) {
            this.setAction(this.actBookmark);
        } else if (this.m_command.equals("history")) {
            this.setAction(this.actHistory);
        } else if (this.m_command.equals("filecontrol")) {
            this.setAction(this.actFileControl);
        }
        this.m_pop = pop;
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4 + m_arrow.getIconWidth()));
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Dimension dim = this.getSize();
        Insets ins = this.getInsets();
        int x2 = dim.width - ins.right;
        int y2 = ins.top + (dim.height - ins.top - ins.bottom - m_arrow.getIconHeight()) / 2;
        m_arrow.paintIcon(this, g2, x2, y2);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        MenuButton mb = (MenuButton)e2.getSource();
        if (mb.isEnabled()) {
            Point pt = e2.getPoint();
            if (pt.getX() >= 23.0) {
                if (this.m_command.equals("filecontrol")) {
                    AppMenuActions.s_actFileControl.actionPerformed(null);
                    return;
                }
                this.m_pop.show(this, 0, this.getHeight());
            } else if (this.m_command.equals("connect")) {
                AppMenuActions.s_actConnect.actionPerformed(null);
            } else if (this.m_command.equals("bookmark")) {
                AppMenuActions.s_actBookmark.actionPerformed(null);
            } else if (this.m_command.equals("history")) {
                if (AppGlobal.showConfirmMessage(AppLang.getText("Delete"), AppLang.getText("Do you really want to delete all history?")) == 0) {
                    AppGlobal.g_frmMain.m_toolBar.removeAllHistoryPopupItems();
                }
            } else if (this.m_command.equals("filecontrol")) {
                AppMenuActions.s_actFileControl.actionPerformed(null);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        String sSiteName = (String)linkInfo.get("SITE_NAME");
        if (sSiteName == null) {
            sSiteName = "Quick";
        }
        String sValue = String.valueOf(sSiteName) + "-" + (String)linkInfo.get("IP_ADDRESS");
        if (((String)linkInfo.get("LINK_KIND")).equals("MODEM")) {
            sValue = String.valueOf(sSiteName) + "-" + (String)linkInfo.get("TEL_NUMBER") + ":";
            sValue = String.valueOf(sValue) + "COM" + (String)linkInfo.get("COM_PORT") + ":" + (String)linkInfo.get("BAUD_RATE") + "bps";
        }
        this.actConnect.putValue("ShortDescription", String.valueOf(AppLang.getText("Connect")) + " [" + sValue + " ]");
        this.actFileControl.putValue("ShortDescription", String.valueOf(AppLang.getText("File Control")) + " [" + sValue + " ]");
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }
}

