/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.components;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.table.ICellComponent;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AppTextBox
implements ICellComponent {
    public static final int PTTN_NULL = 0;
    public static final int PTTN_DID_DIGIT = 1;
    public static final int PTTN_HEX_ONLY = 2;
    public static final int PTTN_IPADDRESS = 3;
    public static final int PTTN_IPV4ADDRESS = 4;
    public static final int PTTN_IPV6ADDRESS = 5;
    public static final int PTTN_LCR_DIGIT = 6;
    public static final int PTTN_MODIFY_DIGIT = 7;
    public static final int PTTN_MOH_ONLY = 8;
    public static final int PTTN_NUM_ONLY = 9;
    public static final int PTTN_NUM1_ONLY = 10;
    public static final int PTTN_NUM2_ONLY = 11;
    public static final int PTTN_TEL_ONLY = 12;
    public static final int PTTN_TEL1_ONLY = 13;
    public static final int PTTN_TEL2_ONLY = 14;
    public static final int PTTN_TEL3_ONLY = 15;
    public static final int PTTN_TOLLDIGIT = 16;
    public static final int PTTN_TOSFIELD = 17;
    public static final int PTTN_NUM3_ONLY = 18;
    public static final int PTTN_NUM4_ONLY = 19;
    public static final int PTTN_EVENT1 = 20;
    public static final int PTTN_EVENT2 = 21;
    public static final int PTTN_NUM5_ONLY = 22;
    public static final int PTTN_DESCRIPTION = 23;
    public static final int PTTN_TEL4_ONLY = 24;
    public static final int PTTN_LABEL_NAME = 25;
    public static final int PTTN_DTMF1 = 26;
    public static final int PTTN_OVERHEAD = 27;
    public static final int PTTN_DELSCHEDULE = 28;
    public static final int PTTN_SECOND_LCR = 29;
    public static final int PTTN_PASSWORD = 30;
    public static final int PTTN_DESTINATION = 31;
    public static final int PTTN_TEL5_ONLY = 32;
    public static final int PTTN_USER_LCRNO = 33;
    public static final int PTTN_NEXT_ROUTE = 34;
    public static final int PTTN_NUM_ONLYBLOCK = 35;
    public static final int PTTN_SIGNED_NUM = 36;
    public static final int PTTN_EVENT3 = 37;
    public static final int PTTN_DIAL = 38;
    public static final int PTTN_TEL6_ONLY = 39;
    public static final int PTTN_LAST = 38;
    private JTable m_owner = null;
    private JTextField m_component = null;
    private int m_pattern = 0;
    private int m_minimum = 0;
    private int m_maximum = 0;
    private int m_length = 0;
    private String m_default = "";
    private String m_toolTip = "";
    private Color m_backColor = Color.WHITE;
    private int m_HorizontalAlignment = 2;
    public static final Hashtable<Integer, String> m_htPattern = new Hashtable();
    public static final Hashtable<Integer, String> m_htTooltip;

    static {
        m_htPattern.put(28, "^[0-9a-zA-Z: ]*$");
        m_htPattern.put(23, "^[0-9a-zA-Z ]*$");
        m_htPattern.put(31, "^[0-9B-Db-dPpSs -]*$");
        m_htPattern.put(1, "^[0-9*#a-fA-F]*$");
        m_htPattern.put(26, "^[0-9abcd*.#&;,W]*$");
        m_htPattern.put(20, "^[0-9a-zA-Z -]*$");
        m_htPattern.put(21, "^[0-9abcd#*?]*$");
        m_htPattern.put(37, "^[0-9abcd#*]*$");
        m_htPattern.put(2, "^[0-9a-fA-F]*$");
        m_htPattern.put(3, "^[0-9a-fA-F:.]*$");
        m_htPattern.put(4, "^[0-9.]*$");
        m_htPattern.put(5, "^[0-9a-fA-F:]*$");
        m_htPattern.put(25, "^[0-9a-zA-Z -]*$");
        m_htPattern.put(6, "^[0-9*#cClLrR]*$");
        m_htPattern.put(29, "^[0-9*#aAcClLrR]*$");
        m_htPattern.put(7, "^[0-9*#cCpP]*$");
        m_htPattern.put(8, "^[0-9*#tToOnNeE]*$");
        m_htPattern.put(34, "^[0-9*#lcrLCR]*$");
        m_htPattern.put(9, "^[0-9]*$");
        m_htPattern.put(10, "^[0-9*]*$");
        m_htPattern.put(11, "^[0-9,]*$");
        m_htPattern.put(18, "^[0-9*#a-cA-C]*$");
        m_htPattern.put(19, "^[0-9*#aAcC]*$");
        m_htPattern.put(22, "^[0-9*#pP]*$");
        m_htPattern.put(35, "^[0-9]*$");
        m_htPattern.put(36, "^-?[0-9]*$");
        m_htPattern.put(27, "^[0-9H;W&,$]*$");
        m_htPattern.put(12, "^[0-9*#]*$");
        m_htPattern.put(13, "^[0-9*#abdABD]*$");
        m_htPattern.put(14, "^[0-9*#fpFP]*$");
        m_htPattern.put(15, "^[0-9*#cfpCFP&,]*$");
        m_htPattern.put(24, "^[0-9*#bB]*$");
        m_htPattern.put(32, "^[0-9*#cfpCFP]*$");
        m_htPattern.put(39, "^[0-9*#bBpP]*$");
        m_htPattern.put(16, "^[0-9*xyzeXYZE]*$");
        m_htPattern.put(17, "^[0-1]*$");
        m_htPattern.put(33, "^[0-9*#allALL]*$");
        m_htPattern.put(38, "^[0-9abcd#*,\\&HTPMW; -$KXCFOBENSA~DIdioF]*$");
        m_htTooltip = new Hashtable();
        m_htTooltip.put(28, "0 ~ 9, A ~ Z, a ~ z, :, space");
        m_htTooltip.put(23, "0 ~ 9, A ~ Z, a ~ z, space");
        m_htTooltip.put(1, "0 ~ 9, *, #, a ~ f, A ~ F");
        m_htTooltip.put(26, "0 ~ 9, a ~ d, *, ., #, &, ;, ,, W");
        m_htTooltip.put(20, "0 ~ 9, A ~ Z, a ~ z, space, -");
        m_htTooltip.put(21, "0 ~ 9, a, b, c, d, #, *, ?");
        m_htTooltip.put(37, "0 ~ 9, a, b, c, d, #, *");
        m_htTooltip.put(2, "0 ~ 9, a ~ f, A ~ F");
        m_htTooltip.put(3, "0 ~ 9, a ~ f, A ~ F, :, .");
        m_htTooltip.put(4, "0 ~ 9, .");
        m_htTooltip.put(5, "0 ~ 9, a ~ f, A ~ F, :");
        m_htTooltip.put(25, "0 ~ 9, a ~ z, A ~ Z, space");
        m_htTooltip.put(6, "0 ~ 9, *, #, c, C, l, L, r, R");
        m_htTooltip.put(29, "0 ~ 9, *, #, a, A, c, C, l, L, r, R");
        m_htTooltip.put(7, "0 ~ 9, *, #, c, C, p, P");
        m_htTooltip.put(8, "0 ~ 9, *, #, t, T, o, O, n, N, e, E");
        m_htTooltip.put(34, "0 ~ 9, *, #, l, L, LCR");
        m_htTooltip.put(9, "0 ~ 9");
        m_htTooltip.put(10, "0 ~ 9, *");
        m_htTooltip.put(11, "0 ~ 9, ,");
        m_htTooltip.put(18, "0 ~ 9, *, #, a ~ c, A ~ C");
        m_htTooltip.put(19, "0 ~ 9, *, #, a, c, A, C");
        m_htTooltip.put(22, "0 ~ 9, *, #, p, P");
        m_htTooltip.put(35, "01 ~ 99");
        m_htTooltip.put(27, "0 ~ 9, H, W, &, $, ;, ,");
        m_htTooltip.put(12, "0 ~ 9, *, #");
        m_htTooltip.put(13, "0 ~ 9, *, #, a, A, b, B, d, D");
        m_htTooltip.put(14, "0 ~ 9, *, #, f, F, p, P");
        m_htTooltip.put(15, "0 ~ 9, *, #, c, C, f, F, p, P, [, ]");
        m_htTooltip.put(24, "0 ~ 9, *, #, b, B");
        m_htTooltip.put(32, "0 ~ 9, *, #, c, C, f, F, p, P");
        m_htTooltip.put(39, "0 ~ 9, *, #, b, B, p, P");
        m_htTooltip.put(16, "0 ~ 9, *, e, E, x, X, y, Y, z, Z");
        m_htTooltip.put(17, "0, 1");
        m_htTooltip.put(33, "0 ~ 9, *, #, a, A, ALL");
        m_htTooltip.put(38, "Valid inputs are DTMF 'H;W&,\\' $(register) or ~(sequence)");
    }

    public AppTextBox() {
        this(0, 0, 0, 0, "");
    }

    public AppTextBox(AppPageInfo page, int index) {
        this(page.getFieldPattern(index), page.getFieldLength(index), page.getFieldMin(index), page.getFieldMax(index), page.getFieldDefault(index));
    }

    public AppTextBox(int pattern, int len) {
        this(pattern, len, 0, 0, "");
    }

    public AppTextBox(int pattern, int len, int min, int max) {
        this(pattern, len, min, max, "");
    }

    public AppTextBox(int pattern, int len, int min, int max, int iDefault) {
        this(pattern, len, min, max, "" + iDefault);
    }

    public AppTextBox(int pattern, int len, int min, int max, String sDefault) {
        this.setPattern(pattern);
        this.setRange(min, max);
        this.setLength(len);
        this.setDefault(sDefault);
        this.m_toolTip = AppLang.getText("Available value");
        this.m_toolTip = this.m_maximum > 0 || this.m_pattern == 36 ? String.valueOf(this.m_toolTip) + ": " + this.m_minimum + " ~ " + this.m_maximum : (this.m_pattern == 0 ? String.valueOf(this.m_toolTip) + ": " + AppLang.getText("All characters") + " - " + AppLang.getText("Max length") + ": " + this.m_length : String.valueOf(this.m_toolTip) + ": " + m_htTooltip.get(this.m_pattern) + " - " + AppLang.getText("Max length") + ": " + this.m_length);
        this.m_component = new JTextField();
        this.m_component.setDocument(new TextPattern());
        this.setTooltipText(this.m_toolTip);
    }

    public String getText() {
        return this.m_component.getText().trim();
    }

    public void setText(String strText) {
        this.m_component.setText(strText.trim());
    }

    public void setTooltipText(String strTooltipText) {
        this.m_component.setToolTipText(strTooltipText.trim());
    }

    public void setPattern(int pattern) {
        this.m_pattern = pattern > 38 ? 0 : pattern;
    }

    public void setRange(int min, int max) {
        this.m_minimum = min;
        this.m_maximum = max;
        if (min > max) {
            this.m_minimum = max;
            this.m_maximum = min;
        }
    }

    public void setLength(int len) {
        this.m_length = len;
    }

    public void setDefault(String sDefault) {
        this.m_default = sDefault.trim();
    }

    public void toolTipEvent() {
        this.m_component.dispatchEvent(new KeyEvent(this.m_component, 401, 0L, 2, 112));
    }

    @Override
    public void finishEditing() {
        int value;
        String strData = this.m_component.getText();
        if (strData.equals("")) {
            this.m_component.setText(this.m_default);
        }
        if (!(strData.equals("") || this.m_maximum <= 0 || (value = Integer.parseInt(this.m_component.getText().trim())) >= this.m_minimum && value <= this.m_maximum)) {
            this.m_component.setText(this.m_default);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.m_component;
    }

    @Override
    public JTable getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(JTable table) {
        this.m_owner = table;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    private String getDefault() {
        return this.m_default;
    }

    @Override
    public void clear() {
        this.m_component.setText(this.getDefault());
    }

    @Override
    public boolean checkValue(String strData) {
        return true;
    }

    @Override
    public void fromString(String strData) {
        this.setText(strData.trim());
    }

    public void setBackground(Color back) {
        this.m_backColor = back;
    }

    public Color getBackground() {
        return this.m_backColor;
    }

    public void setHorizontalAlignment(int alignment) {
        this.m_HorizontalAlignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.m_HorizontalAlignment;
    }

    public class TextPattern
    extends PlainDocument {
        String m_inText = "";
        int m_inValue = 0;
        boolean m_bResult = true;

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (AppTextBox.this.m_pattern != 0 && !Pattern.matches(m_htPattern.get(AppTextBox.this.m_pattern), str)) {
                AppTextBox.this.toolTipEvent();
                return;
            }
            if (AppTextBox.this.m_length <= 0) {
                super.insertString(offset, str, attr);
                return;
            }
            if (this.getLength() + str.length() > AppTextBox.this.m_length) {
                AppTextBox.this.toolTipEvent();
                return;
            }
            super.insertString(offset, str, attr);
            if (AppTextBox.this.m_maximum > 0) {
                this.m_bResult = true;
                this.m_inText = AppTextBox.this.m_component.getText().trim();
                try {
                    this.m_inValue = Integer.parseInt(this.m_inText);
                    if (this.m_inText.length() >= String.format("%d", AppTextBox.this.m_minimum).length() && this.m_inValue > AppTextBox.this.m_maximum) {
                        this.m_bResult = false;
                    }
                }
                catch (NumberFormatException ne) {
                    this.m_bResult = false;
                }
                if (!this.m_bResult) {
                    AppTextBox.this.m_component.setText(AppTextBox.this.m_default);
                    AppTextBox.this.toolTipEvent();
                }
            }
        }
    }
}

