/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.ExportFilter;
import com.healthmarketscience.jackcess.SimpleExportFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportUtil {
    private static final Log LOG = LogFactory.getLog(ExportUtil.class);
    public static final String DEFAULT_DELIMITER = ",";
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final String DEFAULT_FILE_EXT = "csv";

    private ExportUtil() {
    }

    public static void exportAll(Database db2, File dir) throws IOException {
        ExportUtil.exportAll(db2, dir, DEFAULT_FILE_EXT);
    }

    public static void exportAll(Database db2, File dir, String ext) throws IOException {
        for (String tableName : db2.getTableNames()) {
            ExportUtil.exportFile(db2, tableName, new File(dir, tableName + "." + ext), false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
        }
    }

    public static void exportAll(Database db2, File dir, String ext, boolean header) throws IOException {
        for (String tableName : db2.getTableNames()) {
            ExportUtil.exportFile(db2, tableName, new File(dir, tableName + "." + ext), header, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
        }
    }

    public static void exportAll(Database db2, File dir, String ext, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        for (String tableName : db2.getTableNames()) {
            ExportUtil.exportFile(db2, tableName, new File(dir, tableName + "." + ext), header, delim, quote, filter);
        }
    }

    public static void exportFile(Database db2, String tableName, File f2) throws IOException {
        ExportUtil.exportFile(db2, tableName, f2, false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(Database db2, String tableName, File f2, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f2));
            ExportUtil.exportWriter(db2, tableName, out, header, delim, quote, filter);
            out.close();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    LOG.warn("Could not close file " + f2.getAbsolutePath(), ex);
                }
            }
        }
    }

    public static void exportWriter(Database db2, String tableName, BufferedWriter out) throws IOException {
        ExportUtil.exportWriter(db2, tableName, out, false, DEFAULT_DELIMITER, '\"', SimpleExportFilter.INSTANCE);
    }

    public static void exportWriter(Database db2, String tableName, BufferedWriter out, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        ExportUtil.exportWriter(Cursor.createCursor(db2.getTable(tableName)), out, header, delim, quote, filter);
    }

    public static void exportWriter(Cursor cursor, BufferedWriter out, boolean header, String delim, char quote, ExportFilter filter) throws IOException {
        Map<String, Object> row;
        String delimiter = delim == null ? DEFAULT_DELIMITER : delim;
        Pattern needsQuotePattern = Pattern.compile("(?:" + Pattern.quote(delimiter) + ")|(?:" + Pattern.quote("" + quote) + ")|(?:[\n\r])");
        List<Column> origCols = cursor.getTable().getColumns();
        List<Column> columns = new ArrayList<Column>(origCols);
        columns = filter.filterColumns(columns);
        HashSet<String> columnNames = null;
        if (!((Object)origCols).equals(columns)) {
            columnNames = new HashSet<String>();
            for (Column c2 : columns) {
                columnNames.add(c2.getName());
            }
        }
        if (header) {
            Iterator<Column> iter = columns.iterator();
            while (iter.hasNext()) {
                ExportUtil.writeValue(out, iter.next().getName(), quote, needsQuotePattern);
                if (!iter.hasNext()) continue;
                out.write(delimiter);
            }
            out.newLine();
        }
        Object[] unfilteredRowData = new Object[columns.size()];
        while ((row = cursor.getNextRow(columnNames)) != null) {
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                unfilteredRowData[i2] = row.get(columns.get(i2).getName());
            }
            Object[] rowData = filter.filterRow(unfilteredRowData);
            for (int i3 = 0; i3 < columns.size(); ++i3) {
                Object obj = rowData[i3];
                if (obj != null) {
                    String value = null;
                    value = obj instanceof byte[] ? ByteUtil.toHexString((byte[])obj) : String.valueOf(rowData[i3]);
                    ExportUtil.writeValue(out, value, quote, needsQuotePattern);
                }
                if (i3 >= columns.size() - 1) continue;
                out.write(delimiter);
            }
            out.newLine();
        }
        out.flush();
    }

    private static void writeValue(BufferedWriter out, String value, char quote, Pattern needsQuotePattern) throws IOException {
        if (!needsQuotePattern.matcher(value).find()) {
            out.write(value);
            return;
        }
        out.write(quote);
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == quote) {
                out.write(quote);
            }
            out.write(c2);
        }
        out.write(quote);
    }
}

