/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.SecurityUtil;
import com.sec.osdm.pages.utils.AppCards;
import java.nio.charset.Charset;
import java.util.Hashtable;

public class AppRunInfo {
    public static final String APP_OSDM_DATE = "V5.01 2017.02.20\n";
    public static final int APP_OSDM_VERSION = 513;
    public static byte[] m_linkData = null;
    private static int m_runMode = 0;
    private static int m_tenantNo = 0;
    private static String m_fileName = "";
    private static String m_filePath = "";
    private static String m_encryptKey = "";
    private static String m_ftpPW = "";
    private static String m_vm_ftpPW = "";
    private static boolean m_vm_sftp_enable = true;

    public static void setLinkData(byte[] link) {
        System.out.println(String.format("[Debug] getRunVersion() - APP_OSDM_VERSION:0x%04X, version:0x%04X", 513, AppFunctions.byte2short(link, 18)));
        m_linkData = link;
        AppGlobal.g_bIsCoference = AppRunInfo.checkRunConference();
        if (m_linkData.length >= 1110) {
            String encryptedValue = AppFunctions.byte2str(m_linkData, 1093, 16);
            AppRunInfo.setVmFtpPW(encryptedValue);
            System.out.println("[Debug] received ftp info");
        } else {
            System.err.println("[Debug] Can't receive ftp info");
        }
    }

    public static byte[] getLinkData() {
        return m_linkData;
    }

    public static int getRunMode() {
        return m_runMode;
    }

    public static void setRunMode(int mode) {
        m_runMode = mode;
    }

    public static int getSystem() {
        return m_linkData[0];
    }

    public static int getCountry() {
        return m_linkData[1];
    }

    public static String getSysVersion() {
        return AppFunctions.byte2str(m_linkData, 2, 16);
    }

    public static void setSysVersion(String version) {
        AppFunctions.str2byte(m_linkData, 2, 16, version);
    }

    public static int getRunVersion() {
        int version = 513;
        try {
            String tmmc = String.valueOf(String.format("%02x", m_linkData[18])) + String.format("%02x", m_linkData[19]);
            version = Integer.parseInt(tmmc, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static void setRunVersion(int version) {
        AppFunctions.short2byte(m_linkData, 18, (short)version);
    }

    public static int getAliveTime() {
        return m_linkData[20];
    }

    public static int getLockOut() {
        return m_linkData[21];
    }

    public static int getMinSpeed() {
        return AppFunctions.byte2short(m_linkData, 22);
    }

    public static int getIPType() {
        return m_linkData[24];
    }

    public static int getPCMCoding() {
        return m_linkData[25];
    }

    public static int getWBSType() {
        return m_linkData[26];
    }

    public static int getTenantNo() {
        return m_tenantNo;
    }

    public static int getMaxTenantNo() {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[1092]));
    }

    public static void setTenantNo(int tenant) {
        m_tenantNo = tenant;
    }

    public static int getUserLevel() {
        return m_linkData[29];
    }

    public static String getFileName() {
        return m_fileName;
    }

    public static void setFileName(String file) {
        m_fileName = file;
    }

    public static String getFilePath() {
        return m_filePath;
    }

    public static void setFilePath(String path) {
        m_filePath = path;
    }

    public static int getRealCabinet() {
        return m_linkData[27];
    }

    public static int getVirtCabinet() {
        return m_linkData[28];
    }

    public static int getConnState(int cabNo) {
        return m_linkData[cabNo * 220 + 32];
    }

    public static int getCabinetType(int cabNo) {
        return m_linkData[cabNo * 220 + 33];
    }

    public static int getRealCabSlot(int cabNo) {
        return m_linkData[cabNo * 220 + 34];
    }

    public static int getPrevCard(int cabNo, int slotNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + 36]));
    }

    public static int getCurrCard(int cabNo, int slotNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + 37]));
    }

    public static int getMaxService(int cabNo, int slotNo) {
        return m_linkData[cabNo * 220 + slotNo * 18 + 38];
    }

    public static int getMaxChannel(int cabNo, int slotNo, int chNo) {
        return m_linkData[cabNo * 220 + slotNo * 18 + (chNo + 39)];
    }

    public static int getStartPort(int cabNo, int slotNo, int chNo) {
        return AppFunctions.byte2short(m_linkData, cabNo * 220 + slotNo * 18 + (chNo * 2 + 42));
    }

    public static int getServiceCard(int cabNo, int slotNo, int chNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + (chNo + 48)]));
    }

    public static int getNewService(int cabNo, int slotNo, int chNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + (chNo + 51)]));
    }

    public static int getVirtSlot(int cabNo) {
        return m_linkData[cabNo * 38 + 692];
    }

    public static int getVirtChannel(int cabNo) {
        return m_linkData[cabNo * 38 + 693];
    }

    public static int getVirtCard(int cabNo, int slotNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 38 + slotNo + 694]));
    }

    public static int getVirtStartPort(int cabNo, int slotNo) {
        return AppFunctions.byte2short(m_linkData, cabNo * 38 + slotNo * 2 + 706);
    }

    public static int getStationStart() {
        return AppFunctions.byte2short(m_linkData, 1072);
    }

    public static int getStationCount() {
        return AppFunctions.byte2short(m_linkData, 1074);
    }

    public static int getTrunkStart() {
        return AppFunctions.byte2short(m_linkData, 1076);
    }

    public static int getTrunkCount() {
        return AppFunctions.byte2short(m_linkData, 1078);
    }

    public static int getFeatStart() {
        return AppFunctions.byte2short(m_linkData, 1080);
    }

    public static int getFeatCount() {
        return AppFunctions.byte2short(m_linkData, 1082);
    }

    public static int getQlcrStart() {
        return AppFunctions.byte2short(m_linkData, 1084);
    }

    public static int getQlcrCount() {
        return AppFunctions.byte2short(m_linkData, 1086);
    }

    private static boolean checkRunConference() {
        int i2 = 0;
        while (i2 < 3) {
            int j2 = 0;
            while (j2 < 12) {
                if (AppRunInfo.getCurrCard(i2, j2) == 136 && AppCards.checkUseCard(136)) {
                    return true;
                }
                ++j2;
            }
            ++i2;
        }
        return false;
    }

    public static String getEncryptKey() {
        try {
            if (m_encryptKey.equals("")) {
                String m_file = "/resources/files/properties/Info.ini";
                Hashtable m_info = (Hashtable)AppProperty.readDataFromFile(AppRunInfo.class.getResourceAsStream(m_file));
                byte[] data = SecurityUtil.HexToArray((String)m_info.get("EncryptKey"));
                int i2 = 0;
                while (i2 < data.length) {
                    int n2 = i2++;
                    data[n2] = (byte)(data[n2] + 32);
                }
                m_encryptKey = new String(data, 0, data.length, Charset.forName("UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m_encryptKey;
    }

    public static void setEncryptKey(String encryptKey) {
        m_encryptKey = encryptKey;
    }

    public static String getFtpID() {
        if (AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 4) {
            return "kpsw";
        }
        return "admin";
    }

    public static String getFtpPW() {
        try {
            if (m_ftpPW.equals("")) {
                String m_file = "/resources/files/properties/Info.ini";
                Hashtable m_info = (Hashtable)AppProperty.readDataFromFile(AppRunInfo.class.getResourceAsStream(m_file));
                byte[] data = AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 4 ? SecurityUtil.HexToArray((String)m_info.get("VwWorks")) : SecurityUtil.HexToArray((String)m_info.get("Linux"));
                int i2 = 0;
                while (i2 < data.length) {
                    int n2 = i2++;
                    data[n2] = (byte)(data[n2] + 32);
                }
                m_ftpPW = new String(data, 0, data.length, Charset.forName("UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m_ftpPW;
    }

    public static void setFtpPW(String ftpPW) {
        m_ftpPW = ftpPW;
    }

    public static String getVmFtpID() {
        return "admin";
    }

    public static String getVmFtpPW() {
        try {
            if (m_vm_ftpPW.equals("")) {
                String m_file = "/resources/files/properties/Info.ini";
                Hashtable m_info = (Hashtable)AppProperty.readDataFromFile(AppRunInfo.class.getResourceAsStream(m_file));
                byte[] data = SecurityUtil.HexToArray((String)m_info.get("VM"));
                int i2 = 0;
                while (i2 < data.length) {
                    int n2 = i2++;
                    data[n2] = (byte)(data[n2] + 32);
                }
                m_vm_ftpPW = new String(data, 0, data.length, Charset.forName("UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m_vm_ftpPW;
    }

    public static void setVmFtpPW(String VmftpPW) {
        m_vm_ftpPW = VmftpPW;
    }

    public static void setVmSftpEnable(boolean vmSftpEnable) {
        m_vm_sftp_enable = vmSftpEnable;
    }

    public static boolean getVmSftpEnable() {
        return m_vm_sftp_enable;
    }
}

