/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDebug;
import com.sec.osdm.io.AppLockOut;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AppNetwork
extends AppComm {
    private static AppNetwork m_oThis = null;
    private static Socket m_sockCall = null;
    private static Socket m_sockVmaa = null;
    private static Hashtable m_siteInfo = new Hashtable();
    public static String m_address = "";
    public static String m_address_SVMi20i = "";
    private static int m_port = 0;
    private static int m_vm_port = 0;
    public static int m_ftp_port_SVMi20i = 0;
    private static AppPageInfo m_pageInfo = null;

    private AppNetwork() {
    }

    public static AppNetwork getInstance() {
        if (m_oThis == null) {
            m_oThis = new AppNetwork();
        }
        m_siteInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        m_address = ((String)m_siteInfo.get("IP_ADDRESS")).trim();
        m_port = Integer.parseInt(((String)m_siteInfo.get("DATA_PORT")).trim());
        m_vm_port = Integer.parseInt(((String)m_siteInfo.get("VM_PORT")).trim());
        return m_oThis;
    }

    @Override
    public boolean connect() {
        try {
            boolean bFirstConnect = false;
            AppGlobal.g_bIsServerIP = true;
            if (AppGlobal.g_encrypt_type == 2) {
                if (m_sockCall == null || !m_sockCall.isConnected()) {
                    try {
                        SSLContext sc = SSLContext.getInstance("SSL");
                        sc.init(null, new TrustManager[]{new FakeX509TrustManager()}, new SecureRandom());
                        sc.createSSLEngine(m_address, m_port);
                        SSLSocketFactory sslFactory = sc.getSocketFactory();
                        m_sockCall = (SSLSocket)sslFactory.createSocket(m_address, m_port);
                        bFirstConnect = true;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            } else if (m_sockCall == null || !m_sockCall.isConnected()) {
                m_sockCall = new Socket();
                m_sockCall.connect(new InetSocketAddress(m_address, m_port), 3000);
                bFirstConnect = true;
            }
            m_sockCall.setSoTimeout(10000);
            m_pageInfo = AppComm.getInstance().m_pageInfo;
            if (m_pageInfo != null && ((AppTreeNode)AppProperty.m_allMmcList.get(m_pageInfo.getMsgId())).getMenuKind() == 1) {
                m_sockVmaa = AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50 ? new Socket(m_address_SVMi20i, m_vm_port) : new Socket(m_address, m_vm_port);
                m_sockVmaa.setSoTimeout(240000);
            }
            return true;
        }
        catch (UnknownHostException e3) {
            AppGlobal.g_bIsServerIP = false;
            AppGlobal.showErrorMessage("", AppLang.getText("Server IP address is not exist."));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void disconnect() {
        try {
            if (m_sockCall != null) {
                if (m_sockCall.isConnected()) {
                    m_sockCall.close();
                }
                m_sockCall = null;
            }
        }
        catch (IOException e2) {
            AppGlobal.hideProgress();
        }
        if (AppGlobal.g_lockOut != null) {
            AppGlobal.g_lockOut = null;
        }
    }

    private void setLocked() {
        if (AppGlobal.g_lockOut != null) {
            if (((AppTreeNode)AppProperty.m_allMmcList.get(m_pageInfo.getMsgId())).getMenuKind() == 1) {
                AppLockOut.m_eventLock = true;
            } else {
                AppGlobal.g_lockOut.begin();
            }
        }
    }

    private void resetLocked() {
        if (AppGlobal.g_lockOut != null && ((AppTreeNode)AppProperty.m_allMmcList.get(m_pageInfo.getMsgId())).getMenuKind() != 1) {
            AppGlobal.g_lockOut.end();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sendData(byte[] data) {
        if (!this.connect()) {
            return false;
        }
        this.resetLocked();
        OutputStream os = null;
        try {
            if (((AppTreeNode)AppProperty.m_allMmcList.get(m_pageInfo.getMsgId())).getMenuKind() == 1) {
                if (m_sockVmaa == null) {
                    return false;
                }
                os = m_sockVmaa.getOutputStream();
            } else {
                if (m_sockCall == null) {
                    return false;
                }
                os = m_sockCall.getOutputStream();
            }
            os.write(data);
            os.flush();
            AppDebug.sendDebugMsg("Send Message".trim(), data);
        }
        catch (IOException e2) {
            this.setLocked();
            return false;
        }
        this.setLocked();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] recvData() {
        byte[] m_bTemp = new byte[0x200000];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int msgLen = -1;
        this.resetLocked();
        InputStream is = null;
        try {
            if (m_pageInfo == null) {
                if (m_sockCall == null) {
                    return null;
                }
                is = m_sockCall.getInputStream();
            } else if (((AppTreeNode)AppProperty.m_allMmcList.get(m_pageInfo.getMsgId())).getMenuKind() == 1) {
                if (m_sockVmaa == null) {
                    return null;
                }
                is = m_sockVmaa.getInputStream();
            } else {
                if (m_sockCall == null) {
                    return null;
                }
                is = m_sockCall.getInputStream();
            }
            while ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) != -1) {
                if (nRead >= 18 && msgLen == -1) {
                    msgLen = AppFunctions.byte2int(m_bTemp, 8);
                }
                if (msgLen < 0 || (nOffset += nRead) < msgLen + 18) continue;
            }
            if (msgLen >= 0) {
                m_bData = new byte[msgLen + 18];
                System.arraycopy(m_bTemp, 0, m_bData, 0, msgLen + 18);
                AppDebug.sendDebugMsg("Receive Data", m_bData);
            }
        }
        catch (IOException e2) {
            this.setLocked();
            return null;
        }
        if (m_pageInfo != null && ((AppTreeNode)AppProperty.m_allMmcList.get(m_pageInfo.getMsgId())).getMenuKind() == 1) {
            try {
                m_sockVmaa.close();
                m_sockVmaa = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setLocked();
        return m_bData;
    }

    public static void setAddressSVMi20i(byte[] recvData) {
        m_address_SVMi20i = AppFunctions.byte2ip(recvData, 124, 16);
        m_ftp_port_SVMi20i = Integer.parseInt(AppFunctions.unsignedValue(AppFunctions.byte2short(recvData, 140)));
    }

    public static /* bridge */ /* synthetic */ AppComm getInstance() {
        return AppNetwork.getInstance();
    }

    public static class FakeX509TrustManager
    implements X509TrustManager {
        public boolean isClientTrusted(X509Certificate[] chain) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] chain) {
            return true;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

