/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.utils.AppFileControl;
import com.sec.osdm.main.utils.AppFileUpdate;
import com.sec.osdm.main.utils.SunFtpWrapper_dm;
import com.sec.osdm.pages.utils.components.AppTextBox;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

public class AppFileRequest
extends Thread {
    private AppFileControl m_requester = null;
    private byte[] m_iniData = null;
    private String m_mode = "";

    public AppFileRequest(String mode, AppFileControl requester) {
        this.m_mode = mode;
        this.m_requester = requester;
    }

    @Override
    public void run() {
        if (this.m_mode.equals("Request")) {
            this.requestRefresh();
            this.m_requester.m_useSlave = false;
            if (this.m_requester.m_recvData != null) {
                int i2 = 0;
                while (i2 < this.m_requester.m_recvData.length) {
                    if (this.m_requester.m_recvData[i2 + 7] == -29) {
                        this.m_requester.m_useSlave = true;
                    }
                    i2 += 172;
                }
            }
            this.m_requester.createComponents();
        } else {
            if (!this.m_mode.equals("Refresh")) {
                if (this.m_mode.equals("Delete")) {
                    this.requestDelete();
                } else if (this.m_mode.equals("Change")) {
                    this.requestChange();
                    if (this.m_requester.m_useSlave && AppGlobal.showConfirmMessage("", String.valueOf(AppLang.getText("The [MASTER]'s boot images will be applied to [SLAVE]")) + "\n" + AppLang.getText("Do you want to continue?")) == 0) {
                        this.requestUpdate();
                    }
                } else if (this.m_mode.equals("Update")) {
                    this.requestUpdate();
                }
            }
            try {
                AppFileRequest.sleep(500L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            this.requestRefresh();
            this.m_requester.setStorageComponents();
        }
    }

    private void requestRefresh() {
        block43: {
            byte[] reqData = null;
            this.m_requester.setNewFileSystemMode(false);
            if (this.m_mode.equals("Request")) {
                AppGlobal.showProgress(AppLang.getText("File Control"), AppLang.getText("Request..."));
            } else {
                AppGlobal.showProgress(AppLang.getText("File Control"), AppLang.getText("Refresh..."));
            }
            try {
                reqData = this.m_requester.m_comm.makeMsgHeader((byte)18, (byte)-1, (byte)-1, (short)0, (byte)-1, (byte)-17);
                this.m_requester.m_recvData = null;
                this.m_requester.m_recvData = this.m_requester.m_comm.requestFileControl(reqData, 172);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (this.m_requester.getSystemName().equals("")) {
                String sSystemName = AppFunctions.byte2str(this.m_requester.m_recvData, 16, 11).toUpperCase();
                if (sSystemName.equals("OS7200")) {
                    if (AppRunInfo.getRunMode() == 2 && AppRunInfo.getSystem() == 34) {
                        sSystemName = "OS7200S";
                    }
                    if (AppGlobal.showConfirmMessage(AppLang.getText("File Control"), AppLang.getText("System type OS7200 is this correct? ( OS7200 : YES, OS7200S : NO )")) == 1) {
                        sSystemName = "OS7200S";
                    }
                }
                this.m_requester.setSystemName(sSystemName);
            }
            reqData = this.m_requester.m_comm.makeMsgHeader((byte)37, (byte)-1, (byte)-1, (short)0, (byte)-1, (byte)-17);
            this.m_iniData = null;
            this.m_iniData = this.m_requester.m_comm.requestFileControl(reqData, 144);
            this.m_requester.m_fileList.clear();
            if (this.m_requester.m_recvData != null && this.m_requester.m_recvData.length >= 172) {
                ArrayList<String> fileData;
                ArrayList compData;
                String fileType;
                String fileName;
                NumberFormat formatter = NumberFormat.getNumberInstance();
                int i2 = 0;
                while (i2 < this.m_requester.m_recvData.length) {
                    int j2 = i2 + 28;
                    while (j2 < i2 + 172) {
                        fileName = AppFunctions.byte2str(this.m_requester.m_recvData, j2, 12);
                        if (!fileName.equals("")) {
                            fileType = this.m_requester.getSubName(this.m_requester.getSubId(fileName));
                            compData = this.m_requester.m_fileList.containsKey(fileType) ? (ArrayList)this.m_requester.m_fileList.get(fileType) : new ArrayList();
                            fileData = new ArrayList<String>();
                            fileData.add(0, AppFunctions.byte2str(this.m_requester.m_recvData, j2, 12));
                            fileData.add(1, formatter.format(AppFunctions.byte2int(this.m_requester.m_recvData, j2 + 12)));
                            fileData.add(2, AppFunctions.byte2str(this.m_requester.m_recvData, j2 + 16, 20));
                            fileData.add(3, "0");
                            compData.add(compData.size(), fileData);
                            this.m_requester.m_fileList.put(fileType, compData);
                        }
                        j2 += 36;
                    }
                    i2 += 172;
                }
                int pos = 0;
                String iniName = "";
                if (this.m_iniData != null && this.m_iniData.length >= 144) {
                    int i3 = 0;
                    while (i3 < this.m_iniData.length) {
                        pos = i3 + 144 <= this.m_iniData.length ? 144 : this.m_iniData.length - i3;
                        int j3 = 0;
                        while (j3 < pos - 8) {
                            fileType = this.m_requester.getSubName(this.m_iniData[i3 + j3 + 8]);
                            iniName = AppFunctions.byte2str(this.m_iniData, i3 + j3 + 10, 32);
                            if (this.m_requester.m_fileList.containsKey(fileType)) {
                                compData = (ArrayList)this.m_requester.m_fileList.get(fileType);
                                int k2 = 0;
                                while (k2 < compData.size()) {
                                    fileData = (ArrayList<String>)compData.get(k2);
                                    fileName = (String)fileData.get(0);
                                    if (iniName.equals(fileName)) {
                                        fileData.set(3, "1");
                                        if (fileName.toUpperCase().startsWith("AP") && fileName.toUpperCase().endsWith(".PKM")) {
                                            this.m_requester.setNewFileSystemMode(true);
                                        }
                                    }
                                    compData.set(k2, fileData);
                                    ++k2;
                                }
                                this.m_requester.m_fileList.put(fileType, compData);
                            }
                            j3 += 34;
                        }
                        i3 += 144;
                    }
                }
                SunFtpWrapper_dm ftp = new SunFtpWrapper_dm();
                Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
                String m_ftpIP = (String)linkInfo.get("IP_ADDRESS");
                String ftpPort = (String)linkInfo.get("FTP_PORT");
                int m_ftpPort = 21;
                if (ftpPort != null) {
                    m_ftpPort = Integer.parseInt(ftpPort);
                }
                String m_ftpID = AppRunInfo.getFtpID();
                String m_ftpPW = AppRunInfo.getFtpPW();
                try {
                    try {
                        ftp.openServer(m_ftpIP, m_ftpPort);
                        ftp.login(m_ftpID, m_ftpPW);
                        ftp.binary();
                        ftp.cd(this.m_requester.getFtpPath());
                        String[] record = ftp.convStr(ftp.getLs()).split("\n");
                        int i4 = 0;
                        while (i4 < record.length) {
                            String[] arr = record[i4].split(" ");
                            int j4 = 0;
                            while (j4 < arr.length) {
                                String tmp = arr[j4].toUpperCase();
                                if (tmp.contains(".JAR") || tmp.contains(".JNLP") || tmp.contains(".EXE")) {
                                    fileType = "OSDM";
                                    compData = this.m_requester.m_fileList.containsKey(fileType) ? (ArrayList)this.m_requester.m_fileList.get(fileType) : new ArrayList();
                                    fileData = new ArrayList<String>();
                                    fileData.add(0, arr[j4]);
                                    if (this.m_requester.getSystemName().equals("OS7200") || this.m_requester.getSystemName().equals("OS7400")) {
                                        fileData.add(1, formatter.format(Integer.parseInt(arr[j4 - 6])));
                                    } else {
                                        fileData.add(1, formatter.format(Integer.parseInt(arr[j4 - 4])));
                                    }
                                    fileData.add(2, "");
                                    fileData.add(3, "0");
                                    compData.add(compData.size(), fileData);
                                    this.m_requester.m_fileList.put(fileType, compData);
                                }
                                ++j4;
                            }
                            ++i4;
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                        try {
                            ftp.closeServer();
                            try {
                                Thread.sleep(100L);
                                break block43;
                            }
                            catch (InterruptedException e4) {
                                e4.printStackTrace();
                            }
                        }
                        catch (IOException e5) {
                            e5.printStackTrace();
                        }
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ftp.closeServer();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e6) {
                            e6.printStackTrace();
                        }
                    }
                    catch (IOException e7) {
                        e7.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    ftp.closeServer();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e8) {
                        e8.printStackTrace();
                    }
                }
                catch (IOException e9) {
                    e9.printStackTrace();
                }
            }
        }
        AppGlobal.hideProgress();
        if (this.m_requester.m_recvData == null || this.m_iniData == null) {
            AppGlobal.showErrorMessage("File Control", "A communications failure has occurred.");
        }
    }

    private void requestDelete() {
        byte[] m_reqData = null;
        byte[] m_header = null;
        AppGlobal.showProgress(AppLang.getText("File Control"), AppLang.getText("Delete..."));
        int i2 = 0;
        while (i2 < this.m_requester.m_model1.getRowHdrRowCount()) {
            if (((JCheckBox)this.m_requester.m_model1.getValueAt(i2, 4)).isSelected()) {
                String fileName = ((AppTextBox)this.m_requester.m_model1.getValueAt(i2, 0)).getText().trim();
                String tmp = fileName.toUpperCase();
                if (tmp.contains(".JAR") || tmp.contains(".JNLP") || tmp.contains(".EXE")) {
                    SunFtpWrapper_dm ftp = new SunFtpWrapper_dm();
                    Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
                    String m_ftpIP = (String)linkInfo.get("IP_ADDRESS");
                    String ftpPort = (String)linkInfo.get("FTP_PORT");
                    int m_ftpPort = 21;
                    if (ftpPort != null) {
                        m_ftpPort = Integer.parseInt(ftpPort);
                    }
                    String m_ftpID = AppRunInfo.getFtpID();
                    String m_ftpPW = AppRunInfo.getFtpPW();
                    try {
                        ftp.openServer(m_ftpIP, m_ftpPort);
                        ftp.login(m_ftpID, m_ftpPW);
                        ftp.issueRawCommand("DELE " + this.m_requester.getFtpPath() + fileName);
                        ftp.closeServer();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                } else {
                    m_reqData = new byte[20];
                    m_header = this.m_requester.m_comm.makeMsgHeader((byte)21, this.m_requester.getSubId(fileName), (byte)-1, (short)0, (byte)-1, (byte)-17);
                    System.arraycopy(m_header, 0, m_reqData, 0, 8);
                    AppFunctions.str2byte(m_reqData, 8, 12, fileName);
                    this.m_requester.m_recvData = null;
                    this.m_requester.m_recvData = this.m_requester.m_comm.requestFileControl(m_reqData, 8);
                    if (this.m_requester.m_recvData != null && this.m_requester.m_recvData.length >= 8 && this.m_requester.m_recvData[7] == -32) {
                        AppGlobal.hideProgress();
                        AppGlobal.showErrorMessage("", "Failed to delete file.");
                        return;
                    }
                    m_reqData = null;
                }
            }
            ++i2;
        }
        AppGlobal.hideProgress();
        if (this.m_requester.m_recvData == null) {
            AppGlobal.showErrorMessage("File Control", "A communications failure has occurred.");
        }
    }

    private void requestChange() {
        ArrayList<String> fileList = new ArrayList<String>();
        byte[] iniData = null;
        byte[] reqData = null;
        byte[] recvData = null;
        byte[] header = null;
        AppGlobal.showProgress(AppLang.getText("File Control"), AppLang.getText("Change INI..."));
        int i2 = 0;
        while (i2 < this.m_requester.m_model1.getRowHdrRowCount()) {
            if (this.m_requester.m_model1.getValueAt(i2, 3) != null && ((JRadioButton)this.m_requester.m_model1.getValueAt(i2, 3)).isSelected()) {
                fileList.add(((AppTextBox)this.m_requester.m_model1.getValueAt(i2, 0)).getText().trim());
            }
            ++i2;
        }
        iniData = new byte[fileList.size() * 34];
        i2 = 0;
        int j2 = 0;
        while (i2 < fileList.size()) {
            iniData[j2] = this.m_requester.getSubId((String)fileList.get(i2));
            iniData[j2 + 1] = -1;
            AppFunctions.str2byte(iniData, j2 + 2, 32, (String)fileList.get(i2));
            ++i2;
            j2 += 34;
        }
        i2 = 0;
        int k2 = 1;
        while (i2 < iniData.length) {
            int msgLen = 136;
            int resp = 255;
            if (i2 + 136 > iniData.length) {
                msgLen = iniData.length - i2;
                resp = 239;
            }
            reqData = new byte[msgLen + 8];
            header = this.m_requester.m_comm.makeMsgHeader((byte)38, (byte)-1, (byte)-1, (short)k2, (byte)msgLen, (byte)resp);
            System.arraycopy(header, 0, reqData, 0, 8);
            System.arraycopy(iniData, i2, reqData, 8, msgLen);
            if (this.m_requester.getSystemName().equals("OS7200") || this.m_requester.getSystemName().equals("OS7400")) {
                this.m_requester.m_comm.requestFileControl(reqData, 0);
            } else if (resp == 239) {
                recvData = null;
                recvData = this.m_requester.m_comm.requestFileControl(reqData, 314);
            } else {
                this.m_requester.m_comm.requestFileControl(reqData, 0);
            }
            i2 += 136;
            ++k2;
        }
        AppGlobal.hideProgress();
        if (this.m_requester.getSystemName().equals("OS7200") || this.m_requester.getSystemName().equals("OS7400")) {
            AppGlobal.showInfoMessage("", String.valueOf(AppLang.getText("INI info is updated successfully.")) + "\n" + AppLang.getText("But, the file(s) will be run after restart"));
        } else if (recvData == null) {
            AppGlobal.showErrorMessage("File Control", "A communications failure has occurred.");
        } else {
            AppGlobal.showInfoMessage("", String.valueOf(AppLang.getText("INI info is updated successfully.")) + "\n" + AppLang.getText("But, the file(s) will be run after restart"));
        }
    }

    private void requestUpdate() {
        byte[] header = null;
        byte[] updateData = null;
        byte[] reqData = null;
        byte[] recvData = null;
        AppGlobal.showProgress(AppLang.getText("File Control"), AppLang.getText("Update(Slave)"));
        updateData = new byte[]{77, 65, 83, 84, 69, 82, 45, 80, 75, 71, 32, 32, 1, 4};
        header = this.m_requester.m_comm.makeMsgHeader((byte)35, (byte)19, (byte)-1, (short)0, (byte)-1, (byte)-17);
        reqData = new byte[header.length + updateData.length];
        System.arraycopy(header, 0, reqData, 0, 8);
        System.arraycopy(updateData, 0, reqData, 8, updateData.length);
        recvData = null;
        recvData = this.m_requester.m_comm.requestFileControl(reqData, 44);
        AppGlobal.hideProgress();
        if (recvData != null) {
            AppFileUpdate update = new AppFileUpdate(this.m_requester);
            update.startUpdateslave();
            String eTime = update.getElapsedTime();
            update.closeDialog();
            if (update.m_result) {
                AppGlobal.showInfoMessage("Update(Slave)", String.valueOf(AppLang.getText("The file(s) is applied successfully.")) + "\n" + AppLang.getText("Total elasped time") + " [ " + eTime + " ]");
                if (AppGlobal.showConfirmMessage("Restart", "Do you want to restart system?") == 0) {
                    this.m_requester.requestSystemRestart();
                    return;
                }
            } else {
                AppGlobal.showInfoMessage("Update(Slave)", String.valueOf(AppLang.getText("Can not apply the file.")) + " \n >> " + AppLang.getText("Fail to download pkg files to SLAVE."));
            }
        } else {
            AppGlobal.showErrorMessage("File Control", "A communications failure has occurred.");
        }
    }
}

